/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.hadoop.io.Text;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaSplitIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(MetaSplitIT.class);
    private Collection<Text> metadataSplits = null;

    @Override
    public int defaultTimeoutSeconds() {
        return 180;
    }

    @Before
    public void saveMetadataSplits() throws Exception {
        if (AccumuloClusterHarness.ClusterType.STANDALONE == MetaSplitIT.getClusterType()) {
            Connector conn = this.getConnector();
            Collection splits = conn.tableOperations().listSplits("accumulo.metadata");
            if (!splits.equals(Arrays.asList(new Text("~")))) {
                log.info("Existing splits on metadata table. Saving them, and applying single original split of '~'");
                this.metadataSplits = splits;
                conn.tableOperations().merge("accumulo.metadata", null, null);
                conn.tableOperations().addSplits("accumulo.metadata", new TreeSet<Text>(Collections.singleton(new Text("~"))));
            }
        }
    }

    @After
    public void restoreMetadataSplits() throws Exception {
        if (null != this.metadataSplits) {
            log.info("Restoring split on metadata table");
            Connector conn = this.getConnector();
            conn.tableOperations().merge("accumulo.metadata", null, null);
            conn.tableOperations().addSplits("accumulo.metadata", new TreeSet<Text>(this.metadataSplits));
        }
    }

    @Test(expected=AccumuloException.class)
    public void testRootTableSplit() throws Exception {
        TableOperations opts = this.getConnector().tableOperations();
        TreeSet<Text> splits = new TreeSet<Text>();
        splits.add(new Text("5"));
        opts.addSplits("accumulo.root", splits);
    }

    @Test
    public void testRootTableMerge() throws Exception {
        TableOperations opts = this.getConnector().tableOperations();
        opts.merge("accumulo.root", null, null);
    }

    private void addSplits(TableOperations opts, String ... points) throws Exception {
        TreeSet<Text> splits = new TreeSet<Text>();
        for (String point : points) {
            splits.add(new Text(point));
        }
        opts.addSplits("accumulo.metadata", splits);
    }

    @Test
    public void testMetadataTableSplit() throws Exception {
        int i;
        TableOperations opts = this.getConnector().tableOperations();
        for (i = 1; i <= 10; ++i) {
            opts.create(Integer.toString(i));
        }
        try {
            opts.merge("accumulo.metadata", new Text("01"), new Text("02"));
            MetaSplitIT.checkMetadataSplits(1, opts);
            this.addSplits(opts, "4 5 6 7 8".split(" "));
            MetaSplitIT.checkMetadataSplits(6, opts);
            opts.merge("accumulo.metadata", new Text("6"), new Text("9"));
            MetaSplitIT.checkMetadataSplits(4, opts);
            this.addSplits(opts, "44 55 66 77 88".split(" "));
            MetaSplitIT.checkMetadataSplits(9, opts);
            opts.merge("accumulo.metadata", new Text("5"), new Text("7"));
            MetaSplitIT.checkMetadataSplits(6, opts);
            opts.merge("accumulo.metadata", null, null);
            MetaSplitIT.checkMetadataSplits(0, opts);
        }
        finally {
            for (i = 1; i <= 10; ++i) {
                opts.delete(Integer.toString(i));
            }
        }
    }

    private static void checkMetadataSplits(int numSplits, TableOperations opts) throws AccumuloSecurityException, TableNotFoundException, AccumuloException, InterruptedException {
        for (int i = 0; i < 10 && opts.listSplits("accumulo.metadata").size() != numSplits; ++i) {
            Thread.sleep(2000L);
        }
        Collection splits = opts.listSplits("accumulo.metadata");
        Assert.assertEquals((String)("Actual metadata table splits: " + splits), (long)numSplits, (long)splits.size());
    }
}

