/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.Credentials;
import org.apache.accumulo.core.client.impl.Writer;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.tabletserver.thrift.ConstraintViolationException;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.junit.Test;

public class MetaConstraintRetryIT
extends AccumuloClusterHarness {
    @Override
    public int defaultTimeoutSeconds() {
        return 30;
    }

    @Test(expected=ConstraintViolationException.class)
    public void test() throws Exception {
        block2: {
            this.getConnector().securityOperations().grantTablePermission(MetaConstraintRetryIT.getAdminPrincipal(), "accumulo.metadata", TablePermission.WRITE);
            Credentials credentials = new Credentials(MetaConstraintRetryIT.getAdminPrincipal(), MetaConstraintRetryIT.getAdminToken());
            ClientContext context = new ClientContext(this.getConnector().getInstance(), credentials, cluster.getClientConfig());
            Writer w = new Writer(context, "!0");
            KeyExtent extent = new KeyExtent("5", null, null);
            Mutation m = new Mutation(extent.getMetadataEntry());
            m.put((CharSequence)"badcolfam", (CharSequence)"badcolqual", (CharSequence)"3");
            try {
                MetadataTableUtil.update((Writer)w, null, (Mutation)m);
            }
            catch (RuntimeException e) {
                if (!e.getCause().getClass().equals(ConstraintViolationException.class)) break block2;
                throw (ConstraintViolationException)e.getCause();
            }
        }
    }
}

