/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.tserver.compaction.CompactionPlan;
import org.apache.accumulo.tserver.compaction.CompactionStrategy;
import org.apache.accumulo.tserver.compaction.MajorCompactionRequest;
import org.apache.accumulo.tserver.compaction.WriteParameters;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.Test;

public class ConfigurableMajorCompactionIT
extends ConfigurableMacBase {
    @Override
    public int defaultTimeoutSeconds() {
        return 30;
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        HashMap<String, String> siteConfig = new HashMap<String, String>();
        siteConfig.put(Property.TSERV_MAJC_DELAY.getKey(), "1s");
        cfg.setSiteConfig(siteConfig);
    }

    @Test
    public void test() throws Exception {
        Connector conn = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        conn.tableOperations().create(tableName);
        conn.tableOperations().setProperty(tableName, Property.TABLE_COMPACTION_STRATEGY.getKey(), TestCompactionStrategy.class.getName());
        this.writeFile(conn, tableName);
        this.writeFile(conn, tableName);
        this.writeFile(conn, tableName);
        this.writeFile(conn, tableName);
        UtilWaitThread.sleep((long)2000L);
        Assert.assertEquals((long)4L, (long)this.countFiles(conn));
        this.writeFile(conn, tableName);
        int count = this.countFiles(conn);
        Assert.assertTrue((count == 1 || count == 5 ? 1 : 0) != 0);
        while (count != 1) {
            UtilWaitThread.sleep((long)250L);
            count = this.countFiles(conn);
        }
    }

    private int countFiles(Connector conn) throws Exception {
        Scanner s = conn.createScanner("accumulo.metadata", Authorizations.EMPTY);
        s.setRange(MetadataSchema.TabletsSection.getRange());
        s.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
        return Iterators.size((Iterator)s.iterator());
    }

    private void writeFile(Connector conn, String tableName) throws Exception {
        BatchWriter bw = conn.createBatchWriter(tableName, new BatchWriterConfig());
        Mutation m = new Mutation((CharSequence)"row");
        m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"value");
        bw.addMutation(m);
        bw.close();
        conn.tableOperations().flush(tableName, null, null, true);
    }

    public static class TestCompactionStrategy
    extends CompactionStrategy {
        public boolean shouldCompact(MajorCompactionRequest request) throws IOException {
            return request.getFiles().size() == 5;
        }

        public CompactionPlan getCompactionPlan(MajorCompactionRequest request) throws IOException {
            CompactionPlan plan = new CompactionPlan();
            plan.inputFiles.addAll(request.getFiles().keySet());
            plan.writeParameters = new WriteParameters();
            plan.writeParameters.setBlockSize(0x100000L);
            plan.writeParameters.setCompressType("none");
            plan.writeParameters.setHdfsBlockSize(0x100000L);
            plan.writeParameters.setIndexBlockSize(10L);
            plan.writeParameters.setReplication(7);
            return plan;
        }
    }
}

