/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.harness;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccumuloITBase {
    private static final Logger log = LoggerFactory.getLogger(AccumuloITBase.class);
    @Rule
    public TestName testName = new TestName();

    public String[] getUniqueNames(int num) {
        String[] names = new String[num];
        for (int i = 0; i < num; ++i) {
            names[i] = this.getClass().getSimpleName() + "_" + this.testName.getMethodName() + i;
        }
        return names;
    }

    public static File getSslDir(File baseDir) {
        Assert.assertTrue((baseDir.exists() && baseDir.isDirectory() ? 1 : 0) != 0);
        return new File(baseDir.getParentFile(), baseDir.getName() + "-ssl");
    }

    public static File createTestDir(String name) {
        File baseDir = new File(System.getProperty("user.dir") + "/target/mini-tests");
        Assert.assertTrue((baseDir.mkdirs() || baseDir.isDirectory() ? 1 : 0) != 0);
        if (name == null) {
            return baseDir;
        }
        File testDir = new File(baseDir, name);
        FileUtils.deleteQuietly((File)testDir);
        Assert.assertTrue((boolean)testDir.mkdir());
        return testDir;
    }

    @Rule
    public Timeout testsShouldTimeout() {
        int waitLonger = 0;
        try {
            String timeoutString = System.getProperty("timeout.factor");
            if (timeoutString != null && !timeoutString.isEmpty()) {
                waitLonger = Integer.parseInt(timeoutString);
            }
        }
        catch (NumberFormatException exception) {
            log.warn("Could not parse timeout.factor, defaulting to no timeout.");
        }
        return Timeout.builder().withTimeout((long)(waitLonger * this.defaultTimeoutSeconds()), TimeUnit.SECONDS).withLookingForStuckThread(true).build();
    }

    protected int defaultTimeoutSeconds() {
        return 0;
    }
}

