/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.security.NamespacePermission;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.util.BadArgumentException;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.Token;
import org.apache.accumulo.shell.commands.TableOperation;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;

public class GrantCommand
extends TableOperation {
    private Option systemOpt;
    private Option userOpt;
    private String user;
    private String[] permission;

    public GrantCommand() {
        this.disableUnflaggedTableOptions();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        this.user = cl.hasOption(this.userOpt.getOpt()) ? cl.getOptionValue(this.userOpt.getOpt()) : shellState.getConnector().whoami();
        this.permission = cl.getArgs()[0].split("\\.", 2);
        if (cl.hasOption(this.systemOpt.getOpt()) && this.permission[0].equalsIgnoreCase("System")) {
            try {
                shellState.getConnector().securityOperations().grantSystemPermission(this.user, SystemPermission.valueOf((String)this.permission[1]));
                Shell.log.debug((Object)("Granted " + this.user + " the " + this.permission[1] + " permission"));
                return 0;
            }
            catch (IllegalArgumentException e) {
                throw new BadArgumentException("No such system permission", fullCommand, fullCommand.indexOf(cl.getArgs()[0]));
            }
        }
        if (this.permission[0].equalsIgnoreCase("Table")) {
            super.execute(fullCommand, cl, shellState);
            return 0;
        }
        if (!this.permission[0].equalsIgnoreCase("Namespace")) throw new BadArgumentException("Unrecognized permission", fullCommand, fullCommand.indexOf(cl.getArgs()[0]));
        if (!cl.hasOption(this.optNamespace.getOpt())) throw new BadArgumentException("No namespace specified to apply permission to", fullCommand, fullCommand.indexOf(cl.getArgs()[0]));
        try {
            shellState.getConnector().securityOperations().grantNamespacePermission(this.user, cl.getOptionValue(this.optNamespace.getOpt()), NamespacePermission.valueOf((String)this.permission[1]));
            return 0;
        }
        catch (IllegalArgumentException e) {
            throw new BadArgumentException("No such namespace permission", fullCommand, fullCommand.indexOf(cl.getArgs()[0]));
        }
    }

    @Override
    protected void doTableOp(Shell shellState, String tableName) throws Exception {
        try {
            shellState.getConnector().securityOperations().grantTablePermission(this.user, tableName, TablePermission.valueOf((String)this.permission[1]));
            Shell.log.debug((Object)("Granted " + this.user + " the " + this.permission[1] + " permission on table " + tableName));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("No such table permission", e);
        }
    }

    @Override
    public String description() {
        return "grants system, table, or namespace permissions for a user";
    }

    @Override
    public String usage() {
        return this.getName() + " <permission>";
    }

    @Override
    public void registerCompletion(Token root, Map<Shell.Command.CompletionSet, Set<String>> completionSet) {
        Token cmd = new Token(this.getName());
        cmd.addSubcommand(new Token(TablePermission.printableValues()));
        cmd.addSubcommand(new Token(SystemPermission.printableValues()));
        cmd.addSubcommand(new Token(NamespacePermission.printableValues()));
        root.addSubcommand(cmd);
    }

    @Override
    public Options getOptions() {
        super.getOptions();
        Options o = new Options();
        OptionGroup group = new OptionGroup();
        this.systemOpt = new Option("s", "system", false, "grant a system permission");
        this.optNamespace = new Option("ns", "namespace", true, "name of a namespace to operate on");
        this.optNamespace.setArgName("namespace");
        group.addOption(this.systemOpt);
        group.addOption(this.optTableName);
        group.addOption(this.optTablePattern);
        group.addOption(this.optNamespace);
        o.addOptionGroup(group);
        this.userOpt = new Option("u", "user", true, "user to operate on");
        this.userOpt.setArgName("username");
        this.userOpt.setRequired(true);
        o.addOption(this.userOpt);
        return o;
    }

    @Override
    public int numArgs() {
        return 1;
    }
}

