/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.DiskUsage;
import org.apache.accumulo.core.client.impl.Namespaces;
import org.apache.accumulo.core.util.NumUtil;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.commands.OptUtil;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class DUCommand
extends Shell.Command {
    private Option optTablePattern;
    private Option optHumanReadble;
    private Option optNamespace;

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws IOException, TableNotFoundException, NamespaceNotFoundException {
        boolean prettyPrint;
        TreeSet<String> tables = new TreeSet<String>(Arrays.asList(cl.getArgs()));
        if (cl.hasOption("t")) {
            tables.add(cl.getOptionValue("t"));
        }
        if (cl.hasOption(this.optNamespace.getOpt())) {
            Instance instance = shellState.getInstance();
            Iterator namespaceId = Namespaces.getNamespaceId((Instance)instance, (String)cl.getOptionValue(this.optNamespace.getOpt()));
            tables.addAll(Namespaces.getTableNames((Instance)instance, (String)((Object)namespaceId)));
        }
        boolean bl = prettyPrint = cl.hasOption(this.optHumanReadble.getOpt());
        if (cl.hasOption(this.optTablePattern.getOpt())) {
            for (String table : shellState.getConnector().tableOperations().list()) {
                if (!table.matches(cl.getOptionValue(this.optTablePattern.getOpt()))) continue;
                tables.add(table);
            }
        }
        if (tables.isEmpty() && !shellState.getTableName().isEmpty()) {
            tables.add(shellState.getTableName());
        }
        for (String tableName : tables) {
            if (shellState.getConnector().tableOperations().exists(tableName)) continue;
            throw new TableNotFoundException(tableName, tableName, "specified table that doesn't exist");
        }
        try {
            String valueFormat = prettyPrint ? "%9s" : "%,24d";
            for (DiskUsage usage : shellState.getConnector().tableOperations().getDiskUsage(tables)) {
                Long value = prettyPrint ? NumUtil.bigNumberForSize((long)usage.getUsage()) : usage.getUsage();
                shellState.getReader().println((CharSequence)String.format(valueFormat + " %s", value, usage.getTables()));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return 0;
    }

    @Override
    public String description() {
        return "prints how much space, in bytes, is used by files referenced by a table. When multiple tables are specified it prints how much space, in bytes, is used by files shared between tables, if any.";
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        this.optTablePattern = new Option("p", "pattern", true, "regex pattern of table names");
        this.optTablePattern.setArgName("pattern");
        this.optHumanReadble = new Option("h", "human-readable", false, "format large sizes to human readable units");
        this.optHumanReadble.setArgName("human readable output");
        this.optNamespace = new Option("ns", "namespace", true, "name of a namespace");
        this.optNamespace.setArgName("namespace");
        o.addOption(OptUtil.tableOpt("table to examine"));
        o.addOption(this.optTablePattern);
        o.addOption(this.optHumanReadble);
        o.addOption(this.optNamespace);
        return o;
    }

    @Override
    public String usage() {
        return this.getName() + " <table>{ <table>}";
    }

    @Override
    public int numArgs() {
        return -1;
    }
}

