/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.CloneConfiguration;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.Token;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class CloneTableCommand
extends Shell.Command {
    private Option setPropsOption;
    private Option excludePropsOption;
    private Option noFlushOption;
    private Option keepOfflineOption;

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws AccumuloException, AccumuloSecurityException, TableNotFoundException, TableExistsException {
        HashMap<String, String> props = new HashMap<String, String>();
        HashSet<String> exclude = new HashSet<String>();
        boolean flush = true;
        boolean keepOffline = false;
        if (cl.hasOption(this.setPropsOption.getOpt())) {
            String[] keyVals;
            for (String keyVal : keyVals = cl.getOptionValue(this.setPropsOption.getOpt()).split(",")) {
                String[] sa = keyVal.split("=");
                props.put(sa[0], sa[1]);
            }
        }
        if (cl.hasOption(this.excludePropsOption.getOpt())) {
            String[] keys;
            for (String key : keys = cl.getOptionValue(this.excludePropsOption.getOpt()).split(",")) {
                exclude.add(key);
            }
        }
        if (cl.hasOption(this.noFlushOption.getOpt())) {
            flush = false;
        }
        if (cl.hasOption(this.keepOfflineOption.getOpt())) {
            keepOffline = true;
        }
        shellState.getConnector().tableOperations().clone(cl.getArgs()[0], cl.getArgs()[1], CloneConfiguration.builder().setFlush(flush).setPropertiesToSet(props).setPropertiesToExclude(exclude).setKeepOffline(keepOffline).build());
        return 0;
    }

    @Override
    public String usage() {
        return this.getName() + " <current table name> <new table name>";
    }

    @Override
    public String description() {
        return "clones a table";
    }

    @Override
    public void registerCompletion(Token root, Map<Shell.Command.CompletionSet, Set<String>> completionSet) {
        this.registerCompletionForTables(root, completionSet);
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        this.setPropsOption = new Option("s", "set", true, "set initial properties before the table comes online. Expects <prop>=<value>{,<prop>=<value>}");
        o.addOption(this.setPropsOption);
        this.excludePropsOption = new Option("e", "exclude", true, "exclude properties that should not be copied from source table. Expects <prop>{,<prop>}");
        o.addOption(this.excludePropsOption);
        this.noFlushOption = new Option("nf", "noFlush", false, "do not flush table data in memory before cloning.");
        o.addOption(this.noFlushOption);
        this.keepOfflineOption = new Option("o", "offline", false, "do not bring the table online after cloning.");
        o.addOption(this.keepOfflineOption);
        return o;
    }

    @Override
    public int numArgs() {
        return 2;
    }
}

