/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.simple.filedata;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.PeekingIterator;
import org.apache.accumulo.examples.simple.filedata.FileDataIngest;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkInputStream
extends InputStream {
    private static final Logger log = LoggerFactory.getLogger(ChunkInputStream.class);
    protected PeekingIterator<Map.Entry<Key, Value>> source;
    protected Key currentKey;
    protected Set<Text> currentVis;
    protected int currentChunk;
    protected int currentChunkSize;
    protected boolean gotEndMarker;
    protected byte[] buf;
    protected int count;
    protected int pos;

    public ChunkInputStream() {
        this.source = null;
    }

    public ChunkInputStream(PeekingIterator<Map.Entry<Key, Value>> in) throws IOException {
        this.setSource(in);
    }

    public void setSource(PeekingIterator<Map.Entry<Key, Value>> in) throws IOException {
        if (this.source != null) {
            throw new IOException("setting new source without closing old one");
        }
        this.source = in;
        this.currentVis = new TreeSet<Text>();
        this.pos = 0;
        this.count = 0;
        if (!this.source.hasNext()) {
            log.debug("source has no next");
            this.gotEndMarker = true;
            return;
        }
        Map.Entry entry = (Map.Entry)this.source.next();
        this.currentKey = (Key)entry.getKey();
        this.buf = ((Value)entry.getValue()).get();
        while (!this.currentKey.getColumnFamily().equals((Object)FileDataIngest.CHUNK_CF)) {
            log.debug("skipping key: " + this.currentKey.toString());
            if (!this.source.hasNext()) {
                return;
            }
            entry = (Map.Entry)this.source.next();
            this.currentKey = (Key)entry.getKey();
            this.buf = ((Value)entry.getValue()).get();
        }
        log.debug("starting chunk: " + this.currentKey.toString());
        this.count = this.buf.length;
        this.currentVis.add(this.currentKey.getColumnVisibility());
        this.currentChunk = FileDataIngest.bytesToInt(this.currentKey.getColumnQualifier().getBytes(), 4);
        this.currentChunkSize = FileDataIngest.bytesToInt(this.currentKey.getColumnQualifier().getBytes(), 0);
        this.gotEndMarker = false;
        if (this.buf.length == 0) {
            this.gotEndMarker = true;
        }
        if (this.currentChunk != 0) {
            this.source = null;
            throw new IOException("starting chunk number isn't 0 for " + this.currentKey.getRow());
        }
    }

    private int fill() throws IOException {
        if (this.source == null || !this.source.hasNext()) {
            if (this.gotEndMarker) {
                this.pos = 0;
                this.count = 0;
                return 0;
            }
            throw new IOException("no end chunk marker but source has no data");
        }
        Map.Entry entry = (Map.Entry)this.source.peek();
        Key thisKey = (Key)entry.getKey();
        log.debug("evaluating key: " + thisKey.toString());
        if (!thisKey.equals(this.currentKey, PartialKey.ROW)) {
            if (this.gotEndMarker) {
                return -1;
            }
            String currentRow = this.currentKey.getRow().toString();
            this.clear();
            throw new IOException("got to the end of the row without end chunk marker " + currentRow);
        }
        log.debug("matches current key");
        this.source.next();
        if (!thisKey.getColumnFamily().equals((Object)FileDataIngest.CHUNK_CF)) {
            log.debug("skipping non-chunk key");
            return this.fill();
        }
        log.debug("is a chunk");
        if (this.currentChunkSize != FileDataIngest.bytesToInt(thisKey.getColumnQualifier().getBytes(), 0)) {
            log.debug("skipping chunk of different size");
            return this.fill();
        }
        if (!this.currentVis.contains(thisKey.getColumnVisibility())) {
            this.currentVis.add(thisKey.getColumnVisibility());
        }
        if (thisKey.getColumnQualifier().equals((Object)this.currentKey.getColumnQualifier())) {
            log.debug("skipping identical chunk with different visibility");
            return this.fill();
        }
        if (this.gotEndMarker) {
            log.debug("got another chunk after end marker: " + this.currentKey.toString() + " " + thisKey.toString());
            this.clear();
            throw new IOException("found extra chunk after end marker");
        }
        int thisChunk = FileDataIngest.bytesToInt(thisKey.getColumnQualifier().getBytes(), 4);
        if (thisChunk != this.currentChunk + 1) {
            log.debug("new chunk same file, unexpected chunkID: " + this.currentKey.toString() + " " + thisKey.toString());
            this.clear();
            throw new IOException("missing chunks between " + this.currentChunk + " and " + thisChunk);
        }
        this.currentKey = thisKey;
        this.currentChunk = thisChunk;
        this.buf = ((Value)entry.getValue()).get();
        this.pos = 0;
        if (this.buf.length == 0) {
            this.gotEndMarker = true;
            return this.fill();
        }
        this.count = this.buf.length;
        return this.count;
    }

    public Set<Text> getVisibilities() {
        if (this.source != null) {
            throw new IllegalStateException("don't get visibilities before chunks have been completely read");
        }
        return this.currentVis;
    }

    @Override
    public int read() throws IOException {
        if (this.source == null) {
            return -1;
        }
        log.debug("pos: " + this.pos + " count: " + this.count);
        if (this.pos >= this.count && this.fill() <= 0) {
            log.debug("done reading input stream at key: " + (this.currentKey == null ? "null" : this.currentKey.toString()));
            if (this.source != null && this.source.hasNext()) {
                log.debug("next key: " + ((Map.Entry)this.source.peek()).getKey());
            }
            this.clear();
            return -1;
        }
        return this.buf[this.pos++] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int total;
        int cnt;
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        log.debug("filling buffer " + off + " " + len);
        for (total = 0; total < len; total += cnt) {
            int avail = this.count - this.pos;
            log.debug(avail + " available in current local buffer");
            if (avail <= 0) {
                if (this.fill() <= 0) {
                    log.debug("done reading input stream at key: " + (this.currentKey == null ? "null" : this.currentKey.toString()));
                    if (this.source != null && this.source.hasNext()) {
                        log.debug("next key: " + ((Map.Entry)this.source.peek()).getKey());
                    }
                    this.clear();
                    log.debug("filled " + total + " bytes");
                    return total == 0 ? -1 : total;
                }
                avail = this.count - this.pos;
            }
            cnt = avail < len - total ? avail : len - total;
            log.debug("copying from local buffer: local pos " + this.pos + " into pos " + off + " len " + cnt);
            System.arraycopy(this.buf, this.pos, b, off, cnt);
            this.pos += cnt;
            off += cnt;
        }
        log.debug("filled " + total + " bytes");
        return total;
    }

    public void clear() {
        this.source = null;
        this.buf = null;
        this.currentKey = null;
        this.currentChunk = 0;
        this.count = 0;
        this.pos = 0;
    }

    @Override
    public void close() throws IOException {
        try {
            while (this.fill() > 0) {
            }
        }
        catch (IOException e) {
            this.clear();
            throw new IOException(e);
        }
        this.clear();
    }
}

