/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.simple.combiner;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.Combiner;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.OptionDescriber;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;

public class StatsCombiner
extends Combiner {
    public static final String RADIX_OPTION = "radix";
    private int radix = 10;

    public Value reduce(Key key, Iterator<Value> iter) {
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        long sum = 0L;
        long count = 0L;
        while (iter.hasNext()) {
            String[] stats = iter.next().toString().split(",");
            if (stats.length == 1) {
                long val = Long.parseLong(stats[0], this.radix);
                min = Math.min(val, min);
                max = Math.max(val, max);
                sum += val;
                ++count;
                continue;
            }
            min = Math.min(Long.parseLong(stats[0], this.radix), min);
            max = Math.max(Long.parseLong(stats[1], this.radix), max);
            sum += Long.parseLong(stats[2], this.radix);
            count += Long.parseLong(stats[3], this.radix);
        }
        String ret = Long.toString(min, this.radix) + "," + Long.toString(max, this.radix) + "," + Long.toString(sum, this.radix) + "," + Long.toString(count, this.radix);
        return new Value(ret.getBytes());
    }

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        this.radix = options.containsKey(RADIX_OPTION) ? Integer.parseInt(options.get(RADIX_OPTION)) : 10;
    }

    public OptionDescriber.IteratorOptions describeOptions() {
        OptionDescriber.IteratorOptions io = super.describeOptions();
        io.setName("statsCombiner");
        io.setDescription("Combiner that keeps track of min, max, sum, and count");
        io.addNamedOption(RADIX_OPTION, "radix/base of the numbers");
        return io;
    }

    public boolean validateOptions(Map<String, String> options) {
        if (!super.validateOptions(options)) {
            return false;
        }
        if (options.containsKey(RADIX_OPTION) && !options.get(RADIX_OPTION).matches("\\d+")) {
            throw new IllegalArgumentException("invalid option radix:" + options.get(RADIX_OPTION));
        }
        return true;
    }

    public static void setRadix(IteratorSetting iterConfig, int base) {
        iterConfig.addOption(RADIX_OPTION, base + "");
    }
}

