/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.volume;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.core.volume.Volume;
import org.apache.accumulo.core.volume.VolumeImpl;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class VolumeConfiguration {
    public static Volume getVolume(String path, Configuration conf, AccumuloConfiguration acuconf) throws IOException {
        Objects.requireNonNull(path);
        if (path.contains(":")) {
            return VolumeConfiguration.create(new Path(path), conf);
        }
        return VolumeConfiguration.getDefaultVolume(conf, acuconf);
    }

    public static Volume getDefaultVolume(Configuration conf, AccumuloConfiguration acuconf) throws IOException {
        String uri = acuconf.get(Property.INSTANCE_DFS_URI);
        if ("".equals(uri)) {
            return VolumeConfiguration.create(FileSystem.get((Configuration)conf), acuconf);
        }
        try {
            return VolumeConfiguration.create(FileSystem.get((URI)new URI(uri), (Configuration)conf), acuconf);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    @Deprecated
    public static String getConfiguredBaseDir(AccumuloConfiguration conf, Configuration hadoopConfig) {
        String baseDir;
        String singleNamespace = conf.get(Property.INSTANCE_DFS_DIR);
        String dfsUri = conf.get(Property.INSTANCE_DFS_URI);
        if (dfsUri == null || dfsUri.isEmpty()) {
            try {
                baseDir = FileSystem.get((Configuration)hadoopConfig).getUri().toString() + singleNamespace;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            if (!dfsUri.contains(":")) {
                throw new IllegalArgumentException("Expected fully qualified URI for " + Property.INSTANCE_DFS_URI.getKey() + " got " + dfsUri);
            }
            baseDir = dfsUri + singleNamespace;
        }
        return baseDir;
    }

    public static String[] getVolumeUris(AccumuloConfiguration conf) {
        return VolumeConfiguration.getVolumeUris(conf, CachedConfiguration.getInstance());
    }

    public static String[] getVolumeUris(AccumuloConfiguration conf, Configuration hadoopConfig) {
        String[] configuredBaseDirs;
        String ns = conf.get(Property.INSTANCE_VOLUMES);
        if (ns == null || ns.isEmpty()) {
            configuredBaseDirs = new String[]{VolumeConfiguration.getConfiguredBaseDir(conf, hadoopConfig)};
        } else {
            String[] namespaces = ns.split(",");
            configuredBaseDirs = new String[namespaces.length];
            int i = 0;
            for (String namespace : namespaces) {
                if (!namespace.contains(":")) {
                    throw new IllegalArgumentException("Expected fully qualified URI for " + Property.INSTANCE_VOLUMES.getKey() + " got " + namespace);
                }
                try {
                    configuredBaseDirs[i++] = new Path(new URI(namespace)).toString();
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(Property.INSTANCE_VOLUMES.getKey() + " contains " + namespace + " which has a syntax error", e);
                }
            }
        }
        return configuredBaseDirs;
    }

    public static String[] prefix(String[] bases, String suffix) {
        if (suffix.startsWith("/")) {
            suffix = suffix.substring(1);
        }
        String[] result = new String[bases.length];
        for (int i = 0; i < bases.length; ++i) {
            result[i] = bases[i].endsWith("/") ? bases[i] + suffix : bases[i] + "/" + suffix;
        }
        return result;
    }

    public static <T extends FileSystem> Volume create(T fs, AccumuloConfiguration acuconf) {
        String dfsDir = acuconf.get(Property.INSTANCE_DFS_DIR);
        return new VolumeImpl(fs, null == dfsDir ? Property.INSTANCE_DFS_DIR.getDefaultValue() : dfsDir);
    }

    public static <T extends FileSystem> Volume create(T fs, String basePath) {
        return new VolumeImpl(fs, basePath);
    }

    public static Volume create(Path path, Configuration conf) throws IOException {
        return new VolumeImpl(path, conf);
    }
}

