/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.user;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.user.RowEncodingIterator;

public class WholeRowIterator
extends RowEncodingIterator {
    public WholeRowIterator() {
    }

    WholeRowIterator(SortedKeyValueIterator<Key, Value> source) {
        this.sourceIter = source;
    }

    @Override
    public SortedMap<Key, Value> rowDecoder(Key rowKey, Value rowValue) throws IOException {
        return WholeRowIterator.decodeRow(rowKey, rowValue);
    }

    @Override
    public Value rowEncoder(List<Key> keys, List<Value> values) throws IOException {
        return WholeRowIterator.encodeRow(keys, values);
    }

    private static byte[] readField(DataInputStream din) throws IOException {
        int len = din.readInt();
        byte[] b = new byte[len];
        int readLen = din.read(b);
        if (len > 0 && len != readLen) {
            throw new IOException(String.format("Expected to read %d bytes but read %d", len, readLen));
        }
        return b;
    }

    public static final SortedMap<Key, Value> decodeRow(Key rowKey, Value rowValue) throws IOException {
        TreeMap<Key, Value> map = new TreeMap<Key, Value>();
        ByteArrayInputStream in = new ByteArrayInputStream(rowValue.get());
        DataInputStream din = new DataInputStream(in);
        int numKeys = din.readInt();
        for (int i = 0; i < numKeys; ++i) {
            byte[] cf = WholeRowIterator.readField(din);
            byte[] cq = WholeRowIterator.readField(din);
            byte[] cv = WholeRowIterator.readField(din);
            long timestamp = din.readLong();
            byte[] valBytes = WholeRowIterator.readField(din);
            map.put(new Key(rowKey.getRowData().toArray(), cf, cq, cv, timestamp, false, false), new Value(valBytes, false));
        }
        return map;
    }

    public static final Value encodeRow(List<Key> keys, List<Value> values) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(out);
        dout.writeInt(keys.size());
        for (int i = 0; i < keys.size(); ++i) {
            Key k = keys.get(i);
            Value v = values.get(i);
            ByteSequence bs = k.getColumnFamilyData();
            dout.writeInt(bs.length());
            dout.write(bs.getBackingArray(), bs.offset(), bs.length());
            bs = k.getColumnQualifierData();
            dout.writeInt(bs.length());
            dout.write(bs.getBackingArray(), bs.offset(), bs.length());
            bs = k.getColumnVisibilityData();
            dout.writeInt(bs.length());
            dout.write(bs.getBackingArray(), bs.offset(), bs.length());
            dout.writeLong(k.getTimestamp());
            byte[] valBytes = v.get();
            dout.writeInt(valBytes.length);
            dout.write(valBytes);
        }
        return new Value(out.toByteArray());
    }
}

