/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.servlets;

import java.lang.management.ManagementFactory;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.master.thrift.DeadServer;
import org.apache.accumulo.core.master.thrift.MasterMonitorInfo;
import org.apache.accumulo.core.master.thrift.TableInfo;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.tabletserver.thrift.ActionStats;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.tabletserver.thrift.TabletStats;
import org.apache.accumulo.core.trace.Tracer;
import org.apache.accumulo.core.util.Duration;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.monitor.Monitor;
import org.apache.accumulo.monitor.servlets.BasicServlet;
import org.apache.accumulo.monitor.util.Table;
import org.apache.accumulo.monitor.util.TableRow;
import org.apache.accumulo.monitor.util.celltypes.CompactionsType;
import org.apache.accumulo.monitor.util.celltypes.DateTimeType;
import org.apache.accumulo.monitor.util.celltypes.DurationType;
import org.apache.accumulo.monitor.util.celltypes.NumberType;
import org.apache.accumulo.monitor.util.celltypes.PercentageType;
import org.apache.accumulo.monitor.util.celltypes.ProgressChartType;
import org.apache.accumulo.monitor.util.celltypes.TServerLinkType;
import org.apache.accumulo.monitor.util.celltypes.TableLinkType;
import org.apache.accumulo.server.AccumuloServerContext;
import org.apache.accumulo.server.master.state.TabletServerState;
import org.apache.accumulo.server.util.ActionStatsUpdator;
import org.apache.accumulo.server.util.TableInfoUtil;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.TServiceClientFactory;

public class TServersServlet
extends BasicServlet {
    private static final long serialVersionUID = 1L;
    private static final TabletServerStatus NO_STATUS = new TabletServerStatus();
    static final long SECOND = 1000L;
    static final long RESPONSE_TIME_MAX_ERR = 3000L;
    static final long MINUTE = 60000L;
    static final long LAST_CONTEXT_MAX_ERR = 180000L;

    @Override
    protected String getTitle(HttpServletRequest req) {
        return "Tablet Server Status";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void pageBody(HttpServletRequest req, HttpServletResponse response, StringBuilder sb) throws Exception {
        String tserverAddress = req.getParameter("s");
        boolean tserverExists = false;
        if (tserverAddress != null && !tserverAddress.isEmpty()) {
            for (TabletServerStatus ts : Monitor.getMmi().getTServerInfo()) {
                if (!tserverAddress.equals(ts.getName())) continue;
                tserverExists = true;
                break;
            }
        }
        if (tserverAddress == null || tserverAddress.isEmpty() || !tserverExists) {
            this.doBadTserverList(req, sb);
            this.doDeadTserverList(req, sb);
            ArrayList<TabletServerStatus> tservers = new ArrayList<TabletServerStatus>();
            if (Monitor.getMmi() != null) {
                tservers.addAll(Monitor.getMmi().tServerInfo);
            }
            Table tServerList = new Table("tservers", "Tablet&nbsp;Servers");
            tServerList.setSubCaption("Click on the <span style='color: #0000ff;'>server address</span> to view detailed performance statistics for that server.");
            TServersServlet.doTserverList(req, sb, tservers, null, tServerList);
            return;
        }
        double totalElapsedForAll = 0.0;
        double splitStdDev = 0.0;
        double minorStdDev = 0.0;
        double minorQueueStdDev = 0.0;
        double majorStdDev = 0.0;
        double majorQueueStdDev = 0.0;
        double currentMinorAvg = 0.0;
        double currentMajorAvg = 0.0;
        double currentMinorStdDev = 0.0;
        double currentMajorStdDev = 0.0;
        TabletStats total = new TabletStats(null, new ActionStats(), new ActionStats(), new ActionStats(), 0L, 0.0, 0.0, 0L);
        HostAndPort address = HostAndPort.fromString((String)tserverAddress);
        TabletStats historical = new TabletStats(null, new ActionStats(), new ActionStats(), new ActionStats(), 0L, 0.0, 0.0, 0L);
        ArrayList tsStats = new ArrayList();
        try {
            AccumuloServerContext context = Monitor.getContext();
            TabletClientService.Client client = (TabletClientService.Client)ThriftUtil.getClient((TServiceClientFactory)new TabletClientService.Client.Factory(), (HostAndPort)address, (ClientContext)context);
            try {
                for (String tableId : Monitor.getMmi().tableMap.keySet()) {
                    tsStats.addAll(client.getTabletStats(Tracer.traceInfo(), context.rpcCreds(), tableId));
                }
                historical = client.getHistoricalStats(Tracer.traceInfo(), context.rpcCreds());
            }
            finally {
                ThriftUtil.returnClient((TServiceClient)client);
            }
        }
        catch (Exception e) {
            TServersServlet.banner(sb, "error", "No Such Tablet ServerAvailable");
            log.error((Object)e, (Throwable)e);
            return;
        }
        Table perTabletResults = new Table("perTabletResults", "Detailed&nbsp;Current&nbsp;Operations");
        perTabletResults.setSubCaption("Per-tablet&nbsp;Details");
        perTabletResults.addSortableColumn("Table", new TableLinkType(), null);
        perTabletResults.addSortableColumn("Tablet");
        perTabletResults.addSortableColumn("Entries", new NumberType(), null);
        perTabletResults.addSortableColumn("Ingest", new NumberType(), null);
        perTabletResults.addSortableColumn("Query", new NumberType(), null);
        perTabletResults.addSortableColumn("Minor&nbsp;Avg", new SecondType(), null);
        perTabletResults.addSortableColumn("Minor&nbsp;Std&nbsp;Dev", new SecondType(), null);
        perTabletResults.addSortableColumn("Minor&nbsp;Avg&nbsp;e/s", new NumberType(), null);
        perTabletResults.addSortableColumn("Major&nbsp;Avg", new SecondType(), null);
        perTabletResults.addSortableColumn("Major&nbsp;Std&nbsp;Dev", new SecondType(), null);
        perTabletResults.addSortableColumn("Major&nbsp;Avg&nbsp;e/s", new NumberType(), null);
        for (TabletStats info : tsStats) {
            if (info.extent == null) {
                historical = info;
                continue;
            }
            total.numEntries += info.numEntries;
            ActionStatsUpdator.update((ActionStats)total.minors, (ActionStats)info.minors);
            ActionStatsUpdator.update((ActionStats)total.majors, (ActionStats)info.majors);
            KeyExtent extent = new KeyExtent(info.extent);
            String tableId = extent.getTableId();
            MessageDigest digester = MessageDigest.getInstance("MD5");
            if (extent.getEndRow() != null && extent.getEndRow().getLength() > 0) {
                digester.update(extent.getEndRow().getBytes(), 0, extent.getEndRow().getLength());
            }
            String obscuredExtent = Base64.getEncoder().encodeToString(digester.digest());
            String displayExtent = String.format("<code>[%s]</code>", obscuredExtent);
            TableRow row = perTabletResults.prepareRow();
            row.add(tableId);
            row.add(displayExtent);
            row.add(info.numEntries);
            row.add(info.ingestRate);
            row.add(info.queryRate);
            row.add(info.minors.num != 0 ? Double.valueOf(info.minors.elapsed / (double)info.minors.num) : null);
            row.add(TServersServlet.stddev(info.minors.elapsed, info.minors.num, info.minors.sumDev));
            row.add(info.minors.elapsed != 0.0 ? Double.valueOf((double)info.minors.count / info.minors.elapsed) : null);
            row.add(info.majors.num != 0 ? Double.valueOf(info.majors.elapsed / (double)info.majors.num) : null);
            row.add(TServersServlet.stddev(info.majors.elapsed, info.majors.num, info.majors.sumDev));
            row.add(info.majors.elapsed != 0.0 ? Double.valueOf((double)info.majors.count / info.majors.elapsed) : null);
            perTabletResults.addRow(row);
        }
        if (total.minors.num != 0) {
            currentMinorAvg = (long)(total.minors.elapsed / (double)total.minors.num);
        }
        if (total.minors.elapsed != 0.0 && total.minors.num != 0) {
            currentMinorStdDev = TServersServlet.stddev(total.minors.elapsed, total.minors.num, total.minors.sumDev);
        }
        if (total.majors.num != 0) {
            currentMajorAvg = total.majors.elapsed / (double)total.majors.num;
        }
        if (total.majors.elapsed != 0.0 && total.majors.num != 0 && total.majors.elapsed > (double)total.majors.num) {
            currentMajorStdDev = TServersServlet.stddev(total.majors.elapsed, total.majors.num, total.majors.sumDev);
        }
        ActionStatsUpdator.update((ActionStats)total.minors, (ActionStats)historical.minors);
        ActionStatsUpdator.update((ActionStats)total.majors, (ActionStats)historical.majors);
        totalElapsedForAll += total.majors.elapsed + historical.splits.elapsed + total.minors.elapsed;
        minorStdDev = TServersServlet.stddev(total.minors.elapsed, total.minors.num, total.minors.sumDev);
        minorQueueStdDev = TServersServlet.stddev(total.minors.queueTime, total.minors.num, total.minors.queueSumDev);
        majorStdDev = TServersServlet.stddev(total.majors.elapsed, total.majors.num, total.majors.sumDev);
        majorQueueStdDev = TServersServlet.stddev(total.majors.queueTime, total.majors.num, total.majors.queueSumDev);
        splitStdDev = TServersServlet.stddev(historical.splits.num, historical.splits.elapsed, historical.splits.sumDev);
        this.doDetailTable(req, sb, address, tsStats.size(), total, historical);
        this.doAllTimeTable(req, sb, total, historical, majorQueueStdDev, minorQueueStdDev, totalElapsedForAll, splitStdDev, majorStdDev, minorStdDev);
        this.doCurrentTabletOps(req, sb, currentMinorAvg, currentMinorStdDev, currentMajorAvg, currentMajorStdDev);
        perTabletResults.generate(req, sb);
    }

    private void doCurrentTabletOps(HttpServletRequest req, StringBuilder sb, double currentMinorAvg, double currentMinorStdDev, double currentMajorAvg, double currentMajorStdDev) {
        Table currentTabletOps = new Table("currentTabletOps", "Current&nbsp;Tablet&nbsp;Operation&nbsp;Results");
        currentTabletOps.addSortableColumn("Minor&nbsp;Average", new SecondType(), null);
        currentTabletOps.addSortableColumn("Minor&nbsp;Std&nbsp;Dev", new SecondType(), null);
        currentTabletOps.addSortableColumn("Major&nbsp;Avg", new SecondType(), null);
        currentTabletOps.addSortableColumn("Major&nbsp;Std&nbsp;Dev", new SecondType(), null);
        currentTabletOps.addRow(currentMinorAvg, currentMinorStdDev, currentMajorAvg, currentMajorStdDev);
        currentTabletOps.generate(req, sb);
    }

    private void doAllTimeTable(HttpServletRequest req, StringBuilder sb, TabletStats total, TabletStats historical, double majorQueueStdDev, double minorQueueStdDev, double totalElapsedForAll, double splitStdDev, double majorStdDev, double minorStdDev) {
        Table opHistoryDetails = new Table("opHistoryDetails", "All-Time&nbsp;Tablet&nbsp;Operation&nbsp;Results");
        opHistoryDetails.addSortableColumn("Operation");
        opHistoryDetails.addSortableColumn("Success", new NumberType(), null);
        opHistoryDetails.addSortableColumn("Failure", new NumberType(), null);
        opHistoryDetails.addSortableColumn("Average<br />Queue&nbsp;Time", new SecondType(), null);
        opHistoryDetails.addSortableColumn("Std.&nbsp;Dev.<br />Queue&nbsp;Time", new SecondType(), null);
        opHistoryDetails.addSortableColumn("Average<br />Time", new SecondType(), null);
        opHistoryDetails.addSortableColumn("Std.&nbsp;Dev.<br />Time", new SecondType(), null);
        opHistoryDetails.addSortableColumn("Percentage&nbsp;Time&nbsp;Spent", new ProgressChartType(totalElapsedForAll), null);
        opHistoryDetails.addRow("Split", historical.splits.num, historical.splits.fail, null, null, historical.splits.num != 0 ? Double.valueOf(historical.splits.elapsed / (double)historical.splits.num) : null, splitStdDev, historical.splits.elapsed);
        opHistoryDetails.addRow("Major&nbsp;Compaction", total.majors.num, total.majors.fail, total.majors.num != 0 ? Double.valueOf(total.majors.queueTime / (double)total.majors.num) : null, majorQueueStdDev, total.majors.num != 0 ? Double.valueOf(total.majors.elapsed / (double)total.majors.num) : null, majorStdDev, total.majors.elapsed);
        opHistoryDetails.addRow("Minor&nbsp;Compaction", total.minors.num, total.minors.fail, total.minors.num != 0 ? Double.valueOf(total.minors.queueTime / (double)total.minors.num) : null, minorQueueStdDev, total.minors.num != 0 ? Double.valueOf(total.minors.elapsed / (double)total.minors.num) : null, minorStdDev, total.minors.elapsed);
        opHistoryDetails.generate(req, sb);
    }

    private void doDetailTable(HttpServletRequest req, StringBuilder sb, HostAndPort address, int numTablets, TabletStats total, TabletStats historical) {
        Table detailTable = new Table("tServerDetail", "Details");
        detailTable.setSubCaption(address.getHost() + ":" + address.getPort());
        detailTable.addSortableColumn("Hosted&nbsp;Tablets", new NumberType(), null);
        detailTable.addSortableColumn("Entries", new NumberType(), null);
        detailTable.addSortableColumn("Minor&nbsp;Compacting", new NumberType(), null);
        detailTable.addSortableColumn("Major&nbsp;Compacting", new NumberType(), null);
        detailTable.addSortableColumn("Splitting", new NumberType(), null);
        detailTable.addRow(numTablets, total.numEntries, total.minors.status, total.majors.status, historical.splits.status);
        detailTable.generate(req, sb);
    }

    private static double stddev(double elapsed, double num, double sumDev) {
        if (num != 0.0) {
            double average = elapsed / num;
            return Math.sqrt(sumDev / num - average * average);
        }
        return 0.0;
    }

    private void doBadTserverList(HttpServletRequest req, StringBuilder sb) {
        if (Monitor.getMmi() != null && !Monitor.getMmi().badTServers.isEmpty()) {
            Table badTServerList = new Table("badtservers", "Non-Functioning&nbsp;Tablet&nbsp;Servers", "error");
            badTServerList.setSubCaption("The following tablet servers reported a status other than Online.");
            badTServerList.addSortableColumn("Tablet&nbsp;Server");
            badTServerList.addSortableColumn("Tablet&nbsp;Server&nbsp;Status");
            for (Map.Entry badserver : Monitor.getMmi().badTServers.entrySet()) {
                badTServerList.addRow(badserver.getKey(), TabletServerState.getStateById((byte)((Byte)badserver.getValue())).name());
            }
            badTServerList.generate(req, sb);
        }
    }

    private void doDeadTserverList(HttpServletRequest req, StringBuilder sb) {
        MasterMonitorInfo mmi = Monitor.getMmi();
        if (mmi != null) {
            List obit = mmi.deadTabletServers;
            Table deadTServerList = new Table("deaddtservers", "Dead&nbsp;Tablet&nbsp;Servers", "error");
            deadTServerList.setSubCaption("The following tablet servers are no longer reachable.");
            TServersServlet.doDeadServerTable(req, sb, deadTServerList, obit);
        }
    }

    public static void doDeadServerTable(HttpServletRequest req, StringBuilder sb, Table deadTServerList, List<DeadServer> obit) {
        if (obit != null && !obit.isEmpty()) {
            deadTServerList.addSortableColumn("Server");
            deadTServerList.addSortableColumn("Last&nbsp;Updated", new DateTimeType(2, 3), null);
            deadTServerList.addSortableColumn("Event");
            deadTServerList.addUnsortableColumn("Clear");
            for (DeadServer dead : obit) {
                deadTServerList.addRow(TServerLinkType.displayName(dead.server), dead.lastStatus, dead.status, "<a href='/op?action=clearDeadServer&redir=" + TServersServlet.currentPage(req) + "&server=" + TServersServlet.encode(dead.server) + "'>clear</a>");
            }
            deadTServerList.generate(req, sb);
        }
    }

    static void doTserverList(HttpServletRequest req, StringBuilder sb, List<TabletServerStatus> tservers, String tableId, Table tServerList) {
        int guessHighLoad = ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors();
        long now = System.currentTimeMillis();
        double avgLastContact = 0.0;
        double avgResponseTime = 0.0;
        int count = 0;
        for (TabletServerStatus status : tservers) {
            ++count;
            avgLastContact += (double)(now - status.lastContact);
            avgResponseTime += (double)status.responseTime;
        }
        tServerList.addSortableColumn("Server", new TServerLinkType(), null);
        tServerList.addSortableColumn("Hosted&nbsp;Tablets", new NumberType<Integer>(0, Integer.MAX_VALUE), null);
        tServerList.addSortableColumn("Last&nbsp;Contact", new DurationType(0L, (long)Math.min(avgLastContact * 4.0, 180000.0)), null);
        tServerList.addSortableColumn("Response&nbsp;Time", new DurationType(0L, (long)Math.min((avgResponseTime /= (double)count) * 4.0, 3000.0)), null);
        tServerList.addSortableColumn("Entries", new NumberType(), "The number of key/value pairs.");
        tServerList.addSortableColumn("Ingest", new NumberType(), "The number of key/value pairs inserted. (Note that deletes are also 'inserted')");
        tServerList.addSortableColumn("Query", new NumberType(), "The number of key/value pairs returned to clients. (Not the number of scans)");
        tServerList.addSortableColumn("Hold&nbsp;Time", new DurationType(), "The amount of time ingest is suspended waiting for data to be written to disk.");
        tServerList.addSortableColumn("Running<br />Scans", new CompactionsType("scans"), "The number of scans running and queued on this tablet server.");
        tServerList.addSortableColumn("Minor<br />Compactions", new CompactionsType("minor"), "The number of minor compactions running and (queued waiting for resources). Minor compactions are the operations where entries are flushed from memory to disk.");
        tServerList.addSortableColumn("Major<br />Compactions", new CompactionsType("major"), "The number of major compactions running and (queued waiting for resources). Major compactions are the operations where many smaller files are grouped into a larger file, eliminating duplicates and cleaning up deletes.");
        tServerList.addSortableColumn("Index Cache<br />Hit Rate", new PercentageType(), "The recent index cache hit rate.");
        tServerList.addSortableColumn("Data Cache<br />Hit Rate", new PercentageType(), "The recent data cache hit rate.");
        tServerList.addSortableColumn("OS&nbsp;Load", new NumberType<Double>(0.0, (double)guessHighLoad * 1.0, 0.0, (double)guessHighLoad * 3.0), "The Unix one minute load average. The average number of processes in the run queue over a one minute interval.");
        log.debug((Object)("tableId: " + tableId));
        for (TabletServerStatus status : tservers) {
            if (status == null) {
                status = NO_STATUS;
            }
            TableInfo summary = TableInfoUtil.summarizeTableStats((TabletServerStatus)status);
            if (tableId != null) {
                summary = (TableInfo)status.tableMap.get(tableId);
            }
            if (summary == null) continue;
            TableRow row = tServerList.prepareRow();
            row.add(status);
            row.add(summary.tablets);
            row.add(now - status.lastContact);
            row.add(status.responseTime);
            row.add(summary.recs);
            row.add(summary.ingestRate);
            row.add(summary.queryRate);
            row.add(status.holdTime);
            row.add(summary);
            row.add(summary);
            row.add(summary);
            double indexCacheHitRate = (double)status.indexCacheHits / (double)Math.max(status.indexCacheRequest, 1L);
            row.add(indexCacheHitRate);
            double dataCacheHitRate = (double)status.dataCacheHits / (double)Math.max(status.dataCacheRequest, 1L);
            row.add(dataCacheHitRate);
            row.add(status.osLoad);
            tServerList.addRow(row);
        }
        tServerList.generate(req, sb);
    }

    static class SecondType
    extends NumberType<Double> {
        private static final long serialVersionUID = 1L;

        SecondType() {
        }

        @Override
        public String format(Object obj) {
            if (obj == null) {
                return "&mdash;";
            }
            return Duration.format((long)((long)(1000.0 * (Double)obj)));
        }
    }
}

