/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.servlets;

import java.text.SimpleDateFormat;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.accumulo.core.gc.thrift.GCStatus;
import org.apache.accumulo.monitor.Monitor;
import org.apache.accumulo.monitor.servlets.BasicServlet;
import org.apache.accumulo.monitor.util.Table;
import org.apache.accumulo.monitor.util.celltypes.DateTimeType;
import org.apache.accumulo.monitor.util.celltypes.DurationType;
import org.apache.accumulo.monitor.util.celltypes.NumberType;

public class GcStatusServlet
extends BasicServlet {
    private static final long serialVersionUID = 1L;

    @Override
    protected String getTitle(HttpServletRequest req) {
        return "Garbage Collector Status";
    }

    @Override
    protected void pageBody(HttpServletRequest req, HttpServletResponse resp, StringBuilder sb) {
        GCStatus status = Monitor.getGcStatus();
        if (status != null) {
            Table gcActivity = new Table("gcActivity", "Collection&nbsp;Activity");
            gcActivity.addSortableColumn("Activity");
            gcActivity.addSortableColumn("Finished", new DateTimeType(new SimpleDateFormat("MMM dd, yyyy kk:mm")), null);
            gcActivity.addSortableColumn("Candidates", new NumberType(), null);
            gcActivity.addSortableColumn("Deleted", new NumberType(), null);
            gcActivity.addSortableColumn("In&nbsp;Use", new NumberType(), null);
            gcActivity.addSortableColumn("Errors", new NumberType<Long>(0L, 1L), null);
            gcActivity.addSortableColumn("Duration", new DurationType(), null);
            if (status.last.finished > 0L) {
                gcActivity.addRow("File&nbsp;Collection,&nbsp;Last&nbsp;Cycle", status.last.finished, status.last.candidates, status.last.deleted, status.last.inUse, status.last.errors, status.last.finished - status.last.started);
            }
            if (status.current.started > 0L) {
                gcActivity.addRow("File&nbsp;Collection,&nbsp;Running", status.current.finished, status.current.candidates, status.current.deleted, status.current.inUse, status.current.errors, System.currentTimeMillis() - status.current.started);
            }
            if (status.lastLog.finished > 0L) {
                gcActivity.addRow("WAL&nbsp;Collection,&nbsp;Last&nbsp;Cycle", status.lastLog.finished, status.lastLog.candidates, status.lastLog.deleted, status.lastLog.inUse, status.lastLog.errors, status.lastLog.finished - status.lastLog.started);
            }
            if (status.currentLog.started > 0L) {
                gcActivity.addRow("WAL&nbsp;Collection,&nbsp;Running", status.currentLog.finished, status.currentLog.candidates, status.currentLog.deleted, status.currentLog.inUse, status.currentLog.errors, System.currentTimeMillis() - status.currentLog.started);
            }
            gcActivity.generate(req, sb);
        } else {
            GcStatusServlet.banner(sb, "error", "Collector is Unavailable");
        }
    }
}

