
# line 45 "conf_parse.y"
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif /* HAVE_CONFIG_H */
#include <am_defs.h>
#include <amd.h>

extern char *conf_text;
extern int aconf_lineno;
extern int conf_lex(void);

static int conf_error(const char *s);
static int retval;
static char *header_section = NULL; /* start with no header section */

#define YYDEBUG 1

#define PARSE_DEBUG 0

#if PARSE_DEBUG
# define dprintf(f,s) fprintf(stderr, (f), aconf_lineno, (s))
# define amu_return(v)
#else /* not PARSE_DEBUG */
# define dprintf(f,s)
# define amu_return(v) return((v))
#endif /* not PARSE_DEBUG */


# line 73 "conf_parse.y"
typedef union
#ifdef __cplusplus
	YYSTYPE
#endif
 {
char *strtype;
} YYSTYPE;
# define LEFT_BRACKET 257
# define RIGHT_BRACKET 258
# define EQUAL 259
# define NEWLINE 260
# define NONWS_STRING 261
# define NONWSEQ_STRING 262
# define QUOTED_NONWSEQ_STRING 263

#include <inttypes.h>

#ifdef __STDC__
#include <stdlib.h>
#include <string.h>
#define	YYCONST	const
#else
#include <malloc.h>
#include <memory.h>
#define	YYCONST
#endif

#include <values.h>

#if defined(__cplusplus) || defined(__STDC__)

#if defined(__cplusplus) && defined(__EXTERN_C__)
extern "C" {
#endif
#ifndef conf_error
#if defined(__cplusplus)
	void conf_error(YYCONST char *);
#endif
#endif
#ifndef conf_lex
	int conf_lex(void);
#endif
	int conf_parse(void);
#if defined(__cplusplus) && defined(__EXTERN_C__)
}
#endif

#endif

#define conf_clearin conf_char = -1
#define conf_errok conf_errflag = 0
extern int conf_char;
extern int conf_errflag;
YYSTYPE conf_lval;
YYSTYPE conf_val;
typedef int conf_tabelem;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
#if YYMAXDEPTH > 0
int conf__conf_s[YYMAXDEPTH], *conf_s = conf__conf_s;
YYSTYPE conf__conf_v[YYMAXDEPTH], *conf_v = conf__conf_v;
#else	/* user does initial allocation */
int *conf_s;
YYSTYPE *conf_v;
#endif
static int conf_maxdepth = YYMAXDEPTH;
# define YYERRCODE 256

# line 148 "conf_parse.y"


static int
conf_error(const char *s)
{
  fprintf(stderr, "AMDCONF: %s on line %d (section %s)\n",
	  s, aconf_lineno,
	  (header_section ? header_section : "null"));
  exit(1);
  return 1;	/* to full compilers that insist on a return statement */
}
static YYCONST conf_tabelem conf_exca[] ={
-1, 0,
	260, 1,
	-2, 3,
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 17
# define YYLAST 30
static YYCONST conf_tabelem conf_act[]={

    21,    22,    23,    16,    15,    17,    27,    26,    25,    24,
     5,    19,    20,     9,    13,     6,     4,    14,     8,     7,
    10,     3,    11,    12,     2,     1,     0,     0,     0,    18 };
static YYCONST conf_tabelem conf_pact[]={

-10000000,-10000000,  -250,  -244,  -244,  -250,-10000000,  -244,  -257,  -256,
-10000000,-10000000,-10000000,-10000000,  -257,  -248,-10000000,  -246,-10000000,  -261,
  -251,  -252,  -253,  -254,-10000000,-10000000,-10000000,-10000000 };
static YYCONST conf_tabelem conf_pgo[]={

     0,    25,    24,    16,    15,    21,    19,    18,    14,    17 };
static YYCONST conf_tabelem conf_r1[]={

     0,     2,     1,     5,     1,     3,     3,     4,     4,     6,
     7,     8,     8,     9,     9,     9,     9 };
static YYCONST conf_tabelem conf_r2[]={

     0,     1,     6,     1,     4,     2,     4,     2,     4,     4,
     9,     2,     4,     9,     9,     9,     2 };
static YYCONST conf_tabelem conf_chk[]={

-10000000,    -1,    -2,    -5,    -3,   260,    -4,    -6,    -7,   257,
    -4,    -3,    -4,    -8,    -9,   261,   260,   261,    -8,   259,
   258,   261,   262,   263,   260,   260,   260,   260 };
static YYCONST conf_tabelem conf_def[]={

    -2,    -2,     0,     0,     0,     5,     4,     7,     0,     0,
     2,     6,     8,     9,    11,     0,    16,     0,    12,     0,
     0,     0,     0,     0,    10,    13,    14,    15 };
typedef struct
#ifdef __cplusplus
	conf_toktype
#endif
{
#ifdef __cplusplus
const
#endif
char *t_name; int t_val; } conf_toktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

conf_toktype conf_toks[] =
{
	"LEFT_BRACKET",	257,
	"RIGHT_BRACKET",	258,
	"EQUAL",	259,
	"NEWLINE",	260,
	"NONWS_STRING",	261,
	"NONWSEQ_STRING",	262,
	"QUOTED_NONWSEQ_STRING",	263,
	"-unknown-",	-1	/* ends search */
};

#ifdef __cplusplus
const
#endif
char * conf_reds[] =
{
	"-no such reduction-",
	"file : /* empty */",
	"file : newlines map_sections",
	"file : /* empty */",
	"file : map_sections",
	"newlines : NEWLINE",
	"newlines : NEWLINE newlines",
	"map_sections : map_section",
	"map_sections : map_section map_sections",
	"map_section : sec_header kv_pairs",
	"sec_header : LEFT_BRACKET NONWS_STRING RIGHT_BRACKET NEWLINE",
	"kv_pairs : kv_pair",
	"kv_pairs : kv_pair kv_pairs",
	"kv_pair : NONWS_STRING EQUAL NONWS_STRING NEWLINE",
	"kv_pair : NONWS_STRING EQUAL NONWSEQ_STRING NEWLINE",
	"kv_pair : NONWS_STRING EQUAL QUOTED_NONWSEQ_STRING NEWLINE",
	"kv_pair : NEWLINE",
};
#endif /* YYDEBUG */
# line	1 "/usr/ccs/bin/yaccpar"
/*
 * Copyright (c) 1993 by Sun Microsystems, Inc.
 */

#pragma ident	"@(#)yaccpar	6.16	99/01/20 SMI"

/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define YYERROR		goto conf_errlab
#define YYACCEPT	return(0)
#define YYABORT		return(1)
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( conf_char >= 0 || ( conf_r2[ conf_tmp ] >> 1 ) != 1 )\
	{\
		conf_error( "syntax error - cannot backup" );\
		goto conf_errlab;\
	}\
	conf_char = newtoken;\
	conf_state = *conf_ps;\
	conf_lval = newvalue;\
	goto conf_newstate;\
}
#define YYRECOVERING()	(!!conf_errflag)
#define YYNEW(type)	malloc(sizeof(type) * conf_newmax)
#define YYCOPY(to, from, type) \
	(type *) memcpy(to, (char *) from, conf_maxdepth * sizeof (type))
#define YYENLARGE( from, type) \
	(type *) realloc((char *) from, conf_newmax * sizeof(type))
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int conf_debug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-10000000)

/*
** global variables used by the parser
*/
YYSTYPE *conf_pv;			/* top of value stack */
int *conf_ps;			/* top of state stack */

int conf_state;			/* current state */
int conf_tmp;			/* extra var (lasts between blocks) */

int conf_nerrs;			/* number of errors */
int conf_errflag;			/* error recovery flag */
int conf_char;			/* current input token number */



#ifdef YYNMBCHARS
#define YYLEX()		conf_cvtok(conf_lex())
/*
** conf_cvtok - return a token if i is a wchar_t value that exceeds 255.
**	If i<255, i itself is the token.  If i>255 but the neither 
**	of the 30th or 31st bit is on, i is already a token.
*/
#if defined(__STDC__) || defined(__cplusplus)
int conf_cvtok(int i)
#else
int conf_cvtok(i) int i;
#endif
{
	int first = 0;
	int last = YYNMBCHARS - 1;
	int mid;
	wchar_t j;

	if(i&0x60000000){/*Must convert to a token. */
		if( conf_mbchars[last].character < i ){
			return i;/*Giving up*/
		}
		while ((last>=first)&&(first>=0)) {/*Binary search loop*/
			mid = (first+last)/2;
			j = conf_mbchars[mid].character;
			if( j==i ){/*Found*/ 
				return conf_mbchars[mid].tvalue;
			}else if( j<i ){
				first = mid + 1;
			}else{
				last = mid -1;
			}
		}
		/*No entry in the table.*/
		return i;/* Giving up.*/
	}else{/* i is already a token. */
		return i;
	}
}
#else/*!YYNMBCHARS*/
#define YYLEX()		conf_lex()
#endif/*!YYNMBCHARS*/

/*
** conf_parse - return 0 if worked, 1 if syntax error not recovered from
*/
#if defined(__STDC__) || defined(__cplusplus)
int conf_parse(void)
#else
int conf_parse()
#endif
{
	register YYSTYPE *conf_pvt = 0;	/* top of value stack for $vars */

#if defined(__cplusplus) || defined(lint)
/*
	hacks to please C++ and lint - goto's inside
	switch should never be executed
*/
	static int __yaccpar_lint_hack__ = 0;
	switch (__yaccpar_lint_hack__)
	{
		case 1: goto conf_errlab;
		case 2: goto conf_newstate;
	}
#endif

	/*
	** Initialize externals - conf_parse may be called more than once
	*/
	conf_pv = &conf_v[-1];
	conf_ps = &conf_s[-1];
	conf_state = 0;
	conf_tmp = 0;
	conf_nerrs = 0;
	conf_errflag = 0;
	conf_char = -1;

#if YYMAXDEPTH <= 0
	if (conf_maxdepth <= 0)
	{
		if ((conf_maxdepth = YYEXPAND(0)) <= 0)
		{
			conf_error("yacc initialization error");
			YYABORT;
		}
	}
#endif

	{
		register YYSTYPE *conf__pv;	/* top of value stack */
		register int *conf__ps;		/* top of state stack */
		register int conf__state;		/* current state */
		register int  conf__n;		/* internal state number info */
	goto conf_stack;	/* moved from 6 lines above to here to please C++ */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	conf_newstate:
		conf__pv = conf_pv;
		conf__ps = conf_ps;
		conf__state = conf_state;
		goto conf__newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	conf_stack:
		conf__pv = conf_pv;
		conf__ps = conf_ps;
		conf__state = conf_state;

		/*
		** top of for (;;) loop while no reductions done
		*/
	conf__stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( conf_debug )
		{
			register int conf__i;

			printf( "State %d, token ", conf__state );
			if ( conf_char == 0 )
				printf( "end-of-file\n" );
			else if ( conf_char < 0 )
				printf( "-none-\n" );
			else
			{
				for ( conf__i = 0; conf_toks[conf__i].t_val >= 0;
					conf__i++ )
				{
					if ( conf_toks[conf__i].t_val == conf_char )
						break;
				}
				printf( "%s\n", conf_toks[conf__i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++conf__ps >= &conf_s[ conf_maxdepth ] )	/* room on stack? */
		{
			/*
			** reallocate and recover.  Note that pointers
			** have to be reset, or bad things will happen
			*/
			long conf_ps_index = (conf__ps - conf_s);
			long conf_pv_index = (conf__pv - conf_v);
			long conf_pvt_index = (conf_pvt - conf_v);
			int conf_newmax;
#ifdef YYEXPAND
			conf_newmax = YYEXPAND(conf_maxdepth);
#else
			conf_newmax = 2 * conf_maxdepth;	/* double table size */
			if (conf_maxdepth == YYMAXDEPTH)	/* first time growth */
			{
				char *newconf_s = (char *)YYNEW(int);
				char *newconf_v = (char *)YYNEW(YYSTYPE);
				if (newconf_s != 0 && newconf_v != 0)
				{
					conf_s = YYCOPY(newconf_s, conf_s, int);
					conf_v = YYCOPY(newconf_v, conf_v, YYSTYPE);
				}
				else
					conf_newmax = 0;	/* failed */
			}
			else				/* not first time */
			{
				conf_s = YYENLARGE(conf_s, int);
				conf_v = YYENLARGE(conf_v, YYSTYPE);
				if (conf_s == 0 || conf_v == 0)
					conf_newmax = 0;	/* failed */
			}
#endif
			if (conf_newmax <= conf_maxdepth)	/* tables not expanded */
			{
				conf_error( "yacc stack overflow" );
				YYABORT;
			}
			conf_maxdepth = conf_newmax;

			conf__ps = conf_s + conf_ps_index;
			conf__pv = conf_v + conf_pv_index;
			conf_pvt = conf_v + conf_pvt_index;
		}
		*conf__ps = conf__state;
		*++conf__pv = conf_val;

		/*
		** we have a new state - find out what to do
		*/
	conf__newstate:
		if ( ( conf__n = conf_pact[ conf__state ] ) <= YYFLAG )
			goto conf_default;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		conf_tmp = conf_char < 0;
#endif
		if ( ( conf_char < 0 ) && ( ( conf_char = YYLEX() ) < 0 ) )
			conf_char = 0;		/* reached EOF */
#if YYDEBUG
		if ( conf_debug && conf_tmp )
		{
			register int conf__i;

			printf( "Received token " );
			if ( conf_char == 0 )
				printf( "end-of-file\n" );
			else if ( conf_char < 0 )
				printf( "-none-\n" );
			else
			{
				for ( conf__i = 0; conf_toks[conf__i].t_val >= 0;
					conf__i++ )
				{
					if ( conf_toks[conf__i].t_val == conf_char )
						break;
				}
				printf( "%s\n", conf_toks[conf__i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( conf__n += conf_char ) < 0 ) || ( conf__n >= YYLAST ) )
			goto conf_default;
		if ( conf_chk[ conf__n = conf_act[ conf__n ] ] == conf_char )	/*valid shift*/
		{
			conf_char = -1;
			conf_val = conf_lval;
			conf__state = conf__n;
			if ( conf_errflag > 0 )
				conf_errflag--;
			goto conf__stack;
		}

	conf_default:
		if ( ( conf__n = conf_def[ conf__state ] ) == -2 )
		{
#if YYDEBUG
			conf_tmp = conf_char < 0;
#endif
			if ( ( conf_char < 0 ) && ( ( conf_char = YYLEX() ) < 0 ) )
				conf_char = 0;		/* reached EOF */
#if YYDEBUG
			if ( conf_debug && conf_tmp )
			{
				register int conf__i;

				printf( "Received token " );
				if ( conf_char == 0 )
					printf( "end-of-file\n" );
				else if ( conf_char < 0 )
					printf( "-none-\n" );
				else
				{
					for ( conf__i = 0;
						conf_toks[conf__i].t_val >= 0;
						conf__i++ )
					{
						if ( conf_toks[conf__i].t_val
							== conf_char )
						{
							break;
						}
					}
					printf( "%s\n", conf_toks[conf__i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register YYCONST int *conf_xi = conf_exca;

				while ( ( *conf_xi != -1 ) ||
					( conf_xi[1] != conf__state ) )
				{
					conf_xi += 2;
				}
				while ( ( *(conf_xi += 2) >= 0 ) &&
					( *conf_xi != conf_char ) )
					;
				if ( ( conf__n = conf_xi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( conf__n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( conf_errflag )
			{
			case 0:		/* new error */
				conf_error( "syntax error" );
				goto skip_init;
			conf_errlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				conf__pv = conf_pv;
				conf__ps = conf_ps;
				conf__state = conf_state;
			skip_init:
				conf_nerrs++;
				/* FALLTHRU */
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				conf_errflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( conf__ps >= conf_s )
				{
					conf__n = conf_pact[ *conf__ps ] + YYERRCODE;
					if ( conf__n >= 0 && conf__n < YYLAST &&
						conf_chk[conf_act[conf__n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						conf__state = conf_act[ conf__n ];
						goto conf__stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( conf_debug )
						printf( _POP_, *conf__ps,
							conf__ps[-1] );
#	undef _POP_
#endif
					conf__ps--;
					conf__pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( conf_debug )
				{
					register int conf__i;

					printf( "Error recovery discards " );
					if ( conf_char == 0 )
						printf( "token end-of-file\n" );
					else if ( conf_char < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( conf__i = 0;
							conf_toks[conf__i].t_val >= 0;
							conf__i++ )
						{
							if ( conf_toks[conf__i].t_val
								== conf_char )
							{
								break;
							}
						}
						printf( "token %s\n",
							conf_toks[conf__i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( conf_char == 0 )	/* reached EOF. quit */
					YYABORT;
				conf_char = -1;
				goto conf__newstate;
			}
		}/* end if ( conf__n == 0 ) */
		/*
		** reduction by production conf__n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( conf_debug )
			printf( "Reduce by (%d) \"%s\"\n",
				conf__n, conf_reds[ conf__n ] );
#endif
		conf_tmp = conf__n;			/* value to switch over */
		conf_pvt = conf__pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using conf__state here as temporary
		** register variable, but why not, if it works...
		** If conf_r2[ conf__n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto conf__stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int conf__len = conf_r2[ conf__n ];

			if ( !( conf__len & 01 ) )
			{
				conf__len >>= 1;
				conf_val = ( conf__pv -= conf__len )[1];	/* $$ = $1 */
				conf__state = conf_pgo[ conf__n = conf_r1[ conf__n ] ] +
					*( conf__ps -= conf__len ) + 1;
				if ( conf__state >= YYLAST ||
					conf_chk[ conf__state =
					conf_act[ conf__state ] ] != -conf__n )
				{
					conf__state = conf_act[ conf_pgo[ conf__n ] ];
				}
				goto conf__stack;
			}
			conf__len >>= 1;
			conf_val = ( conf__pv -= conf__len )[1];	/* $$ = $1 */
			conf__state = conf_pgo[ conf__n = conf_r1[ conf__n ] ] +
				*( conf__ps -= conf__len ) + 1;
			if ( conf__state >= YYLAST ||
				conf_chk[ conf__state = conf_act[ conf__state ] ] != -conf__n )
			{
				conf__state = conf_act[ conf_pgo[ conf__n ] ];
			}
		}
					/* save until reenter driver code */
		conf_state = conf__state;
		conf_ps = conf__ps;
		conf_pv = conf__pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( conf_tmp )
	{
		
case 1:
# line 87 "conf_parse.y"
{ conf_debug = PARSE_DEBUG; } break;
case 3:
# line 88 "conf_parse.y"
{ conf_debug = PARSE_DEBUG; } break;
case 10:
# line 103 "conf_parse.y"
{
		  if (conf_debug)
		    fprintf(stderr, "sec_header1 = \"%s\"\n", conf_pvt[-2].strtype);
		  header_section = conf_pvt[-2].strtype;
		} break;
case 13:
# line 115 "conf_parse.y"
{
		  if (conf_debug)
		    fprintf(stderr,"parse1: key=\"%s\", val=\"%s\"\n", conf_pvt[-3].strtype, conf_pvt[-1].strtype);
		  retval = set_conf_kv(header_section, conf_pvt[-3].strtype, conf_pvt[-1].strtype);
		  if (retval != 0) {
		    conf_error("syntax error");
		    YYABORT;
		  }
		} break;
case 14:
# line 125 "conf_parse.y"
{
		  if (conf_debug)
		    fprintf(stderr,"parse2: key=\"%s\", val=\"%s\"\n", conf_pvt[-3].strtype, conf_pvt[-1].strtype);
		  retval = set_conf_kv(header_section, conf_pvt[-3].strtype, conf_pvt[-1].strtype);
		  if (retval != 0) {
		    conf_error("syntax error");
		    YYABORT;
		  }
		} break;
case 15:
# line 135 "conf_parse.y"
{
		  if (conf_debug)
		    fprintf(stderr,"parse3: key=\"%s\", val=\"%s\"\n", conf_pvt[-3].strtype, conf_pvt[-1].strtype);
		  retval = set_conf_kv(header_section, conf_pvt[-3].strtype, conf_pvt[-1].strtype);
		  if (retval != 0) {
		    conf_error("syntax error");
		    YYABORT;
		  }
		} break;
# line	531 "/usr/ccs/bin/yaccpar"
	}
	goto conf_stack;		/* reset registers in driver code */
}

