/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with sun_map_ or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum sun_map_tokentype {
     NEWLINE = 258,
     COMMENT = 259,
     WSPACE = 260,
     WORD = 261
   };
#endif
#define NEWLINE 258
#define COMMENT 259
#define WSPACE 260
#define WORD 261




/* Copy the first part of user declarations.  */
#line 1 "sun_map_parse.y"

/*
 * Copyright (c) 1997-2006 Erez Zadok
 * Copyright (c) 2005 Daniel P. Ottavio
 * Copyright (c) 1990 Jan-Simon Pendry
 * Copyright (c) 1990 Imperial College of Science, Technology & Medicine
 * Copyright (c) 1990 The Regents of the University of California.
 * All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Jan-Simon Pendry at Imperial College, London.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgment:
 *      This product includes software developed by the University of
 *      California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *
 * File: am-utils/amd/sun_map_parse.y
 *
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif /* HAVE_CONFIG_H */
#include <am_defs.h>
#include <amd.h>
#include <sun_map.h>


#define SUN_FSTYPE_STR  "fstype="


extern int sun_map_lex(void);
extern int sun_map_error(const char *);
extern void sun_map_tok_setbuff(const char *);
extern int sun_map_parse(void);

struct sun_entry *sun_map_parse_read(const char *);

static struct sun_list *sun_entry_list = NULL;
static struct sun_list *sun_opt_list = NULL;
static struct sun_list *sun_host_list = NULL;
static struct sun_list *sun_location_list = NULL;
static struct sun_list *mountpt_list = NULL;
static char *tmpFsType = NULL;


/*
 * Each get* function returns a pointer to the corresponding global
 * list structure.  If the structure is NULL than a new instance is
 * returned.
 */
static struct sun_list *get_sun_opt_list();
static struct sun_list *get_sun_host_list();
static struct sun_list *get_sun_location_list();
static struct sun_list *get_mountpt_list();
static struct sun_list *get_sun_entry_list();



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 85 "sun_map_parse.y"
typedef union YYSTYPE {
  char strval[2048];
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 175 "sun_map_parse.c"
# define sun_map_stype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 187 "sun_map_parse.c"

#if ! defined (sun_map_overflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (sun_map_overflow) || YYERROR_VERBOSE */


#if (! defined (sun_map_overflow) \
     && (! defined (__cplusplus) \
	 || (YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union sun_map_alloc
{
  short sun_map_ss;
  YYSTYPE sun_map_vs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union sun_map_alloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T sun_map_i;		\
	  for (sun_map_i = 0; sun_map_i < (Count); sun_map_i++)	\
	    (To)[sun_map_i] = (From)[sun_map_i];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T sun_map_newbytes;						\
	YYCOPY (&sun_map_ptr->Stack, Stack, sun_map_size);				\
	Stack = &sun_map_ptr->Stack;						\
	sun_map_newbytes = sun_map_stacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	sun_map_ptr += sun_map_newbytes / sizeof (*sun_map_ptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char sun_map_signed_char;
#else
   typedef short sun_map_signed_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  24
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   47

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  12
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  15
/* YYNRULES -- Number of rules. */
#define YYNRULES  29
/* YYNRULES -- Number of states. */
#define YYNSTATES  50

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   261

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? sun_map_translate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char sun_map_translate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      10,    11,     2,     2,     9,     7,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     8,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned char sun_map_prhs[] =
{
       0,     0,     3,     5,     8,    10,    12,    15,    19,    21,
      24,    26,    31,    33,    38,    40,    44,    48,    55,    57,
      61,    65,    68,    70,    74,    76,    79,    83,    85,    89
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const sun_map_signed_char sun_map_rhs[] =
{
      13,     0,    -1,    14,    -1,    16,    15,    -1,    15,    -1,
      17,    -1,    17,    16,    -1,    17,    16,    15,    -1,     3,
      -1,     3,    16,    -1,    20,    -1,     7,    25,     5,    20,
      -1,    18,    -1,     7,    25,     5,    18,    -1,    19,    -1,
      19,     5,    18,    -1,     6,     5,    21,    -1,     6,     5,
       7,    25,     5,    21,    -1,    21,    -1,    21,     5,    20,
      -1,    22,     8,     6,    -1,     8,     6,    -1,    23,    -1,
      23,     9,    22,    -1,     6,    -1,     6,    24,    -1,    10,
       6,    11,    -1,    26,    -1,    26,     9,    25,    -1,     6,
      -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short sun_map_rline[] =
{
       0,    94,    94,    97,    98,   101,   102,   103,   106,   107,
     110,   131,   166,   187,   224,   225,   228,   251,   290,   291,
     294,   317,   331,   332,   335,   346,   359,   374,   375,   378
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const sun_map_tname[] =
{
  "$end", "error", "$undefined", "NEWLINE", "COMMENT", "WSPACE", "WORD", 
  "'-'", "':'", "','", "'('", "')'", "$accept", "amap", "file", "entries", 
  "new_lines", "entry", "mountpoints", "mountpoint", "locations", 
  "location", "hosts", "host", "weight", "options", "option", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short sun_map_toknum[] =
{
       0,   256,   257,   258,   259,   260,   261,    45,    58,    44,
      40,    41
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char sun_map_r1[] =
{
       0,    12,    13,    14,    14,    15,    15,    15,    16,    16,
      17,    17,    17,    17,    18,    18,    19,    19,    20,    20,
      21,    21,    22,    22,    23,    23,    24,    25,    25,    26
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char sun_map_r2[] =
{
       0,     2,     1,     2,     1,     1,     2,     3,     1,     2,
       1,     4,     1,     4,     1,     3,     3,     6,     1,     3,
       3,     2,     1,     3,     1,     2,     3,     1,     3,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned char sun_map_defact[] =
{
       0,     8,    24,     0,     0,     0,     2,     4,     0,     5,
      12,    14,    10,    18,     0,    22,     9,     0,     0,    25,
      29,     0,    27,    21,     1,     3,     6,     0,     0,     0,
       0,    24,     0,    16,     0,     0,     0,     7,     0,    15,
      19,    20,    23,     0,    26,    13,    11,    28,     0,    17
};

/* YYDEFGOTO[NTERM-NUM]. */
static const sun_map_signed_char sun_map_defgoto[] =
{
      -1,     5,     6,     7,     8,     9,    10,    11,    12,    13,
      14,    15,    19,    21,    22
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -25
static const sun_map_signed_char sun_map_pact[] =
{
      10,    11,    -1,     9,    23,    30,   -25,   -25,     0,    11,
     -25,    27,   -25,    28,    26,    29,   -25,    15,    31,   -25,
     -25,    34,    32,   -25,   -25,   -25,     0,    36,    19,    37,
      38,    25,     9,   -25,    35,    20,     9,   -25,    40,   -25,
     -25,   -25,   -25,    42,   -25,   -25,   -25,   -25,    19,   -25
};

/* YYPGOTO[NTERM-NUM].  */
static const sun_map_signed_char sun_map_pgoto[] =
{
     -25,   -25,   -25,    -7,     1,   -25,   -24,   -25,   -23,   -17,
       6,   -25,   -25,   -12,   -25
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1
static const unsigned char sun_map_table[] =
{
      33,    25,    16,    39,    17,    40,     2,     3,     4,    18,
      26,    45,    46,     1,     1,    20,     2,     3,     4,    37,
      43,    31,    32,     4,    47,    31,     2,     4,     4,    23,
      24,    49,    27,    28,    29,    18,    42,    34,    30,    35,
       0,    36,    38,    41,    31,    17,    44,    48
};

static const sun_map_signed_char sun_map_check[] =
{
      17,     8,     1,    27,     5,    28,     6,     7,     8,    10,
       9,    35,    35,     3,     3,     6,     6,     7,     8,    26,
      32,     6,     7,     8,    36,     6,     6,     8,     8,     6,
       0,    48,     5,     5,     8,    10,    30,     6,     9,     5,
      -1,     9,     6,     6,     6,     5,    11,     5
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char sun_map_stos[] =
{
       0,     3,     6,     7,     8,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    16,     5,    10,    24,
       6,    25,    26,     6,     0,    15,    16,     5,     5,     8,
       9,     6,     7,    21,     6,     5,     9,    15,     6,    18,
      20,     6,    22,    25,    11,    18,    20,    25,     5,    21
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define sun_map_errok		(sun_map_errstatus = 0)
#define sun_map_clearin	(sun_map_char = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto sun_map_acceptlab
#define YYABORT		goto sun_map_abortlab
#define YYERROR		goto sun_map_errlab1

/* Like YYERROR except do call sun_map_error.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto sun_map_errlab

#define YYRECOVERING()  (!!sun_map_errstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (sun_map_char == YYEMPTY && sun_map_len == 1)				\
    {								\
      sun_map_char = (Token);						\
      sun_map_lval = (Value);						\
      sun_map_token = YYTRANSLATE (sun_map_char);				\
      YYPOPSTACK;						\
      goto sun_map_backup;						\
    }								\
  else								\
    { 								\
      sun_map_error ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)         \
  Current.first_line   = Rhs[1].first_line;      \
  Current.first_column = Rhs[1].first_column;    \
  Current.last_line    = Rhs[N].last_line;       \
  Current.last_column  = Rhs[N].last_column;
#endif

/* YYLEX -- calling `sun_map_lex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX sun_map_lex (YYLEX_PARAM)
#else
# define YYLEX sun_map_lex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (sun_map_debug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (sun_map_debug)					\
    sun_map_symprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (sun_map_debug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      sun_map_symprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| sun_map__stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (cinluded).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
sun_map__stack_print (short *bottom, short *top)
#else
static void
sun_map__stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (sun_map_debug)							\
    sun_map__stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
sun_map__reduce_print (int sun_map_rule)
#else
static void
sun_map__reduce_print (sun_map_rule)
    int sun_map_rule;
#endif
{
  int sun_map_i;
  unsigned int sun_map_lineno = sun_map_rline[sun_map_rule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             sun_map_rule - 1, sun_map_lineno);
  /* Print the symbols being reduced, and their result.  */
  for (sun_map_i = sun_map_prhs[sun_map_rule]; 0 <= sun_map_rhs[sun_map_i]; sun_map_i++)
    YYFPRINTF (stderr, "%s ", sun_map_tname [sun_map_rhs[sun_map_i]]);
  YYFPRINTF (stderr, "-> %s\n", sun_map_tname [sun_map_r1[sun_map_rule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (sun_map_debug)				\
    sun_map__reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int sun_map_debug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef sun_map_strlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define sun_map_strlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
sun_map_strlen (const char *sun_map_str)
#   else
sun_map_strlen (sun_map_str)
     const char *sun_map_str;
#   endif
{
  register const char *sun_map_s = sun_map_str;

  while (*sun_map_s++ != '\0')
    continue;

  return sun_map_s - sun_map_str - 1;
}
#  endif
# endif

# ifndef sun_map_stpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define sun_map_stpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
sun_map_stpcpy (char *sun_map_dest, const char *sun_map_src)
#   else
sun_map_stpcpy (sun_map_dest, sun_map_src)
     char *sun_map_dest;
     const char *sun_map_src;
#   endif
{
  register char *sun_map_d = sun_map_dest;
  register const char *sun_map_s = sun_map_src;

  while ((*sun_map_d++ = *sun_map_s++) != '\0')
    continue;

  return sun_map_d - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
sun_map_symprint (FILE *sun_map_output, int sun_map_type, YYSTYPE *sun_map_valuep)
#else
static void
sun_map_symprint (sun_map_output, sun_map_type, sun_map_valuep)
    FILE *sun_map_output;
    int sun_map_type;
    YYSTYPE *sun_map_valuep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) sun_map_valuep;

  if (sun_map_type < YYNTOKENS)
    {
      YYFPRINTF (sun_map_output, "token %s (", sun_map_tname[sun_map_type]);
# ifdef YYPRINT
      YYPRINT (sun_map_output, sun_map_toknum[sun_map_type], *sun_map_valuep);
# endif
    }
  else
    YYFPRINTF (sun_map_output, "nterm %s (", sun_map_tname[sun_map_type]);

  switch (sun_map_type)
    {
      default:
        break;
    }
  YYFPRINTF (sun_map_output, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
sun_map_destruct (int sun_map_type, YYSTYPE *sun_map_valuep)
#else
static void
sun_map_destruct (sun_map_type, sun_map_valuep)
    int sun_map_type;
    YYSTYPE *sun_map_valuep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) sun_map_valuep;

  switch (sun_map_type)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int sun_map_parse (void *YYPARSE_PARAM);
# else
int sun_map_parse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int sun_map_parse (void);
#else
int sun_map_parse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The lookahead symbol.  */
int sun_map_char;

/* The semantic value of the lookahead symbol.  */
YYSTYPE sun_map_lval;

/* Number of syntax errors so far.  */
int sun_map_nerrs;



/*----------.
| sun_map_parse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int sun_map_parse (void *YYPARSE_PARAM)
# else
int sun_map_parse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
sun_map_parse (void)
#else
int
sun_map_parse ()

#endif
#endif
{
  
  register int sun_map_state;
  register int sun_map_n;
  int sun_map_result;
  /* Number of tokens to shift before error messages enabled.  */
  int sun_map_errstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int sun_map_token = 0;

  /* Three stacks and their tools:
     `sun_map_ss': related to states,
     `sun_map_vs': related to semantic values,
     `sun_map_ls': related to locations.

     Refer to the stacks thru separate pointers, to allow sun_map_overflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	sun_map_ssa[YYINITDEPTH];
  short *sun_map_ss = sun_map_ssa;
  register short *sun_map_ssp;

  /* The semantic value stack.  */
  YYSTYPE sun_map_vsa[YYINITDEPTH];
  YYSTYPE *sun_map_vs = sun_map_vsa;
  register YYSTYPE *sun_map_vsp;



#define YYPOPSTACK   (sun_map_vsp--, sun_map_ssp--)

  YYSIZE_T sun_map_stacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE sun_map_val;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int sun_map_len;

  YYDPRINTF ((stderr, "Starting parse\n"));

  sun_map_state = 0;
  sun_map_errstatus = 0;
  sun_map_nerrs = 0;
  sun_map_char = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  sun_map_ssp = sun_map_ss;
  sun_map_vsp = sun_map_vs;

  goto sun_map_setstate;

/*------------------------------------------------------------.
| sun_map_newstate -- Push a new state, which is found in sun_map_state.  |
`------------------------------------------------------------*/
 sun_map_newstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  sun_map_ssp++;

 sun_map_setstate:
  *sun_map_ssp = sun_map_state;

  if (sun_map_ss + sun_map_stacksize - 1 <= sun_map_ssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T sun_map_size = sun_map_ssp - sun_map_ss + 1;

#ifdef sun_map_overflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *sun_map_vs1 = sun_map_vs;
	short *sun_map_ss1 = sun_map_ss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if sun_map_overflow is a macro.  */
	sun_map_overflow ("parser stack overflow",
		    &sun_map_ss1, sun_map_size * sizeof (*sun_map_ssp),
		    &sun_map_vs1, sun_map_size * sizeof (*sun_map_vsp),

		    &sun_map_stacksize);

	sun_map_ss = sun_map_ss1;
	sun_map_vs = sun_map_vs1;
      }
#else /* no sun_map_overflow */
# ifndef YYSTACK_RELOCATE
      goto sun_map_overflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= sun_map_stacksize)
	goto sun_map_overflowlab;
      sun_map_stacksize *= 2;
      if (YYMAXDEPTH < sun_map_stacksize)
	sun_map_stacksize = YYMAXDEPTH;

      {
	short *sun_map_ss1 = sun_map_ss;
	union sun_map_alloc *sun_map_ptr =
	  (union sun_map_alloc *) YYSTACK_ALLOC (YYSTACK_BYTES (sun_map_stacksize));
	if (! sun_map_ptr)
	  goto sun_map_overflowlab;
	YYSTACK_RELOCATE (sun_map_ss);
	YYSTACK_RELOCATE (sun_map_vs);

#  undef YYSTACK_RELOCATE
	if (sun_map_ss1 != sun_map_ssa)
	  YYSTACK_FREE (sun_map_ss1);
      }
# endif
#endif /* no sun_map_overflow */

      sun_map_ssp = sun_map_ss + sun_map_size - 1;
      sun_map_vsp = sun_map_vs + sun_map_size - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) sun_map_stacksize));

      if (sun_map_ss + sun_map_stacksize - 1 <= sun_map_ssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", sun_map_state));

  goto sun_map_backup;

/*-----------.
| sun_map_backup.  |
`-----------*/
sun_map_backup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* sun_map_resume: */

  /* First try to decide what to do without reference to lookahead token.  */

  sun_map_n = sun_map_pact[sun_map_state];
  if (sun_map_n == YYPACT_NINF)
    goto sun_map_default;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (sun_map_char == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      sun_map_char = YYLEX;
    }

  if (sun_map_char <= YYEOF)
    {
      sun_map_char = sun_map_token = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      sun_map_token = YYTRANSLATE (sun_map_char);
      YYDSYMPRINTF ("Next token is", sun_map_token, &sun_map_lval, &sun_map_lloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  sun_map_n += sun_map_token;
  if (sun_map_n < 0 || YYLAST < sun_map_n || sun_map_check[sun_map_n] != sun_map_token)
    goto sun_map_default;
  sun_map_n = sun_map_table[sun_map_n];
  if (sun_map_n <= 0)
    {
      if (sun_map_n == 0 || sun_map_n == YYTABLE_NINF)
	goto sun_map_errlab;
      sun_map_n = -sun_map_n;
      goto sun_map_reduce;
    }

  if (sun_map_n == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", sun_map_tname[sun_map_token]));

  /* Discard the token being shifted unless it is eof.  */
  if (sun_map_char != YYEOF)
    sun_map_char = YYEMPTY;

  *++sun_map_vsp = sun_map_lval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (sun_map_errstatus)
    sun_map_errstatus--;

  sun_map_state = sun_map_n;
  goto sun_map_newstate;


/*-----------------------------------------------------------.
| sun_map_default -- do the default action for the current state.  |
`-----------------------------------------------------------*/
sun_map_default:
  sun_map_n = sun_map_defact[sun_map_state];
  if (sun_map_n == 0)
    goto sun_map_errlab;
  goto sun_map_reduce;


/*-----------------------------.
| sun_map_reduce -- Do a reduction.  |
`-----------------------------*/
sun_map_reduce:
  /* sun_map_n is the number of a rule to reduce with.  */
  sun_map_len = sun_map_r2[sun_map_n];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  sun_map_val = sun_map_vsp[1-sun_map_len];


  YY_REDUCE_PRINT (sun_map_n);
  switch (sun_map_n)
    {
        case 10:
#line 110 "sun_map_parse.y"
    {

  struct sun_list *list;
  struct sun_entry *entry;

  /* allocate an entry */
  entry = CALLOC(struct sun_entry);

  /*
   * Assign the global location list to this entry and reset the
   * global pointer.  Reseting the global pointer will create a new
   * list instance next time get_sun_location_list() is called.
   */
  list = get_sun_location_list();
  entry->location_list = (struct sun_location *)list->first;
  sun_location_list = NULL;

   /* Add this entry to the entry list. */
  sun_list_add(get_sun_entry_list(), (qelem *)entry);
}
    break;

  case 11:
#line 131 "sun_map_parse.y"
    {

  struct sun_list *list;
  struct sun_entry *entry;

  entry = CALLOC(struct sun_entry);

  /* An fstype may have been defined in the 'options'. */
  if (tmpFsType != NULL) {
    entry->fstype = tmpFsType;
    tmpFsType = NULL;
  }

  /*
   * Assign the global location list to this entry and reset the
   * global pointer.  Reseting the global pointer will create a new
   * list instance next time get_sun_location_list() is called.
   */
  list = get_sun_location_list();
  entry->location_list = (struct sun_location *)list->first;
  sun_location_list = NULL;

  /*
   * Assign the global opt list to this entry and reset the global
   * pointer.  Reseting the global pointer will create a new list
   * instance next time get_sun_opt_list() is called.
   */
  list = get_sun_opt_list();
  entry->opt_list = (struct sun_opt *)list->first;
  sun_opt_list = NULL;

  /* Add this entry to the entry list. */
  sun_list_add(get_sun_entry_list(), (qelem *)entry);
}
    break;

  case 12:
#line 166 "sun_map_parse.y"
    {

  struct sun_list *list;
  struct sun_entry *entry;

  /* allocate an entry */
  entry = CALLOC(struct sun_entry);

  /*
   * Assign the global mountpt list to this entry and reset the global
   * pointer.  Reseting the global pointer will create a new list
   * instance next time get_mountpt_list() is called.
   */
  list = get_mountpt_list();
  entry->mountpt_list = (struct sun_mountpt *)list->first;
  mountpt_list = NULL;

  /* Add this entry to the entry list. */
  sun_list_add(get_sun_entry_list(), (qelem *)entry);
}
    break;

  case 13:
#line 187 "sun_map_parse.y"
    {

  struct sun_list *list;
  struct sun_entry *entry;

  /* allocate an entry */
  entry = CALLOC(struct sun_entry);

  /* An fstype may have been defined in the 'options'. */
  if (tmpFsType != NULL) {
    entry->fstype = tmpFsType;
    tmpFsType = NULL;
  }

  /*
   * Assign the global mountpt list to this entry and reset the global
   * pointer.  Reseting the global pointer will create a new list
   * instance next time get_mountpt_list() is called.
   */
  list = get_mountpt_list();
  entry->mountpt_list = (struct sun_mountpt *)list->first;
  mountpt_list = NULL;

  /*
   * Assign the global opt list to this entry and reset the global
   * pointer.  Reseting the global pointer will create a new list
   * instance next time get_sun_opt_list() is called.
   */
  list = get_sun_opt_list();
  entry->opt_list = (struct sun_opt *)list->first;
  sun_opt_list = NULL;

  /* Add this entry to the entry list. */
  sun_list_add(get_sun_entry_list(), (qelem *)entry);
}
    break;

  case 16:
#line 228 "sun_map_parse.y"
    {

  struct sun_list *list;
  struct sun_mountpt *mountpt;

  /* allocate a mountpt */
  mountpt = CALLOC(struct sun_mountpt);

  /*
   * Assign the global loaction list to this entry and reset the
   * global pointer.  Reseting the global pointer will create a new
   * list instance next time get_sun_location_list() is called.
   */
  list = get_sun_location_list();
  mountpt->location_list = (struct sun_location *)list->first;
  sun_location_list = NULL;

  mountpt->path = strdup(sun_map_vsp[-2].strval);

  /* Add this mountpt to the mountpt list. */
  sun_list_add(get_mountpt_list(), (qelem *)mountpt);
}
    break;

  case 17:
#line 251 "sun_map_parse.y"
    {

  struct sun_list *list;
  struct sun_mountpt *mountpt;

  /* allocate a mountpt */
  mountpt = CALLOC(struct sun_mountpt);

  /* An fstype may have been defined in the 'options'. */
  if (tmpFsType != NULL) {
    mountpt->fstype = tmpFsType;
    tmpFsType = NULL;
  }

  /*
   * Assign the global location list to this entry and reset the
   * global pointer.  Reseting the global pointer will create a new
   * list instance next time get_sun_location_list() is called.
   */
  list = get_sun_location_list();
  mountpt->location_list = (struct sun_location *)list->first;
  sun_location_list = NULL;

  /*
   * Assign the global opt list to this entry and reset the global
   * pointer.  Reseting the global pointer will create a new list
   * instance next time get_sun_opt_list() is called.
   */
  list = get_sun_opt_list();
  mountpt->opt_list = (struct sun_opt *)list->first;
  sun_opt_list = NULL;

  mountpt->path = strdup(sun_map_vsp[-5].strval);

  /* Add this mountpt to the mountpt list. */
  sun_list_add(get_mountpt_list(), (qelem *)mountpt);
}
    break;

  case 20:
#line 294 "sun_map_parse.y"
    {

  struct sun_list *list;
  struct sun_location *location;

  /* allocate a new location */
  location = CALLOC(struct sun_location);

  /*
   * Assign the global opt list to this entry and reset the global
   * pointer.  Reseting the global pointer will create a new list
   * instance next time get_sun_opt_list() is called.
   */
  list = get_sun_host_list();
  location->host_list = (struct sun_host *)list->first;
  sun_host_list = NULL;

  location->path = strdup(sun_map_vsp[0].strval);

  /* Add this location to the location list. */
  sun_list_add(get_sun_location_list(), (qelem *)location);
}
    break;

  case 21:
#line 317 "sun_map_parse.y"
    {

  struct sun_location *location;

  /* allocate a new location */
  location = CALLOC(struct sun_location);

  location->path = strdup(sun_map_vsp[0].strval);

  /* Add this location to the location list. */
  sun_list_add(get_sun_location_list(), (qelem *)location);
}
    break;

  case 24:
#line 335 "sun_map_parse.y"
    {

  /* allocate a new host */
  struct sun_host *host = CALLOC(struct sun_host);

  host->name = strdup(sun_map_vsp[0].strval);

  /* Add this host to the host list. */
  sun_list_add(get_sun_host_list(),(qelem *)host);
}
    break;

  case 25:
#line 346 "sun_map_parse.y"
    {

  /*
   * It is assumed that the host for this rule was allocated by the
   * 'weight' rule and assigned to be the last host item on the host
   * list.
   */
  struct sun_host *host = (struct sun_host *)sun_host_list->last;

  host->name = strdup(sun_map_vsp[-1].strval);
}
    break;

  case 26:
#line 359 "sun_map_parse.y"
    {

  int val;
  /* allocate a new host */
  struct sun_host *host = CALLOC(struct sun_host);

  val = atoi(sun_map_vsp[-1].strval);

  host->weight = val;

  /* Add this host to the host list. */
  sun_list_add(get_sun_host_list(), (qelem *)host);
}
    break;

  case 29:
#line 378 "sun_map_parse.y"
    {

  char *type;

  /* check if this is an fstype option */
  if ((type = strstr(sun_map_vsp[0].strval,SUN_FSTYPE_STR)) != NULL) {
    /* parse out the fs type from the Sun fstype keyword  */
    if ((type = type + strlen(SUN_FSTYPE_STR)) != NULL) {
      /*
       * This global fstype str will be assigned to the current being
       * parsed later in the parsing.
       */
      tmpFsType = strdup(type);
    }
  }
  else {
    /*
     * If it is not an fstype option allocate an opt struct and assign
     * the value.
     */
    struct sun_opt *opt = CALLOC(struct sun_opt);
    opt->str = strdup(sun_map_vsp[0].strval);
    /* Add this opt to the opt list. */
    sun_list_add(get_sun_opt_list(), (qelem *)opt);
  }
}
    break;


    }

/* Line 991 of yacc.c.  */
#line 1400 "sun_map_parse.c"

  sun_map_vsp -= sun_map_len;
  sun_map_ssp -= sun_map_len;


  YY_STACK_PRINT (sun_map_ss, sun_map_ssp);

  *++sun_map_vsp = sun_map_val;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  sun_map_n = sun_map_r1[sun_map_n];

  sun_map_state = sun_map_pgoto[sun_map_n - YYNTOKENS] + *sun_map_ssp;
  if (0 <= sun_map_state && sun_map_state <= YYLAST && sun_map_check[sun_map_state] == *sun_map_ssp)
    sun_map_state = sun_map_table[sun_map_state];
  else
    sun_map_state = sun_map_defgoto[sun_map_n - YYNTOKENS];

  goto sun_map_newstate;


/*------------------------------------.
| sun_map_errlab -- here on detecting error |
`------------------------------------*/
sun_map_errlab:
  /* If not already recovering from an error, report this error.  */
  if (!sun_map_errstatus)
    {
      ++sun_map_nerrs;
#if YYERROR_VERBOSE
      sun_map_n = sun_map_pact[sun_map_state];

      if (YYPACT_NINF < sun_map_n && sun_map_n < YYLAST)
	{
	  YYSIZE_T sun_map_size = 0;
	  int sun_map_type = YYTRANSLATE (sun_map_char);
	  char *sun_map_msg;
	  int sun_map_x, sun_map_count;

	  sun_map_count = 0;
	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  for (sun_map_x = sun_map_n < 0 ? -sun_map_n : 0;
	       sun_map_x < (int) (sizeof (sun_map_tname) / sizeof (char *)); sun_map_x++)
	    if (sun_map_check[sun_map_x + sun_map_n] == sun_map_x && sun_map_x != YYTERROR)
	      sun_map_size += sun_map_strlen (sun_map_tname[sun_map_x]) + 15, sun_map_count++;
	  sun_map_size += sun_map_strlen ("syntax error, unexpected ") + 1;
	  sun_map_size += sun_map_strlen (sun_map_tname[sun_map_type]);
	  sun_map_msg = (char *) YYSTACK_ALLOC (sun_map_size);
	  if (sun_map_msg != 0)
	    {
	      char *sun_map_p = sun_map_stpcpy (sun_map_msg, "syntax error, unexpected ");
	      sun_map_p = sun_map_stpcpy (sun_map_p, sun_map_tname[sun_map_type]);

	      if (sun_map_count < 5)
		{
		  sun_map_count = 0;
		  for (sun_map_x = sun_map_n < 0 ? -sun_map_n : 0;
		       sun_map_x < (int) (sizeof (sun_map_tname) / sizeof (char *));
		       sun_map_x++)
		    if (sun_map_check[sun_map_x + sun_map_n] == sun_map_x && sun_map_x != YYTERROR)
		      {
			const char *sun_map_q = ! sun_map_count ? ", expecting " : " or ";
			sun_map_p = sun_map_stpcpy (sun_map_p, sun_map_q);
			sun_map_p = sun_map_stpcpy (sun_map_p, sun_map_tname[sun_map_x]);
			sun_map_count++;
		      }
		}
	      sun_map_error (sun_map_msg);
	      YYSTACK_FREE (sun_map_msg);
	    }
	  else
	    sun_map_error ("syntax error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	sun_map_error ("syntax error");
    }



  if (sun_map_errstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      /* Return failure if at end of input.  */
      if (sun_map_char == YYEOF)
        {
	  /* Pop the error token.  */
          YYPOPSTACK;
	  /* Pop the rest of the stack.  */
	  while (sun_map_ss < sun_map_ssp)
	    {
	      YYDSYMPRINTF ("Error: popping", sun_map_stos[*sun_map_ssp], sun_map_vsp, sun_map_lsp);
	      sun_map_destruct (sun_map_stos[*sun_map_ssp], sun_map_vsp);
	      YYPOPSTACK;
	    }
	  YYABORT;
        }

      YYDSYMPRINTF ("Error: discarding", sun_map_token, &sun_map_lval, &sun_map_lloc);
      sun_map_destruct (sun_map_token, &sun_map_lval);
      sun_map_char = YYEMPTY;

    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto sun_map_errlab2;


/*----------------------------------------------------.
| sun_map_errlab1 -- error raised explicitly by an action.  |
`----------------------------------------------------*/
sun_map_errlab1:

  /* Suppress GCC warning that sun_map_errlab1 is unused when no action
     invokes YYERROR.  */
#if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__) \
    && !defined __cplusplus
  __attribute__ ((__unused__))
#endif


  goto sun_map_errlab2;


/*---------------------------------------------------------------.
| sun_map_errlab2 -- pop states until the error token can be shifted.  |
`---------------------------------------------------------------*/
sun_map_errlab2:
  sun_map_errstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      sun_map_n = sun_map_pact[sun_map_state];
      if (sun_map_n != YYPACT_NINF)
	{
	  sun_map_n += YYTERROR;
	  if (0 <= sun_map_n && sun_map_n <= YYLAST && sun_map_check[sun_map_n] == YYTERROR)
	    {
	      sun_map_n = sun_map_table[sun_map_n];
	      if (0 < sun_map_n)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (sun_map_ssp == sun_map_ss)
	YYABORT;

      YYDSYMPRINTF ("Error: popping", sun_map_stos[*sun_map_ssp], sun_map_vsp, sun_map_lsp);
      sun_map_destruct (sun_map_stos[sun_map_state], sun_map_vsp);
      sun_map_vsp--;
      sun_map_state = *--sun_map_ssp;

      YY_STACK_PRINT (sun_map_ss, sun_map_ssp);
    }

  if (sun_map_n == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++sun_map_vsp = sun_map_lval;


  sun_map_state = sun_map_n;
  goto sun_map_newstate;


/*-------------------------------------.
| sun_map_acceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
sun_map_acceptlab:
  sun_map_result = 0;
  goto sun_map_return;

/*-----------------------------------.
| sun_map_abortlab -- YYABORT comes here.  |
`-----------------------------------*/
sun_map_abortlab:
  sun_map_result = 1;
  goto sun_map_return;

#ifndef sun_map_overflow
/*----------------------------------------------.
| sun_map_overflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
sun_map_overflowlab:
  sun_map_error ("parser stack overflow");
  sun_map_result = 2;
  /* Fall through.  */
#endif

sun_map_return:
#ifndef sun_map_overflow
  if (sun_map_ss != sun_map_ssa)
    YYSTACK_FREE (sun_map_ss);
#endif
  return sun_map_result;
}


#line 407 "sun_map_parse.y"


/*
 * Parse 'map_data' which is assumed to be a Sun-syle map.  If
 * successful a sun_entry is returned.
 *
 * The parser is designed to parse map entries with out the keys.  For
 * example the entry:
 *
 * usr -ro pluto:/usr/local
 *
 * should be passed to the parser as:
 *
 * -ro pluto:/usr/local
 *
 * The reason for this is that the Amd info services already strip off
 * the key when they read map info.
 */
struct sun_entry *
sun_map_parse_read(const char *map_data)
{
  struct sun_entry *retval = NULL;

  /* pass map_data to lex */
  sun_map_tok_setbuff(map_data);

  /* call yacc */
  sun_map_parse();

  if (sun_entry_list != NULL) {
    /* return the first Sun entry in the list */
    retval = (struct sun_entry*)sun_entry_list->first;
    sun_entry_list = NULL;
  }
  else {
    plog(XLOG_ERROR, "Sun map parser did not produce data structs.");
  }

  return retval;
}


static struct sun_list *
get_sun_entry_list(void)
{
  if (sun_entry_list == NULL) {
    sun_entry_list = CALLOC(struct sun_list);
  }
  return sun_entry_list;
}


static struct sun_list *
get_mountpt_list(void)
{
  if (mountpt_list == NULL) {
    mountpt_list = CALLOC(struct sun_list);
  }
  return mountpt_list;
}


static struct sun_list *
get_sun_location_list(void)
{
  if (sun_location_list == NULL) {
    sun_location_list = CALLOC(struct sun_list);
  }
  return sun_location_list;
}


static struct sun_list *
get_sun_host_list(void)
{
  if (sun_host_list == NULL) {
    sun_host_list = CALLOC(struct sun_list);
  }
  return sun_host_list;
}


static struct sun_list *
get_sun_opt_list(void)
{
  if (sun_opt_list == NULL) {
    sun_opt_list = CALLOC(struct sun_list);
  }
  return sun_opt_list;
}

