/* A Bison parser, made from /home/ezk/proj/amd/am-utils-exp/A.i386-pc-linux-deb3.0/amd/../../amd/sun_map_parse.y
   by GNU bison 1.35.  */

#define YYBISON 1  /* Identify Bison output.  */

# define	NEWLINE	257
# define	COMMENT	258
# define	WSPACE	259
# define	WORD	260

#line 1 "sun_map_parse.y"

/*
 * Copyright (c) 1997-2005 Erez Zadok
 * Copyright (c) 2005 Daniel P. Ottavio
 * Copyright (c) 1990 Jan-Simon Pendry
 * Copyright (c) 1990 Imperial College of Science, Technology & Medicine
 * Copyright (c) 1990 The Regents of the University of California.
 * All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Jan-Simon Pendry at Imperial College, London.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgment:
 *      This product includes software developed by the University of
 *      California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *
 * File: am-utils/amd/sun_map_parse.y
 *
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif /* HAVE_CONFIG_H */
#include <am_defs.h>
#include <amd.h>
#include <sun_map.h>


#define SUN_FSTYPE_STR  "fstype="


extern int sun_map_lex(void);
extern int sun_map_error(const char *);
extern void sun_map_tok_setbuff(const char *);
extern int sun_map_parse(void);

struct sun_entry *sun_map_parse_read(const char *);

static struct sun_list *sun_entry_list = NULL;
static struct sun_list *sun_opt_list = NULL;
static struct sun_list *sun_host_list = NULL;
static struct sun_list *sun_location_list = NULL;
static struct sun_list *mountpt_list = NULL;
static char *tmpFsType = NULL;


/*
 * Each get* function returns a pointer to the corresponding global
 * list structure.  If the structure is NULL than a new instance is
 * returned.
 */
static struct sun_list *get_sun_opt_list();
static struct sun_list *get_sun_host_list();
static struct sun_list *get_sun_location_list();
static struct sun_list *get_mountpt_list();
static struct sun_list *get_sun_entry_list();


#line 85 "sun_map_parse.y"
#ifndef YYSTYPE
typedef union {
  char strval[2048];
} sun_map_stype;
# define YYSTYPE sun_map_stype
# define YYSTYPE_IS_TRIVIAL 1
#endif
#ifndef YYDEBUG
# define YYDEBUG 0
#endif



#define	YYFINAL		50
#define	YYFLAG		-32768
#define	YYNTBASE	12

/* YYTRANSLATE(YYLEX) -- Bison token number corresponding to YYLEX. */
#define YYTRANSLATE(x) ((unsigned)(x) <= 260 ? sun_map_translate[x] : 26)

/* YYTRANSLATE[YYLEX] -- Bison token number corresponding to YYLEX. */
static const char sun_map_translate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      10,    11,     2,     2,     9,     7,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     8,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     3,     4,     5,
       6
};

#if YYDEBUG
static const short sun_map_prhs[] =
{
       0,     0,     2,     5,     7,     9,    12,    16,    18,    21,
      23,    28,    30,    35,    37,    41,    45,    52,    54,    58,
      62,    65,    67,    71,    73,    76,    80,    82,    86
};
static const short sun_map_rhs[] =
{
      13,     0,    15,    14,     0,    14,     0,    16,     0,    16,
      15,     0,    16,    15,    14,     0,     3,     0,     3,    15,
       0,    19,     0,     7,    24,     5,    19,     0,    17,     0,
       7,    24,     5,    17,     0,    18,     0,    18,     5,    17,
       0,     6,     5,    20,     0,     6,     5,     7,    24,     5,
      20,     0,    20,     0,    20,     5,    19,     0,    21,     8,
       6,     0,     8,     6,     0,    22,     0,    22,     9,    21,
       0,     6,     0,     6,    23,     0,    10,     6,    11,     0,
      25,     0,    25,     9,    24,     0,     6,     0
};

#endif

#if YYDEBUG
/* YYRLINE[YYN] -- source line where rule number YYN was defined. */
static const short sun_map_rline[] =
{
       0,    94,    97,    98,   101,   102,   103,   106,   107,   110,
     131,   166,   187,   224,   225,   228,   251,   290,   291,   294,
     317,   331,   332,   335,   346,   359,   374,   375,   378
};
#endif


#if (YYDEBUG) || defined YYERROR_VERBOSE

/* YYTNAME[TOKEN_NUM] -- String name of the token TOKEN_NUM. */
static const char *const sun_map_tname[] =
{
  "$", "error", "$undefined.", "NEWLINE", "COMMENT", "WSPACE", "WORD", 
  "'-'", "':'", "','", "'('", "')'", "amap", "file", "entries", 
  "new_lines", "entry", "mountpoints", "mountpoint", "locations", 
  "location", "hosts", "host", "weight", "options", "option", 0
};
#endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives. */
static const short sun_map_r1[] =
{
       0,    12,    13,    13,    14,    14,    14,    15,    15,    16,
      16,    16,    16,    17,    17,    18,    18,    19,    19,    20,
      20,    21,    21,    22,    22,    23,    24,    24,    25
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN. */
static const short sun_map_r2[] =
{
       0,     1,     2,     1,     1,     2,     3,     1,     2,     1,
       4,     1,     4,     1,     3,     3,     6,     1,     3,     3,
       2,     1,     3,     1,     2,     3,     1,     3,     1
};

/* YYDEFACT[S] -- default rule to reduce with in state S when YYTABLE
   doesn't specify something else to do.  Zero means the default is an
   error. */
static const short sun_map_defact[] =
{
       0,     7,    23,     0,     0,     1,     3,     0,     4,    11,
      13,     9,    17,     0,    21,     8,     0,     0,    24,    28,
       0,    26,    20,     2,     5,     0,     0,     0,     0,    23,
       0,    15,     0,     0,     0,     6,     0,    14,    18,    19,
      22,     0,    25,    12,    10,    27,     0,    16,     0,     0,
       0
};

static const short sun_map_defgoto[] =
{
      48,     5,     6,     7,     8,     9,    10,    11,    12,    13,
      14,    18,    20,    21
};

static const short sun_map_pact[] =
{
       0,    12,     4,    10,    23,-32768,-32768,    13,    12,-32768,
      26,-32768,    27,    25,    28,-32768,    16,    29,-32768,-32768,
      31,    30,-32768,-32768,    13,    32,    19,    34,    35,    24,
      10,-32768,    33,    20,    10,-32768,    37,-32768,-32768,-32768,
  -32768,    38,-32768,-32768,-32768,-32768,    19,-32768,    45,    46,
  -32768
};

static const short sun_map_pgoto[] =
{
  -32768,-32768,    -6,     3,-32768,   -23,-32768,   -21,   -16,    21,
  -32768,-32768,   -17,-32768
};


#define	YYLAST		49


static const short sun_map_table[] =
{
      31,    23,    37,     1,    15,    38,     2,     3,     4,    16,
      43,    24,    44,    41,    17,     1,    19,    45,    35,     2,
       3,     4,    29,    30,     4,    29,     2,     4,     4,    22,
      47,    25,    26,    27,    17,    32,    33,    28,    36,    34,
      39,    29,    16,    46,    42,    49,    50,     0,     0,    40
};

static const short sun_map_check[] =
{
      16,     7,    25,     3,     1,    26,     6,     7,     8,     5,
      33,     8,    33,    30,    10,     3,     6,    34,    24,     6,
       7,     8,     6,     7,     8,     6,     6,     8,     8,     6,
      46,     5,     5,     8,    10,     6,     5,     9,     6,     9,
       6,     6,     5,     5,    11,     0,     0,    -1,    -1,    28
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/share/bison/bison.simple"

/* Skeleton output parser for bison,

   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software
   Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser when
   the %semantic_parser declaration is not specified in the grammar.
   It was written by Richard Stallman by simplifying the hairy parser
   used when %semantic_parser is specified.  */

/* All symbols defined below should begin with sun_map_ or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

#if ! defined (sun_map_overflow) || defined (YYERROR_VERBOSE)

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (sun_map_overflow) || defined (YYERROR_VERBOSE) */


#if (! defined (sun_map_overflow) \
     && (! defined (__cplusplus) \
	 || (YYLTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union sun_map_alloc
{
  short sun_map_ss;
  YYSTYPE sun_map_vs;
# if YYLSP_NEEDED
  YYLTYPE sun_map_ls;
# endif
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAX (sizeof (union sun_map_alloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# if YYLSP_NEEDED
#  define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE) + sizeof (YYLTYPE))	\
      + 2 * YYSTACK_GAP_MAX)
# else
#  define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAX)
# endif

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T sun_map_i;		\
	  for (sun_map_i = 0; sun_map_i < (Count); sun_map_i++)	\
	    (To)[sun_map_i] = (From)[sun_map_i];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T sun_map_newbytes;						\
	YYCOPY (&sun_map_ptr->Stack, Stack, sun_map_size);				\
	Stack = &sun_map_ptr->Stack;						\
	sun_map_newbytes = sun_map_stacksize * sizeof (*Stack) + YYSTACK_GAP_MAX;	\
	sun_map_ptr += sun_map_newbytes / sizeof (*sun_map_ptr);				\
      }									\
    while (0)

#endif


#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define sun_map_errok		(sun_map_errstatus = 0)
#define sun_map_clearin	(sun_map_char = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto sun_map_acceptlab
#define YYABORT 	goto sun_map_abortlab
#define YYERROR		goto sun_map_errlab1
/* Like YYERROR except do call sun_map_error.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto sun_map_errlab
#define YYRECOVERING()  (!!sun_map_errstatus)
#define YYBACKUP(Token, Value)					\
do								\
  if (sun_map_char == YYEMPTY && sun_map_len == 1)				\
    {								\
      sun_map_char = (Token);						\
      sun_map_lval = (Value);						\
      sun_map_char1 = YYTRANSLATE (sun_map_char);				\
      YYPOPSTACK;						\
      goto sun_map_backup;						\
    }								\
  else								\
    { 								\
      sun_map_error ("syntax error: cannot back up");			\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).

   When YYLLOC_DEFAULT is run, CURRENT is set the location of the
   first token.  By default, to implement support for ranges, extend
   its range to the last symbol.  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)       	\
   Current.last_line   = Rhs[N].last_line;	\
   Current.last_column = Rhs[N].last_column;
#endif


/* YYLEX -- calling `sun_map_lex' with the right arguments.  */

#if YYPURE
# if YYLSP_NEEDED
#  ifdef YYLEX_PARAM
#   define YYLEX		sun_map_lex (&sun_map_lval, &sun_map_lloc, YYLEX_PARAM)
#  else
#   define YYLEX		sun_map_lex (&sun_map_lval, &sun_map_lloc)
#  endif
# else /* !YYLSP_NEEDED */
#  ifdef YYLEX_PARAM
#   define YYLEX		sun_map_lex (&sun_map_lval, YYLEX_PARAM)
#  else
#   define YYLEX		sun_map_lex (&sun_map_lval)
#  endif
# endif /* !YYLSP_NEEDED */
#else /* !YYPURE */
# define YYLEX			sun_map_lex ()
#endif /* !YYPURE */


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (sun_map_debug)					\
    YYFPRINTF Args;				\
} while (0)
/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int sun_map_debug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
#endif /* !YYDEBUG */

/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif

#ifdef YYERROR_VERBOSE

# ifndef sun_map_strlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define sun_map_strlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
sun_map_strlen (const char *sun_map_str)
#   else
sun_map_strlen (sun_map_str)
     const char *sun_map_str;
#   endif
{
  register const char *sun_map_s = sun_map_str;

  while (*sun_map_s++ != '\0')
    continue;

  return sun_map_s - sun_map_str - 1;
}
#  endif
# endif

# ifndef sun_map_stpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define sun_map_stpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
sun_map_stpcpy (char *sun_map_dest, const char *sun_map_src)
#   else
sun_map_stpcpy (sun_map_dest, sun_map_src)
     char *sun_map_dest;
     const char *sun_map_src;
#   endif
{
  register char *sun_map_d = sun_map_dest;
  register const char *sun_map_s = sun_map_src;

  while ((*sun_map_d++ = *sun_map_s++) != '\0')
    continue;

  return sun_map_d - 1;
}
#  endif
# endif
#endif

#line 315 "/usr/share/bison/bison.simple"


/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into sun_map_parse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
#  define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#  define YYPARSE_PARAM_DECL
# else
#  define YYPARSE_PARAM_ARG YYPARSE_PARAM
#  define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
# endif
#else /* !YYPARSE_PARAM */
# define YYPARSE_PARAM_ARG
# define YYPARSE_PARAM_DECL
#endif /* !YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
# ifdef YYPARSE_PARAM
int sun_map_parse (void *);
# else
int sun_map_parse (void);
# endif
#endif

/* YY_DECL_VARIABLES -- depending whether we use a pure parser,
   variables are global, or local to YYPARSE.  */

#define YY_DECL_NON_LSP_VARIABLES			\
/* The lookahead symbol.  */				\
int sun_map_char;						\
							\
/* The semantic value of the lookahead symbol. */	\
YYSTYPE sun_map_lval;						\
							\
/* Number of parse errors so far.  */			\
int sun_map_nerrs;

#if YYLSP_NEEDED
# define YY_DECL_VARIABLES			\
YY_DECL_NON_LSP_VARIABLES			\
						\
/* Location data for the lookahead symbol.  */	\
YYLTYPE sun_map_lloc;
#else
# define YY_DECL_VARIABLES			\
YY_DECL_NON_LSP_VARIABLES
#endif


/* If nonreentrant, generate the variables here. */

#if !YYPURE
YY_DECL_VARIABLES
#endif  /* !YYPURE */

int
sun_map_parse (YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  /* If reentrant, generate the variables here. */
#if YYPURE
  YY_DECL_VARIABLES
#endif  /* !YYPURE */

  register int sun_map_state;
  register int sun_map_n;
  int sun_map_result;
  /* Number of tokens to shift before error messages enabled.  */
  int sun_map_errstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int sun_map_char1 = 0;

  /* Three stacks and their tools:
     `sun_map_ss': related to states,
     `sun_map_vs': related to semantic values,
     `sun_map_ls': related to locations.

     Refer to the stacks thru separate pointers, to allow sun_map_overflow
     to reallocate them elsewhere.  */

  /* The state stack. */
  short	sun_map_ssa[YYINITDEPTH];
  short *sun_map_ss = sun_map_ssa;
  register short *sun_map_ssp;

  /* The semantic value stack.  */
  YYSTYPE sun_map_vsa[YYINITDEPTH];
  YYSTYPE *sun_map_vs = sun_map_vsa;
  register YYSTYPE *sun_map_vsp;

#if YYLSP_NEEDED
  /* The location stack.  */
  YYLTYPE sun_map_lsa[YYINITDEPTH];
  YYLTYPE *sun_map_ls = sun_map_lsa;
  YYLTYPE *sun_map_lsp;
#endif

#if YYLSP_NEEDED
# define YYPOPSTACK   (sun_map_vsp--, sun_map_ssp--, sun_map_lsp--)
#else
# define YYPOPSTACK   (sun_map_vsp--, sun_map_ssp--)
#endif

  YYSIZE_T sun_map_stacksize = YYINITDEPTH;


  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE sun_map_val;
#if YYLSP_NEEDED
  YYLTYPE sun_map_loc;
#endif

  /* When reducing, the number of symbols on the RHS of the reduced
     rule. */
  int sun_map_len;

  YYDPRINTF ((stderr, "Starting parse\n"));

  sun_map_state = 0;
  sun_map_errstatus = 0;
  sun_map_nerrs = 0;
  sun_map_char = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  sun_map_ssp = sun_map_ss;
  sun_map_vsp = sun_map_vs;
#if YYLSP_NEEDED
  sun_map_lsp = sun_map_ls;
#endif
  goto sun_map_setstate;

/*------------------------------------------------------------.
| sun_map_newstate -- Push a new state, which is found in sun_map_state.  |
`------------------------------------------------------------*/
 sun_map_newstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  sun_map_ssp++;

 sun_map_setstate:
  *sun_map_ssp = sun_map_state;

  if (sun_map_ssp >= sun_map_ss + sun_map_stacksize - 1)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T sun_map_size = sun_map_ssp - sun_map_ss + 1;

#ifdef sun_map_overflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *sun_map_vs1 = sun_map_vs;
	short *sun_map_ss1 = sun_map_ss;

	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  */
# if YYLSP_NEEDED
	YYLTYPE *sun_map_ls1 = sun_map_ls;
	/* This used to be a conditional around just the two extra args,
	   but that might be undefined if sun_map_overflow is a macro.  */
	sun_map_overflow ("parser stack overflow",
		    &sun_map_ss1, sun_map_size * sizeof (*sun_map_ssp),
		    &sun_map_vs1, sun_map_size * sizeof (*sun_map_vsp),
		    &sun_map_ls1, sun_map_size * sizeof (*sun_map_lsp),
		    &sun_map_stacksize);
	sun_map_ls = sun_map_ls1;
# else
	sun_map_overflow ("parser stack overflow",
		    &sun_map_ss1, sun_map_size * sizeof (*sun_map_ssp),
		    &sun_map_vs1, sun_map_size * sizeof (*sun_map_vsp),
		    &sun_map_stacksize);
# endif
	sun_map_ss = sun_map_ss1;
	sun_map_vs = sun_map_vs1;
      }
#else /* no sun_map_overflow */
# ifndef YYSTACK_RELOCATE
      goto sun_map_overflowlab;
# else
      /* Extend the stack our own way.  */
      if (sun_map_stacksize >= YYMAXDEPTH)
	goto sun_map_overflowlab;
      sun_map_stacksize *= 2;
      if (sun_map_stacksize > YYMAXDEPTH)
	sun_map_stacksize = YYMAXDEPTH;

      {
	short *sun_map_ss1 = sun_map_ss;
	union sun_map_alloc *sun_map_ptr =
	  (union sun_map_alloc *) YYSTACK_ALLOC (YYSTACK_BYTES (sun_map_stacksize));
	if (! sun_map_ptr)
	  goto sun_map_overflowlab;
	YYSTACK_RELOCATE (sun_map_ss);
	YYSTACK_RELOCATE (sun_map_vs);
# if YYLSP_NEEDED
	YYSTACK_RELOCATE (sun_map_ls);
# endif
# undef YYSTACK_RELOCATE
	if (sun_map_ss1 != sun_map_ssa)
	  YYSTACK_FREE (sun_map_ss1);
      }
# endif
#endif /* no sun_map_overflow */

      sun_map_ssp = sun_map_ss + sun_map_size - 1;
      sun_map_vsp = sun_map_vs + sun_map_size - 1;
#if YYLSP_NEEDED
      sun_map_lsp = sun_map_ls + sun_map_size - 1;
#endif

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) sun_map_stacksize));

      if (sun_map_ssp >= sun_map_ss + sun_map_stacksize - 1)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", sun_map_state));

  goto sun_map_backup;


/*-----------.
| sun_map_backup.  |
`-----------*/
sun_map_backup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* sun_map_resume: */

  /* First try to decide what to do without reference to lookahead token.  */

  sun_map_n = sun_map_pact[sun_map_state];
  if (sun_map_n == YYFLAG)
    goto sun_map_default;

  /* Not known => get a lookahead token if don't already have one.  */

  /* sun_map_char is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (sun_map_char == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      sun_map_char = YYLEX;
    }

  /* Convert token to internal form (in sun_map_char1) for indexing tables with */

  if (sun_map_char <= 0)		/* This means end of input. */
    {
      sun_map_char1 = 0;
      sun_map_char = YYEOF;		/* Don't call YYLEX any more */

      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      sun_map_char1 = YYTRANSLATE (sun_map_char);

#if YYDEBUG
     /* We have to keep this `#if YYDEBUG', since we use variables
	which are defined only if `YYDEBUG' is set.  */
      if (sun_map_debug)
	{
	  YYFPRINTF (stderr, "Next token is %d (%s",
		     sun_map_char, sun_map_tname[sun_map_char1]);
	  /* Give the individual parser a way to print the precise
	     meaning of a token, for further debugging info.  */
# ifdef YYPRINT
	  YYPRINT (stderr, sun_map_char, sun_map_lval);
# endif
	  YYFPRINTF (stderr, ")\n");
	}
#endif
    }

  sun_map_n += sun_map_char1;
  if (sun_map_n < 0 || sun_map_n > YYLAST || sun_map_check[sun_map_n] != sun_map_char1)
    goto sun_map_default;

  sun_map_n = sun_map_table[sun_map_n];

  /* sun_map_n is what to do for this token type in this state.
     Negative => reduce, -sun_map_n is rule number.
     Positive => shift, sun_map_n is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (sun_map_n < 0)
    {
      if (sun_map_n == YYFLAG)
	goto sun_map_errlab;
      sun_map_n = -sun_map_n;
      goto sun_map_reduce;
    }
  else if (sun_map_n == 0)
    goto sun_map_errlab;

  if (sun_map_n == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %d (%s), ",
	      sun_map_char, sun_map_tname[sun_map_char1]));

  /* Discard the token being shifted unless it is eof.  */
  if (sun_map_char != YYEOF)
    sun_map_char = YYEMPTY;

  *++sun_map_vsp = sun_map_lval;
#if YYLSP_NEEDED
  *++sun_map_lsp = sun_map_lloc;
#endif

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (sun_map_errstatus)
    sun_map_errstatus--;

  sun_map_state = sun_map_n;
  goto sun_map_newstate;


/*-----------------------------------------------------------.
| sun_map_default -- do the default action for the current state.  |
`-----------------------------------------------------------*/
sun_map_default:
  sun_map_n = sun_map_defact[sun_map_state];
  if (sun_map_n == 0)
    goto sun_map_errlab;
  goto sun_map_reduce;


/*-----------------------------.
| sun_map_reduce -- Do a reduction.  |
`-----------------------------*/
sun_map_reduce:
  /* sun_map_n is the number of a rule to reduce with.  */
  sun_map_len = sun_map_r2[sun_map_n];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to the semantic value of
     the lookahead token.  This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  sun_map_val = sun_map_vsp[1-sun_map_len];

#if YYLSP_NEEDED
  /* Similarly for the default location.  Let the user run additional
     commands if for instance locations are ranges.  */
  sun_map_loc = sun_map_lsp[1-sun_map_len];
  YYLLOC_DEFAULT (sun_map_loc, (sun_map_lsp - sun_map_len), sun_map_len);
#endif

#if YYDEBUG
  /* We have to keep this `#if YYDEBUG', since we use variables which
     are defined only if `YYDEBUG' is set.  */
  if (sun_map_debug)
    {
      int sun_map_i;

      YYFPRINTF (stderr, "Reducing via rule %d (line %d), ",
		 sun_map_n, sun_map_rline[sun_map_n]);

      /* Print the symbols being reduced, and their result.  */
      for (sun_map_i = sun_map_prhs[sun_map_n]; sun_map_rhs[sun_map_i] > 0; sun_map_i++)
	YYFPRINTF (stderr, "%s ", sun_map_tname[sun_map_rhs[sun_map_i]]);
      YYFPRINTF (stderr, " -> %s\n", sun_map_tname[sun_map_r1[sun_map_n]]);
    }
#endif

  switch (sun_map_n) {

case 9:
#line 110 "sun_map_parse.y"
{

  struct sun_list *list;
  struct sun_entry *entry;

  /* allocate an entry */
  entry = CALLOC(struct sun_entry);

  /*
   * Assign the global location list to this entry and reset the
   * global pointer.  Reseting the global pointer will create a new
   * list instance next time get_sun_location_list() is called.
   */
  list = get_sun_location_list();
  entry->location_list = (struct sun_location *)list->first;
  sun_location_list = NULL;

   /* Add this entry to the entry list. */
  sun_list_add(get_sun_entry_list(), (qelem *)entry);
}
    break;
case 10:
#line 131 "sun_map_parse.y"
{

  struct sun_list *list;
  struct sun_entry *entry;

  entry = CALLOC(struct sun_entry);

  /* An fstype may have been defined in the 'options'. */
  if (tmpFsType != NULL) {
    entry->fstype = tmpFsType;
    tmpFsType = NULL;
  }

  /*
   * Assign the global location list to this entry and reset the
   * global pointer.  Reseting the global pointer will create a new
   * list instance next time get_sun_location_list() is called.
   */
  list = get_sun_location_list();
  entry->location_list = (struct sun_location *)list->first;
  sun_location_list = NULL;

  /*
   * Assign the global opt list to this entry and reset the global
   * pointer.  Reseting the global pointer will create a new list
   * instance next time get_sun_opt_list() is called.
   */
  list = get_sun_opt_list();
  entry->opt_list = (struct sun_opt *)list->first;
  sun_opt_list = NULL;

  /* Add this entry to the entry list. */
  sun_list_add(get_sun_entry_list(), (qelem *)entry);
}
    break;
case 11:
#line 166 "sun_map_parse.y"
{

  struct sun_list *list;
  struct sun_entry *entry;

  /* allocate an entry */
  entry = CALLOC(struct sun_entry);

  /*
   * Assign the global mountpt list to this entry and reset the global
   * pointer.  Reseting the global pointer will create a new list
   * instance next time get_mountpt_list() is called.
   */
  list = get_mountpt_list();
  entry->mountpt_list = (struct sun_mountpt *)list->first;
  mountpt_list = NULL;

  /* Add this entry to the entry list. */
  sun_list_add(get_sun_entry_list(), (qelem *)entry);
}
    break;
case 12:
#line 187 "sun_map_parse.y"
{

  struct sun_list *list;
  struct sun_entry *entry;

  /* allocate an entry */
  entry = CALLOC(struct sun_entry);

  /* An fstype may have been defined in the 'options'. */
  if (tmpFsType != NULL) {
    entry->fstype = tmpFsType;
    tmpFsType = NULL;
  }

  /*
   * Assign the global mountpt list to this entry and reset the global
   * pointer.  Reseting the global pointer will create a new list
   * instance next time get_mountpt_list() is called.
   */
  list = get_mountpt_list();
  entry->mountpt_list = (struct sun_mountpt *)list->first;
  mountpt_list = NULL;

  /*
   * Assign the global opt list to this entry and reset the global
   * pointer.  Reseting the global pointer will create a new list
   * instance next time get_sun_opt_list() is called.
   */
  list = get_sun_opt_list();
  entry->opt_list = (struct sun_opt *)list->first;
  sun_opt_list = NULL;

  /* Add this entry to the entry list. */
  sun_list_add(get_sun_entry_list(), (qelem *)entry);
}
    break;
case 15:
#line 228 "sun_map_parse.y"
{

  struct sun_list *list;
  struct sun_mountpt *mountpt;

  /* allocate a mountpt */
  mountpt = CALLOC(struct sun_mountpt);

  /*
   * Assign the global loaction list to this entry and reset the
   * global pointer.  Reseting the global pointer will create a new
   * list instance next time get_sun_location_list() is called.
   */
  list = get_sun_location_list();
  mountpt->location_list = (struct sun_location *)list->first;
  sun_location_list = NULL;

  mountpt->path = strdup(sun_map_vsp[-2].strval);

  /* Add this mountpt to the mountpt list. */
  sun_list_add(get_mountpt_list(), (qelem *)mountpt);
}
    break;
case 16:
#line 251 "sun_map_parse.y"
{

  struct sun_list *list;
  struct sun_mountpt *mountpt;

  /* allocate a mountpt */
  mountpt = CALLOC(struct sun_mountpt);

  /* An fstype may have been defined in the 'options'. */
  if (tmpFsType != NULL) {
    mountpt->fstype = tmpFsType;
    tmpFsType = NULL;
  }

  /*
   * Assign the global location list to this entry and reset the
   * global pointer.  Reseting the global pointer will create a new
   * list instance next time get_sun_location_list() is called.
   */
  list = get_sun_location_list();
  mountpt->location_list = (struct sun_location *)list->first;
  sun_location_list = NULL;

  /*
   * Assign the global opt list to this entry and reset the global
   * pointer.  Reseting the global pointer will create a new list
   * instance next time get_sun_opt_list() is called.
   */
  list = get_sun_opt_list();
  mountpt->opt_list = (struct sun_opt *)list->first;
  sun_opt_list = NULL;

  mountpt->path = strdup(sun_map_vsp[-5].strval);

  /* Add this mountpt to the mountpt list. */
  sun_list_add(get_mountpt_list(), (qelem *)mountpt);
}
    break;
case 19:
#line 294 "sun_map_parse.y"
{

  struct sun_list *list;
  struct sun_location *location;

  /* allocate a new location */
  location = CALLOC(struct sun_location);

  /*
   * Assign the global opt list to this entry and reset the global
   * pointer.  Reseting the global pointer will create a new list
   * instance next time get_sun_opt_list() is called.
   */
  list = get_sun_host_list();
  location->host_list = (struct sun_host *)list->first;
  sun_host_list = NULL;

  location->path = strdup(sun_map_vsp[0].strval);

  /* Add this location to the location list. */
  sun_list_add(get_sun_location_list(), (qelem *)location);
}
    break;
case 20:
#line 317 "sun_map_parse.y"
{

  struct sun_location *location;

  /* allocate a new location */
  location = CALLOC(struct sun_location);

  location->path = strdup(sun_map_vsp[0].strval);

  /* Add this location to the location list. */
  sun_list_add(get_sun_location_list(), (qelem *)location);
}
    break;
case 23:
#line 335 "sun_map_parse.y"
{

  /* allocate a new host */
  struct sun_host *host = CALLOC(struct sun_host);

  host->name = strdup(sun_map_vsp[0].strval);

  /* Add this host to the host list. */
  sun_list_add(get_sun_host_list(),(qelem *)host);
}
    break;
case 24:
#line 346 "sun_map_parse.y"
{

  /*
   * It is assumed that the host for this rule was allocated by the
   * 'weight' rule and assigned to be the last host item on the host
   * list.
   */
  struct sun_host *host = (struct sun_host *)sun_host_list->last;

  host->name = strdup(sun_map_vsp[-1].strval);
}
    break;
case 25:
#line 359 "sun_map_parse.y"
{

  int val;
  /* allocate a new host */
  struct sun_host *host = CALLOC(struct sun_host);

  val = atoi(sun_map_vsp[-1].strval);

  host->weight = val;

  /* Add this host to the host list. */
  sun_list_add(get_sun_host_list(), (qelem *)host);
}
    break;
case 28:
#line 378 "sun_map_parse.y"
{

  char *type;

  /* check if this is an fstype option */
  if ((type = strstr(sun_map_vsp[0].strval,SUN_FSTYPE_STR)) != NULL) {
    /* parse out the fs type from the Sun fstype keyword  */
    if ((type = type + strlen(SUN_FSTYPE_STR)) != NULL) {
      /*
       * This global fstype str will be assigned to the current being
       * parsed later in the parsing.
       */
      tmpFsType = strdup(type);
    }
  }
  else {
    /*
     * If it is not an fstype option allocate an opt struct and assign
     * the value.
     */
    struct sun_opt *opt = CALLOC(struct sun_opt);
    opt->str = strdup(sun_map_vsp[0].strval);
    /* Add this opt to the opt list. */
    sun_list_add(get_sun_opt_list(), (qelem *)opt);
  }
}
    break;
}

#line 705 "/usr/share/bison/bison.simple"


  sun_map_vsp -= sun_map_len;
  sun_map_ssp -= sun_map_len;
#if YYLSP_NEEDED
  sun_map_lsp -= sun_map_len;
#endif

#if YYDEBUG
  if (sun_map_debug)
    {
      short *sun_map_ssp1 = sun_map_ss - 1;
      YYFPRINTF (stderr, "state stack now");
      while (sun_map_ssp1 != sun_map_ssp)
	YYFPRINTF (stderr, " %d", *++sun_map_ssp1);
      YYFPRINTF (stderr, "\n");
    }
#endif

  *++sun_map_vsp = sun_map_val;
#if YYLSP_NEEDED
  *++sun_map_lsp = sun_map_loc;
#endif

  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  sun_map_n = sun_map_r1[sun_map_n];

  sun_map_state = sun_map_pgoto[sun_map_n - YYNTBASE] + *sun_map_ssp;
  if (sun_map_state >= 0 && sun_map_state <= YYLAST && sun_map_check[sun_map_state] == *sun_map_ssp)
    sun_map_state = sun_map_table[sun_map_state];
  else
    sun_map_state = sun_map_defgoto[sun_map_n - YYNTBASE];

  goto sun_map_newstate;


/*------------------------------------.
| sun_map_errlab -- here on detecting error |
`------------------------------------*/
sun_map_errlab:
  /* If not already recovering from an error, report this error.  */
  if (!sun_map_errstatus)
    {
      ++sun_map_nerrs;

#ifdef YYERROR_VERBOSE
      sun_map_n = sun_map_pact[sun_map_state];

      if (sun_map_n > YYFLAG && sun_map_n < YYLAST)
	{
	  YYSIZE_T sun_map_size = 0;
	  char *sun_map_msg;
	  int sun_map_x, sun_map_count;

	  sun_map_count = 0;
	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  for (sun_map_x = sun_map_n < 0 ? -sun_map_n : 0;
	       sun_map_x < (int) (sizeof (sun_map_tname) / sizeof (char *)); sun_map_x++)
	    if (sun_map_check[sun_map_x + sun_map_n] == sun_map_x)
	      sun_map_size += sun_map_strlen (sun_map_tname[sun_map_x]) + 15, sun_map_count++;
	  sun_map_size += sun_map_strlen ("parse error, unexpected ") + 1;
	  sun_map_size += sun_map_strlen (sun_map_tname[YYTRANSLATE (sun_map_char)]);
	  sun_map_msg = (char *) YYSTACK_ALLOC (sun_map_size);
	  if (sun_map_msg != 0)
	    {
	      char *sun_map_p = sun_map_stpcpy (sun_map_msg, "parse error, unexpected ");
	      sun_map_p = sun_map_stpcpy (sun_map_p, sun_map_tname[YYTRANSLATE (sun_map_char)]);

	      if (sun_map_count < 5)
		{
		  sun_map_count = 0;
		  for (sun_map_x = sun_map_n < 0 ? -sun_map_n : 0;
		       sun_map_x < (int) (sizeof (sun_map_tname) / sizeof (char *));
		       sun_map_x++)
		    if (sun_map_check[sun_map_x + sun_map_n] == sun_map_x)
		      {
			const char *sun_map_q = ! sun_map_count ? ", expecting " : " or ";
			sun_map_p = sun_map_stpcpy (sun_map_p, sun_map_q);
			sun_map_p = sun_map_stpcpy (sun_map_p, sun_map_tname[sun_map_x]);
			sun_map_count++;
		      }
		}
	      sun_map_error (sun_map_msg);
	      YYSTACK_FREE (sun_map_msg);
	    }
	  else
	    sun_map_error ("parse error; also virtual memory exhausted");
	}
      else
#endif /* defined (YYERROR_VERBOSE) */
	sun_map_error ("parse error");
    }
  goto sun_map_errlab1;


/*--------------------------------------------------.
| sun_map_errlab1 -- error raised explicitly by an action |
`--------------------------------------------------*/
sun_map_errlab1:
  if (sun_map_errstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      /* return failure if at end of input */
      if (sun_map_char == YYEOF)
	YYABORT;
      YYDPRINTF ((stderr, "Discarding token %d (%s).\n",
		  sun_map_char, sun_map_tname[sun_map_char1]));
      sun_map_char = YYEMPTY;
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */

  sun_map_errstatus = 3;		/* Each real token shifted decrements this */

  goto sun_map_errhandle;


/*-------------------------------------------------------------------.
| sun_map_errdefault -- current state does not do anything special for the |
| error token.                                                       |
`-------------------------------------------------------------------*/
sun_map_errdefault:
#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */

  /* If its default is to accept any token, ok.  Otherwise pop it.  */
  sun_map_n = sun_map_defact[sun_map_state];
  if (sun_map_n)
    goto sun_map_default;
#endif


/*---------------------------------------------------------------.
| sun_map_errpop -- pop the current state because it cannot handle the |
| error token                                                    |
`---------------------------------------------------------------*/
sun_map_errpop:
  if (sun_map_ssp == sun_map_ss)
    YYABORT;
  sun_map_vsp--;
  sun_map_state = *--sun_map_ssp;
#if YYLSP_NEEDED
  sun_map_lsp--;
#endif

#if YYDEBUG
  if (sun_map_debug)
    {
      short *sun_map_ssp1 = sun_map_ss - 1;
      YYFPRINTF (stderr, "Error: state stack now");
      while (sun_map_ssp1 != sun_map_ssp)
	YYFPRINTF (stderr, " %d", *++sun_map_ssp1);
      YYFPRINTF (stderr, "\n");
    }
#endif

/*--------------.
| sun_map_errhandle.  |
`--------------*/
sun_map_errhandle:
  sun_map_n = sun_map_pact[sun_map_state];
  if (sun_map_n == YYFLAG)
    goto sun_map_errdefault;

  sun_map_n += YYTERROR;
  if (sun_map_n < 0 || sun_map_n > YYLAST || sun_map_check[sun_map_n] != YYTERROR)
    goto sun_map_errdefault;

  sun_map_n = sun_map_table[sun_map_n];
  if (sun_map_n < 0)
    {
      if (sun_map_n == YYFLAG)
	goto sun_map_errpop;
      sun_map_n = -sun_map_n;
      goto sun_map_reduce;
    }
  else if (sun_map_n == 0)
    goto sun_map_errpop;

  if (sun_map_n == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++sun_map_vsp = sun_map_lval;
#if YYLSP_NEEDED
  *++sun_map_lsp = sun_map_lloc;
#endif

  sun_map_state = sun_map_n;
  goto sun_map_newstate;


/*-------------------------------------.
| sun_map_acceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
sun_map_acceptlab:
  sun_map_result = 0;
  goto sun_map_return;

/*-----------------------------------.
| sun_map_abortlab -- YYABORT comes here.  |
`-----------------------------------*/
sun_map_abortlab:
  sun_map_result = 1;
  goto sun_map_return;

/*---------------------------------------------.
| sun_map_overflowab -- parser overflow comes here.  |
`---------------------------------------------*/
sun_map_overflowlab:
  sun_map_error ("parser stack overflow");
  sun_map_result = 2;
  /* Fall through.  */

sun_map_return:
#ifndef sun_map_overflow
  if (sun_map_ss != sun_map_ssa)
    YYSTACK_FREE (sun_map_ss);
#endif
  return sun_map_result;
}
#line 407 "sun_map_parse.y"


/*
 * Parse 'map_data' which is assumed to be a Sun-syle map.  If
 * successful a sun_entry is returned.
 *
 * The parser is designed to parse map entries with out the keys.  For
 * example the entry:
 *
 * usr -ro pluto:/usr/local
 *
 * should be passed to the parser as:
 *
 * -ro pluto:/usr/local
 *
 * The reason for this is that the Amd info services already strip off
 * the key when they read map info.
 */
struct sun_entry *
sun_map_parse_read(const char *map_data)
{
  struct sun_entry *retval = NULL;

  /* pass map_data to lex */
  sun_map_tok_setbuff(map_data);

  /* call yacc */
  sun_map_parse();

  if (sun_entry_list != NULL) {
    /* return the first Sun entry in the list */
    retval = (struct sun_entry*)sun_entry_list->first;
    sun_entry_list = NULL;
  }
  else {
    plog(XLOG_ERROR, "Sun map parser did not produce data structs.");
  }

  return retval;
}


static struct sun_list *
get_sun_entry_list(void)
{
  if (sun_entry_list == NULL) {
    sun_entry_list = CALLOC(struct sun_list);
  }
  return sun_entry_list;
}


static struct sun_list *
get_mountpt_list(void)
{
  if (mountpt_list == NULL) {
    mountpt_list = CALLOC(struct sun_list);
  }
  return mountpt_list;
}


static struct sun_list *
get_sun_location_list(void)
{
  if (sun_location_list == NULL) {
    sun_location_list = CALLOC(struct sun_list);
  }
  return sun_location_list;
}


static struct sun_list *
get_sun_host_list(void)
{
  if (sun_host_list == NULL) {
    sun_host_list = CALLOC(struct sun_list);
  }
  return sun_host_list;
}


static struct sun_list *
get_sun_opt_list(void)
{
  if (sun_opt_list == NULL) {
    sun_opt_list = CALLOC(struct sun_list);
  }
  return sun_opt_list;
}
