dnl ######################################################################
dnl Setup options for building a shared libamu.so or static libamu.a
AC_DEFUN(AC_OPT_SHARED,
[AC_MSG_CHECKING(if to build and link with shared am-utils library)
AC_ARG_ENABLE(shared,
[  --enable-shared[=ARG]
                          build shared am-utils libraries (yes/no)],
[
if test "$enableval" = ""; then
  enablevel="yes"
fi
case "${enableval}" in
	yes )
		case "${CC}" in
			gcc )
				AM_LDADD_FLAGS=""
				AM_LDFLAGS='-L${top_builddir}/libamu -L${libdir} -lamu -R ${libdir}'
				AM_SHLIB_FLAGS="-fPIC"
			;;
			* )
				AM_LDADD_FLAGS=""
				AM_LDFLAGS='-L${top_builddir}/libamu -L${libdir} -lamu'
				AM_SHLIB_FLAGS="-fPIC-fixme"
			;;
		esac
		LIB_EXT="so"
		MKLIB_CMD='$(LD) -G -z text -o'

		AC_SUBST(AM_LDADD_FLAGS)
		AC_SUBST(AM_LDFLAGS)
		AC_SUBST(AM_SHLIB_FLAGS)
		AC_SUBST(LIB_EXT)
		AC_SUBST(MKLIB_CMD)
		AC_MSG_RESULT(yes)
	;;
	* )
		AM_LDADD_FLAGS="../libamu/libamu.a"
		AM_LDFLAGS=""
		AM_SHLIB_FLAGS=""
		LIB_EXT="a"
		MKLIB_CMD='$(AR) cruv'

		AC_SUBST(AM_LDADD_FLAGS)
		AC_SUBST(AM_LDFLAGS)
		AC_SUBST(AM_SHLIB_FLAGS)
		AC_SUBST(LIB_EXT)
		AC_SUBST(MKLIB_CMD)
		AC_MSG_RESULT(no)
	;;
esac
], [
# default is no shared libraries
AM_LDADD_FLAGS="../libamu/libamu.a"
AM_LDFLAGS=""
AM_SHLIB_FLAGS=""
LIB_EXT="a"
MKLIB_CMD='$(AR) cruv'

AC_SUBST(AM_LDADD_FLAGS)
AC_SUBST(AM_LDFLAGS)
AC_SUBST(AM_SHLIB_FLAGS)
AC_SUBST(LIB_EXT)
AC_SUBST(MKLIB_CMD)
AC_MSG_RESULT(no)
])])
dnl ======================================================================
