dnl ######################################################################
dnl find if "extern char *sys_errlist[]" exist in headers
AC_DEFUN(AC_EXTERN_SYS_ERRLIST,
[
AC_CACHE_CHECK(if external definition for sys_errlist[] exists,
ac_cv_extern_sys_errlist,
[
# try to compile program #1. if failed, it is most likely because of
# a conflict with an external definitions, so I can assume that the
# external definition does exist (it is a weak assumption)
AC_TRY_COMPILE(
[
#ifdef HAVE_STDIO_H
# include <stdio.h>
#endif /* HAVE_STDIO_H */
#ifdef HAVE_SYS_ERRNO_H
# include <sys/errno.h>
#endif /* HAVE_SYS_ERRNO_H */
#ifdef HAVE_ERRNO_H
# include <errno.h>
#endif /* HAVE_ERRNO_H */
],
[
extern char * sys_errlist[];
], ac_cv_extern_sys_errlist=no, ac_cv_extern_sys_errlist=yes)
# if could not find first definition, try to find stricter
# one (esp. on FreeBSD)
if test "$ac_cv_extern_sys_errlist" = no
then
 AC_TRY_COMPILE(
 [
#ifdef HAVE_STDIO_H
# include <stdio.h>
#endif /* HAVE_STDIO_H */
#ifdef HAVE_SYS_ERRNO_H
# include <sys/errno.h>
#endif /* HAVE_SYS_ERRNO_H */
#ifdef HAVE_ERRNO_H
# include <errno.h>
#endif /* HAVE_ERRNO_H */
],
[
extern const char * const sys_errlist[];
], ac_cv_extern_sys_errlist=no, ac_cv_extern_sys_errlist=yes)
fi
])
if test "$ac_cv_extern_sys_errlist" = yes
then
  AC_DEFINE(HAVE_EXTERN_SYS_ERRLIST)
fi
])
dnl ======================================================================
