dnl ######################################################################
dnl Find if struct nfs_args exists anywhere in typical headers
AC_DEFUN(AC_STRUCT_NFS_ARGS,
[
dnl make sure this is called before [AC_TYPE_NFS_FH]
AC_BEFORE([$0], [AC_TYPE_NFS_FH])
AC_BEFORE([$0], [AC_STRUCT_FIELD_NFS_FH])
AC_CACHE_CHECK(for struct nfs_args,
ac_cv_have_struct_nfs_args,
[
# try to compile a program which may have a definition for the structure
AC_TRY_COMPILE_NFS(
[ struct nfs_args na;
], ac_cv_have_struct_nfs_args=yes, ac_cv_have_struct_nfs_args=no)
])
if test "$ac_cv_have_struct_nfs_args" = yes
then
  AC_DEFINE(HAVE_STRUCT_NFS_ARGS)
  AC_DEFINE(nfs_args_t, struct nfs_args)
fi
])
dnl ======================================================================
