dnl ######################################################################
dnl check if system has NFS protocol headers
AC_DEFUN(AC_CHECK_NFS_PROT_HEADERS,
[
AC_CACHE_CHECK(location of NFS protocol header files,
ac_cv_nfs_prot_headers,
[
# select the correct style for mounting filesystems
case "${host_os_name}" in
	irix6* )
			ac_cv_nfs_prot_headers=irix6 ;;
	sunos4* )
			ac_cv_nfs_prot_headers=sunos4 ;;
	bsdi2* )
			ac_cv_nfs_prot_headers=bsdi2 ;;
	hpux* )
			ac_cv_nfs_prot_headers=hpux ;;
	aix* )
			ac_cv_nfs_prot_headers=aix3 ;;
	* )	# no style needed.  Headers are probably <rpcsvc/nfs_prot.h>
			ac_cv_nfs_prot_headers="system headers" ;;
esac
])
# only make a link and include the file name if needed.
if test "$ac_cv_nfs_prot_headers" = "system headers"
then
# define a macro that I could use in code to determine if host has NFS
# protocol headers.
  AC_DEFINE(HAVE_NFS_PROT_HEADERS)
# set empty variable for expansion in Makefile.am files
  AMU_NFS_PROT_HEADERS=""
  AC_SUBST(AMU_NFS_PROT_HEADERS)
else
# make sure correct header is linked in top build directory
  am_utils_nfs_prot_file="amu_nfs_prot.h"
  am_utils_link_files_src=${am_utils_link_files_src}conf/nfs_prot/nfs_prot_${ac_cv_nfs_prot_headers}.h" "
  am_utils_link_files_dst=${am_utils_link_files_dst}${am_utils_nfs_prot_file}" "
# set headers in a macro for Makefile.am files to use (for dependencies)
  AMU_NFS_PROT_HEADERS="../"$am_utils_nfs_prot_file
  AC_SUBST(AMU_NFS_PROT_HEADERS)
fi
])
dnl ======================================================================
