//mbxmime.cpp
//
// by JN2LHU jn2lhu@mailhost.net
// 
#include <afx.h>
#include <afxcoll.h>
#include <mbctype.h>
extern "C" {
extern unsigned short __cdecl _mbcjistojms(unsigned short);
extern unsigned short __cdecl _mbcjmstojis(unsigned short);
}

#define ESC 0x1b

BOOL bJIS = FALSE;
BOOL bHTML = FALSE;
BOOL bBase64 = FALSE;

void ConvJIS(char *buf)
{
    char tempLine[2048];
    unsigned short c;
    unsigned char *s;
    char *d;
    char f;

    s = (unsigned char*)buf;
    d = tempLine;
    f = 0;
    while(*s) {
        c = *s++;
        c &= 0xff;
        if (_ismbblead(c)) {
            c <<= 8;
            if (*s == '\x0a')
                break;
            c |= *s++;
            c = _mbcjmstojis(c);
            if (f == 0) {
                f = 1;
                *d++ = ESC;
                *d++ = 0x24;
                *d++ = 0x42;
            }
            *d++ = (char)(c>>8);
            *d++ = (char)(c & 0xff);
        } else {
            if (f == 1) {
                f = 0;
                *d++ = ESC;
                *d++ = 0x28;
                *d++ = 0x42;
            }
            *d++ = (char)c;
        }
    }
    if (f == 1) {
        f = 0;
        *d++ = ESC;
        *d++ = 0x28;
        *d++ = 0x42;
	}
    *d = '\0';
    strcpy(buf,tempLine);
}

class CQuoted
{
	int m_pos;
public:
	CQuoted();
	void Conv(char *buf);
};

CQuoted::CQuoted()
{
	m_pos = 0;
}

void CQuoted::Conv(char *buf)
{
	char *p;
	p = buf;
	while(*p) {
		BYTE c;
		c = *p++;
		if (c == '\n') {
			printf("\n");
			m_pos = 0;
		} else if (c < ' ' || c >= 0x80) {
			if (m_pos > 72) {
				printf("=\n");
				m_pos = 0;
			}
			printf("=%02X", (int)c);
			m_pos += 3;
		} else {
			if (m_pos > 72) {
				printf("=\n");
				m_pos = 0;
			}
			printf("%c", c);
			m_pos++;
		}
	}
}

static char basis_64[] =
   "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

class CBase64
{
	char m_buf[3];
	int m_pos;
	int m_cnt;
	void Putc(char c);
public:
	CBase64();
	~CBase64();
	void Conv(char *buf);
	void Flash();
};

CBase64::CBase64()
{
	m_pos = 0;
	m_cnt = 0;
}

CBase64::~CBase64()
{
	if (m_cnt > 0) {
		Flash();
	}
	if (m_pos > 0) {
		printf("\n");
	}
}

void CBase64::Putc(char c)
{
	m_buf[m_cnt++] = c;
	if (m_cnt >= 3) {
		Flash();
		if (m_pos > 72) {
			printf("\n");
			m_pos = 0;
		}
	}
}

void CBase64::Conv(char *buf)
{
	char *p;
	p = buf;
	while(*p) {
		char c;
		c = *p++;
		if (c == '\n') {
			Putc('\r');
			Putc('\n');
		} else {
		    Putc(c);
		}
 	}
}

void CBase64::Flash()
{
	int c1,c2,c3;
	char tmp[5];
	strcpy(tmp,"====");
     switch(m_cnt) {
        case 0:
 			return;
            break;
        case 1:
    	    c1 = m_buf[0] & 0xff;
    	    c2 = 0;
            c3 = 0;
    	    tmp[0] = basis_64[c1>>2];
    	    tmp[1] = basis_64[((c1 & 0x3)<< 4) | ((c2 & 0xF0) >> 4)];
 	    	break;
		case 2:
    	    c1 = m_buf[0] & 0xff;
    	    c2 = m_buf[1] & 0xff;
    	    c3 = 0;
    	    tmp[0] = basis_64[c1>>2];
    	    tmp[1] = basis_64[((c1 & 0x3)<< 4) | ((c2 & 0xF0) >> 4)];
            tmp[2] = basis_64[((c2 & 0xF)<< 2) | ((c3 & 0xC0) >> 6)];
  	    	break;
		case 3:
    	    c1 = m_buf[0] & 0xff;
    	    c2 = m_buf[1] & 0xff;
    	    c3 = m_buf[2] & 0xff;
    	    tmp[0] = basis_64[c1>>2];
    	    tmp[1] = basis_64[((c1 & 0x3)<< 4) | ((c2 & 0xF0) >> 4)];
            tmp[2] = basis_64[((c2 & 0xF)<< 2) | ((c3 & 0xC0) >> 6)];
            tmp[3] = basis_64[c3 & 0x3F];
	    	break;
    }
    m_cnt = 0;
	printf("%s", tmp);
	m_pos += 4;
}

BOOL mime(char *name)
{
    CStdioFile f;
    if (!f.Open(name,CFile::modeRead|CFile::typeText)) {
		return FALSE;
	}
	int pos = 0;

	printf("MIME-Version: 1.0\n");
	if (bJIS) {
		printf("Content-Type: text/%s; charset=ISO-2022-JP\n",
							bHTML ? "html" : "plain");
	} else {
		printf("Content-Type: text/%s\n",
							bHTML ? "html" : "plain");
	}
	if (bBase64) {
		printf("Content-Transfer-Encoding: base64\n");
	} else {
		printf("Content-Transfer-Encoding: quoted-printable\n");
	}
	printf("\n");
	CBase64 *pBase64 = new CBase64();
	CQuoted *pQuoted = new CQuoted();
	char buf[256];
	while(f.ReadString(buf,255) != NULL) {
		if (strcmp(buf,"/EX\n") == 0) {
			break;
		}
		if (bJIS) {
			ConvJIS(buf);
		}
		if (bBase64) {
			pBase64->Conv(buf);
		} else {
			pQuoted->Conv(buf);
		}
	}
	f.Close();
	delete pBase64;
	delete pQuoted;

	//printf("/EX\n");

	return TRUE;
}

int main(int argc, char *argv[])
{
	if (argc <= 1) {
		fprintf(stderr,"MBXMIME MIMEGR[_\n");
		fprintf(stderr,"    bZ[W{̂MIMEGR[h܂.\n");
		fprintf(stderr,"%s [-J] [-B] [-Q] file\n", argv[0]);
		fprintf(stderr,"-J ... JISR[hɕϊ.\n");
		fprintf(stderr,"-B ... Base64ŃGR[h.\n");
		fprintf(stderr,"-Q ... Quoted-PrintabledeŃGR[h.\n");
		exit(1);
	}
	for (int i = 1; i < argc; i++) {
		if (argv[i][0] == '-') {
			switch(argv[i][1]) {
				case 'H': case 'h':	//HTML
					bHTML = TRUE;
					break;
				case 'J': case 'j':	//JIS
					bJIS = TRUE;
					break;
				case 'S': case 's':	//SHIFT-JIS
					bJIS = FALSE;
					break;
				case 'B': case 'b':	//Base64
					bBase64 = TRUE;
					break;
				case 'Q': case 'q':	//Quoted-Printable
					bBase64 = FALSE;	
				    break;
				case 'L':
					break;
				default:
				    break;
			}
		} else {
			mime(argv[i]);
		}
	}    
    return 0;
}
