/*
 *   Copyright 1992, 1993, 1994 John Melton (G0ORX/N6LYT)
 *              All Rights Reserved
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
	xawutils.c

	Prepare a PacSat message for uploading

	John Melton
	G0ORX, N6LYT

	4 Charlwoods Close
	Copthorne
	West Sussex
	RH10 3QZ
	England

	INTERNET:	g0orx@amsat.org
			n6lyt@amsat.org
			john@images.demon.co.uk
			J.D.Melton@slh0613.icl.wins.co.uk

	History:

	0.1	initial version.
	0.2	fixed file length in header.
	0.3	converted to Xaw.
*/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>

#include "xawutils.h"

extern Display *dpy;
extern XtAppContext app_context;
extern Widget compwindow;

static Widget shell, form, label, button;

static int Ok;

static Arg shell_args[] =
{
	{XtNtitle,		(XtArgVal)NULL},
	{XtNheight,		(XtArgVal)80},
	{XtNwidth,		(XtArgVal)350}
};

static Arg form_args[] =
{
	{XtNdefaultDistance,	(XtArgVal)0},
};

static Arg label_args[] =
{
	{XtNfont,		(XtArgVal)NULL},
	{XtNwidth,		(XtArgVal)350},
	{XtNjustify,		XtJustifyCenter},
	{XtNresize,		False},
	{XtNborderWidth,	(XtArgVal)0},
	{XtNvertDistance,	(XtArgVal)10},
	{XtNtop,		XtChainTop},
	{XtNbottom,		XtChainTop},
	{XtNleft,		XtChainLeft},
	{XtNright,		XtChainLeft}
};

static Arg button_args[] =
{
	{XtNcallback,		(XtArgVal)NULL},
	{XtNlabel,		(XtArgVal)NULL},
	{XtNfont,		(XtArgVal)NULL},
	{XtNfromVert,		(XtArgVal)NULL},
	{XtNresize,		(XtArgVal)False},
	{XtNhorizDistance,	(XtArgVal)160},
	{XtNvertDistance,	(XtArgVal)20},
	{XtNtop,		XtChainTop},
	{XtNbottom,		XtChainTop},
	{XtNleft,		XtChainLeft},
	{XtNright,		XtChainLeft}
};

static Arg menu_item_args[] =
{
	{XtNlabel,		(XtArgVal)NULL},
	{XtNfont,		(XtArgVal)NULL}
};

static void OkCb(Widget w, XtPointer closure, XtPointer data)
{
	XtPopdown(shell);
	
	Ok = TRUE;
}

void MessageBox(char *message)
{
	XEvent e;
	Window root, child;
	int x, y, x_win, y_win;
	Dimension width, height;
	unsigned int mask;
	
	Ok = FALSE;

	XtVaSetValues(label, XtNlabel, message, NULL);

	XQueryPointer(dpy, DefaultRootWindow(dpy), &root, &child, &x, &y,
		&x_win, &y_win, &mask);
	XtVaGetValues(shell, XtNwidth, &width, XtNheight, &height, NULL);
	x -= width / 2;
	y -= height / 2;
	XtVaSetValues(shell, XtNx, (XtArgVal)x, XtNy, (XtArgVal)y, NULL);

	XtPopup(shell, XtGrabExclusive);
	
	do
	{
		XtAppNextEvent(app_context, &e);
		XtDispatchEvent(&e);
	}
	while (!Ok);
}

void createMessagePopup(XFontStruct *label_font, XFontStruct *button_font)
{
	static XtCallbackRec callback[2];

	shell = XtCreatePopupShell("message", transientShellWidgetClass,
				compwindow, shell_args, XtNumber(shell_args));

	form = XtCreateManagedWidget("form", formWidgetClass,
				shell, form_args, XtNumber(form_args));

	label_args[0].value = (XtArgVal)label_font;
	label = XtCreateManagedWidget("label", labelWidgetClass,
				form, label_args, XtNumber(label_args));

	callback[0].callback = OkCb;
	callback[0].closure  = shell;
	button_args[0].value = (XtArgVal)callback;
	button_args[1].value = (XtArgVal)"OK";
	button_args[2].value = (XtArgVal)button_font;
	button_args[3].value = (XtArgVal)label;
	button = XtCreateManagedWidget("button", commandWidgetClass,
				form, button_args, XtNumber(button_args));

	XtRealizeWidget(shell);
}

void createMenuPopup(Widget w, XFontStruct *font, MenuEntry *Entry, Cardinal n, XtCallbackProc callback)
{
	Widget shell, entries[20];
	int i;

	shell = XtCreatePopupShell("menu", simpleMenuWidgetClass, w, NULL, 0);

	for (i = 0; i < n; i++)
	{
		menu_item_args[0].value = (XtArgVal)Entry[i].Label;
		menu_item_args[1].value = (XtArgVal)font;

		entries[i] = XtCreateManagedWidget(Entry[i].widgetname, smeBSBObjectClass,
					shell, menu_item_args, XtNumber(menu_item_args));

		XtAddCallback(entries[i], XtNcallback, callback, (XtPointer)Entry[i].Value);
	}
}

