/*
 *   Copyright 1992, 1993, 1994 John Melton (G0ORX/N6LYT)
 *              All Rights Reserved
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
	viewlog.c

	X-Window front end to the log display functions.

	John Melton
	G0ORX, N6LYT

	4 Charlwoods Close
	Copthorne
	West Sussex
	RH10 3QZ
	England

	INTERNET:	g0orx@amsat.org
			n6lyt@amsat.org
			john@images.demon.co.uk
			J.D.Melton@slh0613.icl.wins.co.uk

	History:

	0.1	Initial version.		G4KLX
	0.2	Added WOD display.		G4KLX
*/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Text.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Viewport.h>

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <fcntl.h>
#include <dirent.h>
#include <signal.h>

#include "xawutils.h"
#include "viewlog.h"

Display *dpy;

XtAppContext app_context;

typedef struct
{
	XFontStruct *bold_font, *button_font, *text_font;
}
Resources;

Resources  resources;

Widget toplevel, compwindow, quitbutton, datawindow;

static XtResource resource_list[] =
{
	{"boldFont", XtCFont, XtRFontStruct, sizeof(XFontStruct *),
		XtOffsetOf(Resources, bold_font), XtRString, XtDefaultFont},
	{"buttonFont", XtCFont, XtRFontStruct, sizeof(XFontStruct *),
		XtOffsetOf(Resources, button_font), XtRString, XtDefaultFont},
	{"textFont", XtCFont, XtRFontStruct, sizeof(XFontStruct *),
		XtOffsetOf(Resources, text_font), XtRString, XtDefaultFont}
};

static Arg shell_args[] =
{
	{XtNtitle,		(XtArgVal)NULL}
};

static Arg form_args[] =
{
	{XtNdefaultDistance,	(XtArgVal)0}
};

static Arg button_args[] =
{
	{XtNcallback,		(XtArgVal)NULL},
	{XtNlabel,		(XtArgVal)NULL},
	{XtNfromHoriz,		(XtArgVal)NULL},
	{XtNfont,		(XtArgVal)NULL},
	{XtNresize,		(XtArgVal)False},
	{XtNvertDistance,	(XtArgVal)6},
	{XtNhorizDistance,	(XtArgVal)8},
	{XtNtop,		XtChainTop},
	{XtNbottom,		XtChainTop},
	{XtNleft,		XtChainLeft},
	{XtNright,		XtChainLeft}
};

static Arg window_args[] =
{
	{XtNfromVert,		(XtArgVal)NULL},
	{XtNbackground,		(XtArgVal)NULL},
	{XtNfont,		(XtArgVal)NULL},
	{XtNcursor,		(XtArgVal)NULL},
	{XtNwidth,		(XtArgVal)640},
	{XtNheight,		(XtArgVal)260},
	{XtNvertDistance,	(XtArgVal)6},
	{XtNscrollVertical,	XawtextScrollAlways},
	{XtNscrollHorizontal,	XawtextScrollWhenNeeded},
	{XtNeditType,		XawtextEdit},
	{XtNtype,		XawAsciiString},
	{XtNdisplayNonprinting,	False},
	{XtNdisplayCaret,	False},
	{XtNautoFill,		True}
};

void writetext(char *message)
{
	static XawTextPosition pos = 0;
	XawTextBlock tt;

	tt.firstPos = 0;
	tt.ptr      = message;
	tt.length   = strlen(message);
	tt.format   = FMT8BIT;

	XawTextReplace(datawindow, pos, pos, &tt);

	pos += strlen(message);
}


void QuitCb(Widget w, XtPointer client_data, XtPointer call_data)
{
	XtDestroyApplicationContext(app_context);

	exit(0);
}

int main(int argc, char **argv)
{
	static XtCallbackRec callback[2];
	FILE *fp;
	char *fileName;

	if (argc < 2)
	{
		fprintf(stderr, "usage: viewlog [title] <file-name>\n");
		return(1);
	}

	toplevel = XtAppInitialize(&app_context, "Xpb", NULL, 0, &argc, argv,
				NULL, shell_args, XtNumber(shell_args));

	XtVaSetValues(toplevel, XtNtitle, argv[1], NULL);

	dpy  = XtDisplay(toplevel);

	XtGetApplicationResources(toplevel, &resources,
				resource_list, XtNumber(resource_list),
				NULL, ZERO);

	compwindow = XtCreateManagedWidget("appForm", formWidgetClass,
				toplevel, form_args, XtNumber(form_args));

	callback[0].callback = QuitCb;
	callback[0].closure  = toplevel;
	button_args[0].value = (XtArgVal)callback;
	button_args[1].value = (XtArgVal)"Quit";
	button_args[3].value = (XtArgVal)resources.button_font;
	quitbutton = XtCreateManagedWidget("quitButton", commandWidgetClass,
				compwindow, button_args, XtNumber(button_args));

	window_args[0].value = (XtArgVal)quitbutton;
	window_args[1].value = (XtArgVal)WhitePixel(dpy, DefaultScreen(dpy));
	window_args[2].value = (XtArgVal)resources.text_font;
	datawindow = XtCreateManagedWidget("viewText", asciiTextWidgetClass,
				compwindow, window_args, XtNumber(window_args));

	createMessagePopup(resources.bold_font, resources.button_font);

	if (argc == 2)
		fileName = argv[1];
	else
		fileName = argv[2];

	if ((fp = fopen(fileName, "r")) == NULL)
	{
		MessageBox("Cannot open input file");
		return(1);
	}

	if (strncasecmp(argv[1], "AL", 2) == 0)
	{
		if (alogdisp(fp) != 0)
			MessageBox("Log file is currupt");
	}
	else if (strncasecmp(argv[1], "BL", 2) == 0)
	{
		if (blogdisp(fp) != 0)
			MessageBox("Log file is currupt");
	}
	else if (strncasecmp(argv[1], "CL", 2) == 0)
	{
		if (clogdisp(fp) != 0)
			MessageBox("Log file is currupt");
	}
	else if (strncasecmp(argv[1], "EL", 2) == 0)
	{
		if (elogdisp(fp) != 0)
			MessageBox("Log file is currupt");
	}
	else if (strncasecmp(argv[1], "WD", 2) == 0)
	{
		if (wdlogdisp(fp) != 0)
			MessageBox("Log file is currupt");
	}

	fclose(fp);

	XtRealizeWidget(toplevel);

	XtAppMainLoop(app_context);
	
	return(0);
}

