/* sparse.c - Parser for STATS tool.
   This module is part of stats.exe
                  
   Language = Microsoft C version 4.0


   This source is distributed freely and may be copied and
   redistributed with the following provisos:
   
           You may not sell it, nor may you charge for making 
           copies beyond the actual cost of mailing and media.
                      
   Written by Skip Hansen WB6YMH and Harold Price NK6K.

   Feedback is desired.

   RCP/M (213) 541-2503 300/1200/2400 baud
   or via packet WB6YMH @ WB6YMH-2 or 
		 NK6K @ NK6K

   Modification history:

	8/10/87	 	NK6K: Initial release.	
	ver 1.0		 

   10/18/87     NK6K: First general release.
   ver 1.1
  

	Notes:  This was a quick grab from something else that was
		laying around, and has several hooks for things 
		which aren't actually here.  On the other hand, it
		does the job.  To add new commands, add the text to
		sparse.h and a new case in doit() below.

*/



#include "sparse.h"
#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define FALSE 	0
#define TRUE 	!FALSE

/* common variables */
extern int p_timestamp;
extern int p_baud;
extern char p_port[];
extern char p_output[];
#ifdef LINUX
extern char using_socket;
#endif
extern int fd;

#define promptlen 4;

#define WAIT 1

int ars,ppoint,i;
unsigned int pnum;
int old_more;

char *token;
char buf[128];
int ctype;
int ltype;
int first_com_g;
      
int tflag,ok,eh;
#define true 1
#define false 0

enum ttypes { notoken,
	alftoken,
	numtoken,
	qmarktoken,		/* ? */
	}  typtoken;

char oplist[] = " ?;\"";

FILE *fin, *fout;
int in_open = 0;
int out_open = 0;

extern int  serlopen();
#ifdef LINUX
extern int  sockopen();
extern void sockdone();
#endif
extern void serldone(),kbddone(),kbdopen();
extern void dump_data();
void pbreak();

int baud[] = {
	300,600,1200,2400,4800,9600,19200};

void
ptoken(string)
char *string;
{
	static char *start;
	char *s;

	if (string != NULL)
		start = string;

	token = strtok(string, " \t\r\n");

	if (token == NULL) {
		typtoken = notoken;
		return;
	}

	ppoint = token - start;

	if (strcmp(token, "?") == 0) {
		typtoken = qmarktoken;
		return;
	}

	typtoken = alftoken;
	
	for (s = token; *s != '\0'; s++)
		if (!isdigit(*s))
			return;

	pnum = atoi(token);
	typtoken = numtoken;
}

void
pcom()
{
int match, looking, i;
        looking = true;
        ctype = 1+ (int) c_fnull ;
        while (comtext[ctype].c[0]!='\0' && (looking==1)) {
            match = true;
            i = 0;
            while ((i < strlen(token)) && (match==1)) {
               match = (toupper(token[i]) == comtext[ctype].c[i]);
                i++;
              }
            if (match==1) looking = false;
            else ctype++;
          }
      }

void
writedol(i)
int i;
{
 int j;
        i = i + promptlen;
        for (j=0;j<i;j++) printf(" ");
        printf("^");
}

void
writeeh(i)
int i;
{
        writedol(i);
        printf(" Error");
	pbreak();
}

void
peh()
{
	eh=true;
	ok=false;
}

void
doit()
{
int i,j,k,ii;

        switch (ctype) {
          case c_lnull:
              ok = false;
              eh = true;
		break;
          
	  case c_help:
 	        printf("Commands are:\r\n");
		 i=(numcom)/8;
		 k=1;
		 for (j=0;j<i;j++) {
			for (ii=0;ii<8;ii++,k++) printf("%.8s ",comtext[k].c);
			printf("\r\n");
			}
		 for (ii=0;ii<((numcom) % 8);ii++,k++)
			printf("%.8s ",comtext[k].c);
		 printf("\r\n");
		 break;

          case c_baud:
		ptoken(NULL);
		if (typtoken == notoken) {
			printf("Baud rate is %u\r\n",p_baud);
		} else if (typtoken != numtoken) {
			peh();
		} else {
			for (i = 0; i < 7; i++) {
				if (pnum == baud[i])
					break;
			}
			if (i == 7) {
				printf("Error: Baudrate %d is not supported.\r\n", pnum);
				break;
			}
			p_baud = pnum;
		}
		break;

	  case c_output:
	  	ptoken(NULL);
	  	if (typtoken == alftoken || typtoken == numtoken)
			strcpy(p_output, token);
	  	else peh();
	  	break;

          case c_port:
		ptoken(NULL);
		if (typtoken == notoken) {
			printf("Port is %s\r\n", p_port);
		} else if (typtoken == alftoken) {
#ifdef LINUX
			if (using_socket) {
				sockdone(fd);
			} else {
#endif
				serldone(fd);
#ifdef LINUX
			}
			if (strncmp(token, "sl", 2) == 0) {
				using_socket = TRUE;
				strcpy(p_port,token);
				fd = sockopen();
			} else {
				using_socket = FALSE;
#endif
				if ((fd = serlopen(token,p_baud)) == -1) {
					printf("Error: Invalid device name %s\r\n", token);
					break;
				}
				strcpy(p_port,token);
#ifdef LINUX
			}
#endif
		} else {
			peh();
		}
		break;

	  case c_end:
	  case c_quit:
		kbddone();
#ifdef LINUX
		if (using_socket) {
			sockdone(fd);
		} else {
#endif
			serldone(fd);
#ifdef LINUX
		}
#endif
		dump_data();
		exit(0);
		break;

	  case c_time:
		p_timestamp = !p_timestamp;
		if (p_timestamp) printf("Screen timestamping is now on\r\n");
		else printf("Screen timestamping is now off\r\n");
		break;

	  default: 
		fprintf(stderr,"*** internal error, parser default case\r\n");
		break;
	}
}

void
parse(flag,s)
int flag;			/* command line flag */
char *s;
{
	ok = true;
	eh = false;
	if (flag) 
		strcpy (buf,s);
	else {
		kbddone();
		fgets(buf, 128, stdin);
		kbdopen();
	}
	ars = strlen(buf);

        ptoken(buf);
	while ((ok) && (typtoken!=notoken)){
		if (typtoken==qmarktoken) {
			ctype=(int) c_help;
			doit();
			}
		else if ((typtoken==alftoken)||(typtoken==numtoken)) {
		        pcom();
          		if (ctype == (int) c_lnull) {
              			ok = false;
              			eh = true;
              			}
			else doit();
			}
		else {
			ok = false;
			eh = true;
			}
		if (ok) ptoken(NULL);
		else if (eh) writeeh(ppoint);
                }
}

void
pbreak()
{
	printf("\r\n");
}

