REM THIS PROGRAM CURRENTLY CONFIGURED TO BUILD A FILTERED TRACK HISTORY FILE
REM FROM A NUMBER OF SOURCE HISTORY FILES.  THE FILTERING IS NOT AS IMPORTANT
REM AS IT USED TO BE, BECAUSE NOW APRS PRE-FILTERS ALL POSITION REPORTS BEFORE
REM EVEN SAVING THEM TO A TRACK HISTORY FILE.
REM
REM It will filter out all position reports that are within a specified range
REM of each other.  It is primarily used to eliminate all duplicate points
REM while a station is stationary.  By making the range about .3 miles, almost
REM all points from a boat in port including the errors of GPS selective
REM availability will be eliminated.
REM
REM
DIM P$(59), Num(39)
LineP = 1: P$(1) = "NOTHING HERE TO START"
REM ON ERROR GOTO ErrorTrap

    CLS
    INPUT "Enter file name for accumulation of output if other than FILTROUT.HST"; F$
    IF F$ = "" THEN F$ = "FILTROUT.HST"
    OPEN F$ FOR OUTPUT AS #5
    PRINT
    INPUT "Enter range delta in miles if other than 0.3"; Del$
    IF Del$ = "" THEN Del$ = ".3"
 
REM BEGIN HERE TO REPETITIVELY ASK FOR THE NEXT SOURCE FILE
DO UNTIL UCASE$(a$) = "END"
ReDo: CLS : LOCATE 1, 47: PRINT "NumLines", "NumGood"
      LOCATE 3, 47: PRINT i, j
      LOCATE 4, 1: PRINT "Units found in file"
      LOCATE 6, 1: FOR ip = 1 TO LineP: PRINT LEFT$(P$(ip), 25), Num(ip): NEXT ip
      LOCATE 1, 1
      INPUT "Enter xxxxx.HST file name for filtering (or end)"; F$
      IF UCASE$(F$) = "END" THEN EXIT DO
      OPEN "b:" + F$ + ".hst" FOR INPUT AS #3
      IF Fault = 53 THEN GOTO ReDo

   REM BEGIN HERE TO READ EVERY ENTRY IN THE xxxxx.HST FILE AND FILTER IT
   DO WHILE NOT EOF(3)
      LINE INPUT #3, a$
      IF a$ <> "" THEN
         PM = 0: i = i + 1
         REM BUILD AN ARRAY OF ALL DIFFERENT STATIONS, SO THAT WE KEEP THE LATEST
         REM POSIT OF EACH STATION FOR COMPARISON WITH EACH NEW POSIT IN THE FILE
   
         FOR ip = 1 TO LineP ' Identify which boat and add to array if new boat
             IF LEFT$(a$, 9) = LEFT$(P$(ip), 9) THEN
                PM = ip: ip = LineP: Num(PM) = Num(PM) + 1
                END IF
         NEXT ip: IF PM = 0 THEN LineP = LineP + 1: PM = LineP: Num(PM) = 1
         REM Now compare new value with old value
         IF ABS(VAL(MID$(a$, 26, 7)) - VAL(MID$(P$(PM), 26, 7))) > VAL(Del$) THEN
            PRINT #5, a$: j = j + 1: P$(PM) = a$: LOCATE 3, 47: PRINT i, j
         ELSEIF ABS(VAL(MID$(a$, 35, 8)) - VAL(MID$(P$(PM), 35, 8))) > VAL(Del$) THEN
            PRINT #5, a$: j = j + 1: P$(PM) = a$: LOCATE 3, 47: PRINT i, j
         END IF
         REM the following line if activated assures that each new point is
         REM always compared with the previous point no matter what it is...
         REM In otherwords, the program works like a filter to remove adjacent
         REM points that are closer than delta apart.
         REM HOWEVER, if the following line is iimplemented in the above two
         REM lines after each save, then the program operates like a step
         REM filter throwing out all points EXCEPT for points separated by DEL
         REM This results in an evenly spaced track history every DEL miles
         REM P$(PM) = a$: LOCATE 3, 47: PRINT i, j
      END IF
   LOOP ' Loop back to read the next POSIT in this file
   CLOSE 3

LOOP ' Loop back to beginning and ask for the next xxxx.HST file
CLOSE 5: PRINT : PRINT "Filtered data from all files stored in FILTROUT.HST"
INPUT "Hit return to conitinue..."; a$
SYSTEM

ErrorTrap: Fault = ERR: LOCATE 2, 60'Error handling routine
     ercntr = ercntr + 1: REM IF ercntr > 6 THEN INPUT "in err routine"; a$
     IF ERR = 57 THEN PRINT "  I/O-error-User-"; : RESUME
     IF ERR = 69 THEN PRINT "  Comm-buffer-overflow"; : RESUME
     IF ERR = 53 THEN PRINT file$; "-NotFound": CLOSE #3: CLOSE #5: RESUME NEXT
     IF ERR = 52 THEN PRINT file$; "-Bad#": CLOSE #3: CLOSE #5: RESUME NEXT
     IF ERR = 64 THEN PRINT file$; "-BadName": CLOSE #3: CLOSE #5: RESUME NEXT
     IF ERR = 62 THEN RESUME NEXT  'Read past end of file
     IF ERR = 2 THEN PRINT "SYNTAX-error"
     RESET: PRINT : PRINT "Error I cant fix. Number = "; ERR;
     INPUT "Program crashed.  Sorry.  Hit RETURN to return to DOS"; a$
     SYSTEM

END

