{ ****************************************************************************
  ***                                                                      ***
  ***     QWCTIARU.PAS         Converts CT CQWW LOG.ALL TO IARU HF World   ***
  ***                          Championship Log                            ***
  ***                                                                      ***
  ***     Mario H. Fietz, N0LAZ        Version 1.0              15-JUL-91  ***
  ***                                                                      ***
  **************************************************************************** }

PROGRAM Qwctiaru;

USES Crt;

CONST yar  = 99;
      yhqb = '     ';
      yvers = 'K1EA CT CQWW > N0LAZ QW IARU V 1.0 (C) 1991';

VAR yhqstn                  : ARRAY[1..yar] OF String[14];  { HQ-Call        }
    yhqrpt                  : ARRAY[1..yar] OF String[5];   { HQ-RPRT        }
    yczne                   : ARRAY[1..300] OF STRING[4];   { Check Zone     }
    yhq,ypge                : INTEGER;                      { HQ-stn counter }
    ysumq,ysumz,ysumc,ysump : ARRAY[0..7] OF LongInt;
    yyr                     : STRING[2];
    yfile                   : STRING[14];
    iaru                    : TEXT;
    ytqso                   : LongInt;          { total qso   }
    ytzne                   : LongInt;          { total zones }
    ythq                    : LongInt;          { total HQs   }
    ytpts                   : LongInt;          { total pts   }

{-------------------------------------------------- Ini ---------------------}

PROCEDURE Ini;
VAR yn : INTEGER;
BEGIN
  ypge:=0; ytqso:=0; ytzne:=0; ythq:=0; ytpts:=0;
  FOR yn:=1 TO 300 DO yczne[yn]:='';
  FOR yn:=0 TO 7 DO
    BEGIN
    ysumq[yn]:=0;
    ysump[yn]:=0;
    ysumc[yn]:=0;
    ysumz[yn]:=0
    END
END;


{-------------------------------------------------- HQ Stn INPUT ------------}


PROCEDURE SumIn (yiband, ynzne, ynclb, ypts : INTEGER);
VAR yi : INTEGER;
BEGIN
  yi:=0;
  CASE yiband OF
    60 : yi:=1;
    80 : yi:=2;
    40 : yi:=3;
    20 : yi:=4;
    15 : yi:=5;
    10 : yi:=6
  END;

  ysumq[yi]:=ysumq[yi]+1;
  ysumz[yi]:=ysumz[yi]+ynzne;
  ysumc[yi]:=ysumc[yi]+ynclb;
  ysump[yi]:=ysump[yi]+ypts;

  ysumq[ 7]:=ysumq[ 7]+1;
  ysumz[ 7]:=ysumz[ 7]+ynzne;
  ysumc[ 7]:=ysumc[ 7]+ynclb;
  ysump[ 7]:=ysump[ 7]+ypts

END;


{-------------------------------------------------- EXCPT H -----------------}

PROCEDURE LogH(ymy,yclss : STRING);
CONST yhd = '                      IARU HF World Championship ';
VAR   yho : STRING;
BEGIN
  ypge:=ypge+1;
  Writeln(iaru,yhd+yyr);
   Writeln(iaru,' ');
  Writeln(iaru,'     PAGE : ',ypge:3,'   Callsign : ',ymy,'  Class : ',yclss);
  Writeln(iaru,' ');
  Writeln(iaru,'                                                          nw  new');
  Writeln(iaru,' BAND MODE   DATE    UTC      Call       send    rcvd     Zn   HQ    Pts');
  Writeln(iaru,' ---- ---- -------- ----- ------------- ------ ---------  --  -----  ---');
  Writeln(iaru,' ');
END;

{-------------------------------------------------- EXCPT F -----------------}

PROCEDURE LogF(var ydup,ypqso,ypzne,ypclb,yppts : INTEGER;ylast : BOOLEAN);
Const yb1 = '                        ';
BEGIN
  ypqso:=ypqso-ydup;
  ytqso:=ytqso+ypqso;
  ytzne:=ytzne+ypzne;
  ythq :=ythq +ypclb;
  ytpts:=ytpts+yppts;

  Writeln(iaru,' ');
  Writeln(iaru,'Total This Page   :       ',ypqso:5,yb1,ypzne:5,ypclb:5,' ',yppts:5);
  Writeln(iaru,' ');
  Writeln(iaru,'Cumulative Totals :       ',ytqso:5,yb1,ytzne:5,ythq:5,' ',ytpts:5);
  IF ylast=True THEN
    BEGIN
    Writeln(iaru,' ');
    Writeln(iaru,yvers)
    END;
  Writeln(iaru,Chr(12));

  ydup:=0; ypqso:=0; ypzne:=0; ypclb:=0; yppts:=0;

END;


{-------------------------------------------------- HQ Stn INPUT ------------}


PROCEDURE In_Hq;
VAR stn           : TEXT;
    yhqstr        : STRING;
    yblank        : INTEGER;

BEGIN
  yhq:=0;
  Assign (stn,'HQ.STN');
  {$I-}
  Reset (stn);
  {$I+}
  IF IOResult = 0 THEN
    BEGIN
    WHILE NOT Eof(stn) DO
      BEGIN
      Readln(stn,yhqstr);
      yblank:=Pos(' ',yhqstr);
      yhq:=yhq+1;
      yhqstn[yhq]:=Copy(yhqstr,1,yblank-1);
      yhqrpt[yhq]:=Copy(yhqstr,yblank+1,(Length(yhqstr)-Length(yhqstn[yhq])-1));
      WHILE Length(yhqrpt[yhq])<Length(yhqb) DO
	yhqrpt[yhq]:=yhqrpt[yhq]+' ';
      Writeln(yhqstn[yhq],' > ',yhqrpt[yhq]);
      END
    END
END;


{-------------------------------------------------------- Check HQ-Stns -----}


FUNCTION HqRprt (ycall : STRING) : STRING;
VAR yn : INTEGER;
BEGIN
  HqRprt:=yhqb;
  FOR yn:=1 TO yhq DO
    IF ycall=yhqstn[yn] THEN HqRprt:=yhqrpt[yn]
END;


{-------------------------------------------------------- Check Zones -------}


FUNCTION CheckZone (yband,yzone : STRING) : STRING;
VAR yn  : INTEGER;
    yb  : BOOLEAN;
    ybz : STRING[4];
BEGIN

  yb:=False;
  yn:=0;
  REPEAT
  yn:=yn+1;
  ybz:=yband+yzone;
  IF yczne[yn]='' THEN
    BEGIN
    yczne[yn]:=ybz;
    CheckZone:=yzone;
    yb:=True
    END
  ELSE
    BEGIN
    IF yczne[yn]=ybz THEN
      BEGIN
      CheckZone:='  ';
      yb:=True
      END
    END
  UNTIL (yb=True)
END;


{-------------------------------------------------------- Read CT Log --------}


PROCEDURE ReadLog;
VAR 
    ysl,ypts                    : STRING[1];
    yutc,ysnd                   : STRING[4];
    yhqclub                     : STRING[5];
    ydate,ym                    : STRING[8];
    ycall,ymy                   : STRING[16];
    ysrprt                      : STRING[40];
    yrzone,ynzon,ymyzone,yband  : STRING[2];
    yzone                       : STRING[5];
    y1st,yclss                  : STRING[60];
    yctlog                      : STRING;
    ct                          : TEXT;
    yipts                       : BYTE;             { qso   pts  }
    ydup                        : INTEGER;          { dupes      }
    yppts                       : INTEGER;          { page  pts  }
    yphq                        : INTEGER;          { page  HQ   }
    ypzn                        : INTEGER;          { page  Zone }
    ycode,yclb,yiband,yisnd     : INTEGER;
    ynzne,ynclb,yqsoc           : INTEGER;
    ycallsign                   : STRING[8];
    yfirst,ydupe                : BOOLEAN;

BEGIN
  yipts:=0; yppts:=0; ydup:=0;
  yphq :=0;
  ypzn :=0;
  yqsoc:=40;
  yfirst:=True;


  yfile  :=ParamStr(1);
  ymyzone:=ParamStr(2);
  yclss  :=ParamStr(3);
  ymy:='';

  Assign (iaru,yfile+'.WCL');
  Rewrite(iaru);

  Assign (ct,yfile+'.ALL');
  {$I-}
  Reset (ct);
  {$I+}
  IF IOResult > 0 THEN
    Writeln ('Cannot open ',yfile,'.ALL !')
  ELSE
    BEGIN
     While NOT Eof(ct) DO
      BEGIN
      Readln(ct,yctlog);

      ysl:=Copy(yctlog,8,1);
      ycallsign:=Copy(yctlog,13,8);
	IF ycallsign='CALLSIGN' THEN ymy:=Copy(yctlog,23,12);

      IF ysl='/' THEN                                       { a qso }
	BEGIN
	ydupe:=False;
	IF yqsoc=40 THEN
	  BEGIN
	  IF yfirst=False THEN
	    LogF(ydup,yqsoc,ypzn,yphq,yppts,False)
	  ELSE
	    yfirst:=False;
	  yyr:=Copy(yctlog,12,2);
	  yqsoc:=0;
	  LogH(ymy,yclss);
	  END;
	yqsoc:=yqsoc+1;
	ydate:=Copy(yctlog,06,08);
	yutc :=Copy(yctlog,16,04);
	yband:=Copy(yctlog,33,02);
	ycall:=Copy(yctlog,36,12);
	yclb:=Pos(' ',ycall);
	ycall:=Copy(ycall,1,yclb-1);

	ysnd :=Copy(yctlog,49,03);
	Val(ysnd,yisnd,ycode);
	yzone:=Copy(yctlog,53,02);
	yrzone:=yzone;
	ynzon:=Copy(yctlog,59,02);
	IF ynzon=' ' THEN ynzne:=0 ELSE ynzne:=1;
	ypts :=Copy(yctlog,71,01);
	y1st :=Copy(yctlog,01,60);

	IF ynzon='-D' THEN
	  BEGIN
	  ypts:='0';
	  ydupe:=True;
	  ydup:=ydup+1
	  END
	ELSE
	  BEGIN

	  ynzon:=CheckZone(yrzone,yband);

	  IF yzone=ymyzone THEN ypts:='1'
	  ELSE
	    IF (ypts='1') AND (yzone<>ymyzone) THEN ypts:='3'
	    ELSE
	      IF ypts='3' THEN ypts:='5';

	  VAL(ypts,yipts,ycode);
	  yppts:=yppts+yipts;

	  yhqclub:=HqRprt(ycall);
	  IF yhqclub<>yhqb THEN
	    BEGIN
	    ypts:='1';
	    yphq:=yphq+1;                      { Page HQ Counter }
	    yzone:=yhqclub;
	    ynclb:=1
	    END
	  ELSE
	    ynclb:=0;

	  IF ynzon<>'  ' THEN
	    BEGIN
	    ypzn:=ypzn+1;                      { Page Zone Counter }
	    ynzne:=1
	    END
	  ELSE
	    ynzne:=0;

	  VAL(yband,yiband,ycode);

	  SumIn(yiband,ynzne,ynclb,yipts);
        END;

	WHILE Length(yzone)<5 DO yzone:=yzone+' ';

	IF yisnd<100 THEN
	  BEGIN
	  ym:=' SSB  ';
	  ysrprt:=' 59  '+ymyzone+' '+ysnd+' '+yzone
	  END
	ELSE
	  BEGIN
	  ym:='  CW  ';
	  ysrprt:=' 599 '+ymyzone+' '+ysnd+' '+yzone
	  END;

	IF ydupe=True THEN ysrprt:=ysrprt+' -DUPLICATE-  0'
	ELSE
	  IF ynclb=1 THEN ysrprt:=ysrprt+'      '+yzone+'   '+ypts
	  ELSE
	    IF ynzne=1 THEN
	      ysrprt:=ysrprt+'  '+yrzone+'          '+ypts
	    ELSE
	      ysrprt:=ysrprt+'              '+ypts;

	ycall:='  '+ycall;
	WHILE Length(ycall)<14 DO ycall:=ycall+' ';

	Writeln(iaru,yiband:5,ym,ydate,'  ',yutc,ycall,ysrprt);
	IF (yqsoc=10) OR (yqsoc=20) OR (yqsoc=30) THEN Writeln(iaru,' ');
	END;


  {    Writeln(yctlog)    }     { This command displays the original log }
      END
    END;

  IF yqsoc>0 THEN LogF(ydup,yqsoc,ypzn,yphq,yppts,True);
  
  Close(iaru)
END;

{----------------------------------------------------- writing summary -----}

PROCEDURE SumOut;
VAR yn  : INTEGER;
    yb  : ARRAY[0..7] OF STRING;
    sum : TEXT;
    yso : STRING;
    ytot : LongInt;
BEGIN
  yb[1]:=' 160   ';
  yb[2]:='  80   ';
  yb[3]:='  40   ';
  yb[4]:='  20   ';
  yb[5]:='  15   ';
  yb[6]:='  10   ';
  yb[7]:=' Tot   ';

  Assign (sum,yfile+'.WCS');
  Rewrite(sum);

  yso:='BAND    QSO    ZONES      HQs     POINTS      TOTAL';
  Writeln(sum,yso);
  Writeln(sum,' ');

  FOR yn:=1 TO 7 DO
    BEGIN
    ytot:=ysump[yn] * (ysumz[yn]+ysumc[yn]);
    yso:=yso+yb[yn];
    Write  (sum,yb[yn],ysumq[yn]:4,'      ',ysumz[yn]:3,'      ');
    Writeln(sum,ysumc[yn]:3,'   ',ysump[yn]:8,'  ',ytot:9);
    END;
  Writeln(sum,' ');
  Writeln(sum,yvers);
  Close(sum)
END;


{----------------------------------------------------- MAIN PGM ------------}

BEGIN
   IF ParamCount <> 3 THEN
   Writeln ('***ERROR in PARAMETER')
ELSE
   Ini;
   In_Hq;
   ReadLog;
   SumOut
END.
