program LOCATOR;

 uses
  crt,arcsincos;

 var
  x:char;

 procedure DAZDEG;
  var
   z,la,lb,fa,fb,k,x,d:real;
   ch:char;
  begin
   repeat
    clrscr;
    write(#10,'Type point A''s longitude (in degrees and its decimals): ');
    readln(la);
    write('Type point A''s latitude (as above): ');
    readln(fa);
    write(#10'Type point B''s longitude (as above): ');
    readln(lb);
    write('Type point B''s latitude (as above): ');
    readln(fb);
    la:=pi*la/180;
    fa:=pi*fa/180;
    lb:=pi*lb/180;
    fb:=pi*fb/180;
    k:=111.1347+0.1867*cos(fa+fb);
    x:=arccos(sin(fa)*sin(fb)+cos(fa)*cos(fb)*cos(lb-la));
    d:=k*x*180/pi;
    writeln(#10,#10,'Distance between points A and B on Earth surface is ',d:0:2,' km.');
    z:=sin(fb)-sin(fa)*cos(x);
    d:=cos(fa)*sin(x);
    z:=z/d;
    if z>1 then z:=1;
    d:=arccos(z)/pi*180;
    if d<0 then d:=d+180;
    if sin(la-lb)>0 then d:=360-d;
    writeln('Azimuth is ',d:0:2);
    ch:=readkey;
   until ch=#27;
  end;

 procedure DAZLOC;
  var
   z,la,lb,fa,fb,k,x,d:real;
   loc:string[6];
   i:byte;
   ch:char;
  begin
   repeat
    clrscr;
    write(#10,'Type point A''s LOCATOR: ');
    readln(loc);
    for i:=1 to 6 do
     loc[i]:=upcase(loc[i]);
    la:=(ord(loc[1])-65)*20-180+(ord(loc[3])-48)*2+(ord(loc[5])-65)/12+1/24;
    fa:=(ord(loc[2])-65)*10-90+(ord(loc[4])-48)+(ord(loc[6])-65)/24+1/48;
    write('Type point B''s LOCATOR: ');
    readln(loc);
    for i:=1 to 6 do
     loc[i]:=upcase(loc[i]);
    lb:=(ord(loc[1])-65)*20-180+(ord(loc[3])-48)*2+(ord(loc[5])-65)/12+1/24;
    fb:=(ord(loc[2])-65)*10-90+(ord(loc[4])-48)+(ord(loc[6])-65)/24+1/48;
    la:=pi*la/180;
    fa:=pi*fa/180;
    lb:=pi*lb/180;
    fb:=pi*fb/180;
    k:=111.1347+0.1867*cos(fa+fb);
    x:=arccos(sin(fa)*sin(fb)+cos(fa)*cos(fb)*cos(lb-la));
    d:=k*x*180/pi;
    writeln(#10,#10,'Distance between points A and B on Earth surface is ',d:0:2,' km.');
    z:=sin(fb)-sin(fa)*cos(x);
    d:=cos(fa)*sin(x);
    z:=z/d;
    if z>1 then z:=1;
    d:=arccos(z)/pi*180;
    if d<0 then d:=d+180;
    if sin(la-lb)>0 then d:=360-d;
    writeln('Azimuth is ',d:0:2);
    ch:=readkey;
   until ch=#27;
  end;


 procedure LOC2DEG;
  var
   loc:string[6];
   la,fa:real;
   ch:char;
   i:byte;
  begin
   repeat
    clrscr;
    write(#10,'LOC = ');
    readln(loc);
    for i:=1 to 6 do
     loc[i]:=upcase(loc[i]);
    la:=(ord(loc[1])-65)*20-180+(ord(loc[3])-48)*2+(ord(loc[5])-65)/12;
    fa:=(ord(loc[2])-65)*10-90+(ord(loc[4])-48)+(ord(loc[6])-65)/24;
    writeln(#10,#10,' Longitude:  ',la:0:4,'  ',la+1/12:0:4,'   (',la+1/24:0:4,')');
    writeln(' Latitude:   ',fa:0:4,'  ',fa+1/24:0:4,'   (',fa+1/48:0:4,')');
    ch:=readkey;
   until ch=#27;
  end;

 procedure DEG2LOC;
  var
   loc:string[6];
   bc,lc,la,fa:real;
   ch:char;
  begin
   repeat
    clrscr;
    write(#10,'Type longitude (in degrees and its decimals): ');
    readln(la);
    write('Type latitude (in degrees and its decimals): ');
    readln(fa);
    bc:=(fa+90)/10;
    lc:=(la+180)/20;
    if lc>=18 then lc:=lc-18;
    loc:=chr(65+trunc(lc))+chr(65+trunc(bc));
    lc:=(lc-trunc(lc))*10;
    bc:=(bc-trunc(bc))*10;
    loc:=loc+chr(48+trunc(lc))+chr(48+trunc(bc));
    lc:=(lc-trunc(lc))*24;
    bc:=(bc-trunc(bc))*24;
    loc:=loc+chr(65+trunc(lc))+chr(65+trunc(bc));
    writeln(#10,#10,' LOC = ',loc);
    ch:=readkey;
   until ch=#27;
  end;

 begin
  repeat
   clrscr;
   writeln(#10,#10,#10,'     1. Computing distance and azimuth basing on geographical coordinates.');
   writeln('     2. Computing distance and azimuth basing on locator grid.');
   writeln('     3. Translating LOCATOR => geograph. coords.');
   writeln('     4. Translating geograph. coords => LOCATOR.');
   gotoxy(55,25);
   write('(C) 1994 Peter Kaczmarzyk');
   gotoxy(5,9);
   write(':');
   x:=readkey;
   case x of
    '1':DAZDEG;
    '2':DAZLOC;
    '3':LOC2DEG;
    '4':DEG2LOC;
   end;
  until x=#27;
 end.