10  '                          LOCATE
20  '        Locator conversions, bearings and distances
30  '     Program by G3SEK, from original subroutines by GM4ANB
40  '
50 PI = 4 * ATN(1): DR = PI / 180: RD = 180 / PI
55 DEF FNA (X) = ABS(RD * X)
60 A = 6378: B = 6356: R = (A + B) / 2: BA = B * B / (A * A)' Earth's radii
70 GOSUB 5000                                   ' read data from HOME.DAT
80 N0 = N0 * DR: N = N0
90 E0 = -E0 * DR: E = E0
95 GOSUB 2000: HLCTR$ = IARU$                   ' home locator
98 '
99 ' Start/restart point
100 CLS : KEY OFF
110 LOCATE 3, 34: COLOR 0, 3: PRINT " LOCATE ": COLOR 7, 0
120 LOCATE 5, 29: PRINT "Locator Conversions"
130 LOCATE 6, 36: PRINT "and"
140 LOCATE 7, 27: PRINT "Bearings and Distances": LOCATE 8, 36: PRINT "from"
150 LOCATE 9, 28: PRINT CLL$; " "; HOME$
160 LOCATE 10, 34: COLOR 14, 0: PRINT " "; HLCTR$; " ": COLOR 7, 0
170 GOSUB 500: LOCATE 12, 1: PRINT SPACE$(79); : LOCATE 17, 28
180 T1 = FNA(N): PRINT USING "Latitude  =  ## ##.#min "; INT(T1); 60 * (T1 - INT(T1));
190 IF SGN(N) = 1 THEN PRINT "N" ELSE IF SGN(N) = -1 THEN PRINT "S" ELSE PRINT
195 LOCATE 18, 28: T1 = FNA(E)
200 PRINT USING "Longitude = ### ##.#min "; INT(T1); 60 * (T1 - INT(T1));
210 IF SGN(E) = 1 THEN PRINT "E" ELSE IF SGN(E) = -1 THEN PRINT "W" ELSE PRINT
220 GOSUB 3000
230 LOCATE 20, 28: PRINT USING "Distance  = #####.# km"; DX
240 LOCATE 21, 40: PRINT USING "#####.# miles"; DX / 1.609
250 LOCATE 23, 28: PRINT USING "Bearing   =   ###.#"; RD * AZ
260 LOCATE 25, 19: COLOR 11, 0
270 PRINT " Press Enter to continue  -OR-  Esc to quit "; : COLOR 7, 0
280 T$ = INPUT$(1)
290 IF T$ = CHR$(27) THEN CLS : END ELSE GOTO 100
498 '
499 ' Input subroutine
500 LOCATE 12, 1: COLOR 11, 0
510 PRINT "INPUT  -  Locator or 8-character National Grid Reference   (Enter = lat/long)"
515 COLOR 7, 0: LOCATE 14, 35
520 INPUT "", LCTR$: IF LCTR$ = "" THEN GOTO 610 ELSE GOSUB 4000
530 OK% = 0
540 IF LEN(LCTR$) = 4 THEN LCTR$ = "IO" + LCTR$: LOCATE 14, 35: PRINT LCTR$;
550 IF LEN(LCTR$) = 5 THEN GOSUB 1200             'Old European locator
560 IF LEN(LCTR$) = 6 THEN GOSUB 1000             'IARU locator
570 IF LEN(LCTR$) = 8 THEN GOSUB 1500             'UK National Grid Reference
580 IF NOT OK% THEN BEEP: LOCATE 14, 35: PRINT SPACE$(44); : GOTO 515
590 IF LEN(LCTR$) <> 6 THEN GOSUB 2000 ELSE PRINT 'Print IARU loc if not entered
600 RETURN
610 LOCATE 15, 20: PRINT "Latitude  (degrees)"
620 LOCATE 16, 20: PRINT "Latitude  (decimal minutes)"
630 LOCATE 17, 20: PRINT "N or S"
640 LOCATE 18, 20: PRINT "Longitude (degrees)"
650 LOCATE 19, 20: PRINT "Longitude (decimal minutes)"
660 LOCATE 20, 20: PRINT "E or W"
670 LOCATE 15, 49: INPUT ; ": ", LAD: IF LAD < 0 OR LAD > 89 THEN GOSUB 850: GOTO 670
680 LOCATE 16, 49: INPUT ; ": ", LAM: IF LAM < 0 OR LAM >= 60 THEN GOSUB 850: GOTO 680
690 LOCATE 17, 20: PRINT "               Press N or S  > ";
700 N$ = INPUT$(1): IF N$ = "S" OR N$ = "s" THEN N$ = "S" ELSE N$ = "N"
710 PRINT N$
720 LOCATE 18, 49: INPUT ; ": ", LOD: IF LOD < 0 OR LOD > 179 THEN GOSUB 850: GOTO 720
730 LOCATE 19, 49: INPUT ; ": ", LOM: IF LOM < 0 OR LOM >= 60 THEN GOSUB 850: GOTO 730
740 LOCATE 20, 20: PRINT "               Press E or W  > ";
750 E$ = INPUT$(1): IF E$ = "E" OR E$ = "e" THEN E$ = "E" ELSE E$ = "W"
760 PRINT E$
770 N = DR * (LAD + LAM / 60): IF N$ = "S" THEN N = -N
780 E = DR * (LOD + LOM / 60): IF E$ = "W" THEN E = -E
790 FOR I% = 15 TO 20: LOCATE I%, 20: PRINT SPACE$(40): NEXT
800 GOSUB 2000
810 RETURN
850 BEEP: LOCATE CSRLIN, 49: PRINT SPACE$(30); : RETURN
998 '
999 ' IARU locator to latlong
1000 IF LEN(LCTR$) <> 6 THEN RETURN
1010 T = 1: GOSUB 1070
1020 E = N + N
1030 IF NOT OK% THEN RETURN
1040 OK% = 0: T = 2: GOSUB 1070
1050 RETURN
1060 '
1070 N = ASC(MID$(LCTR$, T, 1)) - ASC("A")
1080 IF N < 0 OR N > 17 THEN RETURN
1090 T$ = MID$(LCTR$, T + 2, 1)
1100 IF T$ < "0" OR T$ > "9" THEN RETURN
1110 N = N * 10 + ASC(T$) - ASC("0")
1120 T$ = MID$(LCTR$, T + 4, 1)
1130 IF T$ < "A" OR T$ > "X" THEN RETURN
1140 N = N * 24 + ASC(T$) - ASC("A")
1150 N = N - 2160 + .5
1160 N = N * PI / 4320
1170 OK% = -1: RETURN
1198 '
1199 ' Old QRA locator to latlong
1200 E = 60 * (ASC(LEFT$(LCTR$, 1)) - ASC("A"))
1280 IF (E < 0) OR (E > 1500) THEN RETURN
1290 N = 48 * (ASC(MID$(LCTR$, 2, 1)) - ASC("A"))
1300 IF (N < 0) OR (N > 1200) THEN RETURN
1310 T$ = MID$(LCTR$, 3, 1)
1320 IF (T$ < "0") OR (T$ > "8") THEN RETURN
1330 T$ = MID$(LCTR$, 4, 1)
1340 IF (T$ < "0") OR (T$ > "9") THEN RETURN
1350 T = VAL(MID$(LCTR$, 3, 2))
1360 IF (T > 80) OR (T < 1) THEN RETURN
1370 T = (T - 1) / 10
1380 N = N + 6 * (7 - INT(T))
1390 E = E + 60 * (T - INT(T))
1400 A$ = RIGHT$(LCTR$, 1): IF (A$ < "A") OR (A$ = "I") OR (A$ > "J") THEN RETURN
1410 IF (A$ = "A") OR (A$ = "J") OR (A$ = "E") THEN E = E + 2
1420 IF (A$ = "B") OR (A$ = "C") OR (A$ = "D") THEN E = E + 4
1430 IF (A$ = "G") OR (A$ = "J") OR (A$ = "C") THEN N = N + 2
1440 IF (A$ = "H") OR (A$ = "A") OR (A$ = "B") THEN N = N + 4
1450 N = N + 1921: E = E + 1
1460 IF (E > 1200) THEN E = E - 1560
1470 E = E * PI / 5400
1480 N = N * PI / 8640
1490 OK% = -1: RETURN
1498 '
1499 ' UK NGR to latlong
1500 ON ERROR GOTO 1610: E1 = VAL(MID$(LCTR$, 3, LEN(LCTR$) - 5)) / 10
1510 N1 = VAL(RIGHT$(LCTR$, 3)) / 10
1520 T1 = ASC(LEFT$(LCTR$, 1)) - ASC("A"): IF T1 > 8 THEN T1 = T1 - 1
1530 T2 = INT(T1 / 5): N1 = N1 + 500 * (3 - T2): E1 = E1 + 500 * (T1 - 5 * T2 - 2)
1540 T1 = ASC(MID$(LCTR$, 2, 1)) - ASC("A"): IF T1 > 8 THEN T1 = T1 - 1
1550 T2 = INT(T1 / 5): N1 = N1 + 100 * (4 - T2): E1 = E1 + 100 * (T1 - 5 * T2)
1560 T1 = (N1 + 5548.79) / 6371.28
1570 T2 = 2 * ATN(EXP((E1 - 400) / 6389.7))
1580 E = ATN(-COS(T2) / (COS(T1) * SIN(T2))) - .0349066
1590 N = SIN(T2) * SIN(T1): N = ATN(N / SQR(1 - N * N))
1600 OK% = -1: ON ERROR GOTO 0: RETURN
1610 RESUME 1620
1620 RETURN
1998 '
1999 ' Latlong to IARU locator
2000 IF (PI / 2 - ABS(N)) < .000157 GOTO 2060' < 1km from N or S pole
2010 T = 1 / (2 * PI): E1 = E * T + .5: N1 = N * T * 2 + .5: IARU$ = ""
2020 T = ASC("A"): F = 18: GOSUB 2080
2030 T = ASC("0"): F = 10: GOSUB 2080
2040 T = ASC("A"): F = 24: GOSUB 2080
2050 GOTO 2070
2060 IF SGN(N) = -1 THEN IARU$ = "SOUTH POLE" ELSE IARU$ = "NORTH POLE"
2070 LOCATE 15, 28: PRINT "IARU Loc. =  "; IARU$: RETURN
2080 N1 = F * (N1 - INT(N1)): E1 = F * (E1 - INT(E1))
2090 IARU$ = IARU$ + CHR$(INT(T + E1)) + CHR$(INT(T + N1))
2100 RETURN
2998 '
2999 ' Bearing and distance using central angles
3000 N1 = ATN(BA * TAN(N0))
3010 N2 = ATN(BA * TAN(N))
3020 CO = COS(E0 - E) * COS(N1) * COS(N2) + SIN(N1) * SIN(N2)
3030 CA = ATN(ABS(SQR(1 - CO * CO) / CO))
3040 IF CO < 0 THEN CA = PI - CA
3050 DX = R * CA
3060 SI = SIN(E - E0) * COS(N2) * COS(N1)
3070 CO = SIN(N2) - SIN(N1) * COS(CA)
3080 AZ = ATN(ABS(SI / CO))
3090 IF CO < 0 THEN AZ = PI - AZ
3100 IF SI < 0 THEN AZ = -AZ
3110 IF AZ < 0 THEN AZ = AZ + 2 * PI
3120 RETURN
3998 '
3999 ' Convert LCTR$ to upper case, and strip spaces
4000 TT$ = ""
4010 FOR I% = 1 TO LEN(LCTR$)
4020 T$ = MID$(LCTR$, I%, 1)
4030 IF T$ = " " THEN GOTO 4060
4040 IF T$ >= "a" AND T$ <= "z" THEN T$ = CHR$(ASC(T$) - 32)
4050 TT$ = TT$ + T$
4060 NEXT
4070 LCTR$ = TT$
4080 RETURN
5000 ' Read home station location from HOME.DAT
5010 OPEN "HOME.DAT" FOR INPUT AS 1
5020 INPUT #1, N0, E0
5030 INPUT #1, HOME$, CLL$
5040 CLOSE
5050 RETURN

