/*
 * TRK - Satellite tracking program based on Norad SGP/SDP model with
 *       curses interface
 *
 *	by Lapo Pieri IK5NAX  2000-2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Send bugs reports, comments, critique, etc, to ik5nax@amsat.org
 */

#include <string.h>
#include <ctype.h>
#include "trk.h"

/*--------------------------------------------------------------------------*/
/*  Un buon articolo che spieghi il QTH locator e' su RR 1/91 pag 77, e' da */
/*  li che ho preso spunto, anche quando scrissi i programmini di           */
/*  conversione per l'HP48                                                  */
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* Brevi note sul QTH locator:                                              */
/* -il rettangolo piu'grande e' di 20x10 gradi (lonxlat) [prime due lettere]*/
/* -quello intermedio 2x1 grado (lonxlat) [cifre]                           */
/* -quello piu' piccolo 5x2.5 minuti (lonxlat) [ultime due lettere]         */
/* -il primo carattere di ogni coppia e' la longitudine                     */
/* -per la prima coppia di lettere sono validi AA-RR, per la seconda AA-XX  */
/* -prima di questo locator ce n'era un altro...                            */
/* -la numerazione dei quadrati piu' grandi parte con la A al polo sud e    */
/*  termina con la R al polo nord                                           */
/* -per la longitudine si inizia con la A a 180 da Greenwich e si termina   */
/*  con R sul meridiano zero                                                */ 
/*--------------------------------------------------------------------------*/


/*--------------------------------------------------------------------------*/
/*  Lonlat2qthloc:      (longitudine,latitudine)->QTH Locator               */
/*                IN: lon [deg]  {-180,360} <0 ovest   >0 est               */
/*                    lat [deg]  {-90,90} <0 sud   >0 nord                  */
/*                OUT: qthlocator [maiuscolo]                               */
/*                Ritorno: -1 se lon,lat sono nei limiti, +1 altrimenti     */ 
/*--------------------------------------------------------------------------*/
int lonlat2qthloc(float lon, float lat, char *qth)
{
float t;

if(lon>360 || lon<-180 || lat>90 || lat<-90) return(-1);
if(lon>180.) lon-=360.;
lon+=180.; lat+=90.;
t=lon/20.;
qth[0]='A'+(int)t;
t=(t-(int)t)*10;
qth[2]='0'+(int)t;
t=(t-(int)t)*24;
qth[4]='A'+(int)t;
t=lat/10.;
qth[1]='A'+(int)t;
t=(t-(int)t)*10;
qth[3]='0'+(int)t;
t=(t-(int)t)*24;
qth[5]='A'+(int)t;

return(0);
}


/*--------------------------------------------------------------------------*/
/*  Qthloc2lonlat:      QTH Locator -> (longitudine,latitudine)             */
/*                IN: qthlocator [maiuscolo o minuscolo]                    */
/*                OUT: lon [deg]  {-180,180} <0 ovest   >0 est              */
/*                     lat [deg]  {-90,90} <0 sud   >0 nord                 */
/*                Ritorno: -1 se il qth contiene caratteri non ammessi,     */
/*                          0 altrimenti                                    */ 
/*                                                                          */
/*     ATTENZIONE: le coordinate restituite sono il centro del              */
/*                 quadratino, non i bordi!                                 */
/*                                                                          */
/* Se il QTH viene dato a 4 caratteri gli ultimi  due vengono messi uguali  */
/* a KK (centro del quadratone)                                             */
/*--------------------------------------------------------------------------*/
int qthloc2lonlat(char *qth, float *lon, float *lat)
{

qth[0]=toupper(qth[0]); qth[1]=toupper(qth[1]);
 
if(qth[0]<'A' || qth[0]>'R') return(-1);
if(qth[1]<'A' || qth[1]>'R') return(-1);
if(qth[2]<'0' || qth[2]>'9') return(-1);
if(qth[3]<'0' || qth[3]>'9') return(-1);

if(strlen(qth)<6) { qth[4]='k'; qth[5]='k'; }
qth[4]=toupper(qth[4]); qth[5]=toupper(qth[5]);
if(qth[4]<'A' || qth[4]>'X') return(-1);
if(qth[5]<'A' || qth[5]>'X') return(-1);

*lon=(qth[0]-'A')*20.+(qth[2]-'0')*2.+(qth[4]-'A')/12.+1./24.;
*lat=(qth[1]-'A')*10.+(qth[3]-'0')*1.+(qth[5]-'A')/24.+1./48.;
*lon-=180; *lat-=90;   

return 0;
}
