/*
 * TRK - Satellite tracking program based on Norad SGP/SDP model with
 *       curses interface
 *
 *	by Lapo Pieri IK5NAX  2000-2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Send bugs reports, comments, critique, etc, to ik5nax@amsat.org
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include "trk.h"

extern cfg_file cfgf;

double localhoriz(OBS *obs, double az, int h0){
int n=0, i;

if(h0==0) return 0.;

 az=az*180./M_PI+180;

 /* Ricerca delle due posizioni della tabella dell'orizzonte a cavallo delle
    quali si trova az */
 while(obs->horiz[0][n]!=360.){
 if(obs->horiz[0][n]<az) i=n;
 if(obs->horiz[0][n]>az) break;
 n++; if(n>72) break;
 }

 /* L' interpolazione e` lineare fra i due punti piu` prossimi sopra e sotto */
return((obs->horiz[1][n]-obs->horiz[1][i])/
       (obs->horiz[0][n]-obs->horiz[0][i])*
       (az-obs->horiz[0][i])+obs->horiz[1][i]);
}


/* Calcola la posizione dell'osservatore nelle coordinate IJK (geocentrico
   equatoriale) con modello ellissoidale della Terra*/
void obsijk(double tetha, OBS *obs, float *xo, float *yo, float *zo){
 
float x,z;
   
x=(aT/sqrt(1-eT*eT*sin(obs->lat)*sin(obs->lat))+obs->h0)*cos(obs->lat);
z=(aT/sqrt(1-eT*eT*sin(obs->lat)*sin(obs->lat))*(1-eT*eT)+obs->h0)*
  sin(obs->lat);
*xo=x*cos(tetha);
*yo=x*sin(tetha);
*zo=z;
   }


/* 
   Lettura del file obs.dat contenente le informazioni sugli osservatori e
   riempimento di strutture organizzate in una lista concatenata con gli 
   stessi dati controllando gli errori

   Se prerr=1 vengono stampati gli errori su stderr, altrimenti si va avanti:
   al limite nella lista concatenata non ci saranno dati (questo si potrebbe 
   segnalare o forse ne risulta una lista di un solo puntatore a NULL (?))
 */
OBS *getobs(int prerr){
 FILE *fpobs;
  char lb[80], b[80];
  int n, e=1, chk, i;
  OBS *obs, *h, *t;
  float v, lon, lat, horaz, horel;

  if((fpobs=fopen(cfgf.obsdatf, "r"))==NULL) {
    if(prerr==1) 
      fprintf(stderr, "Unable to open observer data file %s\n", cfgf.obsdatf); 
    return NULL;
  }

  obs=NULL; h=NULL; t=NULL;

  while(e){
    for(n=0; n<80; n++) lb[n]=0;

    /* Controllo della fine del file */
    if(fgets(lb, 80, fpobs)==NULL) { e=0; lb[0]='['; }

    /* Il carattere "#" e` per i commenti */
    if(lb[0]=='#') continue;

    /* Se e` stato trovato un carattere "[" ... */
    if(lb[0]=='[') {          
      if(obs!=NULL) {              /* ...ma non e` il primo osservatore */
                                   /* allora si puo` salvare la struttura obs
				      nella lista concatenata: non ho ben
				      chiaro come funzioni tutto cio` ma 
				      copiando dal file tle.c (proveniente dal
				      programma COLA) tutto funziona...
				   */

/* Prima si fanno pero` alcuni controlli e si riempiono i campi mancanti */

	chk=0;
	/* Se lon e lat non sono stati letti si cerca di ottenerli dal QTH */
	if(obs->lat>90.&&obs->lon>180.){
	  if(obs->qth[0]==0) chk=1;                   /* Non ci sono ne' lon,
							 lat, ne qth... */
	  else if(qthloc2lonlat(obs->qth, &lon, &lat)<0) chk=2; /* Errore
								   formato 
								   QTHloc */
	  else { obs->lon=lon; obs->lat=lat; }
	}

	/* Altrimenti si verifica che siano concordi con il QTH */
	else if(obs->qth[0]!=0) {
	  lonlat2qthloc(obs->lon, obs->lat, b);
	  if(strcmp(b, obs->qth)!=0) chk=3;
	}

	/* Se invece il QTH non c'e` fra i dati lo si calcola */
	else{
	  lonlat2qthloc(obs->lon, obs->lat, b);
	  strcpy(obs->qth, b);
	}


	/* Di controlli da fare ce ne sarebbero ancora, come ad esempio solo
	   lon o solo lat, ecc..., ma per ora bastano questi.
	*/

/* Se i dati sono buoni, si salvano con il metodo delle liste concatenate */

  obs->lat=obs->lat/180.*M_PI; obs->lon=obs->lon/180.*M_PI;

	if(chk==0){
	  if(h==NULL)
	    h=obs;
	  if(t!=NULL)
	    t->next=obs;
	  obs->prev=t;
	  t=obs;
	}
      
	/* Se invece i dati non sono buoni non c'e` bisogno di fare nulla,
	   a meno che non si vogliano fare delle segnalazioni, come ad 
	   esempio:
	*/
	else{
	  switch(chk){
	  case 1:
	    if(prerr==1) 
	      fprintf(stderr, "No lon, lat, neither QTHloc for [%s]!\n",
		      obs->name); break;
	  case 2:  
	    if(prerr==1) 
	      fprintf(stderr, "Error in QTHloc format for [%s]\n", obs->name);
	    break;
	  case 3:
	    if(prerr==1) {
	      qthloc2lonlat(obs->qth, &lon, &lat);
	      fprintf(stderr, "QTHloc do not match for [%s]: should be %s or \
lon %7.3f, lat %7.3f\n", obs->name, b, lon, lat);
	    }
	    break;

	  default: if(prerr==1) fprintf(stderr, "Unknown error!\n"); break;
	  }
	
	}
      }

      /* Ora si puo` riservare la memoria per una nuova struttura; con il
	 sistema delle liste concatenate non e` necessario liberare la
	 memoria con free(obs).
      */
      obs=(OBS *)malloc(sizeof(OBS));
      
      /* Si impongono dei valori non validi o nulli per verificare cosa sia
	 stato assegnato o meno prima di salvare la struttura
      */
      obs->lat=91.;
      obs->lon=181.;
      obs->h0=0.;      
      obs->qth[0]=0;
      obs->descr[0]=0;
      obs->name[0]=0;
      obs->horiz[0][0]=0.; obs->horiz[1][0]=0.;
      obs->horiz[0][1]=0.; obs->horiz[1][1]=360.;
      n=1;
      if(e!=0){
      while(lb[n]!=']') { obs->name[n-1]=lb[n]; n++; }
      obs->name[n-1]=0;
      }
}

    
    /* Se invece la riga non inizia ne' con un "#", ne' con una "[", allora 
       bisogna analizzare il tipo di dato
    */
    else{      

      /* Le stringhe andrebbero trasformate tutte maiuscole */
      if(strncmp(lb, "lon", strlen("lon"))==0){ 
  	if(sscanf(lb+strlen("lon")+1, "%f", &v)!=EOF)
	  obs->lon=v;	
	else 
	  obs->lon=181.;
      }
      if(strncmp(lb, "lat", strlen("lat"))==0){ 
  	if(sscanf(lb+strlen("lat")+1, "%f", &v)!=EOF)
	  obs->lat=v;	
	else
	  obs->lat=91.;
      }
      if(strncmp(lb, "height", strlen("height"))==0){ 
  	if(sscanf(lb+strlen("height")+1, "%f", &v)!=EOF)
	  obs->h0=v;
	else
	  obs->h0=0.;
      }
      if(strncmp(lb, "QTHloc", strlen("QTHloc"))==0){ 
  	if(sscanf(lb+strlen("QTHloc")+1, "%s", b)!=EOF)
	  strcpy(obs->qth, b);
	else
	  obs->qth[0]=0;
      }
      /* Questa gestione delle stringhe e` fatta malino, non ci sono controlli
	 sulla lunghezza, si assume che le linee siano terminate da un solo
	 carattere (0x0d), insomma e` da rifare per benino, anche se cosi` 
	 funziona
      */
      if(strncmp(lb, "Descr", strlen("Descr"))==0){ 
  	strncpy(obs->descr, lb+strlen("Descr")+1,
		strlen(lb+strlen("Descr")+1)-1);
	obs->descr[strlen(lb+strlen("Descr")+1)-1]=0;
      }
      if(strncmp(lb, "Horiz", strlen("Horiz"))==0){ 
	i=0;
	while(1){
	  if(fgets(lb, 80, fpobs)==NULL) { e=0; lb[0]='['; break;}
	  sscanf(lb, "%f %f", &horaz, &horel);
	  obs->horiz[0][i]=horaz; obs->horiz[1][i]=horel; i++;
	  if(i>70) break;
	  if(strncmp(lb, "Horiz_end", strlen("Horiz_end"))==0) break;
	}
	  obs->horiz[0][i]=360.; obs->horiz[1][i]=obs->horiz[1][0];
      }


/* Se il campo non e` riconosciuto viene semplicemente ignorato, forse
   si potrebbe fare di meglio...
*/

    }
  }


  fclose(fpobs);

  /* L'inizio della lista concatenata inizia da h */
  return h;
} 
