/*
 * TRK - Satellite tracking program based on Norad SGP/SDP model with
 *       curses interface
 *
 *	by Lapo Pieri IK5NAX  2000-2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Send bugs reports, comments, critique, etc, to ik5nax@amsat.org
 */

#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "trk.h"

#define TRKDIR     ".trk/\0"
#define TLEDAT     "trk.tle\0"
#define OBSDAT     "obs.dat\0"
#define GEGPT_CMD  "graphel.cmd\0"
#define SATDB      "sat.db\0"
#define GPT_CMD    "testgpt.cmd\0"
#define FIFOROT    "trkOUTrot\0"

int setup_config_file(int argc, char **argv, cfg_file *cfgf){

int mode;
char HomeDir[40], cfgdir[40], gf[80];
FILE *fp;

/* Si cerca prima un dir .trk nella dir corrente, e poi in $HOME */
 mode=F_OK; strcpy(cfgdir, "./"); strcat(cfgdir, TRKDIR);
 if(access(cfgdir, mode)==-1) {
   strcpy(HomeDir, getenv("HOME"));
   if(HomeDir==NULL) {
     printf("Unable to find HOME dir ?!\n"); return 1;
   }
   strcat(HomeDir, "/");
   strcpy(cfgdir, HomeDir); strcat(cfgdir, TRKDIR);
   if(access(cfgdir, mode)==-1) {
     printf("Unable to find a \".trk\" dir neither in current neither in HOME\
 dir!\n");
     return 1;
   }   
 }

 /* Se si e` arrivati a questo punto in cfgdir c'e` il nome della directory 
    contenente i file di configurazione; bisogna verificare che ci siano 
    almeno i file obs.dat e trk.tle o in mancanza di quest'ultimo che sia 
    stato fornito il nome di un file tle nella linea di comando
 */

 mode=R_OK; strcpy(gf, cfgdir); strcat(gf, OBSDAT);
 if(access(gf, mode)==-1){
   printf("Unable to read %s in %s\n", OBSDAT, cfgdir);
   return 1; }
 strcpy(cfgf->obsdatf, gf);

 mode=R_OK;
 if(((argc>=2)&&(access(argv[1], mode)==-1))||argc<2){
   mode=R_OK; strcpy(gf, cfgdir); strcat(gf, TLEDAT);
   if(access(gf, mode)==-1) {
     printf("Unable to read %s in %s\n", TLEDAT, cfgdir);
     return 1; }
   strcpy(cfgf->tlef, gf);
 }
 else { strcat(cfgf->tlef, argv[1]); }

 /* 
    I file seguenti se non presenti nella dir di configurazione verranno 
    creati la' automaticamente, sempreche' ci sia il permesso alla scrittura
 */

 /* Database satelliti */
 mode=R_OK; strcpy(gf, cfgdir); strcat(gf, SATDB);
 if(access(gf, mode)==-1){
   if((fp=fopen(gf, "w"))==NULL){
     printf("%s not found and unable to write to %s\n", SATDB, cfgdir);
     return 1;
   }
   fprintf(fp, "# sat.db\n#\n");
   fprintf(fp, "# Skeleton generated automatically by trk, update manually\n");
   fprintf(fp, "#\n# Use \"#\" as comment character\n");
   fprintf(fp, "# Each satellite is specified by its norad number between []\
\n");
   fprintf(fp, "# Follow some field beginning with a string and one or more\
 values\n");
   fprintf(fp, "# The only field used in present version is \"Beacon\",\
 followed by a float\n");
   fprintf(fp, "# Example:\n# [00001]\n# Beacon 20.005\n");
   fclose(fp); 
 }
 strcpy(cfgf->satdbf, gf); 


 /* Comandi gnuplot per il tracciamento del grafico dell'elevazione */
 mode=R_OK; strcpy(gf, cfgdir); strcat(gf, GEGPT_CMD);
 if(access(gf, mode)==-1){
   if((fp=fopen(gf, "w"))==NULL){
     printf("%s not fund and unable to write to %s\n", GEGPT_CMD, cfgdir);
     return 1;
   }
   fprintf(fp, "set xdata time\nset format x \"%%d/%%m %%H:%%M\"\n");
   fprintf(fp, "set timefmt \"%%d/%%m/%%Y %%H:%%M:%%S\"\n");
   fprintf(fp, "set zeroaxis\nset yrange [-90:90]\n");
   fprintf(fp, "plot 'el.dat' using 1:3 with lines\n");
   fprintf(fp, "#Uncomment the following line for some terminal (such X)\n");
   fprintf(fp, "#pause 1\n");

   fclose(fp);
 }
 strcpy(cfgf->gelf, gf);

 /* Comandi per il controllo della presenza dello gnuplot */
 mode=R_OK; strcpy(gf, cfgdir); strcat(gf, GPT_CMD);
 if(access(gf, mode)==-1){
   if((fp=fopen(gf, "w"))==NULL){
     printf("%s not fund and unable to write to %s\n", GPT_CMD, cfgdir);
     return 1;
   }
   fprintf(fp, "print \"GNUPLOT\"\n");

   fclose(fp);
 }
 strcpy(cfgf->gpttf, gf);


 mode=F_OK; strcpy(gf, cfgdir); strcat(gf, FIFOROT);
 if(access(gf, mode)==-1){
   if(mkfifo(gf, 0600)==-1){
     printf("%s not found and unable to create it in %s\n", FIFOROT, cfgdir);
     return 1;
   }
 }
 strcpy(cfgf->fiforot, gf);

printf("%s\n%s\n%s\n%s\n%s\n%s\n%s\n", 
       cfgdir, cfgf->obsdatf, cfgf->tlef, cfgf->satdbf, cfgf->gelf, 
       cfgf->gpttf, cfgf->fiforot);

return 0;
}
