/*
 * ba_stub.c - With this code, only kernel TCP/IP will be supported.
 */

#include <sys/types.h>
#include <ctype.h>
#include <netdb.h>
#include <netinet/in.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>

#if defined (__OS2__)
#include <types.h>
#include <utils.h>
#else
#include <sys/un.h>
#include <arpa/inet.h>
#endif

static union {
  struct sockaddr sa;
  struct sockaddr_in si;
#if !defined (__OS2__)
  struct sockaddr_un su;
#endif
} addr;

#if defined (_AIX)          /* This should be in netdb.h but thats AIX :-( */
#ifdef __STDC__
void endhostent(void);
void endservent(void);
#else
void endhostent();
void endservent();
#endif
#endif

struct sockaddr *build_sockaddr(name, addrlen)
char *name;
int *addrlen;
{
  char *host_name, *serv_name, buf[1024];

  memset((char *) &addr, 0, sizeof(addr));
  *addrlen = 0;

  host_name = strcpy(buf, name);
  serv_name = strchr(buf, ':');
  if (!serv_name) return 0;
  *serv_name++ = 0;
  if (!*host_name || !*serv_name) return 0;
  
  /* FEF */
  if (!strcmp(host_name, "unix")) {
    addr.su.sun_family = AF_UNIX;
    strcpy(addr.su.sun_path, serv_name);
    *addrlen = sizeof(struct sockaddr_un);
    return (struct sockaddr *) &addr;
  }

  addr.si.sin_family = AF_INET;
  if (!strcmp(host_name, "*")) {
    addr.si.sin_addr.s_addr = INADDR_ANY;
  } else if (!strcmp(host_name, "loopback")) {
    addr.si.sin_addr.s_addr = inet_addr("127.0.0.1");
  } else if ((addr.si.sin_addr.s_addr = inet_addr(host_name)) == -1L) {
    struct hostent *hp = gethostbyname(host_name);
    endhostent();
    if (!hp) return 0;
    addr.si.sin_addr.s_addr = ((struct in_addr *) (hp->h_addr))->s_addr;
  }
  if (isdigit(*serv_name & 0xff)) {
    addr.si.sin_port = htons(atoi(serv_name));
  } else {
    struct servent *sp = getservbyname(serv_name, (char *) 0);
    endservent();
    if (!sp) return 0;
    addr.si.sin_port = sp->s_port;
  }
  *addrlen = sizeof(struct sockaddr_in);
  return &addr.sa;
}

