/* Output from p2c, the Pascal-to-C translator */
/* From input file "status.p" */


/************************************************************/
/*                                                          */
/* DigiPoint SourceCode                                     */
/*                                                          */
/* Copyright (c) 1991-1996 Joachim Schurig, DL8HBS, Berlin  */
/*                                                          */
/* For license details see documentation                    */
/*                                                          */
/************************************************************/


#include "defs.h"

#define STATUS_G
#include "status.h"


#ifndef BOXGLOBL_H
#include "boxglobl.h"
#endif

#ifndef BOX_SYS_H
#include "box_sys.h"
#endif

#ifndef YAPP_H
#include "yapp.h"
#endif

#ifndef BOXLOCAL_H
#include "boxlocal.h"
#endif

#ifndef BOXBCAST_H
#include "boxbcast.h"
#endif

#ifndef BOX_MEM_H
#include "box_mem.h"
#endif

#ifndef BOX_FILE_H
#include "box_file.h"
#endif

#ifndef TOOLS_H
#include "tools.h"
#endif

#ifdef dpmacos
#include <utsname.h>
#endif


#define statbufsize     32767


void free_statp(uchar **p)
{
  if (*p != NULL)
    mymfree(p);
}


Static Char tl[256];
Static uchar *pp;
Static long szz;
Static short lcc;


Static void al(Char *line)
{
  Char STR1[256];

  if (szz < statbufsize - strlen(tl) - strlen(line) - 2) {
    sprintf(STR1, "%s%s", tl, line);
    put_line(pp, &szz, STR1);
    lcc++;
  }
  *tl = '\0';
}


Static void ap(short i, Char *line)
{
  al(line);
}


Static void a(Char *line)
{
  if (strlen(tl) + strlen(line) < 256)
    strcat(tl, line);
}


Static void ai(long l)
{
  Char w[256];

  sprintf(w, "%ld", l);
  a(w);
}


Static void ait(long l, short t)
{
  Char w[256];

  sprintf(w, "%ld", l);
  lspacing(w, t);
  a(w);
}


Static void swlnuser(short unr, Char *s)
{
  al(s);
}


Static long lastsysrunt, lastsysrunres;


long get_sysruntime(void)
{
  short k;
  Char hs[256], w[256];
  short x, y;

  if (clock_.ixtime - lastsysrunt < 15)
    return lastsysrunres;

  lastsysrunres = get_boxruntime_l();

#ifndef dpmacos
  k = sfopen("/proc/uptime", FO_READ);
  if (k < minhandle)
    return lastsysrunres;
  file_to_string(k, hs);
  sfclose(&k);
  get_word(hs, w);
  x = strlen(w);
  y = strpos2(w, ".", 1);
  if (y > 0)
    strdelete((void *)w, y, x - y + 1);
  lastsysrunres = str2lint(w);
#endif

  lastsysrunt = clock_.ixtime;
  return lastsysrunres;
}


Static long lastsysltime;
Static Char lastsysload[21];


void get_sysload(Char *s)
{
  short k;
  Char hs[256], w[256];
  short x, y;
  boolean newproc;

  if (clock_.ixtime - lastsysltime < 25) {
    strcpy(s, lastsysload);
    return;
  }

#ifndef dpmacos
  k = sfopen("/proc/loadavg", FO_READ);
  if (k >= minhandle) {
    *s = '\0';
    file_to_string(k, hs);
    sfclose(&k);

/*    newproc = (count_words(hs) > 3); */
    newproc = false; /* mal schauen, ob linux 2.0 wieder wie 1.2 anzeigt */

    for (x = 1; x <= 3; x++) {
      get_word(hs, w);

      if (newproc) {
	y = strpos2(w, ".", 1);
	if (y > 0)
	  cut(w, y - 1);
	cut(w, 3);
	while (w[0] == '0')
	  strdelete((void *)w, 1, 1);
      } else {
	y = strpos2(w, ".", 1);
	if (y > 0)
	  strdelete((void *)w, y, 1);
	cut(w, 3);
	while (w[0] == '0')
	  strdelete((void *)w, 1, 1);
      }
      if (*w == '\0')
	strcpy(w, "0");

      sprintf(s + strlen(s), "%s%% ", w);
    }

    del_lastblanks(s);

  } else
#endif
    strcpy(s, "100% 100% 100%");

  lastsysltime = clock_.ixtime;
  strcpy(lastsysload, s);
}

Static long lastcputime;
Static Char lastcputype[80];
Static Char lastbogomips[80];

void get_cpuinf(Char *cpu, Char *mips)
{
  short k, x;
  Char hs[256];

  if (clock_.ixtime - lastcputime < 100000) {
    strcpy(cpu, lastcputype);
    strcpy(mips, lastbogomips);
    return;
  }
  
  k = nohandle;

#ifndef dpmacos
  k = sfopen("/proc/cpuinfo", FO_READ);
  if (k >= minhandle) {
    *hs = '\0';
    while (file_to_string(k, hs) && uspos("cpu", hs) < 1);
    if (uspos("cpu", hs) < 1) goto _L1;
    x = strpos2(hs, ":", 1);
    if (x < 4) goto _L1;
    strdelete(hs, 1, x);
    if (strlen(hs) < 80)
      get_word(hs, lastcputype);

    *hs = '\0';
    while (file_to_string(k, hs) && uspos("BogoMips", hs) < 1);
    if (uspos("BogoMips", hs) < 1) goto _L1;
    x = strpos2(hs, ":", 1);
    if (x < 4) goto _L1;
    strdelete(hs, 1, x);
    if (strlen(hs) < 80)
      get_word(hs, lastbogomips);
  } 
#endif

_L1:
  sfclose(&k);
  lastcputime = clock_.ixtime;
  strcpy(cpu, lastcputype);
  strcpy(mips, lastbogomips);
}


void get_lastsysload(Char *s)
{
  Char hs[256];

  get_sysload(hs);
  get_word(hs, s);
}


void get_sysversion(Char *s)
{
#ifdef dpmacos
  struct utsname name;

  strcpy(s, "?");
  if (!uname(&name))
    sprintf(s, "%s v%s.%s", name.sysname, name.release, name.version);

#else
  short k, x, y;
  boolean nok;

  strcpy(s, "?");
  k = sfopen("/proc/version", FO_READ);
  if (k < minhandle)
    return;
  *s = '\0';
  file_to_string(k, s);
  sfclose(&k);
  do {
    x = strpos2(s, "(", 1);
    y = strpos2(s, ")", 1);
    nok = false;
    if (x > 0 && y > 0 && y > x)
      strdelete((void *)s, x, y - x + 1);
    else
      nok = true;
  } while (!nok);
#endif
  del_mulblanks(s);
  del_lastblanks(s);
}


void get_status(boolean sysop, uchar **p, long *sz)
{
  Char hs[256], w[256];
  long ct;
  boolean owner;
  Char STR7[18];
  void (*TEMP)(short i, Char *line);
  void (*TEMP1)(short unr, Char *s);
  void (*TEMP2)(short unr, Char *s);

  if (*p == NULL) {
    *p = Malloc(statbufsize);
    owner = true;
  } else
    owner = false;

  if (*p == NULL)
    return;
  *sz = 0;

  pp = *p;
  szz = *sz;
  *tl = '\0';
  lcc = 0;

  a("dpbox v");
  a(dp_vnr);
  a(dp_vnr_sub);
  a(", ");
  a(dp_date);
  al(" (c) DL8HBS, Joachim Schurig, Berlin               ");
 #ifdef dpmacos
  al("parts of code (c) DL4YBG, Mark Wahl, Berlin");
 #endif
 #ifdef dplinux
  al("Linux porting (c) DL4YBG, Mark Wahl, Berlin");
 #endif
  al("  ");

  a("installed by     : ");
  al(Console_call);
  al("  ");
  a("date             : ");
  sprintf(STR7, "%s %s", clock_.datum, clock_.zeit);
  al(STR7);
  a("ixtime           : ");
  ai(clock_.ixtime);
  al(" sec. since 1.1.1970");
  a("dpbox runtime    : ");
  get_boxruntime_s(hs);
  al(hs);
  a("system runtime   : ");
  calc_ixsecs_to_string(get_sysruntime(), hs);
  al(hs);
  a("system load      : ");
  get_sysload(hs);
  al(hs);
  a("system version   : ");
  get_sysversion(hs);
  al(hs);
  al("  ");
  
  get_cpuinf(w, hs);
  a("cpu type         : ");
  al(w);
  a("bogomips         : ");
  al(hs);

  a("cpu speed index1 : ");   /*t*/
  /*,4*/
  ai(get_cpu_speed(1));
  al("% (68000/8Mhz = 100%)");
  a("cpu speed index2 : ");   /*t*/
  /*,4*/
  ai(get_cpu_speed(2));
  al("% (68000/8Mhz = 100%)");

  al("  ");


  if (sysop) {
    al("open files:");
    TEMP = ap;
    sfdispfilelist(0, TEMP);
    al("  ");
  }


  if (sysop) {
    al("bbs connection streams:");
    TEMP1 = swlnuser;
    calc_boxactivity(0, TEMP1);
    al("  ");

  }


  if (send_bbsbcast) {
    al("broadcast transmission streams:");
    TEMP2 = swlnuser;
    show_bcastactivity(0, TEMP2);
  } else
    al("no bbs broadcast active");
  al("  ");


  al("memory information:");
  a("MemAvail         : ");
  ai(memavail__());
  al(" Bytes");
  al("  ");

  al("Bulletin-ID management:");
  a("buffer in ram    : ");
  if (membidpuffer != NULL) {
    a("yes, size ");
    ai(membidsize);
    al(" Bytes");
  } else
    al("no");
  ct = bidhash_active();
  a("hashing          : ");
  if (ct == 0)
    al("inactive");
  else {
    a("active, size ");
    ai(ct);
    al(" Bytes");
  }

  a("maxbullids       : ");
  ai(maxbullids);
  al("  ");
  a("bullidseek       : ");
  ai(bullidseek);
  al("  ");
  a("bids             : ");
  ai(sfsize(msgidlog) / 13);
  al("  ");

  al("  ");
  a("actmsgnum        : ");
  ai(actmsgnum + msgnumoffset);
  al("  ");

  ct = hboxhash_active();
  a("hboxhash         : ");
  if (ct == 0)
    al("inactive");
  else {
    a("active, size ");
    ai(ct);
    al(" Bytes");
  }

  a("ttask            : ");
  ai(ttask * 5);
  al(" ms");
  a("ufilhide         : ");
  if (ufilhide)
    al("on");
  else
    al("off");
  a("smart_routing    : ");
  if (smart_routing)
    al("on");
  else
    al("off");
  a("small_msgs_first : ");
  if (small_first)
    al("on");
  else
    al("off");
  a("7plus            : ");
  if (*spluspath != '\0')
    al("available");
  else
    al("not found");
  a("debug level      : ");
  ai(debug_level);
  al("  ");
  a("erasedelay       : ");
  ai(erasewait / 86400L);
  al("  ");
  a("packdelay        : ");
  ai(packdelay);
  al("  ");
  a("userinfocachehit : ");
  if (ufchit + ufcmiss > 0)
    ai(ufchit * 100 / (ufchit + ufcmiss));
  else
    ai(0);
  al("% ");
  a("usersftellmode   : ");
  ai(usersftellmode);
  al("  ");
  a("connect hiscore  : ");
  ai(hiscore_connects);
  al("  ");

  *sz = szz;

}


void _status_init(void)
{
  static int _was_initialized = 0;
  if (_was_initialized++)
    return;
  lastsysrunt = 0;
  lastsysrunres = 0;
  lastsysltime = 0;
  lastcputime = 0;
  *lastsysload = '\0';
  strcpy(lastcputype, "unknown");
  strcpy(lastbogomips, lastcputype );
}
