/* Output from p2c, the Pascal-to-C translator */
/* From input file "sort.p" */

#include "defs.h"

#define SORT_G
#include "sort.h"


#define sortstrsize     120


typedef Char sortstr[sortstrsize + 1];

typedef struct strmem {
  struct strmem *left, *right;
  sortstr zeile;
} strmem;


  /*----------------------------------*/
Static void fuege_ein(strmem **s, strmem *entry_)
{
  /*Fuegt den String in den Baum ein  */
  /*----------------------------------*/
  if (*s == NULL) {
    *s = entry_;
    return;
  }
  if (strcmp(entry_->zeile, (*s)->zeile) > 0)
    fuege_ein(&(*s)->left, entry_);
  else
    fuege_ein(&(*s)->right, entry_);
}


  /*-------------------------------------*/
Static void ordne_ein(Char *instr, strmem **lroot, boolean *no_mem)
{
  /*Findet die richtige Stelle wo instr  */
  /*im Baum einzusortieren ist.          */
  /*-------------------------------------*/
  strmem *entry_;

  entry_ = Malloc(sizeof(strmem));
  if (entry_ == NULL) {
    *no_mem = true;
    return;
  }
  entry_->left = NULL;
  entry_->right = NULL;
  strcpy(entry_->zeile, instr);
  fuege_ein(lroot, entry_);
}


Static void lese_file_ein(Char *name, strmem **lroot, boolean *no_mem)
{
  Char instr[256];
  short workfile;

  workfile = sfopen(name, FO_READ);
  while (file_to_string(workfile, instr) && !*no_mem) {
    if (*instr != '\0') {
      cut(instr, sortstrsize);
      ordne_ein(instr, lroot, no_mem);
    }
  }
  sfclose(&workfile);
}


  /*-----------------------------------*/
Static void schreibe_file2(short *workfile, strmem *s)
{
  /*Rekursiver Schreibalgr.            */
  /*-----------------------------------*/
  if (s->right != NULL)
    schreibe_file2(workfile, s->right);
  string_to_file(workfile, s->zeile, true);
  if (s->left != NULL)
    schreibe_file2(workfile, s->left);
  Free(s);
}


Static void schreibe_file(Char *name, strmem **lroot)
{
  short workfile;

  workfile = sfcreate(name, FC_FILE);
  if (*lroot != NULL)
    schreibe_file2(&workfile, *lroot);
  sfclose(&workfile);
}


Static void lese_mem_ein(uchar *start, long size, strmem **lroot,
			 boolean *no_mem)
{
  long lz;
  Char instr[256];

  lz = 0;
  while (lz < size && !*no_mem) {
    get_line(start, &lz, size, instr);
    if (*instr != '\0') {
      cut(instr, sortstrsize);
      ordne_ein(instr, lroot, no_mem);
    }
  }
}


  /*----------------------------------*/
Static void schreibe_mem2(uchar *start, long *lz, strmem *s)
{
  /*Rekursiver Schreibalgr.           */
  /*----------------------------------*/
  if (s->right != NULL)
    schreibe_mem2(start, lz, s->right);
  put_line(start, lz, s->zeile);
  if (s->left != NULL)
    schreibe_mem2(start, lz, s->left);
  Free(s);
}


Static void schreibe_mem(uchar *start, long *size, strmem **lroot)
{
  long lz;

  lz = 0;
  if (*lroot != NULL)
    schreibe_mem2(start, &lz, *lroot);
  *size = lz;
}


Static void sort_it(Char *name, uchar *start, long *size)
{
  strmem *lroot;
  boolean no_mem;

  no_mem = false;
  lroot = NULL;

  if (*name != '\0') {
    lese_file_ein(name, &lroot, &no_mem);
    if (!no_mem)
      schreibe_file(name, &lroot);
    return;
  }

  if (start == NULL || *size <= 0)
    return;
  lese_mem_ein(start, *size, &lroot, &no_mem);
  if (!no_mem)
    schreibe_mem(start, size, &lroot);
}


void sort_file(Char *name)
{
  long h;

  sort_it(name, NULL, &h);
}


void sort_mem(uchar *start, long *size)
{
  sort_it("", start, size);
}


void _sort_init(void)
{
  static int _was_initialized = 0;
  if (_was_initialized++)
    return;
}
