/* Header for module pastrix, generated by p2c */

#ifndef PASTRIX_H
#define PASTRIX_H


/* following headers are taken from: (note: it is only a small subset
 * of the original file) */

/* Header file for code generated by "p2c", the Pascal-to-C translator */

/* "p2c"  Copyright (C) 1989, 1990, 1991 Free Software Foundation.
 * By Dave Gillespie, daveg@csvax.cs.caltech.edu.  Version 1.20.
 * This file may be copied, modified, etc. in any way.  It is not restricted
 * by the licence agreement accompanying p2c itself.
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>


/* The following definitions work only on twos-complement machines */
#ifndef SHORT_MAX
# define SHORT_MAX  ((short)(((unsigned short) -1) >> 1))
# define SHORT_MIN  (~SHORT_MAX)
#endif

#ifndef INT_MAX
# define INT_MAX    ((int)(((unsigned int) -1) >> 1))
# define INT_MIN    (~INT_MAX)
#endif

#ifndef LONG_MAX
# define LONG_MAX   ((long)(((unsigned long) -1) >> 1))
# define LONG_MIN   (~LONG_MAX)
#endif

#ifndef SEEK_SET
# define SEEK_SET   0
# define SEEK_CUR   1
# define SEEK_END   2
#endif

#define Register    register  /* Register variables */
#define Char        char      /* Characters (not bytes) */

#define Malloc(n)   malloc(n)
#define Free(n)     free(n)

#ifndef Static
# define Static     static    /* Private global funcs and vars */
#endif

#ifndef Local
# define Local      static    /* Nested functions */
#endif

typedef unsigned char uchar;
typedef unsigned char boolean;

#ifndef true
# define true    1
# define false   0
#endif

#ifndef TRUE
# define TRUE    1
# define FALSE   0
#endif

/* end of needed p2c.h definitions */




#include "filesys.h" /* includes localised file system access for dpbox */

#ifdef PASTRIX_G
# define vextern
#else
# define vextern extern
#endif

#define tab             '\t'

#ifdef dpmacos
#include <time.h>
#else
#include <sys/time.h>
#endif
typedef long bst;
typedef time_t time_t_;
typedef long pid_tt;

#ifdef dplinux
#include <signal.h>
#define DP_SIGHUP SIGHUP
#define DP_SIGTSTP SIGTSTP
#define DP_SIGTTIN SIGTTIN
#define DP_SIGTTOU SIGTTOU
#define DP_SIGPIPE SIGPIPE
#define DP_SIGKILL SIGKILL
#define DP_SIGTERM SIGTERM
#include <sys/wait.h>
#define DP_WNOHANG WNOHANG
#endif

#ifdef dpmacos
typedef int pid_t;
#include <signal.h>
#define DP_SIGHUP SIGABRT
#define DP_SIGTSTP 1
#define DP_SIGTTIN 2
#define DP_SIGTTOU 3
#define DP_SIGPIPE 4
#define DP_SIGKILL 5
#define DP_SIGTERM SIGTERM
#define DP_WNOHANG 6
#endif

typedef Char Cstring[256];
typedef unsigned short intsemtype;

extern short dp_randomize(short low, short hiw);
extern long searchbyte(uchar what, uchar *start, long size);
extern long maxavail__(void);
extern uchar *mymalloc(long v);
extern void mymfree(uchar **p);
extern void mymfreep(uchar **p);
extern void dpgetmem(uchar **p, long size);
extern void dpfreemem(uchar **p, long size);
extern void RESETA(void);
extern void RESTART(void);
extern void WATCHDOG(short mode, short timer);
extern void VBLTIMER(short mode);
extern long GETVBLTIMER(void);
extern void NOCRITIC(boolean on);
extern Char RAM_INIT(unsigned short size);
extern void RAM_EXIT(void);
extern void klang(short nr);
extern void Gettimestr(Char *ts);
extern void GetDatestr(Char *ds);
extern unsigned short Make_DTime(short Hour, short Min, short Sec);
extern unsigned short Make_DDate(short Day, short Mon, short Yr);
extern void Get_DDate(unsigned short ddate, short *Day, short *Mon, short *Yr);
extern void Get_DTime(unsigned short dtime, short *Hour, short *Min,
		      short *Sec);
extern long statclock(void);
extern void mtpause(void);

#ifdef dpmacos
extern int fork();
extern int kill(pid_tt pid, int signal);
extern void setsid();
extern int waitpid(pid_tt pid, int *res, int flag);
#endif

extern char *strsub(register char *ret, register char *s, register int pos, register int len);
extern int strpos2(char *s, register char *pat, register int pos);
extern void strdelete(register char *s, register int pos, register int len);
extern void strinsert(register char *src, register char *dst, register int pos);

extern void del_leadblanks(Char *s);
/* Loescht fuehrende Leerzeichen in "s" */
extern void del_lastblanks(Char *s);
/* Loescht letzte Leerzeichen */
extern void lspacing(Char *txt, short l);
extern void rspacing(Char *txt, short l);
extern Char upcase_(Char ch);
extern Char lowcase(Char ch);
extern void upper(Char *s);
extern void lower(Char *s);
extern boolean zahl(Char *s); /* nur dez               */
extern boolean azahl(Char *s); /* auch bin und hex      */
extern boolean rzahl(Char *s); /* nur dez/real          */
extern long hstr2int(Char *s);
/* "Hex-String to Integer", String wird unbedingt als Hex-Zahl interpretiert */
extern long bstr2int(Char *s);
/* "Bin-String to Integer", String wird unbedingt als Bin-Zahl interpretiert */
extern void int2hstr(long i, Char *s);
/* "Integer to Hex-String", Zahl als Hex-Zahl dargestellt, mit "$" am Anfang */
extern void int2hchar(short i, Char *c1, Char *c2); /* Bereich von 0..255    */
extern void hstr2str(Char *h, Char *s);
extern void str2hstr(Char *s, Char *h);
extern void str2mem(Char *s1, uchar *at, boolean lbyte);
extern void mem2str(uchar *at, Char *s1);
extern void mem2str2(Char *s1, uchar *at, short size);
extern void del_mulblanks(Char *s); /*Laesst in einer Folge von Leerzeichen nur je eines stehen*/
extern short count_words(Char *s);
extern void get_word(Char *inp, Char *outp);
/*Holt naechstes Wort aus "inp" und lscht dieses dort, Leerzeichen werden berlesen*/
extern void del_comment(Char *z, Char c);
/*Loescht String nach erstem Auftreten von "C"*/
/* get_line und put_line operieren in einem Pufferspeicher, die Zeilen sollten zum Lesen mit CR+LF abgeschlossen sein */
extern void get_line(uchar *buf, long *posi, long ende, Char *zeile);
extern void next_line(uchar *buf, long *posi, long ende);
extern void prev_line(uchar *buf, long *posi);
extern void put_line(uchar *buf, long *posi, Char *zeile);
extern void umlaut1(Char *txt);
extern void umlaut2(Char *txt);
extern void ersetze(Char *oldstr, Char *newstr, Char *txt);
extern void gkdeutsch(Char *name);
extern void sfbread(boolean aslongaspossible, Char *name, uchar **puffer,
		    long *size);
extern short week_day(short d, short m, short y);

#undef vextern

#define cut(string, size) string[size] = '\0'
#define spacing(size, string) rspacing(string, size)
#define maxram() 0x7fffffffL
#ifdef dpmacos
extern long memavail__(void);
#else
#define memavail__() maxavail__()
#endif
#define move_b(quelle, ziel, size) memmove(ziel, quelle, size)
#define Str2int(s) atol(s)
#define str2lint(s) atol(s)

#endif
