/* Output from p2c, the Pascal-to-C translator */
/* From input file "boxbcast.p" */


/************************************************************/
/*                                                          */
/* DigiPoint SourceCode                                     */
/*                                                          */
/* Copyright (c) 1991-1996 Joachim Schurig, DL8HBS, Berlin  */
/*                                                          */
/* For license details see documentation                    */
/*                                                          */
/************************************************************/

#include "defs.h"

#define BOXBCAST_G
#include "boxbcast.h"


#ifndef MISC_OS_H
#include "misc_os.h"
#endif

#ifndef TOOLS_H
#include "tools.h"
#endif

#ifndef BOXGLOBL_H
#include "boxglobl.h"
#endif

#ifndef YAPP_H
#include "yapp.h"
#endif

#ifndef BOXLOCAL_H
#include "boxlocal.h"
#endif

#ifndef BOX_H
#include "box.h"
#endif

#ifndef BOX_FILE_H
#include "box_file.h"
#endif


#define maxages         20


typedef long agearrtype[maxages];
typedef long logcttype[maxages];
typedef long fileidarrtype[maxages];
typedef Char statinfarrtype[maxages][81];

typedef struct bcastdesctype {
  struct bcastdesctype *next;

  uchar tnc, port;
  boolean UsePidF0;
  long hfbaud;
  unsigned short msgsel;
  uchar level;
  unsigned short filetype;

  unsigned short timeslices;
  agearrtype maxage, starttime;
  logcttype firstlognr, lastlognr;
  fileidarrtype lastfileid;
  statinfarrtype statinf;

  Char qrg[20];
  Char TxPath[121];

} bcastdesctype;


Static long lastbcastok;
Static bcastdesctype *bcastdesc;
Static boolean boxbcastsemaphore;
Static long bcasttfsize, bcasttfct;


Static void increase_filecount(void)
{
  short f;
  Char fn[256];
  Char w[256];

  sprintf(fn, "%sbcstat%cbox", boxstatdir, extsep);
  if (exist(fn)) {
    f = sfopen(fn, FO_READ);
    if (f < minhandle)
      return;
    *w = '\0';
    file_to_string(f, w);
    bcasttfsize += str2lint(w);
    *w = '\0';
    file_to_string(f, w);
    bcasttfct += str2lint(w);
    sfclose(&f);
  }
  f = sfcreate(fn, FC_FILE);
  if (f < minhandle)
    return;
  sprintf(w, "%ld", bcasttfsize);
  string_to_file(&f, w, true);
  sprintf(w, "%ld", bcasttfct);
  string_to_file(&f, w, true);
  sfclose(&f);
  bcasttfsize = 0;
  bcasttfct = 0;
}


void free_boxbcastdesc(void)
{
  bcastdesctype *hp, *hp2;

  hp = bcastdesc;

  while (hp != NULL) {
    hp2 = hp;
    hp = hp->next;
    Free(hp2);
  }

  bcastdesc = NULL;
  boxbcastsemaphore = true;
  increase_filecount();
}


Static void add_bcastdesc(Char *TxPath_, boolean UsePidF0, short tnc,
  short port, Char *qrg, long hfbaud, unsigned short msgsel, uchar level,
  unsigned short filetype, unsigned short timeslices, long *ages)
{
  Char TxPath[256];
  bcastdesctype *hp, *hp2;
  unsigned short x;

  strcpy(TxPath, TxPath_);
  hp = Malloc(sizeof(bcastdesctype));
  if (hp == NULL)
    return;

  if (timeslices > maxages)
    timeslices = maxages;
  else if (timeslices == 0)
    timeslices = 1;
  hp->timeslices = timeslices;
  memcpy(hp->maxage, ages, sizeof(agearrtype));
  for (x = timeslices; x < maxages; x++)
    hp->maxage[x] = 0;
  for (x = 0; x < maxages; x++)
    hp->starttime[x] = 0;
  for (x = 0; x < maxages; x++)
    hp->firstlognr[x] = 0;
  for (x = 0; x < maxages; x++)
    hp->lastlognr[x] = 0;
  for (x = 0; x < maxages; x++)
    hp->lastfileid[x] = 0;
  for (x = 0; x < maxages; x++)
    *hp->statinf[x] = '\0';
  hp->tnc = tnc;
  hp->port = port;
  hp->next = NULL;
  strcpy(hp->qrg, qrg);
  cut(TxPath, 120);
  strcpy(hp->TxPath, TxPath);
  hp->UsePidF0 = UsePidF0;
  hp->hfbaud = hfbaud;
  hp->msgsel = msgsel;
  hp->level = level;
  hp->filetype = filetype;

  if (bcastdesc == NULL) {
    bcastdesc = hp;
    return;
  }

  hp2 = bcastdesc;
  while (hp2->next != NULL)
    hp2 = hp2->next;
  hp2->next = hp;
}


void load_boxbcastparms(Char *name)
{
  uchar *puffer;
  long psize;
  Char hs[256], w[256], w1[256];
  long rp;
  boolean startdef;

  Char TxPath[256];
  Char qrg[20];
  boolean UsePidF0;
  short tnc, port;
  unsigned short timeslices;
  long hfbaud;
  unsigned short msgsel, filetype;
  uchar level;
  agearrtype ages;

  debug(2, 0, 116, name);
  free_boxbcastdesc();

  lastbcastok = clock_.ixtime;
  sfbread(true, name, &puffer, &psize);
  if (psize > 0) {
    UsePidF0 = true;
    *TxPath = '\0';
    *qrg = '\0';
    tnc = 0;
    port = 0;
    timeslices = 0;
    level = 1;
    filetype = 0;
    ages[0] = 1800;
    hfbaud = 9600;
    msgsel = MSG_BROADCAST;
    startdef = false;

    rp = 0;
    while (rp < psize) {
      get_line(puffer, &rp, psize, hs);
      del_comment(hs, '#');
      del_blanks(hs);

      if (*hs != '\0' && hs[0] == '{') {
	if (!startdef) {
	  startdef = true;
	  UsePidF0 = true;
	  *TxPath = '\0';
	  *qrg = '\0';
	  tnc = 0;
	  port = 0;
	  timeslices = 0;
	  level = 1;
	  filetype = 0;
	  ages[0] = 1800;
	  hfbaud = 9600;
	  msgsel = MSG_BROADCAST;
	}
	strdelete((void *)hs, 1, 1);
      }

      if (*hs != '\0' && hs[0] == '}') {
	if (startdef)
	  add_bcastdesc(TxPath, UsePidF0, tnc, port, qrg, hfbaud, msgsel,
			level, filetype, timeslices, ages);
	startdef = false;
	strdelete((void *)hs, 1, 1);
      }

      get_word(hs, w);
      upper(w);
      get_word(hs, w1);

      if (!strcmp(w, "TXPATH")) {
	sprintf(TxPath, "%s %s", w1, hs);
	del_blanks(TxPath);
	upper(TxPath);
	continue;
      }

      if (!strcmp(w, "QRG")) {
	cut(w1, 19);
	upper(w1);
	strcpy(qrg, w1);
	del_blanks(qrg);
	continue;
      }
      if (!strcmp(w, "PIDF0")) {
	UsePidF0 = (strcmp(w1, "0") != 0);
	continue;
      }
      if (!strcmp(w, "TNC")) {
	tnc = Str2int(w1);
	continue;
      }
      if (!strcmp(w, "PORT")) {
	port = Str2int(w1);
	continue;
      }
      if (!strcmp(w, "HFBAUD")) {
	hfbaud = str2lint(w1);
	continue;
      }
      if (!strcmp(w, "MSGSEL")) {
	msgsel = (unsigned short)str2lint(w1);
	continue;
      }
      if (!strcmp(w, "LEVEL")) {
	level = Str2int(w1);
	continue;
      }
      if (!strcmp(w, "FILETYPE"))
	filetype = Str2int(w1);
      else if (!strcmp(w, "SLICE")) {
	if (timeslices < maxages) {
	  timeslices++;
	  ages[timeslices - 1] = str2lint(w1);
	}
      }
    }

    mymfreep(&puffer);

  }


  boxbcastsemaphore = false;
}


Static boolean true_sel(unsigned short flags, unsigned short sel)
{
  if (sel != 0)
    return ((flags & sel) != 0);
  else
    return true;
}


Static boolean get_nextvalidlog(unsigned short msgsel, uchar level, long *nr,
				boxlogstruct *log)
{
  boolean Result;
  long logct;
  short handle;

  debug0(4, 0, 117);
  Result = false;
  log->deleted = true;
  logct = sfsize(boxlog) / sizeof(boxlogstruct);

  if (*nr > 1 && *nr <= logct) {
    handle = sfopen(boxlog, FO_READ);
    if (handle >= minhandle) {
      while ((log->deleted || !true_sel(log->msgflags, msgsel) ||
	      strlen(log->brett) < '\002' || log->msgtype != 'B' ||
	      log->level > level) && *nr > 1) {
	(*nr)--;
	read_log(handle, *nr, log);
      }

      sfclose(&handle);
    }
  }

  if (*nr > 1)
    return true;
  return Result;
}


Static long find_firstvalidlog(long *firstlognr, unsigned short msgsel,
			       uchar level, boxlogstruct *log)
{
  long Result;
  short handle;
  long nr;

  debug0(4, 0, 118);
  Result = 0;
  log->deleted = true;

  nr = sfsize(boxlog) / sizeof(boxlogstruct);
  if (nr > 0) {
    if (*firstlognr <= 0)
      *firstlognr = nr;
    else if (*firstlognr > nr)
      *firstlognr = nr;
    else
      nr = *firstlognr;

    handle = sfopen(boxlog, FO_READ);
    if (handle >= minhandle) {
      while ((log->deleted || !true_sel(log->msgflags, msgsel) ||
	      strlen(log->brett) < '\002' || log->msgtype != 'B' ||
	      log->level > level) && nr > 1) {
	read_log(handle, nr, log);
	nr--;
      }

      sfclose(&handle);
    }

  }


  if (nr > 1)
    return (nr + 1);
  return Result;
}


Static void send_lognr(unsigned short ct, bcastdesctype *hp, short nr,
		       boxlogstruct log, boolean rekursion)
{
  Char bname[256];
  indexstruct header;
  long fid, h;
  Char w1[256];
  long exptime;
  Char fheader[256];
  unsigned short bodychecksum;
  Char hs[256];
  Char STR1[256];
  Char STR13[52];

  debug0(2, 0, 119);
  if (hp->lastlognr[nr - 1] <= 0)
    return;
  dp_watchdog(2, 4711);
  sprintf(hs, "%ld", nr + ct * 50);
  sprintf(bname, "%sBCASTBOX%c%s", tempdir, extsep, hs);
  bodychecksum = read_for_bcast(log.brett, log.idxnr, bname, &header);
  if (bodychecksum == 0xffffL) {
    sfdelfile(bname);
    return;
  }
  if (header.deleted) {
    sfdelfile(bname);
    return;
  }
  fid = (header.rxdate - header.size) & 0xfffffffL;
  h = ct;
  h &= 15;
  fid += h << 28;
  hp->lastfileid[nr - 1] = fid;
  if (header.txlifetime > 0)
    exptime = header.rxdate + header.txlifetime * 86400L;
  else
    exptime = 0;

  fheader[0] = '\0';

  sprintf(hs, "%ld", nr);
  sprintf(hs, "slice:%s board:%s", strcpy(STR1, hs), log.brett);
  sprintf(w1, "%ld", log.idxnr);
  sprintf(hs + strlen(hs), " %s", w1);
  sprintf(w1, "%ld", header.size);
  sprintf(hs + strlen(hs), " size:%s", w1);
  sprintf(hs + strlen(hs), " %s", header.betreff);
  cut(hs, 80);
  strcpy(hp->statinf[nr - 1], hs);
  if (debug_level > 1)
    boxprotokoll(hs);

  boxbcastsemaphore = true;

  bcasttfsize += header.size;
  bcasttfct++;
  if (bcasttfct >= 25)
    increase_filecount();

  sprintf(STR13, "%s @ %s", header.dest, header.verbreitung);
  bcast_file(hp->tnc, hp->port, hp->qrg, fid, hp->filetype, bname, hp->TxPath,
	     header.absender, STR13, header.rxfrom, header.rxdate, exptime, 0,
	     header.id, header.msgtype, header.betreff, fheader, bodychecksum,
	     true);


}


Static void bcastlist(bcastdesctype *hp, unsigned short x, unsigned short ct,
		      boolean rekursion)
{
  boxlogstruct log;

  if (hp->starttime[x - 1] + hp->maxage[x - 1] > clock_.ixtime) {
    if (get_nextvalidlog(hp->msgsel, hp->level, &hp->lastlognr[x - 1], &log))
      send_lognr(ct, hp, x, log, rekursion);
    else {
      /* ansonsten eine Runde aussetzen */
      hp->starttime[x - 1] = 0;
    }
    return;
  }


  if (rekursion)
    return;
  if (hp->firstlognr[x - 1] <= 0 && x != 1)
    return;
  hp->starttime[x - 1] = clock_.ixtime;
  if (hp->lastlognr[x - 1] > 0)
    hp->firstlognr[x] = hp->lastlognr[x - 1] - 1;
  else
    hp->firstlognr[x] = 0;
  if (x == 1)   /* sonst werden neue Eintraege nie gesendet */
    hp->firstlognr[x - 1] = 0;
  hp->lastlognr[x - 1] = find_firstvalidlog(&hp->firstlognr[x - 1],
					    hp->msgsel, hp->level, &log);
  send_lognr(ct, hp, x, log, rekursion);
}


void callback(long l)
{
  /* der TX teilt uns mit, dass das File mit   */
  bcastdesctype *hp;   /* FID l komplett gesendet worden ist        */
  unsigned short x, ct, FORLIM;

  lastbcastok = clock_.ixtime;
  ct = 0;
  hp = bcastdesc;
  while (hp != NULL) {
    ct++;
    FORLIM = hp->timeslices;
    for (x = 1; x <= FORLIM; x++) {
      if (hp->lastfileid[x - 1] == l) {
	hp->lastfileid[x - 1] = 0;
	boxbcastsemaphore = false;
	if (send_bbsbcast)
	  bcastlist(hp, x, ct, true);
	return;
      }
    }
    hp = hp->next;
  }
}


void boxbcasttxtimer(void)
{
  bcastdesctype *hp;
  unsigned short x, ct, FORLIM;

  debug0(4, 0, 120);
  hp = bcastdesc;
  ct = 0;
  while (hp != NULL) {
    ct++;
    FORLIM = hp->timeslices;
    for (x = 1; x <= FORLIM; x++) {
      if (hp->lastfileid[x - 1] == 0)
	bcastlist(hp, x, ct, false);
    }
    hp = hp->next;
  }
  if (send_bbsbcast && bcastdesc != NULL && clock_.ixtime - lastbcastok > 1800) {
    load_boxbcastparms(bcast_box);
  } 
}


void show_bcastactivity(short unr, cbbproc outputproc)
{
  bcastdesctype *hp;
  short x, FORLIM;

  hp = bcastdesc;
  while (hp != NULL) {
    FORLIM = hp->timeslices;
    for (x = 0; x < FORLIM; x++) {
      if (*hp->statinf[x] != '\0')
	outputproc(unr, hp->statinf[x]);
    }
    hp = hp->next;
  }
}


void _boxbcast_init(void)
{
  static int _was_initialized = 0;
  if (_was_initialized++)
    return;
  bcastdesc = NULL;
  bcasttfsize = 0;
  bcasttfct = 0;
  lastbcastok = 0;
}



/* End. */
