/* Output from p2c, the Pascal-to-C translator */
/* From input file "box_tim.p" */


/************************************************************/
/*                                                          */
/* DigiPoint SourceCode                                     */
/*                                                          */
/* Copyright (c) 1991-1996 Joachim Schurig, DL8HBS, Berlin  */
/*                                                          */
/* For license details see documentation                    */
/*                                                          */
/************************************************************/


#include "defs.h"

#define BOX_TIM_G
#include "box_tim.h"


#ifndef TOOLS_H
#include "tools.h"
#endif

#ifndef SORT_H
#include "sort.h"
#endif

#ifndef MISC_OS_H
#include "misc_os.h"
#endif

#ifndef BOXBCAST_H
#include "boxbcast.h"
#endif

#ifndef YAPP_H
#include "yapp.h"
#endif

#ifndef BOXLOCAL_H
#include "boxlocal.h"
#endif

#ifndef BOX_SEND_H
#include "box_send.h"
#endif

#ifndef BOX_SUB_H
#include "box_sub.h"
#endif

#ifndef BOX_SYS_H
#include "box_sys.h"
#endif

#ifndef BOX_SF_H
#include "box_sf.h"
#endif

#ifndef BOX_H
#include "box.h"
#endif

#ifndef BOX_FILE_H
#include "box_file.h"
#endif

#ifndef BOX_INOU_H
#include "box_inou.h"
#endif

#ifndef BOX_MEM_H
#include "box_mem.h"
#endif

#ifndef BOXFSERV_H
#include "boxfserv.h"
#endif

#ifndef SHELL_H
#include "shell.h"
#endif


/* ************************************************************************ */
/* * Die Konvertierroutinen fuer einen kompletten DieBox-Daten-Import     * */
/* ************************************************************************ */

Static Char actboard[9];


void cdbtboard(Char *s)
{
  /* hier holt sich new_entry() den transferierten brettnamen her */
  strcpy(s, actboard);
}


Static void iwuser(short unr, Char *s)
{
  Char STR1[256];

  sprintf(STR1, "%sdiebox%cimp", boxprotodir, extsep);
  append(STR1, s, false);
  wuser(unr, s);
  boxspoolread();
}


Static void iwlnuser(short unr, Char *s)
{
  Char STR1[256];

  sprintf(STR1, "%sdiebox%cimp", boxprotodir, extsep);
  append(STR1, s, true);
  wlnuser(unr, s);
  boxspoolread();
}



Static boolean cverr, idel;


Static void filemove2(Char *n1, Char *n2)
{
  if (idel)
    filemove(n1, n2);
  else
    filecopy(n1, n2);
}


Static void printtime(short unr, long t)
{
  Char hs[256];
  Char STR7[256];

  t /= 200;
  sprintf(hs, "%ld", t / 60);
  sprintf(STR7, "used time: %s minutes, ", hs);
  iwuser(unr, STR7);
  sprintf(hs, "%ld", t % 60);
  sprintf(STR7, "%s seconds.", hs);
  iwlnuser(unr, STR7);
}


Static void conv_pname_rel(Char *w, Char *p)
{
  short x, FORLIM;
  Char STR1[256];

  if (p[1] == ':')
    strdelete((void *)p, 1, 2);
  if (p[0] == '\\')
    strdelete((void *)p, 1, 1);
  FORLIM = strlen(p);
  for (x = 0; x < FORLIM; x++) {
    if (p[x] == '\\')
      p[x] = '/';
  }
  lower(p);
  sprintf(p, "%s%s", w, strcpy(STR1, p));
}


Static boolean check_cpath(Char *w_)
{
  boolean Result;
  Char w[256];
  boolean ok;

  strcpy(w, w_);
  strcat(w, "config.box");
  ok = exist(w);
  Result = ok;
  if (!ok)
    cverr = true;
  return Result;
}


Static void dop(short unr, Char *s)
{
}


/* holt die neue lifetime aus show.box */

Static short get_sblt(uchar *sbp, long sbs, Char *bid)
{
  short Result;
  Char hs[256], b2[256];
  long rp;

  Result = -1;
  rp = 0;
  while (rp < sbs) {
    get_line(sbp, &rp, sbs, hs);
    strsub(b2, hs, 71, 12);
    del_lastblanks(b2);
    if (!strcmp(b2, bid)) {
      strsub(b2, hs, 83, 3);
      del_leadblanks(b2);
      return (Str2int(b2));
    }
  }
  return Result;
}


Static long convert_diebox_mails(short unr, boolean userarea, Char *p,
				 Char *sb)
{
  Char w[256], board[256];
  Char hs[256], prot[256];
  Char mn[256], w1[256];
  Char mnn[256], mn3[256];
  uchar *sbp;
  long sbs;
  short flh;
  Char fmn[256];
  DTA dirinfo;
  boolean improper;
  short result, ph, mh, mnh, ct, x;
  long mct;
  uchar *pp;
  long ps, err, fp1, fp2;
  short nlt;
  Char rxbox[256];
  Char STR1[256], STR7[256];
  void (*TEMP)(short unr, Char *s);

  mct = 0;
  if (userarea)
    sbp = NULL;
  else {
    iwuser(unr,
      "loading show.box for lifetime conversion of sysop-altered mails...");
    sfbread(true, sb, &sbp, &sbs);
    if (sbp == NULL)
      iwlnuser(unr, " not found. doesnt matters.");
    else
      iwlnuser(unr, " done.");
  }

  sprintf(fmn, "%sfmn625702", tempdir);
  flh = sfcreate(fmn, FC_FILE);
  if (flh >= minhandle) {
    iwuser(unr, "creating filelist...");
    sprintf(STR1, "%s%c%c%c", p, allquant, extsep, allquant);
    result = sffirst(STR1, 16, &dirinfo);
    while (result == 0) {
      string_to_file(&flh, dirinfo.d_fname, true);
      result = sfnext(&dirinfo);
    }
    sfclose(&flh);
    iwuser(unr, " done. sorting list...");
    sort_file(fmn);
    iwlnuser(unr, " done");
    flh = sfopen(fmn, FO_READ);
    if (flh >= minhandle) {
      iwlnuser(unr, "importing mails");
      while (file_to_string(flh, board)) {
	cut(board, 8);
	strcpy(actboard, board);
	upper(actboard);
	dp_watchdog(2, 4711);
	improper = false;
	sprintf(STR7, "importing board %s:", board);
	iwlnuser(unr, STR7);
	sprintf(prot, "%s%s%cprotfile.dat", p, board, dirsep);
	iwuser(unr, "opening protfile.dat...");
	ph = sfopen(prot, FO_READ);
	if (ph >= minhandle) {
	  iwlnuser(unr, " done");
	  iwuser(unr, "importing mails into dpbox");
	  ct = 0;
	  while (file_to_string(ph, hs)) {
	    *rxbox = '\0';
	    dp_watchdog(2, 4711);
	    cut(hs, 6);
	    del_lastblanks(hs);
	    lower(hs);
	    sprintf(mn, "%s%s%c%s", p, board, dirsep, hs);
	    sprintf(w, "%ld", ct);
	    sprintf(mnn, "%sSENDING%c%s", newmaildir, extsep, w);
	    validate(mnn);
	    mh = sfopen(mn, FO_READ);
	    if (mh >= minhandle) {
	      mnh = sfcreate(mnn, FC_FILE);
	      if (mnh >= minhandle) {
		strcpy(w, ".");
		iwuser(unr, w);
		if (file_to_string(mh, hs)) {
		  if (*hs == '\0')
		    file_to_string(mh, hs);
		  if (*hs != '\0') {
		    fp1 = sfseek(0, mh, SFSEEKCUR);
		    fp2 = sfseek(0, mh, SFSEEKEND);
		    ps = fp2 - fp1 + 1;
		    sfseek(fp1, mh, SFSEEKSET);

		    if (hs[0] < ' ')
		      strdelete((void *)hs, 1, 1);
		    x = strpos2(hs, " UTC ", 1);
		    if (x > 0) {
		      strdelete((void *)hs, x, 5);
		      strinsert("   0 ", (void *)hs, x);
		    } else if (!userarea && sbp != NULL) {
		      file_to_string(mh, w);   /* subject */
		      file_to_string(mh, w);   /* BID     */
		      if (strpos2(w, "*** Bulletin-ID: ", 1) == 1) {
			strdelete((void *)w, 1, 17);
			get_word(w, w1);
			cut(w1, 12);
			if (strlen(w1) > 3) {
			  /* lifetime aus show.box raussuchen */
			  nlt = get_sblt(sbp, sbs, w1);
			} else
			  nlt = -1;

			if (nlt >= 0) {
			  sprintf(w1, "%ld", nlt);
			  lspacing(w1, 3);
			  strdelete((void *)hs, 43, 3);
			  strinsert(w1, (void *)hs, 43);
			}
		      }
		      file_to_string(mh, w);   /* received from */
		      if (strpos2(w, "*** Received from ", 1) == 1) {
			for (x = 1; x <= 4; x++)
			  get_word(w, rxbox);
		      }
		    }


		    if (userarea || sbp == NULL) {
		      file_to_string(mh, w);   /* subject */
		      file_to_string(mh, w);   /* leerzeile */
		      file_to_string(mh, w);   /* received from */
		      if (strpos2(w, "*** Received from ", 1) == 1) {
			for (x = 1; x <= 4; x++)
			  get_word(w, rxbox);
		      }
		    }
		    /*
DP @DL           de:DF3VI  01.07.95 22:27 200   1242 Bytes
DP @DL           de:DF3VI  01.07.95 22:27 200 999999 Bytes
*/
		    if (strlen(hs) > 52) {
		      for (x = 46; x <= 51; x++)
			hs[x] = '9';
		    }

		    string_to_file(&mnh, hs, true);

		    sfseek(fp1, mh, SFSEEKSET);
		    pp = Malloc(ps);
		    if (pp != NULL) {
		      err = sfread(mh, ps, pp);
		      if (sfwrite(mnh, err, pp) != err)
			cverr = true;
		      mymfree(&pp);
		    } else
		      cverr = true;

		  }

		}
		sfclose(&mnh);
	      }
	      sfclose(&mh);
	      stripcr(mnn);

	      if (callsign(rxbox)) {
		sprintf(mn3, "%s&%s%c1", newmaildir, rxbox, extsep);
		validate(mn3);
		sfrename(mnn, mn3);
	      } else
		strcpy(mn3, mnn);

	      /* jetzt einsortieren in dpbox! */

	      sort_new_mail(-99, mn3, Console_call);
	      ct++;

	      sfdelfile(mn3);   /* falls das noch stehenblieb... */
	    } else
	      improper = true;
	    if (idel)
	      sfdelfile(mn);
	  }
	  sfclose(&ph);
	  mct += ct;
	  sprintf(w, "%ld", ct);
	  sprintf(STR7, " done. %s mails imported.", w);
	  iwlnuser(unr, STR7);
	  if (improper)
	    iwlnuser(unr,
	      "protfile.dat contained some inconsistencies. doesnt matters.");
	  if (idel)
	    sfdelfile(prot);
	} else
	  iwlnuser(unr, " failed!");
	if (idel) {
	  sprintf(STR7, "%s%s%c%c%c%c",
		  p, board, dirsep, allquant, extsep, allquant);
	  TEMP = dop;
	  file_delete(0, STR7, TEMP);
	}
      }
      iwlnuser(unr, "Import is done");
      sfclose(&flh);
    }
    sfdelfile(fmn);
  } else
    cverr = true;

  if (sbp != NULL)
    mymfree(&sbp);

  return mct;
}


Static void conv5(short unr, Char *w_)
{
  /* BIDs draufhauen */
  Char w[256];
  long t, tct, bs;
  Char cp[256], p[256], hs[256], ww[256], w1[256], w2[256];
  short ih, oh;
  Char STR1[256], STR7[256];

  strcpy(w, w_);
  if (cverr)
    return;
  if (!check_cpath(w)) {
    iwlnuser(unr, "invalid pathname");
    return;
  }
  free_membidpuffer();
  clear_bidhash();
  wlnuser0(unr);
  iwlnuser(unr, "conversion step 5");
  iwlnuser(unr, "importing all known bulletin IDs");
  t = statclock();
  tct = 0;
  sprintf(cp, "%sconfig.box", w);
  if (!get_fileline(cp, 38, p)) {  /* pfad auf MBSYS */
    cverr = true;
    iwlnuser(unr, "err 2 - mbsys-path not found in config.box");
    return;
  }
  conv_pname_rel(w, p);
  if (idel) {
    sprintf(STR1, "%sbullid.bak", p);
    sfdelfile(STR1);
    sprintf(STR1, "%scbullid.bak", p);
    sfdelfile(STR1);
    sprintf(STR1, "%scbullid.txt", p);
    sfdelfile(STR1);
  }
  sprintf(ww, "%sbullid.txt", p);
  sprintf(hs, "%ld", sfsize(ww) / 19);
  sprintf(hs, "now trying to import %s BIDs", strcpy(STR7, hs));
  iwlnuser(unr, hs);
  iwuser(unr, "opening bullid.txt... ");
  ih = sfopen(ww, FO_READ);
  if (ih >= minhandle) {
    iwlnuser(unr, "done.");
    bs = sfsize(msgidlog) / 13;
    oh = sfopen(msgidlog, FO_RW);
    if (oh < minhandle)
      oh = sfcreate(msgidlog, FC_FILE);
    if (oh >= minhandle) {
      sfseek(0, oh, SFSEEKEND);
      while (file_to_string(ih, hs)) {
	get_word(hs, w1);
	if ((unsigned long)strlen(w1) >= 32 ||
	    ((1L << strlen(w1)) & 0x1ff8) == 0)
	  continue;
	tct++;
	if (tct % 100 == 0) {
	  sprintf(w2, "%ld", tct);
	  strcat(w2, " ");
	  if (tct % 1000 == 0)
	    wlnuser(unr, w2);
	  else
	    wuser(unr, w2);
	  boxspoolread();
	}
	if (bs >= maxbullids) {
	  bs = 0;
	  sfseek(0, oh, SFSEEKSET);
	}
	bs++;
	sfwrite(oh, 13, w1);
      }
      sfclose(&oh);
      bullidseek = bs;
      flush_bidseek();
    } else
      iwlnuser(unr, "cannot access to MSGIDMEM.BOX");
    sfclose(&ih);
    if (idel)
      sfdelfile(ww);
    wlnuser0(unr);
    sprintf(w2, "%ld", tct);
    sprintf(w2, "converted %s BIDs", strcpy(STR1, w2));
    iwlnuser(unr, w2);
  } else {
    cverr = true;
    iwlnuser(unr, "failed");
  }


  wlnuser0(unr);
  if (cverr)
    iwlnuser(unr, "some errors occured in step 5");
  else
    iwlnuser(unr, "step 5 finished without errors");
  printtime(unr, statclock() - t);

}


Static void flush_sfw(short *oh, Char *hs, short *lasttyp)
{
  Char STR1[256];

  if (*hs != '\0') {
    switch (*lasttyp) {

    case 0:
      /* blank case */
      break;

    case 1:
      sprintf(hs, "FOR %s", strcpy(STR1, hs));
      break;

    case 2:
      sprintf(hs, "NOT %s", strcpy(STR1, hs));
      break;

    case 3:
      sprintf(hs, "NOTRUBRIK %s", strcpy(STR1, hs));
      break;

    case 4:
      sprintf(hs, "RUBRIK %s", strcpy(STR1, hs));
      break;
    }
    del_lastblanks(hs);
    if ((unsigned)(*lasttyp) < 32 && ((1L << (*lasttyp)) & 0x1e) != 0)
      string_to_file(oh, hs, true);
  }
  *hs = '\0';
  *lasttyp = 0;
}


Static void convert_sfw(short unr, Char *p, Char *sfw)
{
  Char w[256], w1[256], hs[256], w3[256];
  short ih, oh;
  Char ina[256], ona[256];
  boolean ok;
  short lasttyp;
  Char STR7[256];

  ok = false;
  strcpy(w, sfw);
  del_ext(w);
  upper(w);
  if (!callsign(w))
    return;
  sprintf(STR7, "opening %s ...", sfw);
  iwuser(unr, STR7);















  sprintf(ina, "%s%s", p, sfw);
  lower(w);
  sprintf(ona, "%s%s%csf", boxsfdir, w, extsep);
  ih = sfopen(ina, FO_READ);
  if (ih < minhandle) {
    iwlnuser(unr, "cannot access");
    return;
  }
  iwlnuser(unr, "done");
  oh = sfcreate(ona, FC_FILE);
  if (oh >= minhandle) {
    ok = true;

    upper(w);
    string_to_file(&oh, hs, true);
    strcpy(hs,
      "# the next line is a default. please tell TNT and DPBOX how to connect correctly.");
    string_to_file(&oh, hs, true);
    sprintf(hs, "# IFQRG XXXXX %s 900", w);
    string_to_file(&oh, hs, true);
    *hs = '\0';
    string_to_file(&oh, hs, true);
    strcpy(hs, "SFPARMS 1 1 1 200000 200000 200000 600 0000 2359");
    string_to_file(&oh, hs, true);
    *hs = '\0';
    string_to_file(&oh, hs, true);
    strcpy(hs,
      "# ------------- now starting definition of files, areas, mailboxes ------------");
    string_to_file(&oh, hs, true);
    strcpy(hs, "# keywords in these definitions are (at start of line):");
    string_to_file(&oh, hs, true);
    strcpy(hs, "# FOR NOT NOTFROM NOTRUBRIK");
    string_to_file(&oh, hs, true);
    strcpy(hs, "# NOT is the negation of FOR , NOTFROM is a neighbour BBS");
    string_to_file(&oh, hs, true);
    strcpy(hs,
      "# hierarchical names and abbreviations with <*> are allowed for FOR|NOT|NOTFROM");
    string_to_file(&oh, hs, true);
    strcpy(hs,
      "# keyword not for regular use in S&F is: RUBRIK . selects all boards files");
    string_to_file(&oh, hs, true);
    strcpy(hs,
      "# -----------------------------------------------------------------------------");
    string_to_file(&oh, hs, true);
    *hs = '\0';
    string_to_file(&oh, hs, true);
    /*               hs  := concat('FOR ',w);
                     string_to_file(oh,hs,true); */

    lasttyp = 0;
    *hs = '\0';
    while (file_to_string(ih, w)) {
      while (*w != '\0') {
	get_word(w, w3);

	while (*w3 != '\0') {
	  if (strlen(w3) > 9) {
	    sprintf(w1, "%.9s", w3);
	    strdelete((void *)w3, 1, 9);
	  } else {
	    strcpy(w1, w3);
	    *w3 = '\0';
	  }

	  if (strpos2(w1, "*!", 1) > 0) {
	    flush_sfw(&oh, hs, &lasttyp);
	    continue;
	  }
	  if (*w1 == '\0')
	    continue;
	  if (strpos2(w1, "?", 1) > 0) {
	    cut(w1, strpos2(w1, "?", 1) - 1);
	    strcat(w1, "*");
	  }
	  if (strlen(hs) > 70)
	    flush_sfw(&oh, hs, &lasttyp);
	  switch (w1[0]) {

	  case '*':
	    if (lasttyp != 3)
	      flush_sfw(&oh, hs, &lasttyp);
	    lasttyp = 3;
	    strdelete((void *)w1, 1, 1);
	    sprintf(hs + strlen(hs), "%s ", w1);
	    break;

	  case '~':
	    if (lasttyp != 2)
	      flush_sfw(&oh, hs, &lasttyp);
	    lasttyp = 2;
	    strdelete((void *)w1, 1, 1);
	    sprintf(hs + strlen(hs), "%s ", w1);
	    break;

	  case '%':
	    if (lasttyp != 4)
	      flush_sfw(&oh, hs, &lasttyp);
	    lasttyp = 4;
	    strdelete((void *)w1, 1, 1);
	    sprintf(hs + strlen(hs), "%s ", w1);
	    break;

	  default:
	    if (lasttyp != 1)
	      flush_sfw(&oh, hs, &lasttyp);
	    lasttyp = 1;
	    sprintf(hs + strlen(hs), "%s ", w1);
	    break;
	  }
	}

      }
    }
    flush_sfw(&oh, hs, &lasttyp);

    sfclose(&oh);
  } else
    iwlnuser(unr, "cannot create outfile");
  sfclose(&ih);
  if (ok && idel)
    sfdelfile(ina);
}


Static void conv3(short unr, Char *w)
{
  /* SFW konvertieren */
  long t;
  Char cp[256], p[256];
  DTA dirinfo;
  short result;
  Char STR1[256];

  if (cverr)
    return;
  if (!check_cpath(w)) {
    iwlnuser(unr, "invalid pathname");
    return;
  }
  wlnuser0(unr);
  iwlnuser(unr, "conversion step 3");
  iwlnuser(unr, "importing S&F definition files");
  t = statclock();
  sprintf(cp, "%sconfig.box", w);
  if (!get_fileline(cp, 38, p)) {  /* pfad auf MBSYS */
    cverr = true;
    iwlnuser(unr, "err 2 - mbsys-path not found in config.box");
    return;
  }

  conv_pname_rel(w, p);

  sprintf(STR1, "%s%c%csfw", p, allquant, extsep);
  result = sffirst(STR1, 0, &dirinfo);
  while (result == 0) {
    convert_sfw(unr, p, dirinfo.d_fname);
    if (idel) {
      sprintf(STR1, "%s%s", p, dirinfo.d_fname);
      sfdelfile(STR1);
    }
    result = sfnext(&dirinfo);
  }

  wlnuser0(unr);
  iwlnuser(unr, "remember to set up the connect path in .SF - files.");
  if (cverr)
    iwlnuser(unr, "some errors occured in step 3");
  else
    iwlnuser(unr, "step 3 finished without errors");
  printtime(unr, statclock() - t);
  iwuser(unr, "now reloading new settings...");
  load_all_parms();
  iwlnuser(unr, " done");

}


Static void conv4(short unr, Char *w)
{
  long t, tctu, tctb;
  Char cp[256], p[256], sb[256], ww[256];
  Char STR7[256];

  if (cverr)
    return;
  if (!check_cpath(w)) {
    iwlnuser(unr, "invalid pathname");
    return;
  }
  wlnuser0(unr);
  iwlnuser(unr, "conversion step 4");
  if (packdelay == 0)
    iwlnuser(unr,
	     "all files will be compressed immediately while conversion.");
  iwlnuser(unr, "importing all user files");
  t = statclock();
  tctb = 0;
  sprintf(cp, "%sconfig.box", w);
  if (!(get_fileline(cp, 36, p) && get_fileline(cp, 38, sb)))
      /* pfad auf USER */
      {  /* pfad auf MBSYS */
    cverr = true;
    iwlnuser(unr, "err 2 - user/mbsys-path not found in config.box");
    return;
  }

  conv_pname_rel(w, p);
  conv_pname_rel(w, sb);
  strcat(sb, "show.box");
  tctu = convert_diebox_mails(unr, true, p, sb);
  iwuser(unr, "all user files imported. total files: ");
  sprintf(ww, "%ld", tctu);
  iwlnuser(unr, ww);
  iwlnuser(unr, "importing all info files");
  if (get_fileline(cp, 37, p)) {  /* pfad auf INFO */
    conv_pname_rel(w, p);
    tctb = convert_diebox_mails(unr, false, p, sb);
    iwuser(unr, "all info files imported. total files: ");
    sprintf(ww, "%ld", tctb);
    iwlnuser(unr, ww);
    if (idel)   /* show.box loeschen */
      sfdelfile(sb);

    iwlnuser(unr, "recreating boxlog (check-list) ...");
    create_new_boxlog(unr, false);
    iwlnuser(unr, "done.");
  } else {
    cverr = true;
    iwlnuser(unr, "err 3 - info-path not found in config.box");
  }

  tctu += tctb;
  sprintf(ww, "%ld", tctu);
  sprintf(ww, "file import over all: %s files.", strcpy(STR7, ww));
  iwlnuser(unr, ww);

  wlnuser0(unr);
  if (cverr)
    iwlnuser(unr, "some errors occured in step 4");
  else
    iwlnuser(unr, "step 4 finished without errors");
  printtime(unr, statclock() - t);

}


typedef Char ibufft[12];
typedef Char dbufft[48];

typedef struct irect {
  Char call[7];
  long offset;
} irect;

typedef struct drect {
  Char call[7];
  Char lan[4];
  long last;
  Char mybbs[7];
  Char name[16];
  short level, pwmode;
  long mybbsupd;
} drect;


Static void getcs(uchar *p, short max, Char *s)
{
  long x;

  *s = '\0';
  x = 0;
  while (x < max && p[x] != 32 && p[x] != 0) {
    sprintf(s + strlen(s), "%c", (Char)p[x]);
    x++;
  }
}


Static boolean convert_ibuff(Char *ibuff_, irect *irec)
{
  ibufft ibuff;
  short x, y;
  uchar *p;

  memcpy(ibuff, ibuff_, sizeof(ibufft));
  p = ibuff;
  getcs(p, 6, irec->call);
  upper(irec->call);

  y = 1;
  for (x = 8; x <= 11; x++) {
    switch (y) {

    case 1:
      irec->offset = (long)ibuff[x];
      break;

    case 2:
      irec->offset += (long)ibuff[x] * 256;
      break;

    case 3:
      irec->offset += (long)ibuff[x] * 65536;
      break;

    case 4:
      irec->offset += (long)ibuff[x] * 16777216;
      break;
    }
    y++;
  }

  return (callsign(irec->call) && irec->offset >= 0);
}


Static boolean convert_dbuff(Char *call, Char *dbuff_, drect *drec)
{
  boolean Result;
  dbufft dbuff;
  short x, y;
  uchar *p;
  Char w[256], w1[256];

  memcpy(dbuff, dbuff_, sizeof(dbufft));
  Result = false;

  strcpy(drec->call, call);
  drec->last = 0;
  *drec->mybbs = '\0';
  *drec->name = '\0';
  drec->level = 1;
  drec->mybbsupd = 0;
  drec->pwmode = 0;

  p = dbuff;
  getcs(p, 3, drec->lan);

  getcs((uchar *)(&p[4]), 8, w1);
  getcs((uchar *)(&p[13]), 5, w);
  drec->last = string2ixtime(w1, w);

  getcs((uchar *)(&p[19]), 6, drec->mybbs);
  upper(drec->mybbs);
  if (!strcmp(drec->mybbs, "OWNBBS"))   /* !... */
    strcpy(drec->mybbs, Console_call);

  if (!callsign(drec->mybbs))
    return Result;


  getcs((uchar *)(&p[26]), 15, drec->name);

  y = 1;
  for (x = 44; x <= 47; x++) {
    switch (y) {

    case 1:
      drec->mybbsupd = (long)dbuff[x];
      break;

    case 2:
      drec->mybbsupd += (long)dbuff[x] * 256;
      break;

    case 3:
      drec->mybbsupd += (long)dbuff[x] * 65536;
      break;

    case 4:
      drec->mybbsupd += (long)dbuff[x] * 16777216;
      break;
    }
    y++;
  }

  if (drec->mybbsupd > THEBOX_ERRONEOUS_OFFSET)   /* !... */
    drec->mybbsupd -= THEBOX_ERRONEOUS_OFFSET;
  else
    drec->mybbsupd = 0;

  if (drec->mybbsupd == 0 || drec->mybbsupd < clock_.ixtime - 31536000L * 5 ||
      drec->mybbsupd > clock_.ixtime)
    return Result;

  gkdeutsch(drec->name);

  Result = true;

  switch (p[42]) {   /* der diebox-level */

  case 0:   /*normal*/
    break;

  case 1:
  case 4:   /*sysop*/
    drec->pwmode = 10;
    break;

  case 2:   /*gesperrt*/
    drec->level = 0;
    break;

  case 5:   /*sysop mit schutz*/
    drec->pwmode = 11;
    break;

  case 7:   /*rubrikensysop*/
    drec->pwmode = 8;
    break;

  case 8:   /*rubrikensysop mit schutz*/
    drec->pwmode = 9;
    break;

  case 9:   /*user must priv*/
    drec->pwmode = 2;
    break;
  }

  return Result;
}


Static void conv2(short unr, Char *w_)
{
  /* Die Userdaten */
  Char w[256];
  Char cp[256], p[256], w1[256];
  Char idn[256], dn[256];
  short idh, dh;
  boolean ok;
  long t, ct;
  ibufft ibuff;
  dbufft dbuff;
  irect irec;
  drect drec;
  long dsize;
  userstruct urec;
  Char STR1[256];

  strcpy(w, w_);
  ok = false;
  ct = 0;
  if (cverr)
    return;
  if (!check_cpath(w)) {
    iwlnuser(unr, "invalid pathname");
    return;
  }
  wlnuser0(unr);
  iwlnuser(unr, "conversion step 2");
  iwlnuser(unr, "importing user settings");
  t = statclock();
  sprintf(cp, "%sconfig.box", w);
  if (!get_fileline(cp, 38, p)) {  /* pfad auf MBSYS */
    cverr = true;
    iwlnuser(unr, "err 1 - mbsys-path not found in config.box");
    return;
  }

  conv_pname_rel(w, p);

  sprintf(dn, "%suser3.dat", p);
  sprintf(idn, "%suser3.idx", p);
  if (exist(dn) && exist(idn)) {
    dsize = sfsize(dn);   /*dsize mod 48 = 0*/
    if (true) {
      if (sfsize(idn) % 12 == 0) {
	idh = sfopen(idn, FO_READ);
	if (idh >= minhandle) {
	  dh = sfopen(dn, FO_READ);
	  if (dh >= 0) {
	    iwuser(unr, "now converting ");
	    sprintf(w1, "%ld", dsize / 48);
	    iwuser(unr, w1);
	    iwlnuser(unr, " user settings");

	    strcpy(w1, "users with extended/restricted settings:");
	    sprintf(STR1, "%sdiebox%cimp", boxprotodir, extsep);
	    append(STR1, w1, true);

	    while (sfread(idh, 12, ibuff) == 12) {
	      dp_watchdog(2, 4711);
	      if (!convert_ibuff(ibuff, &irec))
		continue;
	      if (irec.offset > dsize - 48)
		continue;
	      if (sfseek(irec.offset, dh, SFSEEKSET) != irec.offset)
		continue;
	      if (sfread(dh, 48, dbuff) != 48)
		continue;
	      if (!convert_dbuff(irec.call, dbuff, &drec))
		continue;
	      ct++;
	      strcpy(w1, ".");
	      if (ct % 79 == 0)
		wlnuser(unr, w1);
	      else
		wuser(unr, w1);
	      boxspoolread();

	      if (drec.pwmode > 0 || !strcmp(drec.mybbs, Console_call) ||
		  drec.level != 1) {
		load_userinfo_for_change(false, drec.call, &urec);

		urec.level = drec.level;
		urec.plevel = drec.level;
		strcpy(urec.language, drec.lan);
		urec.lastdate = drec.last;
		strcpy(urec.mybbs, drec.mybbs);
		strcpy(urec.name, drec.name);
		urec.pwmode = drec.pwmode;
		urec.mybbsupd = drec.mybbsupd;

		if (drec.pwmode > 0 || drec.level != 1) {
		  sprintf(STR1, "%sdiebox%cimp", boxprotodir, extsep);
		  append(STR1, urec.call, true);
		}

		save_userfile(&urec);

	      }

	      update_mybbsfile(false, drec.call, &drec.mybbsupd, drec.mybbs, "U");

	    }

	    ok = true;
	    sfclose(&dh);
	    wlnuser0(unr);
	    sprintf(w1, "%ld", ct);
	    strcat(w1, " user settings converted");
	    iwlnuser(unr, w1);
	  } else
	    iwlnuser(unr, "cannot open user3.dat");
	  sfclose(&idh);
	  if (idel && ok) {
	    sfdelfile(dn);
	    sfdelfile(idn);
	  }
	} else
	  iwlnuser(unr, "cannot open user3.idx");
      } else
	iwlnuser(unr, "size of user3.idx improper");
    } else
      iwlnuser(unr, "size of user3.dat improper");
  } else
    iwlnuser(unr, "user3.dat/user3.idx not found");

  wlnuser0(unr);
  if (cverr)
    iwlnuser(unr, "some errors occured in step 2");
  else
    iwlnuser(unr, "step 2 finished without errors");
  printtime(unr, statclock() - t);
}


Static void conv1(short unr, Char *w)
{
  /* Die Konfiguration */
  Char cp[256], p[256], w1[256];
  Char f[256];
  DTA dirinfo;
  short result;
  long t;
  Char STR1[256], STR7[256];

  if (cverr)
    return;
  if (!check_cpath(w)) {
    iwlnuser(unr, "invalid pathname");
    return;
  }
  wlnuser0(unr);
  iwlnuser(unr, "conversion step 1");
  iwlnuser(unr, "importing box configuration files");
  t = statclock();
  sprintf(cp, "%sconfig.box", w);

  iwlnuser(unr, "now adapting config.box");
  sprintf(f, "%sconfig%cbox", boxsysdir, extsep);

  if (get_fileline(cp, 70, p)) {
    upper(p);
    strcpy(w1, ownhiername);
    if (strpos2(p, Console_call, 1) == 0)
      sprintf(ownhiername, "%s.%s", Console_call, p);
    else
      strcpy(ownhiername, p);

    if (strcmp(w1, ownhiername)) {
      iwuser(unr, "ownhiername changed to: ");
      iwlnuser(unr, ownhiername);
      sprintf(p, "OWNHIERNAME %s", ownhiername);
      replace_keyline(f, "OWNHIERNAME ", false, p);
    }
  }

  if (get_fileline(cp, 48, p)) {
    get_word(p, w1);
    if (str2lint(w1) < 30000) {   /* + 10000 fuer UserBIDs */
      iwlnuser(unr,
	"original diebox-maxbull-setting is too low, will insert 40000");
      strcpy(w1, "40000");
    } else if (str2lint(w1) > 200000L) {
      iwlnuser(unr,
	"original diebox-maxbull-setting is too high, will insert 200000");
      strcpy(w1, "200000");
    } else
      sprintf(w1, "%ld", str2lint(w1) + 10000);
    sprintf(w1, "MAXBULLIDS %s", strcpy(STR7, w1));
    iwlnuser(unr, w1);
    replace_keyline(f, "MAXBULLIDS ", false, w1);
  }

  if (get_fileline(cp, 50, p)) {
    if (p[0] == '1')
      strcpy(p, "ON");
    else
      strcpy(p, "OFF");
    sprintf(p, "UFILHIDE %s", strcpy(STR7, p));
    iwlnuser(unr, p);
    replace_keyline(f, "UFILHIDE ", false, p);
  }

  if (get_fileline(cp, 51, p)) {
    get_word(p, w1);
    sprintf(p, "ERASEDELAY %s", w1);
    iwlnuser(unr, p);
    replace_keyline(f, "ERASEDELAY ", false, p);
  }

  if (get_fileline(cp, 50, p)) {
    if (p[0] == '1')
      strcpy(p, "OFF");
    else
      strcpy(p, "ON");
    sprintf(p, "WITH_RLINE %s", strcpy(STR7, p));
    iwlnuser(unr, p);
    replace_keyline(f, "WITH_RLINE ", false, p);
  }

  if (get_fileline(cp, 56, p)) {
    if (p[0] == '1')
      strcpy(p, "THEBOX");
    else
      *p = '\0';
    sprintf(p, "SYSFORWARD %s", strcpy(STR7, p));
    iwlnuser(unr, p);
    replace_keyline(f, "SYSFORWARD ", false, p);
  }

  if (get_fileline(cp, 57, p)) {
    if (p[0] == '0')
      strcpy(w1, "OFF");
    else
      strcpy(w1, "ON");
    sprintf(w1, "REMOTE_ERASE %s", strcpy(STR7, w1));
    iwlnuser(unr, w1);
    replace_keyline(f, "REMOTE_ERASE ", false, w1);
    if (p[0] > '1')
      strcpy(p, "ON");
    else
      strcpy(p, "OFF");
    sprintf(p, "REMOTEERASECHECK %s", strcpy(STR7, p));
    iwlnuser(unr, p);
    replace_keyline(f, "REMOTEERASECHECK ", false, p);
  }

  iwlnuser(unr, "config.box adapted.");


  if (!get_fileline(cp, 38, p)) {  /* pfad auf MBSYS */
    cverr = true;
    iwlnuser(unr, "err 1 - mbsys-path not found in config.box");
    return;
  }
  conv_pname_rel(w, p);
  iwlnuser(unr, "convtit");
  sprintf(STR7, "%sconvtit.box", p);
  sprintf(STR1, "%sconvtit.box", boxsysdir);
  filemove2(STR7, STR1);
  sprintf(STR7, "%sconvtit.box", boxsysdir);
  stripcr(STR7);
  iwlnuser(unr, "convlt");
  sprintf(STR7, "%sconvlt.box", p);
  sprintf(STR1, "%sconvlt.box", boxsysdir);
  filemove2(STR7, STR1);
  sprintf(STR7, "%sconvlt.box", boxsysdir);
  stripcr(STR7);
  iwlnuser(unr, "convname/transfer");
  sprintf(STR7, "%sconvname.box", p);
  sprintf(STR1, "%stransfer.box", boxsysdir);
  filemove2(STR7, STR1);
  sprintf(STR7, "%stransfer.box", boxsysdir);
  stripcr(STR7);
  iwlnuser(unr, "prvcalls");
  sprintf(STR7, "%sprvcalls.box", p);
  sprintf(STR1, "%sprvcalls.box", boxsysdir);
  filemove2(STR7, STR1);
  sprintf(STR7, "%sprvcalls.box", boxsysdir);
  stripcr(STR7);
  iwlnuser(unr, "badnames");
  sprintf(STR7, "%sbadnames.box", p);
  sprintf(STR1, "%sbadnames.box", boxsysdir);
  filemove2(STR7, STR1);
  sprintf(STR7, "%sbadnames.box", boxsysdir);
  stripcr(STR7);
  iwlnuser(unr, "lifetime.box / rubriken.box");
  sprintf(STR7, "%slifetime.box", w);
  sprintf(STR1, "%srubriken.box", boxsysdir);
  filemove2(STR7, STR1);
  sprintf(STR7, "%srubriken.box", boxsysdir);
  stripcr(STR7);

  sprintf(STR7, "%spwd%c%c%cpwd", w, dirsep, allquant, extsep);
  result = sffirst(STR7, 0, &dirinfo);
  while (result == 0) {
    iwlnuser(unr, dirinfo.d_fname);
    strcpy(w1, dirinfo.d_fname);
    lower(w1);
    sprintf(STR7, "%spwd%c%s", w, dirsep, dirinfo.d_fname);
    sprintf(STR1, "%s%s", boxsfdir, w1);
    filemove2(STR7, STR1);
    result = sfnext(&dirinfo);
  }
  iwlnuser(unr,
    "remember to set up personal passwords for former users of PWLIST.TXT");
  wlnuser0(unr);

  if (cverr)
    iwlnuser(unr, "some errors occured in step 1");
  else
    iwlnuser(unr, "step 1 finished without errors");
  printtime(unr, statclock() - t);
  iwuser(unr, "now reloading new settings...");
  load_all_parms();
  iwlnuser(unr, " done");
}


void conv_diebox(short unr, Char *eingabe_)
{
  Char eingabe[256];
  Char w[256], p[256], s[256];

  strcpy(eingabe, eingabe_);
  blocking_off();
  boxisbusy(true);

  cverr = false;
  get_word(eingabe, w);
  get_word(eingabe, p);
  get_word(eingabe, s);
  idel = (!strcmp(s, "-") || !strcmp(p, "-"));

  if (idel)
    iwlnuser(unr, "will delete original files after conversion");
  else
    iwlnuser(unr, "will hold original files after conversion");

  switch (w[0]) {

  case '1':   /* Config-Files      */
    conv1(unr, p);
    break;

  case '2':   /* Userdaten         */
    conv2(unr, p);
    break;

  case '3':   /* Forward-Dateien   */
    conv3(unr, p);
    break;

  case '4':   /* Mails/Bulletins   */
    conv4(unr, p);
    break;

  case '5':   /* BullIDs addieren  */
    conv5(unr, p);
    break;

  default:
    conv1(unr, w);
    conv2(unr, w);
    conv3(unr, w);
    conv4(unr, w);
    conv5(unr, w);
    break;
  }

  wlnuser0(unr);
  wlnuser(unr, "check logfile <proto/diebox.imp> for all performed actions.");
  wlnuser(unr, "import is ended.");
  boxisbusy(false);
  blocking_on();
}



/* ************************************************************************ */
/* *                   Ende Konvertierroutinen                            * */
/* ************************************************************************ */

/* Wird angesprungen, wenn endlich der Spooler nach Eingabe von QUIT */
/* leergelaufen ist (unter anderem wegen //COMP ON). Beendet den     */
/* Connect zur Box endgueltig.                                       */

void end_boxconnect(short unr)
{
  short s, e;
  boolean bbs;

  if (!boxrange(unr))
    return;
  debug0(3, -1, 150);
  s = user[unr]->tcon;
  e = user[unr]->pchan;
  bbs = user[unr]->f_bbs;
  melde_user_ab(unr, user[unr]->action == 14);
  if (bbs) {
    if (s > 0) {
      boxendbox(s);
      return;
    }
    if (e > 0)
      boxpabortsf(e, true);
    return;
  }
  if (s > 0) {
    boxendbox(s);
    return;
  }
  if (e > 0)
    boxpacketendbox(e);
}


void spoolendcheck(short unr)
{
  userstruct *WITH;

  if (!boxrange(unr))
    return;

  WITH = user[unr];
  if (boxspoolstatus(WITH->tcon, WITH->pchan, -1) <= 0)
    end_boxconnect(unr);
}


void tell_command(Char *call, Char *bid, Char *frage)
{
  short k;
  Char tellname[256];

  if (!callsign(call))
    return;
  if ((unsigned long)strlen(bid) >= 32 || ((1L << strlen(bid)) & 0x1ff8) == 0)
    return;
  if (count_words(frage) < 3)
    return;
  sprintf(tellname, "%sTELLREQ%c001", boxstatdir, extsep);
  validate(tellname);
  k = sfcreate(tellname, FC_FILE);
  if (k < minhandle)
    return;
  string_to_file(&k, call, true);
  string_to_file(&k, bid, true);
  string_to_file(&k, frage, true);
  tell_waiting = true;
  sfclose(&k);
}


void stop_tell(short unr)
{
  Char hs[256], mbx[256];

  if (!boxrange(unr))
    return;

  sfclose(&user[unr]->tell);



  if (sfsize(user[unr]->tellfname) <= 300000L) {
    strcpy(mbx, user[unr]->tellmbx);
    if (!gen_sftest2(-1, user[unr]->call, mbx)) {
      user_mybbs(user[unr]->call, hs);
      if (*hs == '\0')
	strcpy(hs, Console_call);
      strcpy(mbx, hs);
    }

    sprintf(hs, "%s @ %s < %s tell reply from %s",
	    user[unr]->call, mbx, Console_call, Console_call);
    strcpy(user[unr]->input2, user[unr]->tellfname);
    send_check(unr, hs, false, 'P');
  }
  sfdelfile(user[unr]->tellfname);
  user[unr]->tellfname[0] = '\0';
  melde_user_ab(unr, false);
}


boolean tell_processing(Char *tellfile)
{
  boolean Result;
  short unr, tf, x;
  Char telluser[256];
  Char request[256];
  Char hs[256];
  Char mbx[256];
  Char bid[256];

  debug(1, -1, 121, tellfile);
  boxsetbmouse();
  Result = true;

  tf = sfopen(tellfile, FO_READ);
  if (tf < minhandle)
    return Result;
  file_to_string(tf, telluser);
  file_to_string(tf, bid);
  file_to_string(tf, request);
  sfclosedel(&tf);
  sfdelfile(tellfile);
      /* eigentlich ueberfluessig... aber es gab mal Probleme */

  if (!(callsign(telluser) && (unsigned long)strlen(bid) < 32 &&
	((1L << strlen(bid)) & 0x1ff8) != 0))
    return Result;

  strcpy(hs, "T");
  delete_brett_by_bid(hs, "", bid, false, true);

  x = strlen(request);
  while (x > 0 && request[x - 1] != '@')
    x--;
  if (x > 0) {
    strsub(mbx, request, x + 1, strlen(request) - x);
    cut(request, x - 1);
    del_leadblanks(mbx);
    cut(mbx, 40);
    del_lastblanks(request);

    unr = melde_user_an(telluser, 0, 0, UM_TELLREQ, false);
    if (unr > 0) {
      Result = true;
      strcpy(user[unr]->tellmbx, mbx);
      box_input(unr, false, false, request, true);
    } else
      Result = false;
  }
  boxsetamouse();
  debug(1, -1, 121, "ended (may be continued in background)");
  return Result;
}


void tell_check(void)
{
  short result;
  DTA dirinfo;
  boolean okproc;
  Char STR1[256];

  okproc = true;
  do {
    sprintf(STR1, "%sTELLREQ%c%c", boxstatdir, extsep, allquant);
    result = sffirst(STR1, 0, &dirinfo);
    if (result == 0 && okproc) {
      sprintf(STR1, "%s%s", boxstatdir, dirinfo.d_fname);
      okproc = tell_processing(STR1);
      sprintf(STR1, "%s%s", boxstatdir, dirinfo.d_fname);
      sfdelfile(STR1);
    }
  } while (result == 0 && okproc != false);
  tell_waiting = (result == 0);
}


void do_quit(short unr, boolean abort)
{
  void (*TEMP)(short unr, Char *s);
  Char STR1[256];

  if (!boxrange(unr))
    return;
  TEMP = wlnuser;
  sprintf(STR1, "%scookies%cdoc", boxsysdir, extsep);
  give_cookie(unr, TEMP, STR1);
  wlnuser0(unr);
  show_stat(unr, unr);
  wlnuser(unr, "73 !");
  boxspoolread();
  if (abort)
    user[unr]->action = 15;
  else
    user[unr]->action = 14;
}


void timeout_check(short unr)
{
  Char hs[256];
  userstruct *WITH;

  if (!boxrange(unr))
    return;
  WITH = user[unr];
  if (!callsign(WITH->call))
    return;
  if (user[unr]->console != false)
    return;
  if (WITH->pchan > 0) {
    if (boxspoolstatus(0, WITH->pchan, -1) > 0)
      WITH->lastatime = clock_.ixtime;
    else if (boxunackframes(WITH->pchan) > 0)
      WITH->lastatime = clock_.ixtime;
  }
  if (WITH->f_bbs || in_sfp(WITH->call)) {
    if (clock_.ixtime - WITH->lastatime < sftimeout * 60 &&
	clock_.ixtime - WITH->lastcmdtime < 3600)
      return;
    if ((unsigned)WITH->action < 32 && ((1L << WITH->action) & 0xc000L) != 0)
    {   /* endgueltig ende */
      if (clock_.ixtime - WITH->lastatime >= sftimeout * 120)
	abort_useroutput(unr);
      return;
    }
    debug(1, unr, 122, "s&f");
    sprintf(hs, "%s: Timeout", user[unr]->call);
    abort_sf(unr, false, hs);
    return;
  }
  if (clock_.ixtime - WITH->lastatime < usertimeout * 60 &&
      clock_.ixtime - WITH->lastcmdtime < 12 * 3600) /* 12 Stunden */
    return;
  if ((unsigned)WITH->action < 32 && ((1L << WITH->action) & 0xc000L) != 0)
      /* rote Karte */
      {  /* dann kam schon ein QUIT/ABORT */
    if (clock_.ixtime - WITH->lastcmdtime >= 13 * 3600) /* 13 Stunden */
      abort_useroutput(unr);
    return;
  }
  WITH->action = 0;
  debug(1, unr, 122, "user");
  wlnuser(unr, "TIMEOUT");
  do_quit(unr, true);
}


Static void show_mailbeacon2(Char *ofiname)
{
  short tnc, x;
  long rp;
  uchar *btbuff;
  long btsize;

  boolean found;

  short chan, plen;
  Char hs[256], w[256], hs2[256];
  Char statustext[256];
  Char mailtext[256];
  Char adress[256];
  long rpx;
  short iface;
  Char qrg[256];

  debug(1, 0, 123, "transmitting...");
  boxsetbmouse();
  sprintf(statustext, "< %%u > dpbox v%%v - %s", Console_call);
  strcpy(mailtext, "Mail for :%r");
  strcpy(adress, "MAIL");
  
  tnc = 0;

  if (balisesize > 0) {
    rp = 0;
    do {
      get_line(balisebuf, &rp, balisesize, hs);
      get_word(hs, w);
      upper(w);
      if (!strcmp(w, "STATUSTEXT"))
	strcpy(statustext, hs);
      else if (!strcmp(w, "MAILTEXT"))
	strcpy(mailtext, hs);
    } while (rp < balisesize);
  }

  expand_macro(-1, statustext);
  expand_macro(-1, mailtext);

  sfbread(true, ofiname, &btbuff, &btsize);
  if (btbuff != NULL) {
    rp = 0;
    *qrg = '\0';
    while (rp < balisesize) {
      found = false;
      get_line(balisebuf, &rp, balisesize, hs);
      upper(hs);
      get_word(hs, w);
      if (!strcmp(w, "QRG")) {
	get_word(hs, w);
	upper(w);
	iface = -1;
	if (find_socket(w, &iface)) {
	  strcpy(adress, hs);
	  strcpy(qrg, w);
	  found = true;
	}
      }
      if (!found)  /* jetzt wird's ernst */
	continue;
      boxpushunproto(tnc);
      boxsetunproto(tnc, adress, iface, qrg);
      chan = boxgettncmonchan(tnc);
      strcpy(hs, statustext);
      if (*hs != '\0')
	boxsendpline(chan, hs, true, iface);
      if (btsize > 0) {  /* Calls senden */
	plen = boxgetpaclen(chan);
	rpx = 0;
	while (rpx < btsize) {
	  *hs = '\0';
	  strcpy(hs2, mailtext);
	  x = strlen(hs2);
	  while (x > 0 && hs2[x - 1] != '\015')
	    x--;
	  if (hs2[x - 1] == '\015') {
	    sprintf(hs, "%.*s", x, hs2);
	    strdelete((void *)hs2, 1, x);
	  }

	  while (strlen(hs) + strlen(hs2) < plen - 9 && rpx < btsize) {
	    if (strlen(hs2) >= 72) {
	      sprintf(hs + strlen(hs), "%s \015", hs2);
	      *hs2 = '\0';
	    }
	    get_line(btbuff, &rpx, btsize, w);
	    if (*hs2 != '\0')
	      sprintf(hs2 + strlen(hs2), " %s", w);
	    else
	      strcpy(hs2, w);
	  }
	  strcat(hs, hs2);
	  boxsendpline(chan, hs, true, iface);
	}

      }
      boxpopunproto(tnc);
    }
    mymfreep(&btbuff);
  }

  boxsetamouse();
}


void show_mailbeacon(void)
{
  short x, ofi, result;
  boolean noch;
  userstruct uf;
  Char ofiname[256];
  Char ofiname2[256];
  Char hs[256];
  DTA dirinfo;
  Char STR1[256];

  debug0(3, 0, 123);
  boxsetbmouse();

  sprintf(ofiname2, "%sBALISE%cTX", tempdir, extsep);

  if (balisenumber == 0) {
    laststartbalise = clock_.ixtime;

    sprintf(ofiname, "%sBALISE%cDIR", tempdir, extsep);

    sfdelfile(ofiname2);

    ofi = sfcreate(ofiname, FC_FILE);
    if (ofi >= minhandle) {
      sprintf(STR1, "%s%c%c%s", indexdir, allquant, extsep, idx_e);
      result = sffirst(STR1, 0, &dirinfo);
      while (result == 0) {
	strcpy(hs, dirinfo.d_fname);
	del_ext(hs);
	cut(hs, 8);
	upper(hs);
	if (callsign(hs))
	  string_to_file(&ofi, hs, true);
	result = sfnext(&dirinfo);
      }
      sfclose(&ofi);
      baliseh1 = sfopen(ofiname, FO_READ);
    }
  }

  ofi = baliseh1;
  if (ofi >= minhandle) {
    if (file_to_string(ofi, hs)) {
      balisenumber++;

      noch = false;
      for (x = 1; x <= maxuser; x++) {   /* user ist grade im sf eingeloggt */
	if (user[x] != NULL) {
	  if (!strcmp(user[x]->call, hs)) {
	    if (user[x]->f_bbs)
	      noch = true;
	  }
	}
      }

      if (!noch && boxcheck(false, hs) > 0) {
	load_userfile(true, false, hs, &uf);
	if (!uf.hidebeacon)
	  append(ofiname2, hs, true);
      }

    } else {
      sfclosedel(&baliseh1);
      sort_file(ofiname2);
      show_mailbeacon2(ofiname2);
      sfdelfile(ofiname2);
      lastbalise = laststartbalise;
      balisenumber = 0;
    }

  } else {
    lastbalise = laststartbalise;
    balisenumber = 0;
    sfdelfile(ofiname2);
  }



  boxsetamouse();
}


void balise_check(void)
{
  if (balisenumber == 0 &&
      (clock_.ixtime - lastbalise >= balisetime ||
       clock_.ixtime - lastbalise < 0))
    show_mailbeacon();
}


void start_mailbeacon_manually(short unr)
{
  long sec;
  Char hs[256];
  Char STR7[256];

  if (balisenumber == 0) {
    show_mailbeacon();
    wlnuser(unr, "OK, processing mail beacon");
    return;
  }
  sec = clock_.ixtime - laststartbalise;
  sprintf(hs, "%ld", sec);
  sprintf(STR7, "mail beacon generation in process since %s seconds", hs);
  wlnuser(unr, STR7);
}


Static long lastxgartime;


Static void chk_xgar(void)
{
  if (lastxgartime == 0) {
    lastxgartime = clock_.ixtime;
    return;
  }

  if (!x_garbage_waiting)
    return;

  if (clock_.ixtime - lastxgartime <= 300) /* 5 Minuten */
    return;

  garbage_collection(true, false, false, false, -1);
  /* Rubrik 'X' aufraeumen */
  lastxgartime = clock_.ixtime;
}



Static void retarded_msg(short unr)
{
  short x, k;
  Char hs[256];
  Char STR1[256];

  x = str2disturb_chan(user[unr]->call);
  if (x <= 0)
    return;
  user[unr]->newmsg = false;
  sprintf(STR1, "%s%s%cMSG", boxstatdir, user[unr]->call, extsep);
  k = sfopen(STR1, FO_READ);
  if (k < minhandle)
    return;
  while (file_to_string(k, hs))
    wlnuser(x, hs);
  sfclosedel(&k);
  show_prompt(x);
}


Static boolean immediate_zombiecheck;


void add_zombie(long pid)
{
  zombietype *zz;

  if (pid <= 0)
    return;
  zz = Malloc(sizeof(zombietype));
  if (zz == NULL)
    return;
  zz->pid = pid;
  if (zombieroot == NULL) {
    zz->next = NULL;
    zombieroot = zz;
  } else {
    zz->next = zombieroot->next;
    zombieroot->next = zz;
  }
  immediate_zombiecheck = true;
}


void kill_zombies(void)
{
  zombietype *zz, *hz, *hz1;
  long ret;
  int li;

  zz = zombieroot;
  hz = NULL;
  while (zz != NULL) {
    ret = waitpid(zz->pid, &li, DP_WNOHANG);
    if (ret != -1 && ret != zz->pid) {
      hz = zz;
      zz = zz->next;
      continue;
    }

    if (ret == zz->pid)
      kill(-zz->pid, DP_SIGHUP);

    hz1 = zz;
    zz = zz->next;
    Free(hz1);

    if (hz != NULL) {
      hz->next = zz;
      hz = zz;
    } else
      zombieroot = zz;
  }
}


Static short lastbatchhour;
Static long ltc1, ltc2, ltc3, ltc4, ltc5;


void box_timing2(long tct)
{
  short unr;
  long ret;
  int li;
  Char w[256];
  Char STR1[256], STR7[256];


  if (ltc1 == 0) {
    ltc1 = tct;
    ltc2 = tct;
    ltc3 = tct;
    ltc4 = tct;
    ltc5 = tct;
    return;
  }


  if (tct - ltc5 > 228000L || tct - ltc5 < 0) {  /* alle 19 Minuten */
    fill_msgnumarr();
    ltc5 = statclock();
  }

  if (tct - ltc1 > 120000L || tct - ltc1 < 0) {  /* alle 10 Minuten */
    /*       if badtimecount > 20 then begin
                badtimecount := -1;
                if is_german(console_call) then w := 'Die Systemuhr ist vermutlich falsch gestellt. Bitte korrigieren.'
                else w := 'The system clock appears to be set incorrect. Please adjust.';
                send_sysmsg('Y',console_call,'wrong system time!',w,2);
            end; */

    recompile_log(-1);
    recompile_fwd();

    if (clock_.ixtime - lastwpcreate >= wpcreateinterval)
      generate_wp_files();
    sprintf(STR1, "%slostfile%cbox", boxprotodir, extsep);
    chkopenfiles(43200, STR1);   /* nach 12 Stunden */
    ltc1 = statclock();
    smode_timer(-1, tct);
    boxisbusy(false);
  }


  if (tct - ltc2 > 12200 || tct - ltc2 < 0) {  /* alle 61 Sekunden */
    sprintf(STR1, "%simport%c%c", newmaildir, extsep, allquant);
    sort_new_mail(-1, STR1, Console_call);
    sprintf(STR1, "%s%c%c%c", impmaildir, allquant, extsep, allquant);
    sort_new_mail(-1, STR1, "-moni-");

    if (sf_allowed)
      check_sftimer();

    if (mail_beacon && balisetime > 0)
      balise_check();

    if (clock_.hour == garbagetime && garbage_done == false && auto_garbage)
      garbage_waiting = true;
    else if (clock_.hour != garbagetime) {
      garbage_waiting = false;
      garbage_done = false;
    }

    if (clock_.hour != lastbatchhour) {
      if (lastbatchhour == -1)
	lastbatchhour = clock_.hour;
      else {
	lastbatchhour = clock_.hour;
	if (lastbatchhour == 0) {
	  badtimecount = 0;
	  readjust_dayly_sfcount();
	}
	sprintf(w, "%ld", lastbatchhour);
	sprintf(STR7, "%shour_%s%cbat", boxsysdir, w, extsep);
	run_sysbatch(STR7);
	sprintf(STR7, "%shour%cbat", boxsysdir, extsep);
	run_sysbatch(STR7);
      }
    }

    if (tell_waiting)
      tell_check();

    if (garbage_waiting) {
      if (auto_garbage) {
	if (!boxgbstop()) {
	  garbage_collection(false, false, false, false, -1);
	  garbage_done = true;
	  garbage_waiting = false;
	} else
	  garbage_waiting = false;
      } else
	garbage_waiting = false;
    }

    ltc2 = statclock();

  }



  if (immediate_extcheck || tct - ltc4 > 200 || tct - ltc4 < 0)
  {  /* alle 1 Sekunde */
    immediate_extcheck = false;
    ltc4 = tct;

    if (send_bbsbcast) {
      if (get_boxruntime_l() > 60)
        boxbcasttxtimer();
    }

    for (unr = 1; unr <= maxuser; unr++) {
      if (boxrange(unr)) {
	if (user[unr]->trace_to > 0) {
	  if (*user[unr]->tracefract != '\0') {
	    *w = '\0';
	    trace_string(false, unr, user[unr]->trace_to, w, true);
	  }
	}

	if (user[unr]->newmsg)
	  retarded_msg(unr);

	if (user[unr]->action == 96) {
	  if (user[unr]->yapp != NULL) {
	    if (boxspoolstatus(user[unr]->tcon, user[unr]->pchan, -1) <=
		maxuserspool)
	    {  /* auch in box.pas */
	      if (!read_filepart(unr))
		user[unr]->action = 0;
	    } else if (clock_.ixtime - user[unr]->yapp->touch > 20)
	      sfclose(&user[unr]->yapp->filefd);
	  } else {
	    if (user[unr]->bin == NULL)
	      user[unr]->action = 0;
	    else if (boxspoolstatus(user[unr]->tcon, user[unr]->pchan, -1) <=
		     maxuserspool) {
	      if (!read_filepart(unr))
		user[unr]->action = 0;
	    } else if (clock_.ixtime - user[unr]->bin->touch > 20)
	      sfclose(&user[unr]->bin->filefd);
	  }
	}

	if (user[unr]->wait_pid > 0) {
	  ret = waitpid(user[unr]->wait_pid, &li, DP_WNOHANG);
	  if (ret == -1 || ret == user[unr]->wait_pid) {
	    if (ret == user[unr]->wait_pid)
	      close_shell(unr);

	    user[unr]->wait_pid = -1;
	    boxsetrwmode(user[unr]->pchan, 0);

	    switch (user[unr]->action) {

	    case 71:
	      user[unr]->action = 0;
	      show_sortcheck(unr);
	      show_prompt(unr);
	      break;

	    case 99:
	      user[unr]->action = 0;
	      show_ext_command_result(unr);
	      show_prompt(unr);
	      break;
	    }

	  }
	}

	if ((unsigned)user[unr]->action < 32 &&
	    ((1L << user[unr]->action) & 0xc000L) != 0)
	  spoolendcheck(unr);

      }

    }
  }

  if (immediate_zombiecheck) {
    kill_zombies();
    immediate_zombiecheck = false;
  }

  if (tct - ltc3 > 6200 || tct - ltc3 < 0) {  /* alle 31 Sekunden */
    dp_watchdog(2, 4711);

    for (unr = 1; unr <= maxuser; unr++) {
      if (boxrange(unr)) {
	if (user[unr]->f_bbs &&
	    (user[unr]->action >= 200 && user[unr]->action <= 205))
	  look_for_mail(unr, true, false);
	else if (user[unr]->f_bbs &&
		 (user[unr]->action >= 300 && user[unr]->action <= 305))
	  send_fbb_proposals(unr, true);
	else
	  timeout_check(unr);

      }

    }

    kill_zombies();
    chk_xgar();
    ltc3 = statclock();
  }


  box_get_next_input();
  if (newmailroot != NULL)
    sort_new_mail4();
  if (balisenumber > 0)
    show_mailbeacon();
  if (new_mybbs_data)
    do_emt(&mybbsseekp);
  if (new_remote_erases)
    check_remote_erase(&remerseekp);


  /* auch in box.pas */

}


void _box_tim_init(void)
{
  static int _was_initialized = 0;
  if (_was_initialized++)
    return;
  baliseh1 = nohandle;
  balisenumber = 0;
  lastbatchhour = -1;
  lastxgartime = 0;
  ltc1 = 0;
  ltc2 = 0;
  ltc3 = 0;
  ltc4 = 0;
  ltc5 = 0;
  immediate_zombiecheck = false;
}



/* End. */
