/* Output from p2c, the Pascal-to-C translator */
/* From input file "box_send.p" */


/************************************************************/
/*                                                          */
/* DigiPoint SourceCode                                     */
/*                                                          */
/* Copyright (c) 1991-1995 Joachim Schurig, DL8HBS, Berlin  */
/*                                                          */
/* For license details see documentation                    */
/*                                                          */
/************************************************************/


#include "defs.h"

#define BOX_SEND_G
#include "box_send.h"


#ifndef TOOLS_H
#include "tools.h"
#endif

#ifndef CRC_H
#include "crc.h"
#endif

#ifndef YAPP_H
#include "yapp.h"
#endif

#ifndef BOXLOCAL_H
#include "boxlocal.h"
#endif

#ifndef BOX_H
#include "box.h"
#endif

#ifndef BOX_SYS_H
#include "box_sys.h"
#endif

#ifndef BOX_SUB_H
#include "box_sub.h"
#endif

#ifndef BOX_FILE_H
#include "box_file.h"
#endif

#ifndef BOX_MEM_H
#include "box_mem.h"
#endif

#ifndef BOX_SF_H
#include "box_sf.h"
#endif

#ifndef BOX_TIM_H
#include "box_tim.h"
#endif

#ifndef BOX_INOU_H
#include "box_inou.h"
#endif

#ifndef BOX_SERV_H
#include "box_serv.h"
#endif


Static void disp_sh(short unr)
{
  if (!boxrange(unr))
    return;
  if (user[unr]->sendheader != NULL)
    Free(user[unr]->sendheader);
  user[unr]->sendheader = NULL;
}


#define blocksize       4096


boolean send_file1(short unr, short *kanal, boolean in_send, short force_bin)
{
  boolean Result;
  long size, hsize, ct, ctold;
  uchar *puffer;
  long psize;
  boolean is_bin, werror;
  short x;
  unsigned short crc;
  Char hs[256];
  Char w[256];
  Char STR1[256];

  debug0(3, unr, 29);
  Result = false;
  is_bin = (force_bin == 2);
  size = sfseek(0, *kanal, SFSEEKEND);
  sfseek(0, *kanal, SFSEEKSET);
  psize = blocksize;
  if (psize > size)
    psize = size;

  dpgetmem(&puffer, psize);
  if (puffer != NULL) {
    sfread(*kanal, psize, puffer);

    if (!is_bin && force_bin != 1) {
      for (ct = 0; ct < psize; ct++) {
	if (puffer[ct] > 168 && puffer[ct] != 225) {
	  is_bin = true;
	  goto _L1;
	}
      }

_L1:
      if (is_bin) {  /* koennte auch ein 7PLUS-File sein */
	ct = 0;
	x = 0;
	while (ct < psize && x < 50 && is_bin) {
	  x++;
	  ctold = ct;
	  get_line(puffer, &ct, psize, hs);
	  if (ct - ctold > 80)
	    x = 100;
	  else if (strpos2(hs, " go_7+. ", 1) == 1)
	    is_bin = false;
	}
	if (x != 100)
	  is_bin = false;
      }

    }


    if (is_bin) {
      Result = true;
      string_to_file(&user[unr]->sendchan, "", true);
      string_to_file(&user[unr]->sendchan, "*** binary file ***", true);
      string_to_file(&user[unr]->sendchan, "", true);
      crc = 0;
      crcthp_buf(puffer, psize, &crc);
      hsize = psize;
      ct = 1;
      while (hsize < size && ct > 0) {
	ct = size - hsize;
	if (ct > psize)
	  ct = psize;
	ct = sfread(*kanal, ct, puffer);
	hsize += ct;
	crcthp_buf(puffer, ct, &crc);
      }
      sprintf(hs, "%ld", size);
      sprintf(w, "%ld", crc);
      sprintf(hs, "#BIN#%s#|%s#$1EDEADF1#%s",
	      strcpy(STR1, hs), w, user[unr]->tempbinname);
      string_to_file(&user[unr]->sendchan, hs, true);
      if (in_send)
	wlnuser(unr, hs);
    }

    sfseek(0, *kanal, SFSEEKSET);
    werror = false;
    hsize = 0;
    ct = 1;
    while (hsize < size && ct > 0) {
      ct = size - hsize;
      if (ct > psize)
	ct = psize;
      ct = sfread(*kanal, ct, puffer);
      if (ct <= 0)
	break;
      if (sfwrite(user[unr]->sendchan, ct, puffer) == ct) {
	if (in_send && !is_bin && user[unr]->umode != UM_SYSREQ && user[unr]->tcon > 0)
	      /* damit der Sysop auch sieht, was er einspielt... */
		show_puffer(unr, puffer, ct);
	hsize += ct;
      } else
	ct = 0;
      if (ct == 0)
	werror = true;
    }
    dpfreemem(&puffer, psize);
    if (werror)
      wlnuser(unr, "write error, please delete imported file manually");
  } else
    wlnuser(unr, memfailtxt);

  sfclose(kanal);
  return Result;
}

#undef blocksize


void send_text3(short unr, boolean first, Char *eingabe_, boolean return_)
{
  Char eingabe[256];
  short x;
  boolean invalid, endflag, delmsg, exitflag;
  short snmunr;
  Char hs[256];
  userstruct *WITH;
  Char STR1[256];

  strcpy(eingabe, eingabe_);
  if (!boxrange(unr))
    return;

  WITH = user[unr];
  disp_sh(unr);

  invalid = (WITH->sendchan < minhandle);
  endflag = false;
  exitflag = false;
  snmunr = -1;

  if (!WITH->f_bbs) {
    if (strpos2(eingabe, "\030", 1) > 0) {
      exitflag = true;   /*abort mit ctrl-x*/
      endflag = true;
    } else if (strpos2(eingabe, "\032", 1) > 0)
      endflag = true;
    else {
      if (strpos2(eingabe, "***", 1) > 0)
	endflag = (uspos("***END", eingabe) > 0);
      else if (useq("/EX", eingabe))
	endflag = true;
      else
	endflag = (strcmp("NNNN", eingabe) == 0);
    }
  } else {
    if (strpos2(eingabe, "\032", 1) > 0)
	  /* das '/EX' bei DieBox rausfiltern */
	    endflag = true;
    else if (WITH->sf_level == 1)
      endflag = useq("/EX", eingabe);
    else if (useq(eingabe, "/EX"))
      invalid = true;
  }

  if (endflag) {
    strcpy(WITH->lastcmd, "^Z");
    debug(3, unr, 30, eingabe);
    x = uspos("***END", eingabe);
    if (x == 0) {
      if (useq(eingabe, "/EX"))
	x = 1;
    }
    if (x == 0) {
      if (!strcmp(eingabe, "NNNN"))
	x = 1;
    }
    if (x == 0)
      x = strpos2(eingabe, "\032", 1);

    if (x > 1) {
      delmsg = false;
      strcpy(hs, eingabe);
      cut(hs, x - 1);
      if (!invalid)
	string_to_file(&WITH->sendchan, hs, true);
    } else
      delmsg = first;
    if (exitflag)
      delmsg = true;

    if (!invalid)
      sfclose(&WITH->sendchan);
    WITH->sendchan = nohandle;
    if (WITH->f_bbs) {
      if (*WITH->tempbid != '\0') {
	write_msgid(-1, WITH->tempbid);
	/*                   readressing := true; */
	snmunr = -77;
      }
      *WITH->tempbid = '\0';

      if (WITH->sf_level < 3) {
	if (!invalid)
	  sort_new_mail(snmunr, WITH->input2, Console_call);
	WITH->input2[0] = '\0';
	if (WITH->sf_level == 1 && WITH->sf_master)
	  wlnuser(unr, "F>");
	else {
	  chwuser(unr, '>');
	  wlnuser0(unr);
	}
	WITH->action = 5;
	return;
      }
      /*               readressing := false; */
      if (!invalid)
	sort_new_mail(snmunr, WITH->input2, Console_call);
      WITH->input2[0] = '\0';
      prepare_for_next_fbb(unr);
      return;
    }
    WITH->action = 0;
    if (delmsg) {  /* Leere Nachricht, loeschen. */
      sfdelfile(WITH->input2);
      wln_btext(unr, 11);
    } else {
      wln_btext(unr, 6);
      if (!invalid) {   /*unr*/
	sort_new_mail(-1, WITH->input2, Console_call);
	if (WITH->in_reply)
	  set_reply_flag(unr, WITH->reply_brett, WITH->reply_nr);
      }

      /* hier steht jetzt -1, damit der Router das Maul hlt   */
      /* beim manuellen SEND-Befehl wissen wir ja schon,       */
      /* wohin die Reise geht...                               */

      WITH->input2[0] = '\0';
    }
    WITH->in_reply = false;
    return;
  }

  if (invalid)
    return;
  if (!WITH->isfirstchar) {
    string_to_file(&WITH->sendchan, eingabe, return_);
    return;
  }
  if (true_bin(eingabe)) {
    if (WITH->pchan > 0) {
      WITH->errors = -5;
      boxprwprg2(WITH->pchan, eingabe);
    } else
      wlnuser(unr, "#BIN# not allowed in terminal mode...");
    return;
  }
  if (strpos2(eingabe, "!$%&#B()%$IN#=(&\335@", 1) != 1) {
    string_to_file(&WITH->sendchan, eingabe, return_);
    return;
  }
  WITH->errors = -5;
  strcpy(hs, eingabe);
  strdelete((void *)hs, 1, 18);
  sprintf(hs, "#BIN#%s", strcpy(STR1, hs));
  if (true_bin(hs))
    string_to_file(&WITH->sendchan, hs, return_);
  else
    string_to_file(&WITH->sendchan, eingabe, return_);
}


Static void open_sendfile(short unr)
{
  short k, handle;
  boolean ackmsg, had_no_bid, reject_it, hold_it;
  Char mtyp;
  short sps;
  userstruct uf;
  Char bid[13];
  Char mbx[41], umbx[41];
  Char sname[256];
  Char hw[256], toc[256];
  Char fromcall[7];
  Char hs[256], w[256];
  userstruct *WITH;
  Char STR1[256], STR7[256];

  debug0(3, unr, 31);
  if (!(boxrange(unr) && user[unr]->sendheader != NULL))
    return;

  WITH = user[unr];
  ackmsg = (strpos2(WITH->sendheader->betreff, "ACK:", 1) == 1);

  had_no_bid = false;
  strcpy(bid, WITH->sendheader->id);
  if (!strcmp(bid, "#NONE#")) {
    if (WITH->f_bbs && !callsign(WITH->brett)) {
      abort_sf(unr, false, "missing bulletin ID");
      return;
    }
    new_bid(bid);
    if (WITH->f_bbs)
      had_no_bid = true;
  }

  strcpy(sname, "001");
  if (WITH->f_bbs) {
    if (WITH->is_authentic) {
      if (had_no_bid)
	sprintf(sname, "%s&_%s%c%s",
		newmaildir, WITH->call, extsep, strcpy(STR7, sname));
      else
	sprintf(sname, "%s&%s%c%s",
		newmaildir, WITH->call, extsep, strcpy(STR1, sname));
    } else {
      if (had_no_bid)
	sprintf(sname, "%s%%_%s%c%s",
		newmaildir, WITH->call, extsep, strcpy(STR7, sname));
      else
	sprintf(sname, "%s%%%s%c%s",
		newmaildir, WITH->call, extsep, strcpy(STR1, sname));
    }
  } else {
    if (WITH->is_authentic)
      sprintf(sname, "%s&SENDING%c%s",
	      newmaildir, extsep, strcpy(STR1, sname));
    else
      sprintf(sname, "%s%%SENDING%c%s",
	      newmaildir, extsep, strcpy(STR1, sname));
  }
  validate(sname);
  WITH->sendchan = sfcreate(sname, FC_FILE);
  if (WITH->sendchan < minhandle) {
    WITH->sendchan = nohandle;
    debug(0, unr, 31, "cannot create file");
    if (WITH->f_bbs)
      abort_sf(unr, false, "file system error");
    else {
      WITH->action = 0;
      wln_btext(unr, 98);
    }
    return;
  }

  mtyp = WITH->sendheader->msgtype;

  strcpy(mbx, WITH->sendheader->verbreitung);

  strcpy(fromcall, WITH->sendheader->absender);

  handle = nohandle;
  k = strpos2(WITH->input2, "%", 1);
  if (k > 0) {
    sprintf(hs, "%c%c%c%c%c",
	    WITH->input2[k], WITH->input2[k + 1], WITH->input2[k + 2],
	    WITH->input2[k + 3], WITH->input2[k + 4]);
    del_leadblanks(hs);
    handle = Str2int(hs);
  }


  create_status(0, true, WITH->sendheader->dest, *WITH->sendheader,
		WITH->input2);
  string_to_file(&WITH->sendchan, WITH->input2, true);
  string_to_file(&WITH->sendchan, WITH->sendheader->betreff, true);
  sprintf(hs, "*** Bulletin-ID: %s ***", bid);
  string_to_file(&WITH->sendchan, hs, true);

  string_to_file(&WITH->sendchan, "", true);
  if (WITH->f_bbs == false && ackmsg == false) {
    /*           if (mybbs <> '') and (pos(console_call,mybbs) <> 1) then
                    sps := 8
                else */
    sps = 4;

    *toc = '\0';

    sprintf(hs, "%s @ %s", WITH->call, ownhiername);
    upper(hs);
    strcpy(hw, "From");
    rspacing(hw, sps);
    sprintf(hs, "%s: %s", hw, strcpy(STR7, hs));
    if (*WITH->name != '\0')
      sprintf(hs + strlen(hs), " (%s)", WITH->name);
    cut(hs, 80);
    string_to_file(&WITH->sendchan, hs, true);

    k = strpos2(WITH->input2, "de:", 1);
    if (k > 1) {
      sprintf(hs, "%.*s", k - 1, WITH->input2);
      k = strpos2(hs, "@", 1);
      if (k > 0) {
	sprintf(toc, "%.*s", k - 1, hs);
	del_lastblanks(toc);   /* zur spteren Einfgung des Namens */
	if (hs[k] != ' ')
	  strinsert(" ", (void *)hs, k + 1);
	if (hs[k - 2] != ' ')
	  strinsert(" ", (void *)hs, k);
      }
    } else
      *hs = '\0';
    upper(hs);
    strcpy(hw, "To");
    rspacing(hw, sps);
    sprintf(hs, "%s: %s", hw, strcpy(STR1, hs));
    string_to_file(&WITH->sendchan, hs, true);

    if (*WITH->mybbs != '\0' && strpos2(WITH->mybbs, Console_call, 1) != 1) {
      strcpy(w, WITH->mybbs);
      complete_hierarchical_adress(w);
      sprintf(hs, "%s @ %s", WITH->call, w);
      upper(hs);
      strcpy(hw, "Reply-To");
      rspacing(hw, sps);
      sprintf(hs, "%s: %s", hw, strcpy(STR7, hs));
      string_to_file(&WITH->sendchan, hs, true);
    }

    if (!WITH->is_authentic) {   /* and not(callsign(brett)) */
      if (authentinfo) {
	sig_german_authinfo(WITH->call, mbx, hs);
	string_to_file(&WITH->sendchan, hs, true);
      }
    }

    /*           if bid <> '#NONE#' then begin
                    hs  := concat('Message-Id: <',bid,'>');
                    string_to_file(sendchan,hs,true);
                end; */

    string_to_file(&WITH->sendchan, "", true);

  }

  strcpy(WITH->input2, sname);

  unhpath(mbx, umbx);

  if (WITH->f_bbs && !strcmp(WITH->brett, "T")) {
    if (!strcmp(umbx, Console_call))
      tell_command(fromcall, bid, WITH->sendheader->betreff);
  }

  if (handle >= minhandle) {
    send_file1(unr, &handle, false, 0);
    strcpy(hs, "***END");
    send_text3(unr, false, hs, true);
    return;
  }
  if (WITH->f_bbs) {
    if (WITH->sf_level <= 2) {
      WITH->action = 7;
      return;
    }
    if (WITH->fwdmode > 0) {
      WITH->action = 28;
      set_packsf(unr);
    } else
      WITH->action = 28;
    return;
  }
  reject_it = false;
  hold_it = false;

  if (!strcmp(umbx, Console_call) && in_servers(WITH->brett))
    wlnuser(unr, "mailing list server");
  else {
    strcpy(hs, WITH->brett);
    check_verteiler(hs);
    switch_to_default_board(hs);
    *w = '\0';

    if (mtyp == '\0') {
      if (callsign(hs))
	mtyp = 'P';
      else
	mtyp = 'B';
    }

    /*local?*/
    do_convtit(w, mtyp, hs, mbx, WITH->call, w, WITH->sendheader->betreff,
	       bid, 50, true, WITH->is_authentic, &reject_it, &hold_it);

    if (!reject_it) {
      if (hold_it) {
	if (!WITH->is_authentic) {
	  if (holddelay > 0) {
	    sprintf(w, "%ld", holddelay / 3600);
	    w_btext(unr, 109);
	    sprintf(w, " %s", strcpy(STR7, w));
	    wlnuser(unr, w);
	  }
	}
      }

      if (strcmp(WITH->brett, hs)) {
	w_btext(unr, 110);
	chwuser(unr, 32);
	wlnuser(unr, hs);
      }

    }


  }

  if (!reject_it) {
    w_btext(unr, 47);
    sprintf(hs, " %s @ %s", WITH->brett, mbx);
    if (callsign(WITH->brett)) {
      load_userfile(true, false, WITH->brett, &uf);
      if (*uf.name != '\0')
	sprintf(hs + strlen(hs), " (%s)", uf.name);
      if (uf.lastatime > 0 && !strcmp(umbx, Console_call)) {
	wlnuser(unr, hs);
	ix2string(uf.lastatime, hs);
	w_btext(unr, 54);
	sprintf(hs, " %s", strcpy(STR7, hs));
      } else if (uf.mybbsupd > 0 && *uf.mybbs != '\0') {
	wlnuser(unr, hs);
	w_btext(unr, 188);
	sprintf(hs, " %s ", uf.mybbs);
	wuser(unr, hs);
	w_btext(unr, 189);
	ix2string(uf.mybbsupd, hs);
	sprintf(hs, " %s", strcpy(STR7, hs));        
      }
    }
    wlnuser(unr, hs);

    wln_btext(unr, 48);
    wlnuser0(unr);
    WITH->action = 74;
    return;
  }


  WITH->action = 74;
  strcpy(w, "\030");
  send_text3(unr, true, w, true);


  /* reject */
}


Static void lt_request(short unr)
{
  if (!boxrange(unr))
    return;
  w_btext(unr, 111);
  chwuser(unr, 32);
}


void enter_lifetime(short unr, Char *eingabe)
{
  short k, handle;
  Char hs[256];
  userstruct *WITH;

  if (!boxrange(unr) || user[unr]->sendheader == NULL)
    return;

  if (zahl(eingabe)) {
    user[unr]->errors = 0;
    user[unr]->sendheader->lifetime = Str2int(eingabe);
    open_sendfile(unr);
    return;
  }

  if (strpos2(eingabe, "\032", 1) > 0 || strpos2(eingabe, "\030", 1) > 0 ||
      strpos2(eingabe, "***END", 1) > 0 ||
      strpos2(eingabe, "***end", 1) > 0 || !strcmp(eingabe, "/EX")) {
    WITH = user[unr];
    k = strpos2(WITH->input2, "%", 1);   /* Import aktiv ? */
    if (k > 0) {
      sprintf(hs, "%c%c%c%c%c",
	      WITH->input2[k], WITH->input2[k + 1], WITH->input2[k + 2],
	      WITH->input2[k + 3], WITH->input2[k + 4]);
      del_leadblanks(hs);
      handle = Str2int(hs);
      sfclose(&handle);
    }
    disp_sh(unr);
    WITH->action = 0;

    return;
  }
  wln_btext(unr, 39);
  lt_request(unr);
  user[unr]->errors++;
}


void box_txt2(boolean first, short unr, Char *betreff1_)
{
  Char betreff1[256];
  short k, handle;
  Char subject[256];
  Char hs[256];
  userstruct *WITH;

  strcpy(betreff1, betreff1_);
  debug(3, unr, 32, betreff1);
  if (!boxrange(unr)) {
    debug(0, unr, 32, "no such user!");
    return;
  }
  WITH = user[unr];
  strcpy(subject, betreff1);
  del_blanks(subject);
  cut(subject, 79);

  if (WITH->f_bbs && !first && *subject == '\0')
    sprintf(subject, "<empty subject forwarded by %s>", user[unr]->call);

  if (*subject == '\0') {
    if (WITH->f_bbs) {
      if (!first) {
	abort_sf(unr, true, "fatal error 34");
	return;
      }
      if (WITH->sf_level > 2)
	WITH->action = 27;
      else
	WITH->action = 6;
      if (WITH->fwdmode <= 0)
	return;
      WITH->binsfptr = Malloc(sizeof(binsftyp));
      if (WITH->binsfptr == NULL) {
	abort_sf(unr, false, "no binsfptr 1");
	return;
      }
      *WITH->binsfptr->fbbtitle = '\0';
      *WITH->binsfptr->wname = '\0';
      WITH->binsfptr->wchan = nohandle;
      WITH->binsfptr->blockcounter = SHORT_MAX;
      WITH->binsfptr->rxbytes = 0;
      WITH->binsfptr->validbytes = 0;
      WITH->binsfptr->fbbtitlelen = 0;
      WITH->binsfptr->offset = 0;
      boxsetrwmode(WITH->pchan, 7);
      return;
    }
    WITH->errors++;
    w_btext(unr, 50);
    WITH->action = 73;
    return;
  }
  if (strpos2(subject, "\032", 1) > 0 || strpos2(subject, "\030", 1) > 0 ||
      strpos2(subject, "***END", 1) > 0 ||
      strpos2(subject, "***end", 1) > 0 || !strcmp(subject, "/EX") ||
      *WITH->brett == '\0') {
    if (WITH->f_bbs) {
      write_msgid(-1, WITH->sendheader->id);
      abort_sf(unr, false, "invalid expression in <subject>");
      return;
    }
    WITH->errors = 0;
    handle = nohandle;
    k = strpos2(WITH->input2, "%", 1);   /* Import aktiv ? */
    if (k > 0) {
      sprintf(hs, "%c%c%c%c%c",
	      WITH->input2[k], WITH->input2[k + 1], WITH->input2[k + 2],
	      WITH->input2[k + 3], WITH->input2[k + 4]);
      del_leadblanks(hs);
      handle = Str2int(hs);
      sfclose(&handle);
    }
    disp_sh(unr);
    WITH->action = 0;
    return;
  }
  WITH->errors = 0;
  strcpy(WITH->sendheader->betreff, subject);
  if (!WITH->f_bbs && WITH->lt_required) {
    lt_request(unr);
    WITH->action = 91;
  } else
    open_sendfile(unr);
}


Static void send_text1(short unr, Char *call1, Char *mbx, Char *call2,
		       Char *lts, Char *bid, Char *betreff1, Char mtype)
{
  short handle;
  Char hs[256];
  indexstruct *WITH;

  debug(3, unr, 33, call1);
  strcpy(user[unr]->brett, call1);

  disp_sh(unr);

  user[unr]->sendheader = Malloc(sizeof(indexstruct));

  if (user[unr]->sendheader == NULL) {
    user[unr]->action = 0;
    return;
  }

  WITH = user[unr]->sendheader;

  strcpy(WITH->id, bid);
  strcpy(WITH->verbreitung, mbx);
  strcpy(WITH->dest, call1);
  strcpy(WITH->absender, call2);
  WITH->lifetime = Str2int(lts);
  WITH->rxdate = clock_.ixtime;
  WITH->msgtype = mtype;
  WITH->size = 999000L;
  if (*user[unr]->input2 != '\0') {
    handle = sfopen(user[unr]->input2, FO_READ);
    if (handle >= minhandle) {
      sprintf(hs, "%ld", handle);
      lspacing(hs, 5);
      sprintf(user[unr]->input2, "%%%s ", hs);
    } else
      *user[unr]->input2 = '\0';
  }

  box_txt2(true, unr, betreff1);
}


Static void check_acc(short unr, Char *b, unsigned short *ac)
{
  unsigned short mlt;

  mlt = 1;
  check_lt_acc(b, &mlt, ac);
  if (strlen(b) == 1) {
  
    if (!user[unr]->supervisor)
      *ac = 1000;
  }
}


Static boolean testtosys(Char *call)
{
  userstruct rec;

  if (!strcmp(call, Console_call))
    return true;
  else {
    load_userfile(true, false, call, &rec);
    return (rec.pwmode >= 10);
  }
}


void send_check(short unr, Char *eingabe, boolean is_user, Char msgtype)
{
  unsigned short acc;
  boolean c1isc, errok, ok, db, hadnolt;
  Char hs[256];
  Char brett1[9], call1[9];
  Char call2[7];
  Char lt[256];
  Char mbx[41];
  Char bid[13];
  Char mtyp;
  Char betreff[256];
  Char hmbx[41], hmbx2[41];
  userstruct *WITH;

  debug(3, unr, 34, eingabe);
  if (!boxrange(unr))
    return;
  WITH = user[unr];
  *WITH->tempbid = '\0';
  WITH->lt_required = false;

  strcpy(hs, eingabe);
  split_sline(eingabe, call1, call2, mbx, bid, lt, betreff);
  if (!strcmp(lt, "-")) {
    hadnolt = true;
    strcpy(lt, "0");
  } else
    hadnolt = false;
  if (is_user)
    upper(bid);
  if (is_user && !(WITH->supervisor || WITH->rsysop))
    strcpy(call2, WITH->call);
  else if (*call2 == '\0')
    strcpy(call2, WITH->call);
  if (strpos2(call1, "+", 1) > 0 && !WITH->f_bbs)
    *call1 = '\0';
  if (hs[0] == '\032' || !WITH->f_bbs && useq(hs, "***END")) {  /*Abbruch*/
    if (!WITH->f_bbs) {
      WITH->action = 0;
      return;
    }
    if (WITH->sf_level == 1 && WITH->sf_master)
      wlnuser(unr, "F>");
    else {
      chwuser(unr, '>');
      wlnuser0(unr);
    }
    WITH->action = 5;
    return;
  }
  if (*call1 == '\0') {
    /* or ((length(call1) = 1)
            and not(supervisor)
            and not(f_bbs)
            and (tell <> -99)
            and not(umode=UM_SYSREQ)) */


    if (!WITH->f_bbs) {
      w_btext(unr, 51);
      WITH->action = 72;
      return;
    }
    /* eigentlich quatsch, hier sollte nie was ankommen... */
    if (WITH->sf_level > 2) {
      abort_sf(unr, false, "*** invalid destination");
      return;
    }
    chwuser(unr, '>');
    wlnuser0(unr);
    WITH->action = 5;
    return;
  }

  c1isc = callsign(call1);
  acc = 1;
  errok = false;
  if (is_user) {
    if (!c1isc) {
      WITH->lt_required = (hadnolt && request_lt);
      *hs = '\0';
      ok = false;

      if (msgtype == '\0') {
	if (c1isc)
	  mtyp = 'P';
	else
	  mtyp = 'B';
      } else
	mtyp = msgtype;

      check_reject(hs, mtyp, call1, mbx, call2, hs, hs, bid, 0, false, false,
		   &ok, &db);

      ok = !ok;

      if (ok && valid_boardname(call1)) {
	strcpy(brett1, call1);
	check_acc(unr, brett1, &acc);
	if (WITH->level >= acc || may_sysaccess(unr, brett1)) { /* fuer die rsysops */
	  check_verteiler(brett1);
	  check_acc(unr, brett1, &acc);
	  if (WITH->level >= acc || may_sysaccess(unr, brett1)) {
	    switch_to_default_board(brett1);
	    check_acc(unr, brett1, &acc);
	    if (WITH->level >= acc || may_sysaccess(unr, brett1))
	      acc = 1;
	  }
	}
      } else
	acc = SHORT_MAX;
      if (WITH->level < acc) {
	wln_btext(unr, 7);
	errok = true;   /* 'Fehlermeldung bereits ausgegeben' */
      }
    }
  }

  if (!is_user || is_user && (WITH->se_ok || testtosys(call1)) && !errok) {
    unhpath(mbx, hmbx);

    if (*hmbx == '\0' || !strcmp(hmbx, Console_call) && WITH->f_bbs) {
      if (c1isc) {
	user_mybbs(call1, mbx);

	unhpath(mbx, hmbx2);

	if (is_user && *mbx == '\0') {
	  WITH->action = 0;
	  wln_btext(unr, 11);
	  wln_btext(unr, 112);
	  wln_btext(unr, 113);
	  return;
	}

	if (*mbx == '\0')
	  strcpy(mbx, Console_call);
	else if (WITH->f_bbs && strcmp(hmbx2, Console_call)) {
	  if (*bid != '\0')   /* alte BID sichern und nachher wegschreiben */
	    strcpy(WITH->tempbid, bid);
	  new_bid(bid);
	      /* bei neuem MyBBS muss! eine neue BID vergeben werden */
	}
	if (is_user && *bid != '\0' && strcmp(bid, "#NONE#")) {
	  if (!check_double(bid)) {  /* BID schon vorhanden */
	    WITH->action = 0;
	    wln_btext(unr, 2);
	    wln_btext(unr, 114);
	    wln_btext(unr, 11);
	    return;
	  }
	}

      } else
	strcpy(mbx, Console_call);

    } else if (c1isc && !callsign(hmbx) && !WITH->f_bbs)
      strcpy(mbx, Console_call);


    if (WITH->f_bbs && !strcmp(call1, "T")) {
      if (!strcmp(hmbx, Console_call))
	strcpy(lt, "1");
      else
	strcpy(lt, "7");
    }

    if (is_user || strpos2(mbx, ".", 1) == 0 && callsign(mbx))
      complete_hierarchical_adress(mbx);

    if (*mbx == '\0')
      strcpy(mbx, Console_call);

    if (is_user) {
      if (!gen_sftest2(unr, call1, mbx)) {
	WITH->action = 0;
	wln_btext(unr, 11);
	return;
      }
    }

    send_text1(unr, call1, mbx, call2, lt, bid, betreff, msgtype);
    return;
  }



  WITH->action = 0;
  if (!errok)
    wln_btext(unr, 65);


  /* wenn SEND und nicht privilegiert */
}


void send_file0(short unr, boolean in_send, Char *fname)
{
  short kanal;
  boolean ok;
  Char pfad[256], name[256];

  if (!boxrange(unr))
    return;
  sprintf(pfad, "%s%c%c%c", boxdir, allquant, extsep, allquant);
  *name = '\0';
  ok = false;

  if (*fname == '\0') {
    if (user[unr]->console) {
      if (select_file(unr, pfad, name, "import file"))
	ok = true;
    }
  } else {
    strcpy(name, fname);
    ok = true;
  }

  if (ok)
    ok = exist(name);

  if (!ok) {
    wln_btext(unr, 4);
    return;
  }
  if (in_send) {
    kanal = sfopen(name, FO_READ);
    del_path(name);
    strcpy(user[unr]->tempbinname, name);
    if (kanal >= minhandle) {
      if (send_file1(unr, &kanal, true, 0))  /* War ein Binaerfile */
	send_text3(unr, false, "***END", true);
    }
    return;
  }
  strcpy(user[unr]->input2, name);
  del_path(name);
  strcpy(user[unr]->tempbinname, name);
  *name = '\0';
  send_check(unr, name, false, '\0');
}


void send_sysmsg(Char *tocall, Char *tobbs_, Char *betreff_, Char *msg_,
		 short lt)
{
  Char tobbs[256], betreff[256], msg[256];
  short unr, kanal, force_bin;
  Char msgchar;
  Char hs[256];
  Char w[256];
  Char STR1[256];

  strcpy(tobbs, tobbs_);
  strcpy(betreff, betreff_);
  strcpy(msg, msg_);
  debug(3, -1, 35, tocall);
  unr = melde_user_an(Console_call, 0, 0, UM_SYSREQ, false);
  if (unr <= 0) {
    debug(0, -1, 35, "failed. no syslogin");
    return;
  }
  if (*tobbs != '\0')
    sprintf(tobbs, " @ %s", strcpy(STR1, tobbs));
  if (*betreff == '\0')
    strcpy(betreff, "Msg from SYSTEM");
  sprintf(hs, "%s%s < %s", tocall, tobbs, Console_call);
  if (lt > 0) {
    sprintf(w, "%ld", lt);
    sprintf(hs + strlen(hs), " #%s", w);
  }
  sprintf(hs + strlen(hs), " %s", betreff);
  if (!strcmp(tocall, "WP"))
    msgchar = 'P';
  else
    msgchar = '\0';
  send_check(unr, hs, false, msgchar);
  if (msg[0] == '%' || msg[0] == '&') {
    if (msg[0] == '%')
      force_bin = 2;
    else
      force_bin = 1;
    strdelete((void *)msg, 1, 1);
    if (exist(msg)) {
      kanal = sfopen(msg, FO_READ);
      del_path(msg);
      strcpy(user[unr]->tempbinname, msg);
      if (kanal >= minhandle)
	send_file1(unr, &kanal, true, force_bin);
      else
	send_text3(unr, false, "*** read error", true);
    }
  } else {
    *hs = '\0';
    send_text3(unr, false, hs, true);
    send_text3(unr, false, msg, true);
  }
  send_text3(unr, false, "***END", true);
  melde_user_ab(unr, false);
}




void _box_send_init(void)
{
  static int _was_initialized = 0;
  if (_was_initialized++)
    return;
}



/* End. */
