/* Output from p2c, the Pascal-to-C translator */
/* From input file "box_mem.p" */


/************************************************************/
/*                                                          */
/* DigiPoint SourceCode                                     */
/*                                                          */
/* Copyright (c) 1991-1996 Joachim Schurig, DL8HBS, Berlin  */
/*                                                          */
/* For license details see documentation                    */
/*                                                          */
/************************************************************/


#include "defs.h"

#define BOX_MEM_G
#include "box_mem.h"


#ifndef TOOLS_H
#include "tools.h"
#endif

#ifndef MISC_OS_H
#include "misc_os.h"
#endif

#ifndef BOX_INOU_H
#include "box_inou.h"
#endif

#ifndef BOX_FILE_H
#include "box_file.h"
#endif

#ifndef BOX_SF_H
#include "box_sf.h"
#endif

#ifndef BOX_SUB_H
#include "box_sub.h"
#endif

#ifndef BOXFSERV_H
#include "boxfserv.h"
#endif

#ifndef SORT_H
#include "sort.h"
#endif


#define hashsize        1023

#define minfreeafterbid  300000L


typedef struct hashrecord {
  long offset;
  struct hashrecord *next;
} hashrecord;

typedef hashrecord *hasharr[hashsize + 1];


Static hashrecord **hboxhash, **bidhash;


/* ---------------------------------------------------------------- */

Static void clear_hash(hashrecord ***hash)
{
  long x;
  hashrecord *p1, *p2;

  debug0(5, -1, 128);
  if (*hash == NULL)
    return;
  for (x = 0; x <= hashsize; x++) {
    p1 = (*hash)[x];
    while (p1 != NULL) {
      p2 = p1->next;
      Free(p1);
      p1 = p2;
    }
  }
  Free(*hash);
  *hash = NULL;
}


Static long calc_hashcs(Char *token)
{
  short x, y;
  long cs;

  cs = 0;
  y = strlen(token);
  if (y > 12)
    y = 12;
  for (x = 1; x <= y; x++)
    cs += ((token[x - 1] & 0x7f) - 33) * x * 3;
  if (cs < 0)
    cs = -cs;
  cs %= hashsize + 1;
  if ((unsigned long)cs > hashsize) {
    debug(0, -1, 153, token);
    cs = hashsize;
  }
  return cs;
}


Static boolean add_hash(hashrecord **hash, long offs, Char *token,
			boolean deb)
{
  boolean Result;
  long cs;
  hashrecord *p1, *p2;

  if (deb)
    debug0(5, 0, 129);
  Result = true;
  if (hash == NULL)
    return Result;
  cs = calc_hashcs(token);
  if (hash[cs] == NULL) {
    p1 = Malloc(sizeof(hashrecord));
    if (p1 == NULL) {
      Result = false;
      debug(0, 0, 129, "no mem (1)");
      return Result;
    }

    p1->next = NULL;
    p1->offset = offs;
    hash[cs] = p1;
    return Result;
  }
  p1 = hash[cs];
  while (p1->next != NULL)
    p1 = p1->next;
  p2 = Malloc(sizeof(hashrecord));
  if (p2 == NULL) {
    Result = false;
    debug(0, 0, 129, "no mem (2)");
    return Result;
  }
  p2->next = NULL;
  p2->offset = offs;
  p1->next = p2;
  return Result;
}


Static void delete_hash_offset(hashrecord **hash, long offset)
{
  long ct;
  hashrecord *p1, *p2;

  debug0(5, 0, 131);
  if (hash == NULL)
    return;
  for (ct = 0; ct <= hashsize; ct++) {
    p1 = hash[ct];
    p2 = NULL;
    while (p1 != NULL && p1->offset != offset) {
      p2 = p1;
      p1 = p1->next;
    }
    if (p1 != NULL) {
      if (p2 != NULL)
	p2->next = p1->next;
      else
	hash[ct] = p1->next;
      Free(p1);
      return;
    }
  }
}


Static void update_hash(hashrecord **hash, Char *token, long offset)
{
  debug0(5, 0, 132);
  if (hash != NULL) {
    delete_hash_offset(hash, offset);
    add_hash(hash, offset, token, true);
  }
}


Static void disp_hash(hashrecord **hash, short unr)
{
  long x, z;
  Char w[256];
  hashrecord *p;
  long ct;

  debug0(5, unr, 144);
  if (hash == NULL) {
    wlnuser(unr, "hash not active");
    return;
  }

  for (x = 0; x <= hashsize; x++) {
    if (x % 17 == 0) {
      wlnuser0(unr);
      wlnuser0(unr);
      wuser(unr, "hashpos: ");
      for (z = 0; z <= 16; z++) {
	if (x + z <= hashsize) {
	  sprintf(w, "%ld", x + z);
	  lspacing(w, 4);
	  wuser(unr, w);
	}
      }
      wlnuser0(unr);
      wuser(unr, "nodes  : ");
    }
    ct = 0;
    p = hash[x];
    while (p != NULL) {
      ct++;
      p = p->next;
    }
    sprintf(w, "%ld", ct);
    lspacing(w, 4);
    wuser(unr, w);
  }
  wlnuser0(unr);
}


/* ---------------------------------------------------------------------- */

long bidhash_active(void)
{
  if (bidhash != NULL)
    return (sfsize(msgidlog) / 13 * sizeof(hashrecord) + sizeof(hasharr));
  else
    return 0;
}


long hboxhash_active(void)
{
  if (hboxhash != NULL)
    return (sfsize(hpath_box) / sizeof(hboxtyp) * sizeof(hashrecord) +
	    sizeof(hasharr));
  else
    return 0;
}


void disp_bidhash(short unr)
{
  disp_hash(bidhash, unr);
}


void disp_hboxhash(short unr)
{
  disp_hash(hboxhash, unr);
}


void clear_bidhash(void)
{
  clear_hash(&bidhash);
}


Static boolean bptr_loaded;


void clear_hboxhash(void)
{
  clear_hash(&hboxhash);
  bptr_loaded = false;
}


Static void load_bidhash(void)
{
  short k;
  Char bid[13];
  long ct, a, b, c, needed_mem;
  Char *bp;
  long rpos;


  clear_bidhash();

  debug0(5, 0, 130);

  c = sfsize(msgidlog);
  a = c / 13;
  needed_mem = sizeof(hasharr) + a * sizeof(hashrecord);
  if (needed_mem > memavail__() - 100000L)
    return;

  k = nohandle;

  bidhash = Malloc(sizeof(hasharr));
  if (bidhash == NULL)
    return;
  boxbusy("loading bid hash table");
  for (ct = 0; ct <= hashsize; ct++)
    bidhash[ct] = NULL;
  if (membidpuffer != NULL) {
    rpos = 0;
    ct = 0;
    while (rpos < c) {
      ct++;
      if (ct % 20 == 0)
	dp_watchdog(2, 4711);
      bp = (Char *)(&membidpuffer[rpos]);
      if (!add_hash(bidhash, rpos, bp, false))
	goto _L2;
      rpos += 13;
    }
  } else {
    if (exist(msgidlog)) {
      k = sfopen(msgidlog, FO_READ);
      if (k >= minhandle) {
	for (b = 1; b <= a; b++) {
	  if (b % 20 == 0)
	    dp_watchdog(2, 4711);
	  if (sfread(k, 13, bid) != 13)
	    goto _L1;
	  if (!add_hash(bidhash, (b - 1) * 13, bid, false))
	    goto _L1;
	}
	sfclose(&k);
      } else {
_L1:
	sfclose(&k);
_L2:
	debug(0, 0, 130, "no mem for list (or read error in input file)");
	clear_bidhash();
      }
    }
  }
  boxendbusy();
}


/* Wenn BIDs im RAM gehalten, dann Puffer freigeben  */

void free_membidpuffer(void)
{
  debug0(3, 0, 134);
  if (membidpuffer != NULL)
    mymfreep(&membidpuffer);
  membidsize = 0;
}


Static long find_bidhash(Char *bid)
{
  long Result, cs;
  hashrecord *p1;
  short k;
  Char *bp, bid2[13];
  short l1, l2;
  long maxoffs, dsize, err;
  uchar *puffer;

  debug0(5, 0, 133);

  Result = -1;

  if (membidpuffer == NULL) {
    if (bid_in_ram) {
      membidsize = maxbullids * 13;
      if (membidsize < maxram())
	puffer = Malloc(membidsize);
      else
	puffer = NULL;

      if (puffer != NULL) {
	dsize = sfsize(msgidlog);

	if (dsize > 0 && maxavail__() >= minfreeafterbid) {
	  k = sfopen(msgidlog, FO_READ);
	  if (k >= minhandle) {
	    if (dsize > membidsize)
	      dsize = membidsize;
	    err = sfread(k, dsize, puffer);
	    if (err != dsize) {
	      mymfree(&puffer);
	      debug(0, 0, 133, "read error in msgidmem");
	    } else
	      membidpuffer = puffer;
	    sfclose(&k);
	  } else
	    mymfree(&puffer);
	} else
	  mymfree(&puffer);

      }

    }

  }

  if (bidhash != NULL) {
    l2 = strlen(bid);
    if (l2 > 0 && l2 < 13) {
      cs = calc_hashcs(bid);
      p1 = bidhash[cs];
      if (p1 != NULL) {
	if (membidpuffer == NULL) {
	  debug(5, 0, 133, "on disk");
	  k = sfopen(msgidlog, FO_READ);
	  if (k >= minhandle) {
	    while (p1 != NULL) {
	      sfseek(p1->offset, k, SFSEEKSET);
	      sfread(k, 13, bid2);
	      l1 = strlen(bid2);
	      if (l1 == l2) {
		if (bid[l1 - 1] == bid2[l2 - 1]) {
		  if (bid[1] == bid2[1]) {
		    if (!strcmp(bid, bid2)) {
		      Result = p1->offset;
		      sfclose(&k);
		      return Result;
		    }
		  }
		}
	      }
	      p1 = p1->next;
	    }
	    sfclose(&k);
	  }
	} else {
	  maxoffs = membidsize - 13;
	  while (p1 != NULL) {
	    if (p1->offset > maxoffs) {
	      p1 = p1->next;
	      debug(0, 0, 133, "offset out of range");
	      continue;
	    }
	    bp = (Char *)(&membidpuffer[p1->offset]);
	    l1 = strlen(bp);
	    if (l1 == l2) {
	      if (bid[l1 - 1] == bp[l2 - 1]) {
		if (bid[1] == bp[1]) {
		  if (!strcmp(bid, bp))
		    return (p1->offset);
		}
	      }
	    }
	    p1 = p1->next;
	  }
	}
      }
    }
  }

  /* wollen wir das File im Speicher halten ? */
  if (membidpuffer != NULL) {
    if (!bid_in_ram || maxavail__() < minfreeafterbid)
      free_membidpuffer();
  }

  return Result;
}


/* Schreibt ab v3.53 auch im Speicher mit, falls die BIDs auch   */
/* dort gehalten werden                                          */

void write_msgid(long nr, Char *ibuf)
{
  long seek;
  short k;
  Char *mp;

  debug(2, 0, 62, ibuf);
  if ((unsigned long)strlen(ibuf) >= 32 ||
      ((1L << strlen(ibuf)) & 0x1ffe) == 0 || !strcmp(ibuf, "#NONE#"))
    return;
  k = sfopen(msgidlog, FO_RW);
  if (k < minhandle)
    k = sfcreate(msgidlog, FC_FILE);
  if (k < minhandle)
    return;
  if (nr < 0) {
    if (bullidseek >= maxbullids)
      bullidseek = 0;
    seek = bullidseek * 13;
    if (sfseek(seek, k, SFSEEKSET) != seek) {
      debug(0, 0, 62, "invalid bullidseek, readjusted (1)");
      bullidseek = sfseek(0, k, SFSEEKEND) / 13;
    }
    bullidseek++;
    update_bidseek();
  } else {
    seek = (nr - 1) * 13;
    if (sfseek(seek, k, SFSEEKSET) != seek) {
      debug(0, 0, 62, "invalid bullidseek, readjusted (2)");
      bullidseek = sfseek(0, k, SFSEEKEND) / 13;
    }
  }
  sfwrite(k, 13, ibuf);

  sfclose(&k);

  /* das ganze auch noch im RAM aktualisieren  */

  if (membidpuffer != NULL) {
    if (seek < membidsize) {
      mp = (Char *)(&membidpuffer[seek]);
      strcpy(mp, ibuf);

    } else
      free_membidpuffer();


    /* Puffer freigeben (wird beim naechsten Test neu eingelesen)     */
    /* kann passieren, wenn man nachtraeglich die Puffergroesse aendert  */

  }

  /* und falls vorhanden den hash updaten */

  update_hash(bidhash, ibuf, seek);

}


/* local fuer bid_mem ****************************************************** */

Static void kill_id(short *k, boolean openfile, long at)
{
  Char id[13];

  if (!openfile)
    *k = sfopen(msgidlog, FO_RW);
  if (*k < minhandle)
    return;
  sfseek(at, *k, SFSEEKSET);
  *id = '\0';
  sfwrite(*k, 13, id);
  if (!openfile)
    sfclose(k);

  /* falls vorhanden auch im hash loeschen */
  delete_hash_offset(bidhash, at);
}


Static long search_in_ram(boolean mul, short lnid, Char *new_id,
  boolean *bidcheck, Char (*bidarr)[13], short panz, boolean *ok,
  boolean delet, short *k, Char *id, boolean openfile, uchar *puf, long psiz,
  long offset)
{
  long Result, rpos, ct;
  short x, y, l1, l2;
  Char *mp;

  debug0(5, -1, 145);
  rpos = 0;
  Result = -1;

  if (mul) {
    while (rpos < psiz && !*ok) {
      mp = (Char *)(&puf[rpos]);
      l1 = strlen(mp);

      for (x = 0; x < panz; x++) {
	l2 = strlen(bidarr[x]);
	if (l1 == l2) {
	  if (mp[l1 - 1] == bidarr[x][l2 - 1]) {
	    if (mp[1] == bidarr[x][1]) {
	      if (!strcmp(mp, bidarr[x])) {
		bidcheck[x] = false;
		*ok = true;
		for (y = 0; y < panz; y++) {
		  if (bidcheck[y] == true)
		    *ok = false;
		}
	      }
	    }
	  }
	}
      }
      rpos += 13;
    }
    return Result;
  }

  ct = offset / 13;

  while (rpos < psiz && !*ok) {
    ct++;
    mp = (Char *)(&puf[rpos]);
    l1 = strlen(mp);
    l2 = lnid;
    if (l1 == l2) {
      if (mp[l1 - 1] == new_id[l2 - 1]) {
	if (mp[1] == new_id[1]) {
	  if (!strcmp(mp, new_id)) {
	    Result = ct;
	    *ok = true;
	    if (delet) {
	      *mp = '\0';
	      kill_id(k, openfile, offset + rpos);
	    }
	  }
	}
      }
    }

    rpos += 13;
  }
  return Result;


}


Static long search_in_hash(boolean mul, Char *new_id, short panz,
			   Char (*bidarr)[13], boolean *bidcheck,
			   boolean delet, short *k)
{
  long Result;
  short x;
  long ct;

  debug0(5, -1, 146);
  Result = -1;
  if (mul) {
    for (x = 0; x < panz; x++)
      bidcheck[x] = (find_bidhash(bidarr[x]) < 0);
    return Result;
  }
  ct = find_bidhash(new_id);
  if (delet && ct >= 0)
    kill_id(k, false, ct);
  if (ct >= 0)
    return (ct / 13 + 1);
  return Result;
}


#define blocksize       4095


Static long bid_mem(boolean mul, boolean delet, short panz, boolean *bidcheck,
		    Char (*bidarr_)[13], Char *new_id_)
{
  long Result;
  bidarrtype bidarr;
  Char new_id[13];

  short k, x, y;
  long anz, err, ct, dsize, bct;
  uchar *puffer;
  Char id[13];
  boolean ok;
  short l1, l2, lnid;

  memcpy(bidarr, bidarr_, sizeof(bidarrtype));
  strcpy(new_id, new_id_);
  debug(4, 0, 63, new_id);

  if (mul) {
    for (x = 0; x < maxfbbprops; x++)
      bidcheck[x] = true;
  }
  ok = false;
  Result = -1;
  lnid = strlen(new_id);
  if (!(mul || (unsigned)lnid < 32 && ((1L << lnid) & 0x1ffe) != 0))
    return Result;


  if (bidhash != NULL) {
    Result = search_in_hash(mul, new_id, panz, bidarr, bidcheck, delet, &k);


  } else if (membidpuffer != NULL) {
    Result = search_in_ram(mul, lnid, new_id, bidcheck, bidarr, panz, &ok,
			   delet, &k, id, false, membidpuffer, membidsize, 0);

  } else {
    dsize = sfsize(msgidlog);
    if (dsize > 0) {
      if (delet)
	k = sfopen(msgidlog, FO_RW);
      else
	k = sfopen(msgidlog, FO_READ);
      if (k >= minhandle) {
	membidsize = maxbullids * 13;
	if (membidsize < maxram())
	  puffer = Malloc(membidsize);
	else
	  puffer = NULL;

	if (puffer != NULL) {
	  /* ACHTUNG: ein nachtraeglich verkleinerter Puffer kann   */
	  /* grosse Probleme machen (Parameter BullIDMem in der     */
	  /* Benutzeroberflaeche - sowas sollte man nicht tun...    */

	  if (dsize > membidsize)
	    dsize = membidsize;
	  err = sfread(k, dsize, puffer);
	  if (err != dsize) {
	    mymfreep(&puffer);
	    debug(0, 0, 63, "read error 1");
	  } else {
	    Result = search_in_ram(mul, lnid, new_id, bidcheck, bidarr, panz,
				   &ok, delet, &k, id, true, puffer, err, 0);
	    membidpuffer = puffer;
	  }

	} else {  /* Falls die Datei nicht in den Speicher passt... */
	  puffer = Malloc(blocksize);
	  if (puffer != NULL) {
	    bct = 0;
	    err = dsize - bct;
	    while (err > 0 && !ok) {
	      if (err > blocksize)
		err = blocksize;
	      err = sfread(k, err, puffer);
	      if (err > 0) {
		Result = search_in_ram(mul, lnid, new_id, bidcheck, bidarr,
				       panz, &ok, delet, &k, id, true, puffer,
				       err, bct);
		bct += err;
		err = dsize - bct;
		continue;
	      }
	      if (err < 0) {
		debug(0, 0, 63, "read error 2");
		goto _L1;
	      }
	      if (err == 0)
		goto _L1;
	    }
	  } else {
	    debug(3, 0, 63, "Disk");

	    anz = dsize / 13;
	    for (ct = 1; ct <= anz; ct++) {
	      sfread(k, 13, id);
	      l1 = strlen(id);

	      if (mul) {
		for (x = 0; x < panz; x++) {
		  l2 = strlen(bidarr[x]);
		  if (l1 == l2) {
		    if (id[l1 - 1] == bidarr[x][l2 - 1]) {
		      if (id[1] == bidarr[x][1]) {
			if (!strcmp(id, bidarr[x])) {
			  bidcheck[x] = false;
			  ok = true;
			  for (y = 0; y < panz; y++) {
			    if (bidcheck[y] == true)
			      ok = false;
			  }
			  if (ok)
			    goto _L1;
			}
		      }
		    }
		  }
		}
	      } else {
		if (l1 == lnid) {
		  if (id[l1 - 1] == new_id[lnid - 1]) {
		    if (id[1] == new_id[1]) {
		      if (!strcmp(id, new_id)) {
			Result = ct;
			if (delet)
			  kill_id(&k, true, (ct - 1) * 13);
			goto _L1;
		      }
		    }
		  }
		}
	      }


	    }
	  }
_L1: ;
	}


	sfclose(&k);
      }

    }
  }

  if (bidhash == NULL)
    load_bidhash();

  /* wollen wir das File im Speicher halten ? */
  if (membidpuffer != NULL) {
    if (!bid_in_ram || maxavail__() < minfreeafterbid)
      free_membidpuffer();
  }

  if (bidhash == NULL)   /* das ist mit Absicht doppelt hier... */
    load_bidhash();

  return Result;
}

#undef blocksize


boolean check_double(Char *new_id)
{
  bidchecktype bidcheck;
  bidarrtype bidarr;

  if (bidhash != NULL)
    return (find_bidhash(new_id) < 0);
  else
    return (bid_mem(false, false, 1, bidcheck, bidarr, new_id) < 0);
}


long bull_mem(Char *new_id, boolean delet)
{
  bidchecktype bidcheck;
  bidarrtype bidarr;
  long ct;

  if (bidhash != NULL && !delet) {
    ct = find_bidhash(new_id);
    if (ct >= 0)
      return (ct / 13 + 1);
    else
      return -1;
  } else
    return (bid_mem(false, delet, 1, bidcheck, bidarr, new_id));
}


void multiple_bullcheck(short ct, boolean *bidcheck, Char (*bidarr)[13])
{
  Char nid[13];
  short x;

  if (bidhash != NULL) {
    for (x = 0; x < ct; x++)
      bidcheck[x] = (find_bidhash(bidarr[x]) < 0);
  } else {
    nid[0] = '\0';
    bid_mem(true, false, ct, bidcheck, bidarr, nid);
  }
}


/* *************************************************************************** */

boolean true_bin(Char *zeile)
{
  boolean Result;
  short k, ct;

  Result = false;
  if (zeile[0] != '#')
    return Result;
  if (strpos2(zeile, "#BIN#", 1) != 1)
    return Result;
  k = strlen(zeile);
  if (k < 6)
    return Result;

  ct = 5;
  while (ct < k) {
    ct++;
    if (!isdigit(zeile[ct - 1])) {
      if (zeile[ct - 1] == '#') {
	if (ct > 6)
	  return true;
      }
      return Result;
    }
  }

  return true;
}


long get_binstart(uchar *puffer, long size, Char *fname)
{
  long binstart, rp;
  Char hs[256];
  short x, y;

  debug0(4, 0, 60);
  /* Achtung: Durchsucht nur die ersten 100 Zeilen ab Pufferstart auf #BIN# */

  binstart = 0;
  *fname = '\0';
  x = 0;
  rp = 0;
  get_line(puffer, &rp, size, hs);
  while (strpos2(hs, "R:", 1) == 1 && rp < size)
    get_line(puffer, &rp, size, hs);
  prev_line(puffer, &rp);
  while (rp < size && x < 100 && binstart == 0) {
    x++;
    get_line(puffer, &rp, size, hs);
    if (!true_bin(hs))
      continue;
    y = strlen(hs);
    while (hs[y - 1] != '#' && y > 1)
      y--;
    strdelete((void *)hs, 1, y);
    cut(hs, 80);
    strcpy(fname, hs);
    binstart = rp;
  }
  return binstart;
}


void add_line_to_buff(uchar **buf1, long *size1, long inspos, Char *srline)
{
  uchar *buf2;
  long size2, offset, err;
  short x, k;
  Char tname[256];
  short FORLIM;

  debug0(5, -1, 147);
  size2 = *size1 + strlen(srline) + 1;
  buf2 = Malloc(size2);
  if (inspos > *size1 || inspos < 0)
    inspos = 0;

  if (buf2 != NULL) {  /* passt alles in den Speicher */
    if (inspos > 0)
      memcpy(buf2, *buf1, inspos);
    FORLIM = strlen(srline);
    for (x = 0; x < FORLIM; x++)
      buf2[x + inspos] = srline[x];
    buf2[strlen(srline) + inspos] = 10;
    offset = strlen(srline) + inspos + 1;
    memcpy((uchar *)(&buf2[offset]), (uchar *)(&(*buf1)[inspos]),
	   *size1 - inspos);
    mymfreep(buf1);
    *buf1 = buf2;
    *size1 = size2;
    return;
  }

  debug(3, 0, 61, "Disk");
  sprintf(tname, "%sTEMPR%cR", tempdir, extsep);
  k = sfcreate(tname, FC_FILE);
  if (k < minhandle)
    return;
  err = sfwrite(k, *size1, *buf1);
  if (err == *size1) {
    mymfreep(buf1);
    sfseek(0, k, SFSEEKSET);   /*An den Anfang zurueck*/
    *buf1 = Malloc(size2);
    if (*buf1 != NULL) {
      if (inspos > 0)
	sfread(k, inspos, *buf1);
      FORLIM = strlen(srline);
      for (x = 0; x < FORLIM; x++)
	(*buf1)[x + inspos] = srline[x];
      (*buf1)[strlen(srline) + inspos] = 10;
      offset = strlen(srline) + inspos + 1;
      sfread(k, *size1 - inspos, (uchar *)(&(*buf1)[offset]));
      *size1 = size2;
    } else {  /*hat alles nichts genuetzt*/
      *buf1 = Malloc(*size1);
      if (*buf1 != NULL)
	sfread(k, *size1, *buf1);
      else {
	*buf1 = NULL;
	*size1 = 0;
      }
    }
  }
  sfclose(&k);
  sfdelfile(tname);

  /* Umweg ueber Festplatte */
}


/* ------------------------------------------------------------------ */

Static void load_bptr(void)
{
  short k;
  long l, x;
  hboxtyp hbox, *hboxp;
  uchar *rb;
  long rps, rpr, rpb;

  debug0(1, -1, 158);
  clear_hboxhash();

  hboxhash = Malloc(sizeof(hasharr));
  if (hboxhash == NULL)
    return;
  for (x = 0; x <= hashsize; x++)
    hboxhash[x] = NULL;
  l = sfsize(hpath_box) / sizeof(hboxtyp);
  if (l > 0) {
    k = sfopen(hpath_box, FO_READ);
    if (k >= minhandle) {
      boxbusy("loading hbox hash");

      rpb = sizeof(hboxtyp) * 300;
      rb = Malloc(rpb);

      if (rb == NULL) {
	for (x = 0; x < l; x++) {
	  if (sfread(k, sizeof(hboxtyp), (uchar *)(&hbox)) == sizeof(hboxtyp)) {
	    if (callsign(hbox.call))
	      add_hash(hboxhash, x * sizeof(hboxtyp), hbox.call, false);
	  }
	}
      } else {
	rps = 0;
	rpr = 0;

	for (x = 0; x < l; x++) {
	  if (rpr + sizeof(hboxtyp) - 1 > rps) {
	    rps = sfread(k, rpb, rb);
	    rpr = 0;
	  }

	  hboxp = (hboxtyp *)(&rb[rpr]);
	  rpr += sizeof(hboxtyp);

	  if (callsign(hboxp->call))
	    add_hash(hboxhash, x * sizeof(hboxtyp), hboxp->call, false);

	}

	mymfreep(&rb);
      }


      boxendbusy();
    }
    sfclose(&k);
  }
  bptr_loaded = true;


}


Static void load_initial_hbox(void)
{
  if (bptr_loaded)
    return;
  load_bptr();
}


Static void add_bptr(Char *call, long bpos)
{
  debug(4, -1, 159, call);
  if (bpos >= 0 && (unsigned long)strlen(call) < 32 &&
      ((1L << strlen(call)) & 0x7e) != 0) {
    /*   if hboxhash = NIL then load_bptr; hat keinen Sinn, File ist bereits zum Schreiben geoeffnet */
    add_hash(hboxhash, bpos, call, true);
  }
}


Static long load_hbox(short hboxhandle, Char *call, hboxtyp *hbox)
{
  long Result, cs;
  hashrecord *p1;
  short k;

  debug(4, -1, 160, call);
  Result = -1;
  *hbox->call = '\0';

  if (hboxhandle < minhandle)
    load_initial_hbox();

  if (hboxhash == NULL)
    return Result;
  if (hboxhandle >= minhandle)
    k = hboxhandle;
  else
    k = sfopen(hpath_box, FO_READ);
  if (k < minhandle)
    return Result;
  cs = calc_hashcs(call);
  p1 = hboxhash[cs];
  if (p1 != NULL) {
    while (p1 != NULL) {
      if (sfseek(p1->offset, k, SFSEEKSET) == p1->offset) {
	if (sfread(k, sizeof(hboxtyp), (uchar *)hbox) == sizeof(hboxtyp)) {
	  if (!strcmp(hbox->call, call)) {
	    Result = p1->offset;
	    if (hboxhandle < minhandle)
	      sfclose(&k);
	    return Result;
	  }
	}
      }
      p1 = p1->next;
    }
  }
  if (hboxhandle < minhandle)
    sfclose(&k);
  return Result;
}


/* -------------------------------------------------------------------- */

Static void ct8(short unr, Char *w, short *ct)
{
  (*ct)++;
  if (unr <= 0)
    return;
  rspacing(w, 7);
  wuser(unr, w);
  if (((*ct) & 7) == 0) {
    wlnuser0(unr);
    wuser(unr, "           ");
  }
}


Static void bbspath(short unr, Char *box_, Char *nachbar)
{
  Char box[7];
  hboxtyp hbox;
  short ct, k;
  boolean first;
  Char w[256];
  Char last[7], rxfrom[7], last2[7];

  strcpy(box, box_);
  load_initial_hbox();
  debug(2, unr, 64, box);
  ct = 0;
  *last = '\0';
  *last2 = '\0';
  *nachbar = '\0';
  *rxfrom = '\0';
  first = true;

  k = sfopen(hpath_box, FO_READ);
  if (k >= minhandle) {
    if (unr > 0)
      wuser(unr, "best path: ");

    do {

      load_hbox(k, box, &hbox);
      if (!strcmp(hbox.call, box)) {
	if (first) {
	  strcpy(rxfrom, hbox.rxfrom);
	  first = false;
	}
	strcpy(last2, last);
	strcpy(box, hbox.bestfrom);
	strcpy(w, hbox.call);
	strcpy(last, w);
	ct8(unr, w, &ct);
      }

    } while (strcmp(box, Console_call) && strcmp(box, last2) &&
	     strcmp(box, last) && ct <= 150 && *hbox.call != '\0');

    if (ct > 150 || !strcmp(box, last2))
      strcpy(w, "**loop");
    else if (*hbox.call == '\0') {
      if (in_sfp(box)) {
	strcpy(w, box);
	strcpy(nachbar, box);
      } else
	strcpy(w, "***???");
    } else {
      strcpy(w, Console_call);
      strcpy(nachbar, last);
    }

    if (unr > 0) {
      ct8(unr, w, &ct);
      wlnuser0(unr);
    }

    sfclose(&k);
  }

  if (*nachbar == '\0')
    strcpy(nachbar, rxfrom);
}


/* get_real_neighbour() untersucht, ob die nachbarbox als sf-partner definiert ist.      */
/* wenn nicht, dann wird geschaut, ob der nachbar der nachbarbox definiert ist...        */
/* dies ist nur eine notloesung, wenn man zuhause den router mit mitschnitten fuettert   */

Static void get_real_neighbour(Char *n1_, Char *rn)
{
  Char n1[256];
  boolean ok;
  hboxtyp hbox;

  strcpy(n1, n1_);
  if (in_sfp(n1)) {
    strcpy(rn, n1);
    return;
  }
  load_hbox(nohandle, n1, &hbox);
  ok = (strcmp(hbox.call, n1) == 0);
  if (ok) {
    strcpy(n1, hbox.rxfrom);
    ok = in_sfp(n1);
  }
  if (ok)
    strcpy(rn, hbox.rxfrom);
  else
    strcpy(rn, n1);
}


Static void add_l0(Char *s)
{
  short k;
  Char STR1[256];

  k = strlen(s);
  while (k++ < 2)
    sprintf(s, "0%s", strcpy(STR1, s));
}


#define psize_          16384


Static void get_bbs_info(short unr, Char *boxcall, Char *hname, Char *nachbar,
			 long *average, long *min, long *cts)
{
  short ct;
  hboxtyp *hbox, hb;
  uchar *buff;
  long size, rp;
  boolean found;
  Char hs[256], hs1[256];
  Char w[41], wcp[41];
  long minutes, days, hours, x;
  boolean multi, namesearch;
  long sz, lz;
  uchar *puffer, d1, m1, y1, h1, min1, s1;
  Char STR1[256];
  Char STR7[52];
  Char STR13[256];

  load_initial_hbox();
  debug(3, unr, 11, boxcall);
  puffer = NULL;
  *average = 0;
  *min = 0;
  *cts = 0;
  *hname = '\0';
  *nachbar = '\0';
  multi = (!callsign(boxcall) && unr > 0);
  namesearch = false;
  wcp[0] = '\0';   /* muss 0 bleiben */

  if (multi) {
    if (*boxcall != '\0') {
      if (boxcall[0] == '<') {
	strdelete((void *)boxcall, 1, 1);
	del_leadblanks(boxcall);
	if (*boxcall == '\0') {
	  wln_btext(unr, 13);
	  return;
	}
	namesearch = true;
	if (boxcall[0] != '*')
	  sprintf(boxcall, "*%s", strcpy(STR1, boxcall));
	if (boxcall[strlen(boxcall) - 1] != '*')
	  strcat(boxcall, "*");
      } else if (strpos2(boxcall, "*", 1) == 0)
	strcat(boxcall, "*");
    }
  }

  if (!strcmp(boxcall, Console_call)) {
    if (unr > 0) {
      sprintf(STR7, "Call    : %s", ownhiername);
      wlnuser(unr, STR7);
      wlnuser(unr, "Local ;-)");
      return;
    }
    strcpy(hname, ownhiername);
    *cts = 0;
    *min = 0;
    *average = 0;
    strcpy(nachbar, Console_call);
    return;
  }
  buff = NULL;
  size = 0;
  if (multi)
    sfbread(false, hpath_box, &buff, &size);

  if (multi && size <= 0)
    return;
  ct = 0;
  rp = 0;
  found = false;
  if (multi) {
    puffer = Malloc(psize_);
    sz = 0;
  }

  do {

    if (multi) {
      hbox = (hboxtyp *)(&buff[rp]);
      rp += sizeof(hboxtyp);
      if (puffer != NULL) {
	if (*boxcall == '\0')
	  found = true;
	else {
	  if (namesearch) {
	    strcpy(hs, hbox->desc);
	    upper(hs);
	    found = wildcardcompare(SHORT_MAX, boxcall, hs, wcp);
	  } else {
	    strcpy(hs, hbox->call);
	    if (*hbox->hpath != '\0')
	      sprintf(hs + strlen(hs), ".%s", hbox->hpath);
	    found = wildcardcompare(SHORT_MAX, boxcall, hs, wcp);
	  }
	}
	if (found) {
	  if (sz < psize_ - 8)
	    put_line(puffer, &sz, hbox->call);
	}
      } else
	wlnuser(unr, "no mem");
    } else {
      load_hbox(nohandle, boxcall, &hb);
      hbox = &hb;
      found = (strcmp(hbox->call, boxcall) == 0);
    }

    if (found) {
      if (unr > 0) {
	if (!multi) {
	  strcpy(hs, hbox->call);

	  if (*hbox->hpath != '\0')
	    sprintf(hs + strlen(hs), ".%s", hbox->hpath);

	  sprintf(STR1, "Call     : %s", hs);
	  wlnuser(unr, STR1);
	  decode_ixtime(hbox->lasttx, &d1, &m1, &y1, &h1, &min1, &s1);
	  datum2string(Make_DDate(d1, m1, y1), hs1);
	  sprintf(STR13, "Last Tx  : %s ", hs1);
	  wuser(unr, STR13);
	  zeit2string(Make_DTime(h1, min1, s1), hs1);
	  cut(hs1, 5);   /*keine Sekunden*/
	  wlnuser(unr, hs1);
	  if (hbox->best < maxlonginteger) {
	    x = hbox->best;
	    days = x / 1440;
	    hours = x % 1440;
	    minutes = hours % 60;
	    hours /= 60;
	    sprintf(hs1, "%ld", days);
	    sprintf(w, "%ld", hours);
	    add_l0(w);
	    sprintf(hs1 + strlen(hs1), " days %s", w);
	    sprintf(w, "%ld", minutes);
	    add_l0(w);
	    sprintf(hs1 + strlen(hs1), ":%s", w);
	    sprintf(STR13, "MinTime  : %s", hs1);
	    wlnuser(unr, STR13);
	  }
	  if (hbox->aver < maxlonginteger) {
	    x = hbox->aver;
	    days = x / 1440;
	    hours = x % 1440;
	    minutes = hours % 60;
	    hours /= 60;
	    sprintf(hs1, "%ld", days);
	    sprintf(w, "%ld", hours);
	    add_l0(w);
	    sprintf(hs1 + strlen(hs1), " days %s", w);
	    sprintf(w, "%ld", minutes);
	    add_l0(w);
	    sprintf(hs1 + strlen(hs1), ":%s", w);
	    sprintf(STR13, "AverTime : %s", hs1);
	    wlnuser(unr, STR13);
	  }
	  sprintf(STR7, "Info     : %s", hbox->desc);
	  wlnuser(unr, STR7);
	  sprintf(hs1, "%ld", hbox->msgct);
	  sprintf(STR13, "MsgCt    : %s", hs1);
	  wlnuser(unr, STR13);
	  sprintf(hs1, "%ld", hbox->bytect);
	  sprintf(hs1, "Rx Bytes : %s", strcpy(STR13, hs1));
	  wlnuser(unr, hs1);
	  strcpy(hs1, "DL1XYZ");
	  gen_sftest2(unr, hs1, hs);
	  bbspath(unr, hbox->call, hs1);
	  if (!smart_routing) {
	    sprintf(hs1, "SmartRout: %s", strcpy(STR13, hs1));
	    wlnuser(unr, hs1);
	  }
	}
      } else {
	strcpy(hname, hbox->call);
	if (*hbox->hpath != '\0')
	  sprintf(hname + strlen(hname), ".%s", hbox->hpath);
	*cts = hbox->msgct;
	*min = hbox->best;
	*average = hbox->aver;
	if (!strcmp(hbox->bestfrom, boxcall))
	  strcpy(nachbar, boxcall);
	else
	  bbspath(-1, boxcall, nachbar);
	get_real_neighbour(nachbar, nachbar);
      }
    }
    if (multi)
      found = false;

  } while (multi && !found && rp < size);

  if (multi) {
    if (puffer != NULL && sz > 0) {
      sort_mem(puffer, &sz);
      ct = 1;
      lz = 0;
      while (lz < sz) {
	get_line(puffer, &lz, sz, hs);
	rspacing(hs, 7);
	wuser(unr, hs);
	if (ct % 9 == 0)
	  wlnuser0(unr);
	ct++;
      }
    }
    if (puffer != NULL)
      mymfreep(&puffer);
  }

  if (ct > 0)
    wlnuser0(unr);
  if (!multi) {
    if (!found) {
      wln_btext(unr, 13);
      *hname = '\0';
      *nachbar = '\0';
    }
  }
  if (buff != NULL)
    mymfreep(&buff);

}

#undef psize_


void show_bbs_info(short unr, Char *boxcall)
{
  Char hname[256];
  long aver, min, cts;
  Char nachbar[21];

  get_bbs_info(unr, boxcall, hname, nachbar, &aver, &min, &cts);
}


void find_neighbour(short unr, Char *boxcall, Char *nachbar)
{
  long aver, min, cts;
  Char hname[256];

  *nachbar = '\0';
  get_bbs_info(0, boxcall, hname, nachbar, &aver, &min, &cts);
}


/* Diese Funktion kompletiert ein Rufzeichen auf eine volle hierarchische    */
/* Adresse. Achtung: eine eventuell mit uebergebene hierarchische Angabe     */
/* wird abgetrennt und falls gefunden durch die neue ersetzt. User machen    */
/* viele falsche Angaben...                                                  */

void complete_hierarchical_adress(Char *mbx)
{
  hboxtyp hbox;
  Char hmbx[41];

  if (*mbx == '\0')
    return;
  unhpath(mbx, hmbx);

  if (!strcmp(hmbx, Console_call)) {
    strcpy(mbx, ownhiername);

    return;
  }
  load_hbox(nohandle, hmbx, &hbox);
  if (!strcmp(hbox.call, hmbx)) {
    if (*hbox.hpath != '\0')
      sprintf(mbx, "%s.%s", hbox.call, hbox.hpath);
  }
}


/* sortiert zu alte Eintraege aus */

void check_hpath(boolean reorg)
{
  hboxtyp nheader;
  Char oidxname[256], nidxname[256];
  long ct, dsize;
  short kin_index, kout_index;

  debug0(2, 0, 12);
  if (sfsize(hpath_box) % sizeof(hboxtyp) != 0) {
    boxalert2("Cannot convert old|HPATH.BOX to newer format.|File deleted.",
	      true);
    sfdelfile(hpath_box);
    clear_hboxhash();
    return;
  }
  if (!reorg)
    return;

  clear_hboxhash();
  strcpy(oidxname, hpath_box);
  if (ramdisk > '0') {
    if (DiskFree(drv2num(ramdisk)) > sfsize(oidxname))
      sprintf(nidxname, "%c%c%chpath%cbox", ramdisk, drivesep, dirsep, extsep);
    else
      strcpy(nidxname, oidxname);
  } else
    strcpy(nidxname, oidxname);
  nidxname[strlen(nidxname) - 1] = 'N';
  dsize = sfsize(oidxname);



  kin_index = sfopen(oidxname, FO_READ);
  kout_index = sfcreate(nidxname, FC_FILE);
  if (kin_index >= minhandle && kout_index >= minhandle) {
    for (ct = 1; ct <= dsize / sizeof(hboxtyp); ct++) {
      if (sfread(kin_index, sizeof(hboxtyp), (uchar *)(&nheader)) !=
	  sizeof(hboxtyp)) {
	debug(0, 0, 12, "read error");
	goto _L1;
      }
      if (callsign(nheader.call)) {
	if (clock_.ixtime - nheader.lasttx < 15552000)
	  sfwrite(kout_index, sizeof(hboxtyp), (uchar *)(&nheader));
      }
    }


  }


_L1:
  sfclose(&kin_index);
  sfclose(&kout_index);
  sfdelfile(oidxname);
  filemove(nidxname, oidxname);
  sfdelfile(nidxname);

}


Static short start_extract(boolean priv, short what, Char *s, Char *subject,
			   Char *sender, Char *board, Char *name)
{
  short Result, k, x;
  Char tn[256], hs[256], w[256];
  Char STR1[256];

  Result = nohandle;
  if (disk_full)
    return Result;

  if (what == 0) {  /* autobin */
    strcpy(hs, s);
    x = 1;
    while (x > 0) {
      x = strpos2(hs, "#", 1);
      if (x > 0)
	strdelete((void *)hs, 1, x);
    }
    del_path(hs);
    if (*hs == '\0' || insecure(hs))
      return Result;
    while (strpos2(hs, ".", 1) == 1)
      strdelete((void *)hs, 1, 1);
    if (*hs == '\0')
      return Result;
    lower(hs);
    if (!strcmp(hs, "index"))
      return Result;
    if (priv)
      sprintf(tn, "%s%s%s", boxdir, pservdir, hs);
    else
      sprintf(tn, "%s%snewbin%c%s", boxdir, fservdir, dirsep, hs);
    if (exist(tn))
      return Result;
    k = sfcreate(tn, FC_FILE);
    if (k < minhandle)
      return Result;
    strcpy(name, tn);
    Result = k;
  } else {  /* 7plus */
    strcpy(hs, s);
    if (what == 1) {
      for (x = 1; x <= 5; x++)
	get_word(hs, w);
    } else {
      for (x = 1; x <= 2; x++)
	get_word(hs, w);
    }
    del_path(w);
    if (*w == '\0' || insecure(w))
      return Result;
    while (strpos2(w, ".", 1) == 1)
      strdelete((void *)w, 1, 1);
    if (*w == '\0')
      return Result;
    lower(w);
    if (!strcmp(w, "index"))
      return Result;
    if (priv)
      sprintf(tn, "%s%stemp7pl%c%s", boxdir, pservdir, dirsep, w);
    else
      sprintf(tn, "%s%stemp7pl%c%s", boxdir, fservdir, dirsep, w);
    if (exist(tn))
      return Result;
    k = sfcreate(tn, FC_FILE);
    if (k < minhandle)
      return Result;
    string_to_file(&k, s, true);
    strcpy(name, tn);
    Result = k;
  }


  if (what == 3)
    return Result;
  strcpy(hs, tn);
  x = strlen(hs);
  while (x > 1 && hs[x - 1] != dirsep)
    x--;
  if (hs[x] == '.')
    return Result;
  strinsert(".", (void *)hs, x + 1);
  if (exist(hs))
    return Result;
  k = sfcreate(hs, FC_FILE);
  if (k < minhandle)
    return Result;
  sprintf(STR1, "From: %s To: %s", sender, board);
  string_to_file(&k, STR1, true);
  strcpy(hs, subject);
  cut(hs, 72);
  string_to_file(&k, hs, true);
  sfclose(&k);

  return Result;
}


Static void end_extract(short *k, Char *tn, Char *ls)
{
  short x;
  Char hs[256], w[256];

  if (*k < minhandle)
    return;
  sfclose(k);
  strcpy(hs, ls);
  get_word(hs, w);
  get_word(hs, w);
  if (*w == '\0')
    return;
  strdelete((void *)w, 1, 1);
  strdelete((void *)w, strlen(w), 1);

  x = strlen(w);
  while (x > 1 && w[x - 1] != '/')
    x--;
  if (x > 1)
    cut(w, x - 1);

  del_path(w);
  if (*w == '\0' || insecure(w))
    return;
  while (strpos2(w, ".", 1) == 1)
    strdelete((void *)w, 1, 1);
  if (*w == '\0')
    return;
  lower(w);
  if (!strcmp(w, "index"))
    return;
  strcpy(hs, tn);
  get_path(hs);
  strcat(hs, w);
  sfrename(tn, hs);
  strcpy(tn, hs);
}

Static unsigned short double_val(Char *s, short posi)
{
  return ((s[posi - 1] - '0') * 10 + s[posi] - '0');
}


long get_headerdate(Char *timestr)
{
  unsigned short dd, mm, yy, hh, mi, ss;

  if (strlen(timestr) <= 12)
    return 0;
  if (upcase_(timestr[13]) != 'Z')
    return (clock_.ixtime + 120);
	/* dadurch wird die zeit ungueltig und ersetzt */
  else {
    hh = double_val(timestr, 10);
    mi = double_val(timestr, 12);
    ss = 0;
    if (hh >= 32 || ((1L << hh) & 0xffffffL) == 0 || mi > 59)
      return 0;
    dd = double_val(timestr, 7);
    mm = double_val(timestr, 5);
    yy = double_val(timestr, 3);
    if (mm >= 32 || ((1L << mm) & 0x1ffe) == 0 || dd >= 32 ||
	((1L << dd) & 0xfffffffe) == 0 || (yy < 80 || yy > 99) && yy > 37)
      return 0;
    if (yy < 80)
      yy += 100;
    return (calc_ixtime(dd, mm, yy, hh, mi, ss));
  }
  return 0;
}


/* Diese Prozedur liest eine bereits im Speicher befindliche Nachricht   */
/* und versucht aus dem Nachrichtenkopf die Absender-BBS zu ersehen.     */
/* Ausserdem wird ueberprueft, ob es sich eventuell um ein DieBox -      */
/* Binaerfile handelt. Falls ja, so wird der Offset zum Dateianfang des  */
/* Starts der binaeren Daten zurueckgegeben.                             */
/* Ab v4.06 ebenfalls Scan nach WP-Infos.                                */
/* Ab v4.07 ebenfalls Scan nach //E                                      */
/* Ab v4.18 7plus/AutoBIN - Extraktor                                    */
/* Ab v5.03 und guess_mybbs == true werden auch mybbs-infos extrahiert   */

Static void get_last_bbs(uchar *puffer, long size, boolean wpupdate,
  boolean part, Char *absender, Char *board, Char *subject, Char msgtype,
  Char *ackcall, boolean *is_binary, boolean *is_7plus, boolean *is_ack,
  boolean *is_dirty, boolean *is_html, Char *dirtystring, long *binstart)
{
  long rp, lp, lp2;
  short x;
  long time;
  short lct, lastrl, k, d, m, j, h, min, s;
  boolean rok, priv;
  short a;
  long li, txdate;
  short extracthandle;
  Char extractname[256];
  Char hs[256], w[256], shs[256], hsu[256];
  Char call[256], bbs[256];
  Char actwpfilesender[7];
  Char STR1[256];

  debug0(4, 0, 65);
  *binstart = 0;
  *is_binary = false;
  *is_7plus = false;
  *is_ack = false;
  *is_html = false;
  *ackcall = '\0';
  *shs = '\0';
  *extractname = '\0';
  rp = 0;
  lp2 = 0;
  lct = 0;
  txdate = 0;
  lastrl = 0;
  rok = false;
  priv = false;
  a = -1;
  extracthandle = nohandle;

  if (wpupdate) {
    if (strlen(absender) < 7)
      strcpy(actwpfilesender, absender);
    else
      wpupdate = false;
  }

  while (rp < size && lct == lastrl) {
    lct++;
    lp = rp;
    get_line(puffer, &rp, size, hs);
    if (strpos2(hs, "R:", 1) == 1) {
      if (strpos2(hs, "@", 1) > 10) {
	lastrl = lct;
	lp2 = lp;
	rok = true;
      }
    }
  }

  if (rok)
    get_line(puffer, &lp2, size, shs);

  if (*shs != '\0') {
    get_word(shs, w); /* Datum */
    if (guess_mybbs) {
      txdate = get_headerdate(w);
      if (txdate > clock_.ixtime)
        txdate = 0;
    }
      
    get_word(shs, w);
    x = strpos2(w, "@", 1);
    if (x > 0) {
      strdelete((void *)w, 1, x);
      if (w[0] == ':')
	strdelete((void *)w, 1, 1);
      upper(w);
      unhpath(w, hs);
      if (!callsign(hs))
	*ackcall = '\0';
      else
	strcpy(ackcall, hs);
    }
  }

  x = 0;
  while (rp < size && !*is_binary) {
    x++;
    get_line(puffer, &rp, size, hs);

    if (extracthandle >= minhandle)
      string_to_file(&extracthandle, hs, true);

    strcpy(hsu, hs);
    upper(hsu);

    if (*hs == '\0')  /* empty line nicht auswerten */
      continue;

    if (true_bin(hs)) {
      *is_binary = true;
      *binstart = rp;
      if (!autobinextract || part)
	continue;
      priv = (strcmp(Console_call, board) == 0);
      if (!(priv || msgtype == 'B'))
	continue;
      extracthandle = start_extract(priv, 0, hs, subject, absender, board,
				    extractname);
      if (extracthandle >= minhandle) {
	li = size - rp;
	if (sfwrite(extracthandle, li, (uchar *)(&puffer[rp])) != li)
	  sfclosedel(&extracthandle);
	else
	  sfclose(&extracthandle);
      }
      continue;
    }
    if (a >= 0) {
      if ((a != 0 || strpos2(hs, " stop_7+. ", 1) != 1) &&
	  (a != 1 || strpos2(hs, " stop_text.", 1) != 1) &&
	  (a != 2 || strpos2(hs, " stop_info.", 1) != 1))
	continue;
      if (extracthandle >= minhandle) {
	strcpy(w, extractname);
	end_extract(&extracthandle, extractname, hs);
	sig_7plus_incoming(priv, extractname, w);
      }
      a = -1;
      continue;
    }
    if (a < 0 && strpos2(hs, " go_7+. ", 1) == 1) {
      *is_7plus = true;
      *binstart = rp;
      a = 0;
      if (auto7plusextract && !part) {
	priv = (strcmp(Console_call, board) == 0);
	if (priv || msgtype == 'B')
	  extracthandle = start_extract(priv, 1, hs, subject, absender, board,
					extractname);
      }
      continue;
    }
    if (a < 0 && strpos2(hs, " go_text. ", 1) == 1) {
      if (uspos(".ERR", hs) > 0) {
	*is_7plus = true;
	*binstart = rp;
	a = 1;
	continue;
      }
      if (uspos(".COR", hs) <= 0)
	continue;
      *is_7plus = true;
      *binstart = rp;
      a = 1;
      if (auto7plusextract && !part) {
	priv = (strcmp(Console_call, board) == 0);
	if (priv || msgtype == 'B')
	  extracthandle = start_extract(priv, 2, hs, subject, absender, board,
					extractname);
      }
      continue;
    }
    if (a < 0 && strpos2(hs, " go_info. ", 1) == 1) {
      /*   is_7plus    := true;
           binstart    := rp; */
      a = 2;
      if (auto7plusextract && !part) {
	priv = (strcmp(Console_call, board) == 0);
	if (priv || msgtype == 'B')
	  extracthandle = start_extract(priv, 3, hs, subject, absender, board,
					extractname);
      }
      continue;
    }
    if (a < 0 && strpos2(hsu, "<HTML>", 1) > 0) {
      *is_html = true;
      continue;
    }
    /* NEU: Auch am Anfang einer Mail nach 'ACK' suchen */
    if (strpos2(hs, "/ACK", 1) == 1) {
      del_lastblanks(hs);
      if (!strcmp(hs, "/ACK"))
	*is_ack = true;
      continue;
    }
    if (strpos2(hs, "/ack", 1) == 1) {
      del_lastblanks(hs);
      if (!strcmp(hs, "/ack"))
	*is_ack = true;
      continue;
    }
    if (wpupdate && strpos2(hs, "On ", 1) == 1) {  /* WP */
      if (count_words(hs) < 9)
	continue;

      if (x % 20 == 0)   /* Watchdog resetten         */
	dp_watchdog(2, 4711);

      get_word(hs, w);
      get_word(hs, w);   /*zeit*/
      get_word(hs, call);
      k = strpos2(call, "/", 1);
      if (k <= 0 || k != strlen(call) - 1 || call[k] != 'U')
	continue;
      strdelete((void *)call, k, 2);
      if (!callsign(call))
	continue;
      sprintf(STR1, "%.2s", w);
      j = Str2int(STR1);
      m = Str2int(strsub(STR1, w, 3, 2));
      d = Str2int(strsub(STR1, w, 5, 2));
      h = 0;
      min = 1;
      s = 0;
      time = calc_ixtime(d, m, j, h, min, s);
      if (time <= 0 || time > clock_.ixtime ||
	  time <= clock_.ixtime - 12096000L)
	    /* 14 Tage... */
	      continue;
      get_word(hs, w);
      if (strcmp(w, "@"))
	continue;
      get_word(hs, bbs);
      unhpath(bbs, w);
      if (callsign(w)) {
	sprintf(w, "%ld", time + THEBOX_ERRONEOUS_OFFSET);
	sprintf(hs, "M @ %s < %s $123456123456 %s %s \032",
		e_m_verteiler, call, bbs, w);
	sf_rx_emt1(-17, hs, actwpfilesender);
      }
      continue;
    }
    if (badwordroot == NULL && hs[0] != '/')
      continue;
    if (hs[0] == '/') {
      strcpy(w, hsu);
      get_word(w, shs);
      if (strpos2(shs, "//E", 1) == 1) {
	strcpy(w, "//ECHO");
	if (strpos2(w, shs, 1) == 1) {
	  *is_dirty = true;
	  strcpy(dirtystring, hs);
	}
      }
    }
    if (check_for_dirty(hsu)) {
      *is_dirty = true;
      strcpy(dirtystring, hs);
    }
  }


  if (extracthandle >= minhandle)
    sfclosedel(&extracthandle);
  if (wpupdate)
    *actwpfilesender = '\0';
    
  if (guess_mybbs && txdate > 0 && callsign(absender) && callsign(ackcall))
    update_mybbsfile(false, absender, &txdate, ackcall, "G");
}


/* Diese Funktion liest die letzten vier Zeilen einer im Speicher befind-    */
/* lichen Nachricht durch und prueft, ob sie eine /ACK - Anforderung ent-    */
/* haelt. Da dann auch das reply - Rufzeichen ermittelt werden muss, ruft    */
/* die Funktion die Prozedur GET_LAST_BBS auf, womit dann auch ermittelt     */
/* wird, ob es sich um ein DieBox - Binaerfile handelt.                      */
/* Ab v4.06 ebenfalls Scan nach WP-Infos.                                    */

boolean scan_for_ack(uchar *puffer, long size, boolean wpupdate, boolean part,
		     Char *absender, Char *board, Char *subject, Char msgtype,
		     Char *ackcall, boolean *is_binary, boolean *is_dirty,
		     boolean *is_html, Char *dirtystring, boolean *is_7plus)
{
  long rp, d;
  boolean ack2;
  short x;
  Char hs[256];
  boolean ok;

  debug0(4, 0, 66);
  *ackcall = '\0';
  ok = false;
  rp = size;
  for (x = 1; x <= 4; x++)
    prev_line(puffer, &rp);
  for (x = 1; x <= 4; x++) {
    get_line(puffer, &rp, size, hs);
    upper(hs);
    if (strpos2(hs, "/ACK", 1) == 1) {
      del_lastblanks(hs);
      if (!strcmp(hs, "/ACK"))
	ok = true;
    }
  }
  get_last_bbs(puffer, size, wpupdate, part, absender, board, subject,
	       msgtype, ackcall, is_binary, is_7plus, &ack2, is_dirty,
	       is_html, dirtystring, &d);
  return (ok || ack2);
}



/* Diese Routine untersucht die Nachrichtenkoepfe neu eingehender Mails.     */
/* Mit den daraus gewonnenen Informationen wird der BBS-Router gefuettert.   */
/* Ausserdem wird das Absenderdatum der Nachricht ermittelt.                 */

short scan_hierarchicals(Char *from1, uchar *puffer, long size, long *txdate,
			 boolean sfpartner, Char *lastvias)
{
  short k, i, btc, hops;
  hboxtyp hbox;
  long seekp, rp;
  short lct, lastrl, hbh;
  boolean found;
  long lastminutes, minutes, alterfakt, hmsgct;
  short loops, lviact;
  Char hs[256];
  Char hcall[256], htime[256];
  Char w1[256];
  Char neighbour[7], lastfrom[7];
  Char adesc[256];

  /* R:940424/0945z @:DL8HBS.#BLN.DEU.EU [] #:MSG_NR []    */
  /* R:940424/0945z MSG_NR@DL8HBS.#BLN.DEU.EU              */

  load_initial_hbox();

  debug(2, 0, 67, from1);
  if (*from1 != '\0')
    strcpy(lastfrom, from1);
  else
    strcpy(lastfrom, Console_call);
  *lastvias = '\0';
  lviact = 0;
  strcpy(neighbour, from1);
  *htime = '\0';
  loops = 0;
  hops = 0;
  rp = 0;
  lct = 0;
  lastrl = 0;
  *txdate = 0;
  btc = 0;
  hbh = nohandle;

  if (!exist(hpath_box))
    hbh = sfcreate(hpath_box, FC_FILE);
  else
    hbh = sfopen(hpath_box, FO_RW);

  if (puffer != NULL && size > 0 && hbh >= minhandle) {
    lastminutes = 1;
    do {
      get_line(puffer, &rp, size, hs);
      cut(hs, 120);
      lct++;
      if (strlen(hs) > 6) {
	if (hs[0] == 'R' && hs[1] == ':') {
	  lastrl = lct;
	  get_word(hs, htime);   /*Uhrzeit*/
	  *txdate = get_headerdate(htime);
	  if (*txdate > 0) {
	    if (btc < 3 && badtimecount >= 0 && clock_.ixtime + 600 < *txdate) {
	      btc++;
	      if (btc == 3)
		badtimecount++;
	    } else
	      btc = 4;

	    minutes = (clock_.ixtime - *txdate) / 60;
	    if (minutes < 0) {
	      if (minutes >= -120)
		minutes = lastminutes;
	    }
	    get_word(hs, hcall);
		/* @:Call.at.con oder @Call.at.con oder 12345@Call.at.con */
	    if (strlen(hcall) > 3 && minutes >= 0) {
	      if (minutes < lastminutes)
		minutes = lastminutes;
	      lastminutes = minutes + 1;
	      k = strpos2(hcall, "@", 1);
	      if (k > 0) {
		strdelete((void *)hcall, 1, k);
		if (hcall[0] == ':')
		  strdelete((void *)hcall, 1, 1);
		upper(hcall);

		*adesc = '\0';
		i = strpos2(hs, "[", 1);
		if (i > 0) {
		  k = strpos2(hs, "]", 1);
		  if (k > i + 1) {
		    strsub(adesc, hs, i + 1, k - i - 1);
		    strdelete((void *)hs, 1, k);
		    get_word(hs, w1);
		    if (*w1 != '\0' && isalpha(w1[0]))
		      sprintf(adesc + strlen(adesc), " %s", w1);
		  }
		}

		if (*adesc == '\0') {
		  strcpy(adesc, hs);
		  k = strpos2(adesc, "#:", 1);
		  if (k > 0) {
		    cut(adesc, k - 1);
		    del_blanks(adesc);
		  } else
		    *adesc = '\0';
		}

		if (*adesc == '\0') {
		  strcpy(adesc, hs);
		  k = strpos2(adesc, "#:", 1);
		  if (k > 0) {
		    strdelete((void *)adesc, 1, k);
		    get_word(adesc, w1);   /* MSG_NUMBER */
		    k = strpos2(adesc, "$:", 1);
		    if (k > 0)
		      cut(adesc, k - 1);
		  }
		  del_blanks(adesc);
		}

		cut(adesc, 40);

		*w1 = '\0';
		k = strpos2(hcall, ".", 1);
		if (k > 0 && k < 8) {
		  if (k < strlen(hcall))
		    strsub(w1, hcall, k + 1, strlen(hcall) - k);
		  cut(hcall, k - 1);
		  cut(w1, 40);
		} else
		  cut(hcall, 6);

		if (callsign(hcall)) {
		  if (lviact < 36) {
		    sprintf(lastvias + strlen(lastvias), "%s ", hcall);
		    lviact++;
		  }

		  if (!strcmp(hcall, Console_call))
		    loops++;
		  else {
		    seekp = load_hbox(hbh, hcall, &hbox);
		    found = (strcmp(hbox.call, hcall) == 0);
		    if (found) {
		      if (hbox.msgct < 1)
			hbox.msgct = 0;
		      if (hbox.best < 0)
			hbox.best = 0;
		      if (hbox.aver < 0)
			hbox.aver = 1;
		      else if (hbox.aver >= maxlonginteger)
			hbox.aver = 1;
		      else if (hbox.aver > minutes * 30)
			hbox.aver = minutes;
		      hbox.bytect += size - rp;
		      hbox.msgct++;
		      if (sfpartner) {
			hmsgct = hbox.msgct;
			if (hmsgct > 2000)
			  hmsgct = 2000;
			hbox.aver = (hbox.aver * (hmsgct - 1) + minutes) * 4 /
				    (hmsgct * 4);
			if (hbox.aver < 0)
			  hbox.aver = 1;
		      }
		      if (*txdate > hbox.lasttx) {
			if (*from1 != '\0' && sfpartner) {
			  alterfakt = (clock_.ixtime - hbox.at) / 60;
			  if (alterfakt < 0)
			    alterfakt = 0;
			  if (minutes + hops * 3 <= hbox.best || hbox.best == 0 ||
			      alterfakt > hbox.best + 2000) {
			    hbox.best = minutes + hops * 3;
			    if (hbox.aver < hbox.best)
			      hbox.aver = hbox.best;
			    strcpy(hbox.bestfrom, lastfrom);
			    strcpy(hbox.rxfrom, neighbour);
			    hbox.at = clock_.ixtime;
			  }
			}
			hbox.lasttx = *txdate;
			if (*adesc != '\0')
			  strcpy(hbox.desc, adesc);
			strcpy(hbox.hpath, w1);
		      }
		      if (sfseek(seekp, hbh, SFSEEKSET) == seekp)
			sfwrite(hbh, sizeof(hboxtyp), (uchar *)(&hbox));
		    } else {
		      strcpy(hbox.call, hcall);
		      strcpy(hbox.hpath, w1);
		      strcpy(hbox.bestfrom, lastfrom);
		      strcpy(hbox.rxfrom, neighbour);
		      strcpy(hbox.desc, adesc);
		      hbox.at = clock_.ixtime;
		      hbox.lasttx = *txdate;
		      hbox.msgct = 1;
		      if (sfpartner) {
			hbox.best = minutes + hops * 3;
			hbox.aver = hbox.best;
		      } else {
			hbox.best = SHORT_MAX;
			hbox.aver = SHORT_MAX;
		      }
		      hbox.bytect = size - rp;
		      seekp = sfseek(0, hbh, SFSEEKEND);
		      if (seekp >= 0) {
			if (sfwrite(hbh, sizeof(hboxtyp), (uchar *)(&hbox)) ==
			    sizeof(hboxtyp))
			  add_bptr(hcall, seekp);
		      }
		    }

		  }

		}
	      }
	    }
	    if (callsign(hcall))
	      strcpy(lastfrom, hcall);
	    hops++;
	  }

	}

      }

    } while (rp < size && lct - lastrl <= 0);

    *txdate = get_headerdate(htime);
    if (*txdate == 0)
      *txdate = clock_.ixtime;
  }

  sfclose(&hbh);

  return loops;
}


void pack_entry(uchar **puffer, long *size, short *pmode)
{
  short h1;
  Char archiv[256];
  short packresult;
  long nasize, nsize;
  uchar *nmem;

  debug0(3, 0, 68);
  if (*size <= 0 || *puffer == NULL)
    return;
  sprintf(archiv, "%sINFO%cLZH", tempdir, extsep);
  packresult = huffmempacker(true, *puffer, *size, &nmem, &nsize, archiv,
			     false);
  if (packresult == 0) {
    mymfreep(puffer);
    *size = 0;
    if (nsize == 0) {
      nasize = sfsize(archiv);
      *puffer = Malloc(nasize);
      if (*puffer != NULL) {
	h1 = sfopen(archiv, FO_READ);
	if (h1 >= minhandle) {
	  *size = sfread(h1, nasize, *puffer);
	  sfclose(&h1);
	  if (nasize != *size) {
	    mymfreep(puffer);
	    *size = 0;
	    debug(0, 0, 68, "read error");
	  } else
	    *pmode |= PM_HUFF2;
	} else
	  debug(0, 0, 68, "open error");
      } else
	debug(0, 0, 68, "malloc error");
    } else {
      *puffer = nmem;
      *size = nsize;
      *pmode |= PM_HUFF2;
    }
  }
  sfdelfile(archiv);
  if (*size >= 0)
    return;
  *puffer = NULL;
  *size = 0;
  debug(0, 0, 68, "packerror: size = 0");
}




void _box_mem_init(void)
{
  static int _was_initialized = 0;
  if (_was_initialized++)
    return;
  bidhash = NULL;
  hboxhash = NULL;
  bptr_loaded = false;

}



/* End. */
