#!/usr/bin/perl
#
#	Darryl L. Miles G7LED
#
#	Ack message generator.  Job format goes in, the message is then
#	scanned and checked to see if the last lines which are non-blank
#	begin with slashes.  I have implemented /ACK and /TRACK here.
#	The /ACK must be last if it's to conform with other system, the
#	/TRACK is just to have each BBS mail back an ACK message when it
#	arrives through it.
#
#	The /TRACK can be abused, but we shall look into this later.  For
#	now they are type P, NOT A.
#	
#
#	This is based on my shell script version from 18/04/1995.
#
#	This currently uses the 3rd field in the MGateway file, when it
#	 should really be using the 2nd.
#
#	Version 1.0	06/09/1995
#
#
$FromCall = 'GB7MIP';
#
#############################################################################
###  The rest of this should not need changing, unless it needs fixing!  ####
#############################################################################
#
$TmpBody = "/usr/lbbs/tmp/ack" . $$;
$Prefix = "/usr/lbbs/spool/incoming/";
$Log = "/usr/lbbs/tmp/ack.log";
#
while(($_ = shift(@ARGV))) {
   if($_ eq "\-f") {
      # Senders HA
      # exit 0, I don't consider ACK messages that important.
      $ReplyHA = shift(@ARGV) || exit 0;
   } elsif($_ eq "\-m") {
      # My HA!  Stupid init!
      # exit 0, I don't consider ACK messages that important.
      $MyHA = shift(@ARGV) || exit 0;
   } elsif($_ eq "\-a") {
      # Original To HA.
      # exit 0, I don't consider ACK messages that important.
      $ToHA = shift(@ARGV) || exit 0;
   }
}
#
if(!defined($ReplyHA) || !defined($MyHA) || !defined($ToHA)) {
   exit 0;
}
#
#
#
#   Reverse the message.
#
while(<STDIN>) {
   chop;
   if(/^T(.*)/i) {
      $From = $1;
   } elsif(/^F(.*)/i) {
      $To = $1;
   } elsif(/^\s*$/) {
      last;
   }
}
#
#
if(!defined($To)) {
   exit 0;
}
#
# Strip subject info.
$Subject = <STDIN>;
chop $Subject;

#
# Check now for slash commands.
#
while(<STDIN>) {
   chop;
   if(m#^\s*\/\s*(.+)$#) {
      push(@CMDS, $1);
   } elsif(/^\s*$/) {
      next;
   } else {
      undef(@CMDS);
   }
}

#  No command(s) to perform.
if(!defined(@CMDS)) {
   exit 0;
}

#
$CmdTrack = 0;
$CmrAck = 0;
for $i (@CMDS) {
   if($i =~ /^ACK\s*/i) {
      $CmdAck = 1;
   } elsif($i =~ /^TRACK\s*/i) {
      $CmdTrack = 1;
   }
}

# Only process ACK if we are the dest, i.e. we are the dest, as flagged by the
#  filter.  Only if we are the dest SYSTEM, check with the $MyHA eq $ToHA
#  test.
if(($CmdAck == 1) && ($MyHA eq $ToHA)) {
   $Msg = 'ACK';
   $Status = 'A';
} elsif($CmdTrack == 1) {
   if(($CmdAck == 1) && ($MyHA ne $ToHA)) {
      exit 0;
   }
   $Msg = 'TRACK';
   $Status = 'P';
} else {
   exit 0;
}


if(!open(OUT, "+>$TmpBody")) {
#   print "ERROR: Can not create tmp file for body of message\n";
   exit 0;
}
       

print OUT "C$Status\n";
print OUT "T$To\n";
print OUT "F$FromCall\n";
print OUT "A$ReplyHA\n";
print OUT "\n";
print OUT "$Msg: ", "$Subject\n";

$year = (gmtime(time))[5];
$month = (gmtime(time))[4] + 1;
$day = (gmtime(time))[3];
$hour = (gmtime(time))[2];
$min = (gmtime(time))[1];
$SpoolTo = sprintf("$Prefix%05d%02d%02d%02d", $$, $hour, $min, $sec);

# This is a bodge *just* for me.  Shouldn't be needed by anyone else.
# 
if($FromCall eq "GB7MIP") {
   $line = sprintf("%02d%02d%02d/%02d%02d", $year, $month, $day, $hour, $min);
   print OUT "R:$line @:GB7MIP.#29.GBR.EU LBBS-$Msg\n";
}

print OUT "\n";

close(OUT);



if(rename($TmpBody, $SpoolTo)) {
   &Log("$To @ $ReplyHA < $FromCall");
   exit 0;
} else {
   &Log("$To @ $ReplyHA < $FromCall *** Error");
   print "ERROR: Unable to rename message";
   exit 1;
}

exit 0;



sub Log {
   local($Msg) = $_[0];
   
   if(open(LOG, ">>$Log")) {
      print LOG "$Msg\n";
      close(LOG);
   }
}
