# Script to convert YagiUda files to a format readable by DOS YAGIMAX.

BEGIN {
	#FS="|";
	#OFS="";
	read_parasitic = 0;
	}

END {
	print num_elements, "
";
	print "C
";

	print len_dir[1] * 100, "
";
	print len_driven * 100, "
";
	for (i = 2; i <= num_parasitic; i++)
		print len_dir[i] * 100, "
";

	print x_dir[1] * 100, "
";
	print x_driven * 100, "
";
	for (i = 2; i <= num_parasitic; i++)
		print x_dir[i] * 100, "
";

	print dia_dir[1] * 100, "
";
	print dia_driven * 100, "
";
	for (i = 2; i <= num_parasitic; i++)
		print dia_dir[i] * 100, "
";

	print "YAGIMAX 3.0
"
	print "12-02-96
"
	}

{
	if ($1 == "FREQUENCY")
		frequency = $2;

	if ($1 == "MIN_FREQUENCY")
		min_freqency = $2;

	if ($1 == "MAX_FREQUENCY")
		max_frequency = $3;

	if ($1 == "STEP_FREQUENCY")
		step_frequency = $2;

	if ($1 == "ELEMENTS")
	 	num_elements = $2;

	if ($1 == "DRIVEN")
	 	num_driven = $2;

	if ($1 == "PARASITIC")
	 	num_parasitic = $2;

	if ($1 == "ANGULAR_STEP")
	   	step_angle = $2;

	if ($1 == "DATA_DRIVEN") {
		x_driven = $2;
		y_driven = $3;
		len_driven = $4;
		dia_driven = $5;
	}

	if ($1 == "DATA_PARASITIC") 
		read_parasitic = 1;

	else if (read_parasitic != 0) {
		x_dir[read_parasitic] = $1;
		y_dir[read_parasitic] = $2;
		len_dir[read_parasitic] = $3;
		dia_dir[read_parasitic] = $4;
		read_parasitic += 1;
	}

}

