
/*
   send.c - send data to Yaesu FT-50

   Copyright (c) 1997 Riku Kalinen, OH2LWO, oh2lwo@sral.fi

   RCS $Header: /home/mole/riku/CVS/yaesu/ft50send.c,v 1.2 1997/12/11 15:01:54 riku Exp $

   */

#include <errno.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <termios.h>
#include <stdlib.h>

#include "yaesu.h"

int debug = 0;

/* Write data to Yaesu. Wait every byte to be echoed. Wait ack when block
   finished if so instructed. */

static int yaesu_write (int fd_w, int fd_r, unsigned char *buf, size_t size,
			int waitack)
{
  unsigned char retbuf[32];
  int ret, i, e;

  for (i = 0; i < size; i ++) {
    if (debug) { printf ("%d", i); fflush (stdout); }
    ret = write (fd_w, buf + i, 1);
    if (ret != 1) {
      if (debug) {
	e = errno;
	printf (" Write error, ret=%d, errno=%d\n", ret, e);
      }
      return -1;
    }
    ret = read (fd_r, retbuf, 1);
    if (ret != 1) {
      if (debug) {
	e = errno;
	printf (" Read error (data), ret=%d, errno=%d\n", ret, e);
      }
      return -2;
    }
    if (retbuf[0] != buf[i]) {
      if (debug)
	printf (" Echoed character (%02x) does not match sent (%02x)\n",
		retbuf[0], buf[i]);
      return -3;
    }
    if (debug) { printf ("+"); fflush (stdout); }
  }

  if (! waitack)
    return size;

  ret = read (fd_r, retbuf, 1);
  if (ret != 1) {
    if (debug) {
      e = errno;
      printf (" Read error (ack), ret=%d, errno=%d\n", ret, e);
    }
    return -4;
  }
  if (retbuf[0] != 0x06) {
    if (debug) 
      printf (" Ack character (%02x) is not 0x06\n", retbuf[0]);
    return -5;
  }

  return size;

}

int main (int argc, char *argv[])
{
  int fd, fd_read, fd_write, ret, c;
  unsigned char b1[10], b2[16], b3[112], b4[16], b5[16], b6[1776], b7[1776],
  b8[1];
  unsigned char cksum;
  char str[4096];

  while ((c = getopt (argc, argv, "d")) != -1)
    switch (c) {
    case 'd': debug ++; break;
    case '?': printf ("Usage: send [-d] <device> <infile>\n"); exit (1); break;
    }
 
  if ((argc - optind) != 2) {
    printf ("Usage: send [-d] <device> <infile>\n");
    exit (1);
  }

  fd = open (argv[optind + 1], O_RDONLY);
  if (fd < 0) {
    perror (argv[optind + 1]);
    exit (1);
  }

  ret = read_save_file (fd, b1, b2, b3, b4, b5, b6, b7, b8);
  if (ret != 0) {
    perror ("read_save_file");
    exit (1);
  }

  close (fd);

  cksum = calculate_cksum (b1, b2, b3, b4, b5, b6, b7);
  if (cksum != b8[0]) {
    printf ("Checksum failed, send aborted.\n");
    printf ("Calculated checksum = %02x, checksum form file = %02x .\n",
	    cksum, b8[0]);
    exit (1);
  }

  fd_read = open (argv[optind], O_RDONLY);
  if (fd_read < 0) {
    perror (argv[optind]);
    exit (1);
  }
  fd_write = open (argv[optind], O_WRONLY);
  if (fd_write < 0) {
    perror (argv[optind]);
    exit (1);
  }

  ret = tcflush (fd_write, TCIOFLUSH);
  if (ret != 0) {
    perror ("tcflush fd_write");
    printf ("ret=%d\n", ret);
  }
  ret = tcflush (fd_read, TCIOFLUSH);
  if (ret != 0) {
    perror ("tcflush fd_read");
    printf ("ret=%d\n", ret);
  }

  sprintf (str, "stty 9600 -parenb cs8 -hupcl -cstopb cread clocal -crtscts ignbrk -brkint ignpar -parmrk -inpck -istrip -inlcr -igncr -icrnl -ixon -ixoff -iuclc -ixany -imaxbel -opost -olcuc -ocrnl -onlcr -onocr -onlret -ofill -ofdel nl0 cr0 tab0 bs0 vt0 ff0 -isig -icanon -iexten -echo -echoe -echok -echonl -noflsh -xcase -tostop -echoprt -echoctl -echoke min 1 time 0 < %s > %s", argv[optind], argv[optind]);
  system (str);
  
  printf ("Ensure that radio is in CLON mode and MONI is pressed.\n\n");

  printf ("Sending %d bytes..", sizeof (b1)); fflush (stdout);
  if ((ret = yaesu_write (fd_write, fd_read, b1, sizeof (b1), 1))
      != sizeof (b1)) {
    perror ("yaesu_write b1");
    printf ("yaesu_write returned %d\n", ret);
    exit (1);
  }
  printf ("ok.\n");

  printf ("Sending %d bytes..", sizeof (b2)); fflush (stdout);
  if ((ret = yaesu_write (fd_write, fd_read, b2, sizeof (b2), 1))
      != sizeof (b2)) {
    perror ("yaesu_write b2");
    printf ("yaesu_write returned %d\n", ret);
    exit (1);
  }
  printf ("ok.\n");

  printf ("Sending %d bytes..", sizeof (b3)); fflush (stdout);
  if ((ret = yaesu_write (fd_write, fd_read, b3, sizeof (b3), 1))
      != sizeof (b3)) {
    perror ("yaesu_write b3");
    printf ("yaesu_write returned %d\n", ret);
    exit (1);
  }
  printf ("ok.\n");

  printf ("Sending %d bytes..", sizeof (b4)); fflush (stdout);
  if ((ret = yaesu_write (fd_write, fd_read, b4, sizeof (b4), 1))
      != sizeof (b4)) {
    perror ("yaesu_write b4");
    printf ("yaesu_write returned %d\n", ret);
    exit (1);
  }
  printf ("ok.\n");

  printf ("Sending %d bytes..", sizeof (b5)); fflush (stdout);
  if ((ret = yaesu_write (fd_write, fd_read, b5, sizeof (b5), 1))
      != sizeof (b5)) {
    perror ("yaesu_write b1");
    printf ("yaesu_write returned %d\n", ret);
    exit (1);
  }
  printf ("ok.\n");

  printf ("Sending %d bytes..", sizeof (b6)); fflush (stdout);
  if ((ret = yaesu_write (fd_write, fd_read, b6, sizeof (b6), 1))
      != sizeof (b6)) {
    perror ("yaesu_write b1");
    printf ("yaesu_write returned %d\n", ret);
    exit (1);
  }
  printf ("ok.\n");

  printf ("Sending %d bytes..", sizeof (b7)); fflush (stdout);
  if ((ret = yaesu_write (fd_write, fd_read, b7, sizeof (b7), 1))
      != sizeof (b7)) {
    perror ("yaesu_write b7");
    printf ("yaesu_write returned %d\n", ret);
    exit (1);
  }
  printf ("ok.\n");

  printf ("Sending %d bytes..", sizeof (b8)); fflush (stdout);
  if ((ret = yaesu_write (fd_write, fd_read, b8, sizeof (b8), 0))
      != sizeof (b8)) {
    perror ("yaesu_write b8");
    printf ("yaesu_write returned %d\n", ret);
    exit (1);
  }
  printf ("ok.\n");

  close (fd_read);
  close (fd_write);

  exit (0);

}
