
/*
   get.c - get data from Yaesu VX-1

   Copyright (c) 1997 Riku Kalinen, OH2LWO, oh2lwo@sral.fi

   RCS $Header: /home/mole/riku/CVS/yaesu/vx1get.c,v 1.2 1997/12/11 15:01:58 riku Exp $

   */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>

#include "yaesu.h"

int main (int argc, char *argv[])
{
  int fd, fd_read, fd_write, ret;
  unsigned char b1[4818];
  unsigned char cksum, cksum2;
  char *device;
  char buf[4096];

  if (argc != 3) {
    printf ("Usage: get <device> <outfile>\n");
    exit (1);
  }

  device = argv[1];

  fd = open (argv[2], O_WRONLY | O_CREAT | O_TRUNC, 0666);
  if (fd < 0) {
    perror (argv[2]);
    exit (1);
  }

  fd_read = open (device, O_RDONLY);
  if (fd_read < 0) {
    perror (device);
    printf ("opening %s for reading failed\n", device);
    exit (1);
  }
  fd_write = open (device, O_WRONLY);
  if (fd_write < 0) {
    perror (device);
    printf ("opening %s for write failed\n", device);
    exit (1);
  }

  sprintf (buf, "stty 9600 -parenb cs8 -hupcl -cstopb cread clocal -crtscts ignbrk -brkint ignpar -parmrk -inpck -istrip -inlcr -igncr -icrnl -ixon -ixoff -iuclc -ixany -imaxbel -opost -olcuc -ocrnl -onlcr -onocr -onlret -ofill nl0 cr0 tab0 bs0 vt0 ff0 -isig -icanon -iexten -echo -echoe -echok -echonl -noflsh -xcase -tostop -echoprt -echoctl -echoke min 1 time 0 < %s > %s", device, device);
  system (buf);
  
  printf ("Ensure that the radio is in CLONE mode and press DWN.\n\n");

  printf ("Reading %d bytes..", sizeof (b1)); fflush (stdout);
  if ((ret = repeat_read (fd_read, b1, sizeof (b1), sizeof (b1))) != sizeof (b1)) {
    perror ("read b1");
    printf ("read returned %d\n", ret);
    exit (1);
  }
  printf ("ok.\n");

  close (fd_read);
  close (fd_write);

  printf ("\nVerifying checksums.."); fflush (stdout);
  cksum = calculate_vx1_cksum (b1, sizeof b1 - 1);
  cksum2 = calculate_vx1_cksum_2 (b1, 0xa0);
  if ((cksum == b1[sizeof b1 - 1]) && (cksum2 == b1[0xa0])) {
    printf ("ok. (%02x, %02x)\n", cksum, cksum2);
  } else {
    printf ("FAIL! Calculated checksums = %02x, %02x; checksums from data = %02x, %02x .\n",
	    cksum, cksum2, b1[sizeof b1 - 1], b1[0xa0]);
    printf ("WARNING: Data may be unusable!\n");
  }

  printf ("\nWriting out %d bytes..", sizeof b1); fflush (stdout);

  ret = write_vx1_save_file (fd, b1, sizeof b1);

  if (ret != 0) {
    perror ("write_save_file");
    printf ("WARNING: Data may be unusable!\n");
    exit (1);
  }
 
  close (fd);

  printf ("ok.\n");
  
  exit (0);

}
