/************************************************************************/
/*                                                                      */
/*                                                                      */
/*    *****                       *****                                 */
/*      *****                   *****                                   */
/*        *****               *****                                     */
/*          *****           *****                                       */
/*  ***************       ***************                               */
/*  *****************   *****************                               */
/*  ***************       ***************                               */
/*          *****           *****           TheNetNode                  */
/*        *****               *****         Portable                    */
/*      *****                   *****       Network                     */
/*    *****                       *****     Software                    */
/*                                                                      */
/* This file is part of "TheNetNode" - Software Package                 */
/*                                                                      */
/* Copyright (C) 1998  NORD><LINK e.V. Braunschweig                     */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the NORD><LINK ALAS (Allgemeine Lizenz fuer    */
/* Amateurfunk Software) as published by Hans Georg Giese (DF2AU)       */
/* on 13/Oct/1992; either version 1, or (at your option) any later      */
/* version.                                                             */
/*                                                                      */
/* This program is distributed WITHOUT ANY WARRANTY only for further    */
/* development and learning purposes. See the ALAS (Allgemeine Lizenz   */
/* fuer Amateurfunk Software).                                          */
/*                                                                      */
/* You should have received a copy of the NORD><LINK ALAS (Allgemeine   */
/* Lizenz fuer Amateurfunk Software) along with this program; if not,   */
/* write to NORD><LINK e.V., Hinter dem Berge 5, D-3300 Braunschweig    */
/*                                                                      */
/* Dieses Programm ist PUBLIC DOMAIN, mit den Einschraenkungen durch    */
/* die ALAS (Allgemeine Lizenz fuer Amateurfunk Software), entweder     */
/* Version 1, veroeffentlicht von Hans Georg Giese (DF2AU),             */
/* am 13.Oct.1992, oder (wenn gewuenscht) jede spaetere Version.        */
/*                                                                      */
/* Dieses Programm wird unter Haftungsausschlu vertrieben, aus-        */
/* schliesslich fuer Weiterentwicklungs- und Lehrzwecke. Naeheres       */
/* koennen Sie der ALAS (Allgemeine Lizenz fuer Amateurfunk Software)   */
/* entnehmen.                                                           */
/*                                                                      */
/* Sollte dieser Software keine ALAS (Allgemeine Lizenz fuer            */
/* Amateurfunk Software) beigelegen haben, wenden Sie sich bitte an     */
/* NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig            */
/*                                                                      */
/*                                                                      */
/************************************************************************/

#include <stdio.h>
#include <string.h>

#ifdef __linux__
#define INFILE "tnn170.pas"
#else
#define INFILE "tnn175.pas"
#endif

char    infile[20];
char    outfile[20];
FILE    *ifd;
FILE    *ofd;
char    str[256];
char    str2[256];
int     state;

void
open_files(void)
{
  sprintf(infile, INFILE);
  sprintf(outfile, "tnn176.pas");
#ifndef __linux__
  strupr(infile);
  strupr(outfile);
#endif
  ifd = fopen(infile, "rt");
  if (ifd == NULL)
   {
    printf("Input file %s not found!\n", infile);
    exit(1);
   }
  ofd = fopen(outfile, "rt");
  if (ofd != NULL)
   {
    printf("Output file %s exists!\n", outfile);
    fclose(ifd);
    fclose(ofd);
    exit(1);
   }
  fclose(ofd);
  ofd = fopen(outfile, "wt");
  if (ofd == NULL)
   {
    printf("Open error %s\n", outfile);
    fclose(ifd);
    exit(1);
   }
}

#define BEGIN   0
#define PASWRD  1
#define LOGIN   2
#define CONPWD  3
#define IDENT   4
#define CALL    5
#define CONV    6
#define TEXT    7
#define TEXTCMD 8
#define USEREXE 9
#define SYSEXE  10
#define PACSAT  11

void
main(int argc, char *argv[])
{
  open_files();
  state = BEGIN;
  while (!feof(ifd))
   {
    if (!fgets(str, 255, ifd)) break;
#ifndef __linux__
    if (str[0] != ';')
#else
    if (str[0] != '#')
#endif
     {
      switch(++state)
       {
        case LOGIN:
        case CONV:
          break;

        default:
          fputs(str, ofd);
          break;
       }
     }
    else
     {
#ifdef __linux__
      str[0] = ';';
#endif
      switch(state)
       {
        case PASWRD:
          if (strstr(str, "Login") == NULL)
            fputs(str, ofd);
          break;

        case CALL:
          if (strstr(str, "Convers") == NULL)
            fputs(str, ofd);
          break;

        default:
          fputs(str, ofd);
          break;
       }
     }
   }
  fclose(ifd);
  fclose(ofd);
  if (state < PACSAT)
    puts("WARNING! PACSAT-PATH NOT SET!\n");
  if (state < SYSEXE)
    puts("ERROR! SYSOPEXE-PATH NOT SET!\n");
}
