/************************************************************************/
/*                                                                      */
/*                                                                      */
/*    *****                       *****                                 */
/*      *****                   *****                                   */
/*        *****               *****                                     */
/*          *****           *****                                       */
/*  ***************       ***************                               */
/*  *****************   *****************                               */
/*  ***************       ***************                               */
/*          *****           *****           TheNetNode                  */
/*        *****               *****         Portable                    */
/*      *****                   *****       Network                     */
/*    *****                       *****     Software                    */
/*                                                                      */
/* This file is part of "TheNetNode" - Software Package                 */
/*                                                                      */
/* Copyright (C) 1998  NORD><LINK e.V. Braunschweig                     */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the NORD><LINK ALAS (Allgemeine Lizenz fr     */
/* Amateurfunk Software) as published by Hans Georg Giese (DF2AU)       */
/* on 13/Oct/1992; either version 1, or (at your option) any later      */
/* version.                                                             */
/*                                                                      */
/* This program is distributed WITHOUT ANY WARRANTY only for further    */
/* development and learning purposes. See the ALAS (Allgemeine Lizenz   */
/* fr Amateurfunk Software).                                           */
/*                                                                      */
/* You should have received a copy of the NORD><LINK ALAS (Allgemeine   */
/* Lizenz fr Amateurfunk Software) along with this program; if not,    */
/* write to NORD><LINK e.V., Hinter dem Berge 5, D-3300 Braunschweig    */
/*                                                                      */
/* Dieses Programm ist PUBLIC DOMAIN, mit den Einschrnkungen durch     */
/* die ALAS (Allgemeine Lizenz fr Amateurfunk Software), entweder      */
/* Version 1, verffentlicht von Hans Georg Giese (DF2AU),              */
/* am 13.Oct.1992, oder (wenn gewnscht) jede sptere Version.          */
/*                                                                      */
/* Dieses Programm wird unter Haftungsausschlu vertrieben, aus-        */
/* schlielich fr Weiterentwicklungs- und Lehrzwecke. Nheres          */
/* knnen sie der ALAS (Allgemeine Lizenz fr Amateurfunk Software)     */
/* entnehmen.                                                           */
/*                                                                      */
/* Sollte dieser Software keine ALAS (Allgemeine Lizenz fr Amateurfunk */
/* Software) beigelegen haben, wenden Sie sich bitte an                 */
/* NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig            */
/*                                                                      */
/*                                                                      */
/************************************************************************/

#include "tnn.h"

/**************************************************************************\
*                                                                          *
* action      :  "relink message list to sent list"                        *
*                                                                          *
*                Frameliste in Gesendete-Frames-Liste umhaengen.           *
*                                                                          *
 **************************************************************************
*                                                                          *
* parameter   :  mlp     - in stfl umzuhaengende Frameliste                *
*                                                                          *
* r/o globals :  -                                                         *
*                                                                          *
* r/w globals :  stfl    - Liste der schon gesendeten Frames               *
*                                                                          *
* locals      :  -                                                         *
*                                                                          *
* returns     :  -                                                         *
*                                                                          *
\**************************************************************************/

void rlmlsl(LEHEAD *mlp)
{
  while (mlp->nextle != mlp)
    relink(ulink((LEHEAD *)mlp->nextle),
    (LEHEAD *) stfl.tail);
}

/**************************************************************************\
*                                                                          *
* action      :  "put character"                                           *
*                                                                          *
*                Zeichen in Messagebuffer schreiben, Put-Counter erhoehen  *
*                und Buffer-Pointer setzen. Ist der aktuelle Datenbuffer   *
*                im Messagebuffer voll, dann neuen Datenbuffer allokieren  *
*                und ans Datenbufferlistenende des Messagebuffers          *
*                anhaengen.                                                *
*                                                                          *
 **************************************************************************
*                                                                          *
* parameter   :  ch      - in den Buffer zu schreibendes Zeichen           *
*                mbhd    - Zeiger auf den Messagebuffer-Kopf, in den ch    *
*                          zu schreiben ist                                *
*                                                                          *
* r/o globals :  -                                                         *
*                                                                          *
* r/w globals :  -                                                         *
*                                                                          *
* locals      :  -                                                         *
*                                                                          *
* returns     :  -                                                         *
*                                                                          *
\**************************************************************************/

void putchr(WORD ch, MBHEAD *mbhd)
{
  if (mbhd->mbpc++ % sizeof_MBDATA == 0)
    mbhd->mbbp = ((MB *)(relink((LEHEAD *)allocb(),(LEHEAD *)mbhd->mbl.tail)))->data;
  *mbhd->mbbp++ = ch;
}

/**************************************************************************\
*                                                                          *
* action      :  "get character"                                           *
*                                                                          *
*                Zeichen aus einem Messagebuffer holen. Datenbuffer-Poiner *
*                setzen und Get-Count erhoehen. Uebergang in der           *
*                Datenbufferliste vom Ende eines Datenbuffers zum          *
*                naechsten ausfuehren.                                     *
*                                                                          *
 **************************************************************************
*                                                                          *
* parameter   :  mbhd    - Zeiger auf Kopf des Messagebuffers, aus dem     *
*                          das Zeichen gelesen werden soll                 *
*                                                                          *
* r/o globals :  -                                                         *
*                                                                          *
* r/w globals :  -                                                         *
*                                                                          *
* locals      :  -                                                         *
*                                                                          *
* returns     :  aus dem Buffer gelesenes Zeichen                          *
*                                                                          *
\**************************************************************************/

char getchr(MBHEAD *mbhd)
{
  if (mbhd->mbgc++ % sizeof_MBDATA == 0)
    mbhd->mbbp = ((MB *)((MAX_BUFFER huge *)(mbhd->mbbp)-1))->nextmb->data;
  return ((char)*mbhd->mbbp++);
}

/* End of L2D.C */
