/************************************************************************/
/*                                                                      */
/*                                                                      */
/*    *****                       *****                                 */
/*      *****                   *****                                   */
/*        *****               *****                                     */
/*          *****           *****                                       */
/*  ***************       ***************                               */
/*  *****************   *****************                               */
/*  ***************       ***************                               */
/*          *****           *****           TheNetNode                  */
/*        *****               *****         Portable                    */
/*      *****                   *****       Network                     */
/*    *****                       *****     Software                    */
/*                                                                      */
/* This file is part of "TheNetNode" - Software Package                 */
/*                                                                      */
/* Copyright (C) 1998  NORD><LINK e.V. Braunschweig                     */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the NORD><LINK ALAS (Allgemeine Lizenz fr     */
/* Amateurfunk Software) as published by Hans Georg Giese (DF2AU)       */
/* on 13/Oct/1992; either version 1, or (at your option) any later      */
/* version.                                                             */
/*                                                                      */
/* This program is distributed WITHOUT ANY WARRANTY only for further    */
/* development and learning purposes. See the ALAS (Allgemeine Lizenz   */
/* fr Amateurfunk Software).                                           */
/*                                                                      */
/* You should have received a copy of the NORD><LINK ALAS (Allgemeine   */
/* Lizenz fr Amateurfunk Software) along with this program; if not,    */
/* write to NORD><LINK e.V., Hinter dem Berge 5, D-3300 Braunschweig    */
/*                                                                      */
/* Dieses Programm ist PUBLIC DOMAIN, mit den Einschrnkungen durch     */
/* die ALAS (Allgemeine Lizenz fr Amateurfunk Software), entweder      */
/* Version 1, verffentlicht von Hans Georg Giese (DF2AU),              */
/* am 13.Oct.1992, oder (wenn gewnscht) jede sptere Version.          */
/*                                                                      */
/* Dieses Programm wird unter Haftungsausschlu vertrieben, aus-        */
/* schlielich fr Weiterentwicklungs- und Lehrzwecke. Nheres          */
/* knnen sie der ALAS (Allgemeine Lizenz fr Amateurfunk Software)     */
/* entnehmen.                                                           */
/*                                                                      */
/* Sollte dieser Software keine ALAS (Allgemeine Lizenz fr Amateurfunk */
/* Software) beigelegen haben, wenden Sie sich bitte an                 */
/* NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig            */
/*                                                                      */
/*                                                                      */
/************************************************************************/

#include "tnn.h"

/**************************************************************************\
*                                                                          *
* "deallocate message list"                                                *
*                                                                          *
* Komplette Messageliste, auf deren Listenkopf mlp zeigt, deallokieren.    *
* D.h. alle Messagespeicher (jeweils Kopf und daran haengende Datenbuffer) *
* deallokieren.                                                            *
*                                                                          *
*                                                                          *
*            +--------+    +--------+               +--------+             *
*    mlp --->| head   |--->|        |--->       --->|        |---> mlp     *
*            +--------+    +--------+      ...      +--------+             *
*      b <---| tail   |<---|        |<---       <---|        |<--- b       *
*            +--------+    +--------+               +--------+             *
*                          |        |---> \         |        |---> \       *
*                          +        +      |        +        +      |      *
*                          |        |<--- /|        |        |<--- /|      *
*                          +--------+      |        +--------+      |      *
*                          |        |      |        |        |      |      *
*                                          |                        |      *
*      deallokieren                        |------------------------|      *
*                                            siehe unten dealmb()          *
*                                                                          *
\**************************************************************************/
/*#include "coredump.c"*/
void dealml(LEHEAD *mlp)
{
  MBHEAD *bp;                          /* Zeiger auf Messagebufferhead   */

#if 0
  int i;

  for (bp  = (MBHEAD *) mlp->nextle, i = 0;
       bp != (MBHEAD *) mlp;
       bp  = (MBHEAD *) bp->nextmh)
    if (++i > 10000) { /* Fehler !!! */
       coredump();
       i = *((char*)NULL); /* Zugriff auf NULL-Pointer */
       exit(-1);           /* notfalls normaler exit   */
    }
#endif

  LOOP                                  /* fuer alle Messagebufferheads   */
  {                                     /* in Messagespeicherliste :      */
    bp = (MBHEAD *) mlp->nextle;        /* Zeiger auf naechsten Msgbhead  */
    if (mlp == (LEHEAD *) bp)           /* Schwanz beisst Kopf -> fertig  */
      break;                            /* sonst Messagespeicher deallok. */
    dealmb((MBHEAD *)ulink((LEHEAD *)bp));
  }
}

/**************************************************************************\
*                                                                          *
* "deallocate message buffer"                                              *
*                                                                          *
* Einen kompletten Messagespeicher, auf dessen Kopf mbhd zeigt,            *
* deallokieren, d.h. sowohl den Messagebufferhead als auch alle an dessen  *
* Messagebufferliste haengende Datenbuffer deallokieren.                   *
*                                                                          *
*                                                                          *
*            +--------+           deallokieren                             *
*    mbhd -->|        |                                                    *
*            +--------+                                                    *
*            |        |                                                    *
*            +--------+      +--------+                +--------+          *
*      a --->|        |----->|        |--->        --->|        |---> a    *
*            +  mbl   +      +--------+      ...       +--------+          *
*      b <---|        |<-----|        |<---        <---|        |<--- b    *
*            +--------+      +--------+                +--------+          *
*            |        |      |        |                |        |          *
*                                                                          *
\**************************************************************************/
void dealmb(MBHEAD *mbhd)
{
  MB *bp;                                       /* Datenbufferzeiger      */
                                                /* alle Datenbuffer       */
  while ((bp = (MB*) mbhd->mbl.head) != (MB*)&mbhd->mbl)
    dealoc((MBHEAD *)ulink((LEHEAD *)bp));
  dealoc(mbhd);                                 /* Am Ende den Kopf       */
}

/**************************************************************************\
*                                                                          *
* "deallocate"                                                             *
*                                                                          *
* Buffer, auf den bp zeigt, initialisieren als neuen Messagebufferhead     *
* (rwndmb()) und deallokieren, d.h. in die Freiliste freel einhaengen und  *
* den Freibufferzaehler nmbfre inkrementieren.                             *
*                                                                          *
*                                                                          *
*            +--------+                                                    *
*     bp --->|        |         deallokieren                               *
*            +--------+                                                    *
*            |        |                                                    *
*            +--------+                                                    *
*            |        |                                                    *
*                                                                          *
\**************************************************************************/
#ifdef __LINUX__
#ifndef NO_WATCHDOG
static  struct  timeval tv2;
static  struct  timezone tz2;
static time_t tmptime;
char dealoczeit[40];
#endif
#endif

void dealoc(MBHEAD *bp)
{
  bp->mbl.head =                /* als Messagehead initialisieren         */
  bp->mbl.tail =                /*   Bufferlistenkopf                     */
  &bp->mbl;                     /*   initialisieren                       */
  bp->mbpc = 0;                 /*   Message leer                         */
  bp->mbgc = 0;                 /*   Rest initialisieren                  */
  bp->mbbp = NULL;
  rwndmb(bp);                   /* Buffer an Freiliste anhaengen          */
  relink((LEHEAD  *)bp,(LEHEAD *)freel.tail);
  ++nmbfre;                     /* 1 Freibuffer mehr                      */

#ifdef __LINUX__
#ifndef NO_WATCHDOG
/* Der folgende Code ist ein Notnagel ... sporadisch landet TNN in einer  */
/* Endlosschleife, in der beliebig lange irgendwelche Daten deallociert   */
/* werden. Bei der Linux-TNN gibt es aber (noch) keinen Watchdog, der bei */
/* solchen Programmschleifen fuer einen Neustart sorgen koennte ...       */
  gettimeofday(&tv2,&tz2);             /* im Core-File Zeit dokumentieren */
  sprintf(dealoczeit,"%s",ctime((time_t *) &tv2.tv_sec));
  tmptime = time(NULL);
  if ((tmptime - sys_time) > 30)
    *((int *) NULL) = 0;                      /* crash - fuer Fehlersuche */
#endif
#endif
}

/**************************************************************************\
*                                                                          *
* "initialize head"                                                        *
*                                                                          *
* Listenkopf, auf den hd zeigt, initialisieren :                           *
*                                                                          *
*                                                                          *
*                                              +----------------------+    *
*                                              | +------------------+ |    *
*                                              | |                  | |    *
*            +--------+                        v v   +--------+     | |    *
*     hd --->|        |         ->        hd ------->|        |-----+ |    *
*            +--------+                              +--------+       |    *
*            |        |                              |        |-------+    *
*            +--------+                              +--------+            *
*            |        |                              |        |            *
*                                                                          *
\**************************************************************************/
void inithd(LHEAD *hd)
{
  hd->head = hd->tail = hd;
}

/**************************************************************************\
*                                                                          *
* action      :  "rewind message buffer"                                   *
*                                                                          *
*                Message-Buffer (Kopf und Datenbufferliste) zuruecksetzen. *
*                Get-Counter auf 0 setzen, Buffer-Pointer so setzen, dass  *
*                beim naechsten getchr() auf das das erste Datenbyte des   *
*                ersten Datenbuffers zugegriffen wird.                     *
*                (Dies muss wie folgt geschehen, da der Get-Counter in     *
*                jedem Fall auf 0 stehen muss und in getchr() auf % 32     *
*                fuer das Positionieren auf den naechsten Datenbuffer      *
*                abgetestet wird.)                                         *
*                                                                          *
 **************************************************************************
*                                                                          *
* parameter   :  mbhd    - Zeiger auf Kopf des Message-Buffers             *
*                                                                          *
\**************************************************************************/
void rwndmb(MBHEAD *mbhd)
{
                                        /* Kopf wie Datenbufferende       */
  mbhd->mbbp = (char *)(((MAX_BUFFER huge *)&(mbhd->mbl))+1);
  mbhd->mbgc = 0;                       /* Bufferanfang                   */
}

/**************************************************************************\
*                                                                          *
* action      :  "allocate buffer"                                         *
*                                                                          *
*                Leeren Buffer aus der Freiliste holen, Pogrammneustart    *
*                wenn keine Buffer mehr in Freiliste.                      *
*                                                                          *
 **************************************************************************
*                                                                          *
* r/w globals :  nmbfre  - Anzahl der Buffer in Freiliste freel            *
*                freel   - verkettete Liste der freien Buffer              *
*                                                                          *
* locals      :  s.u.                                                      *
*                                                                          *
* returns     :  Zeiger auf freien Buffer, fall vorhanden                  *
*                                                                          *
\**************************************************************************/
LEHEAD *allocb()
{
  LEHEAD  *ret;                          /* Buffer Rueckgabewert           */

  nmbfre--;                             /* 1 Buffer weniger               */
  if (nmbfre < nmbfre_min)
    nmbfre_min = nmbfre;
  if (!nmbfre)                          /* wenn nicht genug frei          */
    HALT("allocb");                     /* dann Rechner neu starten..     */
  ret = ulink((LEHEAD *)freel.head);    /* Buffer aus Liste aushaengen    */
  return(ret);                          /* Zeiger auf Freibuffer zurueck  */
}

/**************************************************************************\
*                                                                          *
* action      :  Element aus Liste aushaengen.                             *
*                                                                          *
*                                                                          *
*                      le ---+                                             *
*              vor           |     raus                hinter              *
*            +--------+      +-->+--------+          +--------+            *
*      ----->|        |--------->| prevle |--------->|        |----->      *
*            +--------+          +--------+          +--------+            *
*      <-----|        |<---------| nextle |<---------|        |<-----      *
*            +--------+          +--------+          +--------+            *
*            |        |          |        |          |        |            *
*                                                                          *
*                                                                          *
*                                \/                                        *
*                                                                          *
*                                                                          *
*             raus                    vor             hinter               *
*           +--------+              +--------+      +--------+             *
*    le --->| nextle |        ----->|        |----->|        |----->       *
*           +--------+              +--------+      +--------+             *
*           | prevle |        <-----|        |<-----|        |<-----       *
*           +--------+              +--------+      +--------+             *
*           |        |              |        |      |        |             *
*                                                                          *
*                                                                          *
 **************************************************************************
*                                                                          *
* parameter   :  le      - Zeiger auf auszuhaengendes Listenelement        *
*                                                                          *
* returns     :  le                                                        *
*                                                                          *
\**************************************************************************/
LEHEAD *ulink(LEHEAD *le)
{
  le->prevle->nextle = le->nextle;      /* Hinliste ohne le               */
  le->nextle->prevle = le->prevle;      /* Rueckliste ohne le             */
  return(le);                           /* Zeiger auf das Element zurueck */
}

/**************************************************************************\
*                                                                          *
* action      :  Element in Liste einhaengen.                              *
*                                                                          *
*                                                                          *
*             neu                     vor             hinter               *
*           +--------+              +--------+      +--------+             *
*   new --->| nextle |     pred --->|        |----->|        |----->       *
*           +--------+              +--------+      +--------+             *
*           | prevle |        <-----|        |<-----|        |<-----       *
*           +--------+              +--------+      +--------+             *
*           |        |              |        |      |        |             *
*                                                                          *
*                                                                          *
*                                \/                                        *
*                                                                          *
*                                                                          *
*                     new ---+                                             *
*              vor           |     neu                 hinter              *
*            +--------+      +-->+--------+          +--------+            *
*   pred --->|        |--------->| prevle |--------->|        |----->      *
*            +--------+          +--------+          +--------+            *
*      <-----|        |<---------| nextle |<---------|        |<-----      *
*            +--------+          +--------+          +--------+            *
*            |        |          |        |          |        |            *
*                                                                          *
*                                                                          *
 **************************************************************************
*                                                                          *
* parameter   :  new     - Zeiger auf einzuhaengendes Listenelement        *
*                pred    - Zeiger auf Listenelement, hinter dem new        *
*                          eingehaengt werden soll                         *
*                                                                          *
* returns     :  new                                                       *
*                                                                          *
\**************************************************************************/
LEHEAD *relink(LEHEAD *new, LEHEAD *pred)
{
  new->nextle = pred->nextle;           /* Vorzeiger im neuen Element     */
  new->prevle = pred;                   /* Rueckzeiger im neuen Element   */
  new->nextle->prevle = new;            /* Rueckzeiger dahinter           */
  pred->nextle = new;                   /* Vorzeiger davor                */
  return(new);                          /* Zeiger auf neues Element       */
}

/************************************************************************/
/* Anfang des freien Speichers                                          */
/*----------------------------------------------------------------------*/
char huge *minmem(void)
{
  return(RAMBOT);
}

/************************************************************************/
/* Ende des freien Speichers                                            */
/*----------------------------------------------------------------------*/
char huge *maxmem(void)
{
  return(RAMTOP);
}

/************************************************************************/
/* Buffer-Verwaltung initialisieren.                                    */
/*----------------------------------------------------------------------*/
void init_buffers(void)
{
  MAX_BUFFER huge *actbp;
  ULONG n;

  nmblks = nmbfre = nmblks_max = 0;

  actbp = (MAX_BUFFER *)minmem();
  n = (ULONG)((maxmem() - minmem()) / sizeof(MAX_BUFFER));
  while (n--)
    dealoc ((MBHEAD *) actbp++);

#ifdef __DOS16__
  alloc_umb();                     /* steht in MEM386.C                 */
#endif
  nmbfre_min = nmbfre_max = nmbfre;
}

/* End of BUFFER.C */
