/* Copyright (C) 1999 Chris Vine, G3XXF

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#ifndef BUFFERS_H
#define BUFFERS_H

#include "qqueue.cpp"  // include entire template definition, to generate Qqueue<char> object
#include <iostream.h>
#include <fstream.h>
#include "prog_defs.h"
typedef unsigned char uchar;

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

class Transmit_buffer: private Qqueue<char> {
    int line_lettercount;  // used to indicate whether we are at the beginning of a line
    int can_transmit_delete_flag;
    int foundCMDinbuffer;
public:
    void set_can_transmit_delete(int setting) {can_transmit_delete_flag = setting;}
    int add_letter(char);
    int extract_letter(void);
    int view_letter(void);
    int erase_letter(void);
    int letters_free(void) const {return Qqueue<char>::is_free();}
    int is_empty(void) const {return Qqueue<char>::is_empty();}
    int letters_used(void) const {return Qqueue<char>::is_used();}
    void reset(void);
    Transmit_buffer(void): Qqueue<char>(TR_BUFFER_SIZE, 0), line_lettercount(0),
        can_transmit_delete_flag(FALSE), foundCMDinbuffer(FALSE) {}
};

///////////////////////////////////////////////////////////////////////////////////////

class FileBuffer: public Qqueue<char> {
public:
    enum Buffer_mode{text, binary, s_plus};
private:
    Buffer_mode buffer_mode;
    int stream;
    int port;
public:
    Buffer_mode get_buffer_mode(void) const {return buffer_mode;}
    int get_stream(void) const {return stream;}
    int get_port(void) const {return port;}
    virtual void end_loading(void) = 0;
    virtual int load_buffer(void) = 0;
    virtual void show_bytes(void) {}
    virtual char front(Qqueue_enum::extract_mode mode) {return Qqueue<char>::front(mode);}
    FileBuffer(Buffer_mode a, int b, int c): Qqueue<char>(FILE_BUFFER_SIZE, 0),
                 buffer_mode(a), stream(b), port(c) {}
    virtual ~FileBuffer(void){}
};


#endif
