#ifndef _NEWQPSKRX_H
#define _NEWQPSKRX_H

/* --------------------------------------------------------------------- */

struct rxstate {
	struct hdlc_receiver hdlc;
	struct fecstate fec;
	unsigned bps;
	unsigned shreg;
	void (*rxroutine) (void **);
	float *rxwindowfunc;

        /*
         * rxbuf length needs to be at least AliasFilterLen +
         * DecimateRatio + DecimateRatio*SymbolLen/2 +
         * 3/2*DecimateRatio*SymbolLen/2 = 64 + 3 + 48 + 72 = 187
         */
	float rxbuf[256];
	unsigned bufptr;
	int skip;

	complex rxpipe[RxPipeLen][DataCarriers];
	unsigned rxptr;

	float carrierfreq;		/* current rx carrier frequency	*/
	float rxphase;			/* current rx NCO phase		*/

	complex rxwin[WindowLen];
	complex fftbuf[WindowLen];
	int rxphasecorr;

	int acceptance;
	int atsymbol;
	int statecntr;
	int updhold;
	int bitbatches;

	/* tune mode power and correlations */
	float tunepower[TuneCarriers];
	float tunephase[TuneCarriers];
	complex tunecorr[TuneCarriers];

	/* sync mode at-symbol power and correlations */
	float power_at[TuneCarriers];
	complex corr1_at[TuneCarriers];
	complex corr2_at[TuneCarriers];

	/* sync mode inter-symbol power and correlations */
	float power_inter[TuneCarriers];
	complex corr1_inter[TuneCarriers];
	complex corr2_inter[TuneCarriers];

	float syncphase[TuneCarriers];
	float syncdelay[TuneCarriers];

	/* data mode */
	float phesum[DataCarriers];	/* Phase error sum              */
	float pheavg[DataCarriers];	/* Phase error average          */
	float dcdavg[DataCarriers];	/* Phase error power average    */
	float power[DataCarriers];	/* Carrier power average        */
	float correl[DataCarriers];	/* Sync correlation average     */

	float phemax;			/* maximum phase error sum      */

	int fecerrors[DataCarriers];	/* FEC errors per carrier       */
};

/* --------------------------------------------------------------------- */

extern void init_newqpskrx(void **);
extern void newqpskrx(void **);

/* --------------------------------------------------------------------- */

#endif
