/*****************************************************************************/

/*
 *      util.h  --  utility functions.
 *
 *      Copyright (C) 1996  Thomas Sailer (sailer@ife.ee.ethz.ch)
 *        Swiss Federal Institute of Technology (ETH), Electronics Lab
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 */

/*****************************************************************************/
 
#ifndef _UTIL_H
#define _UTIL_H

/* --------------------------------------------------------------------- */

#include <unistd.h>
#include <sys/mman.h>
#include <stdarg.h>

/* --------------------------------------------------------------------- */

#ifdef HAVE_ANON_MMAP
extern inline void *mmap_anon(void *start, size_t length, int prot, int flags)
{
	return mmap(start, length, prot, flags | MAP_ANONYMOUS, -1, 0);
}
#else
extern void *mmap_anon(void *start, size_t length, int prot, int flags);
#endif

#ifndef HAVE_SNPRINTF
extern int snprintf(char *str, size_t n, const char *format, ...);
#endif

#ifndef HAVE_VSNPRINTF
extern int vsnprintf(char *str, size_t n, const char *format, va_list ap);
#endif

/* --------------------------------------------------------------------- */

extern __inline__ unsigned int hweight32(unsigned int w)
{
        unsigned int res = (w & 0x55555555) + ((w >> 1) & 0x55555555);
        res = (res & 0x33333333) + ((res >> 2) & 0x33333333);
        res = (res & 0x0F0F0F0F) + ((res >> 4) & 0x0F0F0F0F);
        res = (res & 0x00FF00FF) + ((res >> 8) & 0x00FF00FF);
        return (res & 0x0000FFFF) + ((res >> 16) & 0x0000FFFF);
}

extern __inline__ unsigned int hweight16(unsigned short w)
{
        unsigned short res = (w & 0x5555) + ((w >> 1) & 0x5555);
        res = (res & 0x3333) + ((res >> 2) & 0x3333);
        res = (res & 0x0F0F) + ((res >> 4) & 0x0F0F);
        return (res & 0x00FF) + ((res >> 8) & 0x00FF);
}

extern __inline__ unsigned int hweight8(unsigned char w)
{
        unsigned short res = (w & 0x55) + ((w >> 1) & 0x55);
        res = (res & 0x33) + ((res >> 2) & 0x33);
        return (res & 0x0F) + ((res >> 4) & 0x0F);
}

/* --------------------------------------------------------------------- */

extern __inline__ unsigned int gcd(unsigned int x, unsigned int y)
{
        for (;;) {
                if (!x)
                        return y;
                if (!y)
                        return x;
                if (x > y)
                        x %= y;
                else
                        y %= x;
        }
}

extern __inline__ unsigned int lcm(unsigned int x, unsigned int y)
{
        return x * y / gcd(x, y);
}

/* --------------------------------------------------------------------- */

extern __inline__ int log2(unsigned int i)
{
	int ret = 0;
	
	if (!i)
		return -1;
	if (i >= 0x10000LU) {
		i >>= 16;
		ret += 16;
	}
	if (i >= 0x100LU) {
		i >>= 8;
		ret += 8;
	}
	if (i >= 0x10LU) {
		i >>= 4;
		ret += 4;
	}
	if (i >= 0x4LU) {
		i >>= 2;
		ret += 2;
	}
	return (i >= 2) ? ret + 1 : ret;
}

/* --------------------------------------------------------------------- */
#endif /* _UTIL_H */
