#include "sun.h"

void sh_grayline(int max_loc)
{
   int	loc,valid; 
   Grayline	grayline;
   char sunrise[8],sunset[8],dawn[8],dusk[8];

   print_header(GRAYLINE,"");
   valid=0;
   for (loc=0;loc<max_loc;loc++)
   {
      switch(locations[loc].pref[0])
      {
      	case '#':
            print_not_in_database(locations[loc].name);
            break;
         case '?':
            print_data_not_available(locations[loc].name);
            break;
         default:
            grayline = 
               graylinetimes(locations[loc].loc.lat,locations[loc].loc.lon);
            strcpy (dawn,min2tim(grayline.dawn));
            strcpy (sunrise,min2tim(grayline.rise));
            strcpy (sunset,min2tim(grayline.set));
            strcpy (dusk,min2tim(grayline.dusk));
            /* Falls Zeiten negativ, dann stattdessen Striche ausgeben */
            if (grayline.dawn<0)
               strcpy(dawn,"--:--");
            if (grayline.dusk<0)
               strcpy(dusk,"--:--");
            if (grayline.rise<0)
               strcpy(sunrise,"--:--");
            if (grayline.set<0)
               strcpy(sunset,"--:--");
         	print_grayline(locations[loc].pref,locations[loc].name,
                        	dawn,sunrise,sunset,dusk);
            valid++;
      }
   }
   print_foot(valid,GRAYLINE);
}
